/*
 * urld.h - include for main daemon process
 *
 *  urld.h,v 1.12 1995/09/05 19:11:36 hardy Exp
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */

#ifndef _URLD_DOT_H
#define _URLD_DOT_H

#include <sys/types.h>		/* for fd_set */


#define SERVER_PORT		7676
#define DEFAULT_MAX_CONN	256
#define DEFAULT_TIMEOUT		600
#define DEFAULT_MAX_CONNECT	50

/* urld message definitions */
#define MSG_LEN         	3

/* client service requests */
#define URL_OPEN        	(0x31303000)
#define URL_OPEN_STR		"100"
#define URL_READ        	(0x31303100)
#define URL_READ_STR		"101"
#define URL_RETR        	(0x31303200)
#define URL_RETR_STR		"102"
#define URL_CLOSE       	(0x31303300)
#define URL_CLOSE_STR		"103"

/* server replies */
#define OPEN_OK         	(0x32303000)
#define OPEN_OK_STR         	"200"
#define READ_OK         	(0x32303100)
#define READ_OK_STR        	"201"
#define RETR_OK         	(0x32303200)
#define RETR_OK_STR         	"202"
#define CLOSE_OK        	(0x32303300)
#define CLOSE_OK_STR        	"203"

#define OPEN_ERR        	(0x34303000)
#define OPEN_ERR_STR       	"400"
#define READ_ERR        	(0x34303100)
#define READ_ERR_STR        	"401"
#define RETR_ERR        	(0x34303200)
#define RETR_ERR_STR   	   	"402"
#define CLOSE_ERR       	(0x34303300)
#define CLOSE_ERR_STR       	"403"

#define DISCNCT			(0x35303000)
#define DISCNCT_STR		"500"


#define	NO_QERROR		0
#define	DEQ_ERROR		-1
#define	DEQ_ON_ENQ		-2
#define CANT_MALLOC_Q		-3
#define CANT_MALLOC_QNODE	-4

#define NO_ERROR		0
#define URLD_GET_SOCK_ERR	-1
#define BIND_SOCK_ERR		-2
#define URLD_GET_HOSTNAME_ERR	-3
#define URLD_GET_HOSTBYNAME_ERR	-4
#define URLD_GET_SOCKNAME_ERR	-5
#define SELECT_ERR		-6
#define ACCEPT_ERR		-7
#define SERVICE_REQUEST		-8
#define URLD_MEMORY_ERROR	-9
#define SOCK_WRITE_ERR		-10
#define URLD_LISTEN_ERR		-11

#define NO_REQ_PRESENT		-15
#define GET_PARAM_ERR		-16
#define URL_OPEN_ERR		-17
#define URL_READ_ERR		-18
#define URL_RETR_ERR		-19
#define GET_URL_ERR		-20
#define ADD_PARAM_ERR		-21
#define ADD_URL_ERR		-22
#define CLIENT_DISCONNECT	-23


typedef struct q_node {
	int		theSocket;
	struct q_node	*next;
	struct q_node	*prev;
} QNode; 

/* in through the head, exit through the rear */
typedef struct queue {
	int		qLength;
	int		maxConnect;
	QNode		*head;
	QNode		*tail;
} Queue;


#ifndef _PARAMS
#if defined(__STDC__) || defined(__cplusplus) || defined(__STRICT_ANSI__)
#define _PARAMS(ARGS) ARGS
#else /* Traditional C */     
#define _PARAMS(ARGS) ()      
#endif /* __STDC__ */              
#endif /* _PARAMS */   

int	GetQErr _PARAMS(());
Queue * InitQueue _PARAMS((int));
QNode * InitQNode _PARAMS((int));
QNode * Dequeue _PARAMS((Queue *, QNode *));
QNode *	Enqueue _PARAMS((Queue *, QNode *));
void	DestroyQueue _PARAMS((Queue *));

int GetURLDErr _PARAMS(());
int InitDSocket _PARAMS((unsigned short));
int WaitForRequest _PARAMS((int, fd_set *, int));
int ServiceClient _PARAMS((int));


#endif /* _URLD_DOT_H */
