typedef struct _word {
	char		*word;
	struct _word	*next;
} Word;

typedef struct _cond {
	Word		*attr;
	int		op;		/* EQUALS | REGEX */
	Word		*value;
	int		nextop;		/* AND | OR */
	struct _cond	*next;
} Cond;

typedef struct _inst {
	Word		*attrs;
	int		op;		/* PIPE | BANG | ASSIGN */
	Word		*args;
	struct _inst	*next;
} Inst;

typedef struct _rule {
	Cond		*cond;
	Inst		*inst;
	struct _rule	*next;
} Rule;

#define AND	1
#define OR	2
#define EQUALS	3
#define REGEX	4
#define NOTEQ	5
#define NOTRE	6
#define PIPE	7
#define BANG	8
#define ASSIGN	9
#define DELETE	10

extern Rule	*PPRules;

/*
 * A hack so that the post_processing routines can tell the summarizer
 * to NOT save an object in the database.  This value will be returned.
 * Maybe it should be a bitmask...
 */
#define SUMMARIZE_DONT_ADD_OBJECT (1<<7)


extern int post_process _PARAMS((Template *));

