%{

#include "util.h"
#include "template.h"
#include "post_process.h"
#include "y.tab.h"
char *name_buf;		/* to pass to the grammer parser */
char *qstr_buf;		/* to pass to the grammer parser */
char *pattern_buf;	/* to pass to the grammer parser */
char *word_buf;		/* to pass to the grammer parser */
%}

Alphanum	[-A-Za-z0-9]

%%

#.*\n			{ }

"&&"			{ return AND_; }
"||"			{ return OR_; }
","			{ return COMMA_; }

"!"			{ return BANG_; }
"|"			{ return PIPE_; }
"~"			{ return TWIDDLE_; }
"=="			{ return EQUALS_; }
"!~"			{ return NOTTWIDDLE_; }
"!="			{ return NOTEQUALS_; }
"="			{ return ASSIGN_; }

"delete()"		{ return DELETE_; }

\\\n			{ }
\n+			{ return END_; }
^\t			{ return LTAB_; }

'[^'\n]*['\n]		{ qstr_buf = (char *) xstrdup (yytext); return QSTR_; }
\"[^"\n]*["\n]		{ qstr_buf = (char *) xstrdup (yytext); return DQSTR_; }
\/[^\/\n]*[\/\n]	{ qstr_buf = (char *) xstrdup (yytext); return PATTERN_;}
[^ \t\n=~!|&,]+		{ word_buf = (char *) xstrdup (yytext); return WORD_; }

[ \t]			{}

.			{ return 0; }

%%

#ifndef yywrap
int yywrap()
{
        return 1;
}
#endif
