static char rcsid[] = "rmbinary.c,v 1.16 1996/01/04 03:46:44 duane Exp";
/*
 *  rmbinary.c - Removes any binary data from SOIF templates
 *
 *  Usage: rmbinary db
 *
 *  Darren Hardy, hardy@cs.colorado.edu, April 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <gdbm.h>
#include "util.h"
#include "template.h"

/* Local functions */
static void usage();

static int ndelete = 0;

static void usage()
{
	fprintf(stderr, "Usage: rmbinary db\n");
	exit(1);
}

/*
 *  update_timestamp() - Changes the Update time of the template to the
 *  current time.
 */
static void update_timestamp(avl)
     AVList *avl;
{
	AVList *walker = avl;
	char buf[BUFSIZ];

	while (walker) {
		if (!strcasecmp(walker->data->attribute, T_UPDATE)) {
			sprintf(buf, "%ld", time(NULL));
			xfree(walker->data->value);
			walker->data->value = strdup(buf);
			walker->data->vsize = strlen(walker->data->value);
			return;
		}
		walker = walker->next;
	}

}

static void write_template(dbf, template)
     GDBM_FILE dbf;
     Template *template;
{
	Buffer *b;
	datum k, d;

	b = init_print_template(NULL);
	print_template(template);
	k.dptr = strdup(template->url);
	k.dsize = strlen(k.dptr) + 1;
	d.dptr = b->data;
	d.dsize = b->length;
	if (gdbm_store(dbf, k, d, GDBM_REPLACE))
		fprintf(stderr, "gdbm_store: %s: %s\n", k.dptr, gdbm_strerror(gdbm_errno));
	finish_print_template();
	xfree(k.dptr);
	ndelete++;
}

/*
 *  fix_template() - Removes any binary data from the template by 
 *  deleting the entire value and replacing it with a dummy string.
 *  If any binary data is removed, then the T_UPDATE time of the 
 *  template is made current.
 */
static void fix_template(dbf, d)
     GDBM_FILE dbf;
     datum d;
{
	Template *t;
	AVList *walker;
	int i;

	init_parse_template_string(d.dptr, d.dsize);
	t = parse_template();
	finish_parse_template();
	for (walker = t->list; walker; walker = walker->next) {
		for (i = 0; i < walker->data->vsize; i++) {
			if (!isascii(walker->data->value[i])) {
				xfree(walker->data->value);
				walker->data->value =
				    strdup("BINARY-DATA-DELETED");
				walker->data->vsize =
				    strlen(walker->data->value);
				update_timestamp(t->list);
				write_template(dbf, t);
				break;
			}
		}
	}
}

int main(argc, argv)
     int argc;
     char *argv[];
{
	GDBM_FILE dbf;
	datum d, k, nk;
	int i, inrow;

	init_log3("rmbinary", stderr, stderr);
	if (argc != 2)
		usage();

	dbf = gdbm_open(argv[1], 0, GDBM_WRITER, 0644, NULL);
	if (dbf == NULL) {
		errorlog("gdbm_open: %s: %s\n", argv[1],
		    gdbm_strerror(gdbm_errno));
		log_errno(argv[1]);
		usage();
	}
	k = gdbm_firstkey(dbf);
	while (k.dptr) {
		nk = gdbm_nextkey(dbf, k);
		d = gdbm_fetch(dbf, k);
		for (i = inrow = 0; i < d.dsize; i++) {
			/* 
			 *  ONLY fix templates that have more than 5 bytes
			 *  of binary data together 
			 */
			if (!isascii(d.dptr[i])) {
				if (++inrow > 5) {
					fix_template(dbf, d);
					break;
				}
				continue;
			}
			inrow = 0;
		}
		free(k.dptr);
		free(d.dptr);
		k = nk;
	}
	if (ndelete > 12)
		gdbm_reorganize(dbf);
	gdbm_close(dbf);
	exit(0);
}
