static char rcsid[] = "gdbmstore.c,v 1.16 1996/01/17 10:07:51 duane Exp";
/*
 *  gdbmstore - Add the given data item (from stdin) to the database.
 *
 *  Darren Hardy, hardy@cs.colorado.edu, March 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <gdbm.h>
#include "util.h"

extern int usage();

static char *mapfile;
static GDBM_FILE mapdb;

int do_store(argc, argv)
     int argc;
     char *argv[];
{
	datum k;
	datum d;
	int c;
	int nallocated;

	if (argc != 3)
		usage();

	mapfile = argv[1];
	k.dptr = strdup(argv[2]);
	k.dsize = strlen(k.dptr) + 1;
	mapdb = gdbm_open(mapfile, 0, GDBM_WRCREAT, 0644, NULL);
	if (mapdb == NULL) {
		errorlog("gdbm_open: %s: %s\n", mapfile,
		    gdbm_strerror(gdbm_errno));
		log_errno(mapfile);
		exit(1);
	}
	d.dptr = xmalloc(BUFSIZ);
	d.dsize = 0;
	nallocated = BUFSIZ;
	while ((c = fgetc(stdin)) != EOF) {
		if (d.dsize >= nallocated) {
			nallocated += BUFSIZ;
			d.dptr = realloc(d.dptr, nallocated);
		}
		d.dptr[d.dsize++] = c;
	}
	d.dptr[d.dsize - 1] = '\0';
	if (gdbm_store(mapdb, k, d, GDBM_REPLACE)) {
		errorlog("gdbm_store: %s: %s: %s\n", k.dptr, mapfile,
		    gdbm_strerror(gdbm_errno));
		gdbm_close(mapdb);
		exit(1);
	}
	gdbm_close(mapdb);
	exit(0);
}
