static char rcsid[] = "ccache_vtimer.c,v 1.11 1995/11/29 00:48:33 duane Exp";
/*
 *  vtimer.c - virtual timer calls for ccache
 *
 *  David Merkel & Mark Peterson, University of Colorado - Boulder, July 1994  
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/time.h>
#include "ccache.h"
#include "ccache_list.h"
#include "ccache_queue.h"
#include "time_it.h"

void HandleTimerSignal();

static Queue *TimerQueue;

static int newid = 0;
static int frozen = 0;
static struct itimerval FreezeTimer;


static void ClearTimerVal(struct itimerval *theTimer)
{
	theTimer->it_value.tv_sec = 0;
	theTimer->it_value.tv_usec = 0;
	theTimer->it_interval.tv_sec = 0;
	theTimer->it_interval.tv_usec = 0;
}


void InitTimer()
{
	TimerQueue = queue_create();
	signal(SIGALRM, HandleTimerSignal);
}


int SetTimer(TimeToExpire, ProcToCall)
     int TimeToExpire;
     int (*ProcToCall) ();
{
	Time_Node *newnode, *first;
	Boolean check;
	struct itimerval SetValue, RecoverValue;

	newnode = (Time_Node *) malloc(sizeof(Time_Node));

	if (TimeToExpire < 1)
		return (0);

	newid++;
	newnode->eventnum = newid;
	newnode->time_in_secs = TimeToExpire;
	newnode->ProctoCall = ProcToCall;

	ClearTimerVal(&SetValue);

	setitimer(ITIMER_REAL, &SetValue, &RecoverValue);
	first = ((Time_Node *) head(TimerQueue));

	if (first && !frozen)
		first->time_in_secs = RecoverValue.it_value.tv_sec;
	else if (first && frozen)
		first->time_in_secs = FreezeTimer.it_value.tv_sec;

	check = tenqueue(TimerQueue, newnode, RecoverValue.it_value.tv_sec);
	first = (Time_Node *) head(TimerQueue);

	if (first && !frozen)
		RecoverValue.it_value.tv_sec = first->time_in_secs;
	else if (first && frozen)
		FreezeTimer.it_value.tv_sec = first->time_in_secs;

	setitimer(ITIMER_REAL, &RecoverValue, NULL);

	if (check == FALSE)
		return (0);

	return (newid);
}


Boolean CancelTimer(TimerID)
     int TimerID;
{
	Boolean check;
	struct itimerval TimerValue, OldTimerValue;
	Time_Node *first;

	if (TimerID > newid)
		return (FALSE);

	ClearTimerVal(&TimerValue);

	setitimer(ITIMER_REAL, &TimerValue, &OldTimerValue);
	first = (Time_Node *) head(TimerQueue);

	if (first && !frozen)
		first->time_in_secs = OldTimerValue.it_value.tv_sec;
	else if (first && frozen)
		first->time_in_secs = FreezeTimer.it_value.tv_sec;

	check = tdequeue(TimerQueue, TimerID);

	first = (Time_Node *) head(TimerQueue);

	if (first) {
		if (!frozen)
			OldTimerValue.it_value.tv_sec = first->time_in_secs;
		else
			FreezeTimer.it_value.tv_sec = first->time_in_secs;

	} else {
		if (!frozen)
			ClearTimerVal(&OldTimerValue);
		else
			ClearTimerVal(&FreezeTimer);
	}

	setitimer(ITIMER_REAL, &OldTimerValue, NULL);
	return (TRUE);
}


void HandleTimerSignal()
{
	List_Node *listtemp;
	Time_Node *temp, *first;
	struct itimerval SetValue;

	ClearTimerVal(&SetValue);

	do {
		listtemp = list_first(TimerQueue);
		(void) ((Time_Node *) list_getdata(listtemp))->ProctoCall(((Time_Node *) list_getdata(listtemp))->eventnum);

		temp = (Time_Node *) dequeue(TimerQueue);
		free((char *) temp);

		first = (Time_Node *) head(TimerQueue);
	}
	while (first && (first->time_in_secs == 0));

	if (first)
		SetValue.it_value.tv_sec = first->time_in_secs;

	setitimer(ITIMER_REAL, &SetValue, NULL);
}

void Freeze()
{
	struct itimerval TimerValue;

	if (frozen)
		return;

	ClearTimerVal(&TimerValue);

	setitimer(ITIMER_REAL, &TimerValue, &FreezeTimer);
	frozen = 1;
}

void Thaw()
{
	if (!frozen)
		return;

	setitimer(ITIMER_REAL, &FreezeTimer, NULL);
	frozen = 0;
}

Boolean print_data(node)
     Datum *node;
{
	Time_Node *tnode;

	if (!node)
		return (FALSE);
	tnode = (Time_Node *) node;
	printf("event: %d\ttime: %d", tnode->eventnum, tnode->time_in_secs);
	return (TRUE);
}

void DisplayQueue()
{
	queue_apply(TimerQueue, print_data);
}
