static char rcsid[] = "cksoif.c,v 1.12 1996/01/05 20:28:18 duane Exp";
/*
 *  cksoif - Reads in templates from stdin and prints whether or not
 *  it's a legal SOIF template.
 *
 *  Usage: cksoif [--in-memory]
 *
 *  Darren Hardy, hardy@cs.colorado.edu, November 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "util.h"
#include "template.h"

#define BIG_BUFSIZ	(4096*16)

static int in_memory = 0;

int main(argc, argv)
     int argc;
     char *argv[];
{
	int n = 0, nok = 0;
	Template *t;
	Buffer *b;
	char buf[BIG_BUFSIZ];

	if (argc == 2 && !strcmp(argv[1], "--in-memory")) {
		in_memory = 1;
	}
	if (in_memory) {
		b = create_buffer(BUFSIZ);
		while ((n = fread(buf, 1, BIG_BUFSIZ, stdin)) > 0) {
			add_buffer(b, buf, n);
		}
		init_parse_template_string(b->data, b->length);
	} else {
		init_parse_template_file(stdin);
	}

	n = nok = 0;
	while (1) {
		n++;
		t = parse_template();
		if (t == NULL && is_parse_end_of_input())
			break;
		if (t == NULL) {
			printf("Attempt %d: Invalid SOIF\n", n);
			continue;
		}
		free_template(t);
		printf("Attempt %d: Valid SOIF\n", n);
		nok++;
	}
	finish_parse_template();
	printf("Successfully parsed %d SOIF objects, in %d attempts\n",
	    nok, n - 1);
	exit(0);
}
