static char rcsid[] = "admin.c,v 1.48 1995/11/28 21:25:53 duane Exp";
/*
 *  admin.c -- Performs administrative actions.
 *  William G. Camargo, Penn State Univ.,
 *  Darren Hardy, U. Colorado, Boulder.
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include "broker.h"
#include "log.h"

/*
 *  A Buffer so we can pass data back to the Query Manager.  Only the
 *  QM has the socket for the client connection...
 */
extern Buffer *admin_return;

/*
 *  AD_restart() - Is used to "restart" a broker that is using the Harvest
 *  replicator to get its data.  This function will shutdown the
 *  Registry file, free the memory currently taken by the in-memory
 *  Registry, then re-read the Registry into memory, and finally
 *  does a full indexing and computes the statistics.
 */
int AD_restart()
{
	int status = SUCCESS;

	Log("Restarting the Broker...\n");
	RG_Registry_Shutdown();
	RG_Free_Registry();
	if (SM_Init() == ERROR) 
		fatal("Could not initialize the storage manager during the Restart.\n");
	if (RG_Init() == ERROR) 
		fatal("Could not initialize Registry during the Restart.\n");
	status = do_IND_Index_Full();
	if (status == SUCCESS)
		status = AD_do_stats();
	Log("Finished Restarting the Broker.\n");

	return (status);
}

int AD_do_stats()
{
	int ret;
	char buf[BUFSIZ];
	extern char *DIRpath;

	Log("Computing Broker statistics.\n");
	sprintf(buf, "mkbrokerstats.pl %s > stats.html", DIRpath);
	ret = run_cmd(buf);
	(void)chmod("stats.html", 0664);
	return (ret == 0 ? SUCCESS : ERROR);
}

/*
 *  AD_add_object - adds the given object in filename to the Broker
 */
int AD_add_object(name)
char *name;
{
	FILE *newo;
	int ret;

	if ((newo = fopen(name, "r")) == NULL) {
		return ERROR;
	}
	init_parse_template_file(newo);
	ret = P_parse_object(UPD_MODE);
	finish_parse_template();
	fclose(newo);
	return (ret);
}

/*
 *  AD_remove_name - Removes the given OID.
 */
int AD_remove_name(oidptr)
char *oidptr;
{
	fd_t cur;
	reg_t *rme;

	cur = (fd_t) atol(oidptr);
	if ((rme = RG_Get_Entry(cur)) == NULL)
		return ERROR;

	return (COL_DEL_Obj(rme));
}

int AD_log_on(name)
char *name;
{
	unsigned int key;

	key = LOG_match_name(name);
	switch (key) {
	case 0:
		if (strcasecmp(name, "all") == 0) {
			LOG_turn_on(~00);
			return SUCCESS;
		} 
		return ERROR;
	case L_QUERY_R:
		LOG_turn_on(L_QUERYERR);
		break;
	case L_BULK_R:
		LOG_turn_on(L_BULKERR);
		break;
	default:
		break;
	}

	LOG_turn_on(key);

	return SUCCESS;
}

int AD_log_off(name)
char *name;
{
	unsigned int key;

	key = LOG_match_name(name);
	switch (key) {
	case 0:
		if (strcasecmp(name, "all") == 0) {
			LOG_reset_master();
			return SUCCESS;
		}
		return ERROR;
	case L_QUERY_R:
		LOG_turn_off(L_QUERYERR);
		break;
	case L_BULK_R:
		LOG_turn_off(L_BULKERR);
		break;
	default:
		break;
	}

	LOG_turn_off(key);

	return SUCCESS;
}

AD_do_info()
{
	char buf[1024];
	extern int qport;
	extern char *HName, *IndexerType;

	if ((admin_return = create_buffer (BUFSIZ)) == (Buffer *) NULL)
		return SUCCESS;		/* well, at least we're alive... */

	buf[0] = '\0';
	sprintf(buf, "@INFO { %s:%d\nBroker-Version{%d}:\t%s\nIndexer-Type{%d}:\t%s\n}\n", HName, qport, strlen(HARVEST_VERSION), HARVEST_VERSION, strlen(IndexerType), IndexerType);
	add_buffer(admin_return, buf, strlen(buf));
	return SUCCESS;
}

AD_do_ping(buf)
char *buf;
{
	static char *default_msg =  "This broker is up.\n";

	if ((admin_return = create_buffer (BUFSIZ)) == (Buffer *) NULL)
		return SUCCESS;		/* well, at least we're alive... */

	if (buf) {
		add_buffer (admin_return, buf, strlen(buf));
		if (!strchr(buf, '\n'))
			add_buffer (admin_return, "\n", 1);
	} else {
		add_buffer (admin_return, default_msg, strlen(default_msg));
	}

	return SUCCESS;
}

void AD_run_admin_process()
{
	extern char *aproc, *cffile;

        /* start admin command in the background */
        if ((aproc != NULL) && (strlen(aproc) > 0)) {
                char buf[BUFSIZ];

                buf[0] = '\0';
                sprintf(buf, "/bin/sh -c \"%s %s\" &", aproc, cffile);
                system(buf);
        }
}
