static char rcsid[] = "print-c-comments.c,v 1.9 1995/09/05 19:07:53 hardy Exp";
/*
 *  This program extracts all C style comments from the input file and
 *  prints them to stdout.  
 *
 *  Darren Hardy, hardy@cs.colorado.edu, March 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <string.h>

/* 
 *  process_file() - Uses a simple state machine to parse the input.  
 *  Below is the state table; basically if it makes it to S2 then
 *  you've found a comment, until it reaches S4 where the comment ends.
 *
 *       S1 -> S2 on '/', otherwise S1 -> S1
 *       S2 -> S3 on '*', otherwise S2 -> S1
 *       S3 -> S4 on '*', otherwise S3 -> S3
 *       S4 -> S1 on '/', S4 -> S4 on '*', otherwise S4 -> S3
 */
void process_file(filename)
char *filename;
{
	FILE *fp;
	int state = 1, c;

	if (!strcmp(filename, "-"))
		fp = stdin;
	else if ((fp = fopen(filename, "r")) == NULL) {
		perror(filename);
		exit(1);
	}
	while ((c = getc(fp)) != EOF) {
		switch (state) {
		case 1:
			if (c == '/') 
				state = 2;
			break;
		case 2:
			if (c == '*') {
				fputc('/', stdout);
				fputc('*', stdout);
				state = 3;
			} else 
				state = 1;
			break;
		case 3:
			fputc(c, stdout);
			if (c == '*') 
				state = 4;
			break;
		case 4:
			fputc(c, stdout);
			if (c == '/') {
				fputc('\n', stdout);
				state = 1;
			} else
				state = (c == '*') ? 4 : 3;
			break;
		default:
			fprintf(stderr, "Fatal Internal Error\n");
			exit(1);
		}
	}
	fclose(fp);
	exit(0);
}

int main(argc, argv)
int argc;
char *argv[];
{
	if (argc > 1)
		while (--argc > 0)
			process_file(*++argv);
	else
		process_file("-");
	exit(0);
}
