static char rcsid[] = "RegisterHSR.c,v 1.7 1995/09/05 19:07:42 hardy Exp";
/*
 *  RegisterHSR.c - CGI Forms interface using POST for users to register
 *  their server with the hsr@cs.colorado.edu.
 *
 *  Look at
 *    http://harvest.cs.colorado.edu/Harvest/brokers/hsr/register-with-hsr.html
 *  for an example HTML page to go with this program.
 *
 *  Darren Hardy, University of Colorado - Boulder, October 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "util.h"
#include "template.h"

#define MAX_ENTRIES 10000

typedef struct {
	char *name;
	char *val;
} entry;

/* External functions from util.c */
extern char *makeword();
extern char *fmakeword();
extern char x2c();
extern void unescape_url();
extern void plustospace();

/* Local functions */
static char *get_time();
static void cgi_fatal();

static char *servertype, *url, *name, *host, *version, *description;
static char *comments, *maintainer, *keywords, *port;

int main(argc, argv)
int argc;
char *argv[];
{
	Template *t;
	entry entries[MAX_ENTRIES];
	char buf[BUFSIZ], *tmpfile = tempnam(NULL, "rhsr"), c;
	int x, m = 0, cl;
	FILE *fp, *tfp;

	servertype = url = name = host = version = description = NULL;
	port = comments = maintainer = keywords = NULL;

	printf("Content-type: text/html\n\n");

	if (strcmp(getenv("REQUEST_METHOD"), "POST")) {
		cgi_fatal("This script must use POST.");
	}
	if (strcmp(getenv("CONTENT_TYPE"), "application/x-www-form-urlencoded")) {
		cgi_fatal("This script can only be used to decode form results.\n");
	}
	cl = atoi(getenv("CONTENT_LENGTH"));

	for (x = 0; cl && (!feof(stdin)); x++) {
		m = x;
		entries[x].val = fmakeword(stdin, '&', &cl);
		plustospace(entries[x].val);
		unescape_url(entries[x].val);
		entries[x].name = makeword(entries[x].val, '=');
	}

	printf("<title>Results of registering with the HSR</title>\n");
	printf("<h1>Results of registering with the HSR</h1>\n");
	printf("<p><hr><p>\n");

	for (x = 0; x <= m; x++) {
		if (!strcmp(entries[x].name, "servertype")) {
			servertype = strdup(entries[x].val);
			if (strlen(servertype) < 1)
				servertype = NULL;
		} else if (!strcmp(entries[x].name, "url")) {
			url = strdup(entries[x].val);
			if (strlen(url) < 1)
				url = NULL;
		} else if (!strcmp(entries[x].name, "host")) {
			host = strdup(entries[x].val);
			if (strlen(host) < 1)
				host = NULL;
		} else if (!strcmp(entries[x].name, "port")) {
			port = strdup(entries[x].val);
			if (strlen(port) < 1)
				port = NULL;
		} else if (!strcmp(entries[x].name, "name")) {
			name = strdup(entries[x].val);
			if (strlen(name) < 1)
				name = NULL;
		} else if (!strcmp(entries[x].name, "version")) {
			version = strdup(entries[x].val);
			if (strlen(version) < 1)
				version = NULL;
		} else if (!strcmp(entries[x].name, "maintainer")) {
			maintainer = strdup(entries[x].val);
			if (strlen(maintainer) < 1)
				maintainer = NULL;
		} else if (!strcmp(entries[x].name, "keywords")) {
			keywords = strdup(entries[x].val);
			if (strlen(keywords) < 1)
				keywords = NULL;
		} else if (!strcmp(entries[x].name, "description")) {
			description = strdup(entries[x].val);
			if (strlen(description) < 1)
				description = NULL;
		} else if (!strcmp(entries[x].name, "comments")) {
			comments = strdup(entries[x].val);
			if (strlen(comments) < 1)
				comments = NULL;
		}
	}

	if (servertype == NULL)
		cgi_fatal("Must specify the server type.\n");
	if (url == NULL)
		cgi_fatal("Must specify the URL.\n");
	if (name == NULL)
		cgi_fatal("Must specify the Name.\n");
	if (host == NULL)
		cgi_fatal("Must specify the Host.\n");
	if (port == NULL)
		cgi_fatal("Must specify the Port.\n");
	if (version == NULL)
		cgi_fatal("Must specify the Version.\n");

	if (!strcmp(servertype, "gatherer")) {
		t = create_template("GATHERER", url);
		t->list = create_AVList("Gatherer-Name", name, strlen(name));
		add_AVList(t->list, "Gatherer-Host", host, strlen(host));
		add_AVList(t->list, "Gatherer-Port", port, strlen(port));
		add_AVList(t->list, "Gatherer-Version", version, strlen(version));
	} else if (!strcmp(servertype, "broker")) {
		t = create_template("BROKER", url);
		t->list = create_AVList("Broker-Name", name, strlen(name));
		add_AVList(t->list, "Broker-Host", host, strlen(host));
		add_AVList(t->list, "Broker-Port", port, strlen(port));
		add_AVList(t->list, "Broker-Version", version, strlen(version));
	} else if (!strcmp(servertype, "cache")) {
		t = create_template("CACHE", url);
		t->list = create_AVList("Cache-Name", name, strlen(name));
		add_AVList(t->list, "Cache-Host", host, strlen(host));
		add_AVList(t->list, "Cache-Port", port, strlen(port));
		add_AVList(t->list, "Cache-Version", version, strlen(version));
	} else {
		cgi_fatal("Unknown server type.\n");
	}
	if (maintainer != NULL)
		add_AVList(t->list, "Maintainer", maintainer,
			   strlen(maintainer));
	if (keywords != NULL)
		add_AVList(t->list, "Keywords", keywords, strlen(keywords));
	if (description != NULL)
		add_AVList(t->list, "Description", description,
			   strlen(description));
	if (comments != NULL)
		add_AVList(t->list, "Comments", comments, strlen(comments));

	/* Send mail to hsr with the template as its contents */
	if ((fp = popen("/bin/mail hsr@cs.colorado.edu", "w")) == NULL) {
		cgi_fatal("Cannot send mail to hsr@cs.colorado.edu.\n");
	}
	fprintf(fp, "From: \"Auto HSR Register\" <hsr@cs.colorado.edu>\n");
	fprintf(fp, "To: hsr@cs.colorado.edu\n");
	fprintf(fp, "Subject: %s Registration for %s\n", servertype, url);
	fprintf(fp, "Reply-To: hsr@cs.colorado.edu\n");
	fprintf(fp, "\n\n\n\n");

	/* SOIF is not well suited for email, so uuencode first */
	if (tmpfile != NULL && (tfp = fopen(tmpfile, "w")) != NULL) {
		(void) init_print_template(tfp);
		print_template(t);
		finish_print_template();
		fclose(tfp);	/* tmpfile now hold SOIF */
		sprintf(buf, "/bin/uuencode %s new.soif", tmpfile);
		if ((tfp = popen(buf, "r")) == NULL)
			cgi_fatal("Can't create mail to hsr@cs.colorado.edu.");
		while ((c = fgetc(tfp)) != EOF)
			putc(c, fp);	/* send uuencoded data via mail */
		pclose(tfp);
	} else {
		(void) init_print_template(fp);
		print_template(t);
		finish_print_template();
	}
	fprintf(fp, "\n\n\n\n");
	pclose(fp);

	printf("You have successfully registered a %s\n", servertype);
	printf("with the Harvest Server Registery.\n");
	printf("<p>Below is the SOIF object describing your server that\n");
	printf("was sent to the HSR.\n");
	printf("<p><hr><p><pre>\n");

	(void) init_print_template(stdout);
	print_template(t);
	finish_print_template();

	printf("</pre>\n");
	exit(0);
}

/*
 *  cgi_fatal() - Print error message to user via stdout; and nicely log
 *  the error to stderr where httpd will save it in error_log.
 */
static void cgi_fatal(s)
char *s;
{
	fprintf(stdout, "%s\n", s);
	fprintf(stderr, "[%s] BrokerQuery: %s", get_time(), s);
	fflush(stdout);
	fflush(stderr);
	exit(1);
}

/* get_time from NCSA httpd */
static char *get_time()
{
	time_t t;
	char *time_string;

	t = time(NULL);
	time_string = ctime(&t);
	time_string[strlen(time_string) - 1] = '\0';
	return (time_string);
}
