static char rcsid[] = "BrokerAdmin.c,v 1.11 1996/01/17 10:07:35 duane Exp";
/*
 *  BrokerAdmin - CGI interface to Broker admin.
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <fcntl.h>
#include <memory.h>

/* External Functions from util.c */
extern void getword(), unescape_url(), plustospace(), nltospace();
extern char x2c();
extern void *xmalloc();

/* Local functions */
static void sigdie();

#ifndef BUFSIZ
#define BUFSIZ	8192
#endif

#if BUFSIZ < 8192
#undef BUFSIZ
#define BUFSIZ	8192		/* Need large buffers */
#endif

#define ENTSIZ 		32

typedef struct {
	char *name;
	char *val;
} entry;

static entry *entries;
static char *command;
static char *parameter;
static char *password;
static char *sendstr;

int main(argc, argv)
int argc;
char *argv[];
{
	int x, m = 0, sport = 0;
	char *cl = getenv("QUERY_STRING");
	char *gl = getenv("REQUEST_METHOD");
	char *hhost = NULL;

	setbuf(stdout, NULL);

	entries = (entry *) xmalloc (ENTSIZ * sizeof (entry));
	for (x=0; x<ENTSIZ; x++) {
		entries[x].name = (char *) xmalloc (BUFSIZ);
		entries[x].val  = (char *) xmalloc (BUFSIZ);
	}
	command   = (char *) xmalloc (BUFSIZ);
	parameter = (char *) xmalloc (BUFSIZ);
	password  = (char *) xmalloc (BUFSIZ);
	sendstr   = (char *) xmalloc (BUFSIZ);

	(void) signal(SIGTERM, sigdie);

	printf("Content-type: text/html\r\n\r\n");

	if (!gl || (memcmp(gl, "GET", 3))) {
		printf("Reference with a METHOD of GET.\n");
		exit(1);
	}
	if (cl == NULL) {
		printf("No query information to decode.\n");
		exit(1);
	}
        /* Parse the URL string for the parameters */
        for (x = 0; (cl[0] != '\0') && (x < ENTSIZ); x++) {
                m = x;
                getword(entries[x].val, cl, '&');
                plustospace(entries[x].val);
                unescape_url(entries[x].val);
                nltospace(entries[x].val);      /* strip \n from query */
                getword(entries[x].name, entries[x].val, '=');
        }

	memset(sendstr, '\0', BUFSIZ);
	memset(command, '\0', BUFSIZ);
	memset(password, '\0', BUFSIZ);
	memset(parameter, '\0', BUFSIZ);
	for (x = 0; x <= m; x++) {
		if (strncmp(entries[x].name, "command", 7) == 0) 
			strcpy(command, entries[x].val);
		if (strncmp(entries[x].name, "password", 8) == 0) 
			strcpy(password, entries[x].val);
		if (strncmp(entries[x].name, "parameter", 9) == 0) 
			strcpy(parameter, entries[x].val);
		if (strncmp(entries[x].name, "port", 4) == 0) 
			sport = atoi(entries[x].val);
		if (strncmp(entries[x].name, "host", 4) == 0) 
			hhost = entries[x].val;
	}

	if (password[0] == '\0') {
		if (parameter[0] == '\0')
			sprintf(sendstr, "#ADMIN %s", command);
		else
			sprintf(sendstr, "#ADMIN %s %s", command, parameter);
	} else {
		if (parameter[0] == '\0')
			sprintf(sendstr, "#ADMIN #password %s %s", 
				password, command);
		else
			sprintf(sendstr, "#ADMIN #password %s %s %s", 
				password, command, parameter);
	}

	if ((sport == 0) || (hhost == NULL)) {
		printf("ERROR: Must give both broker host and port.\n");
		exit(1);
	}
	printf("<H1>Broker Command Results</H1>\n");
	printf("<UL>\n<PRE>\n");
	sinit(hhost, sport, sendstr);
	printf("</PRE>\n");
	exit(0);
}

int sinit(serverstr, port, Qstr)
char *serverstr;
int port;
char *Qstr;
{
	int sock;
	struct sockaddr_in me;
	struct hostent *hp = NULL;
	FILE *sfp = NULL;
	static char buf[BUFSIZ];

	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror("socket");
		exit(1);
	}
	me.sin_family = AF_INET;
	if ((hp = gethostbyname(serverstr)) == 0) {
		fprintf(stderr, "%s: Unknown host.\n", serverstr);
		exit(1);
	}
	memcpy((char *) &me.sin_addr, (char *) hp->h_addr, hp->h_length);

	me.sin_port = htons(port);

	if (connect(sock, (struct sockaddr *) &me, sizeof me) < 0) {
		perror("connect");
		exit(1);
	}
	if (write(sock, Qstr, strlen(Qstr)) < 0) {
		perror("write");
		exit(1);
	}
	if ((sfp = fdopen(sock, "r")) == NULL) {
		perror("fdopen");
		exit(1);
	}
	while (fgets(buf, BUFSIZ, sfp) != NULL) {
		if (!strncmp(buf, "200", 3))	/* ignore version header */
			continue;
		printf("<P>\n<STRONG>%s</STRONG>\n", buf);
	}
	fclose(sfp);
	return (1);
}

void sigdie(sig)
int sig;
{
	exit(0);
}
