#ifndef _GLOBAL_H
#define _GLOBAL_H

/*
 *  Type definition
 */
typedef short *Ivector;            /* integer vector */
typedef double *Fvector;           /* float vector */
typedef Ivector Nqueue;            /* A queue of nodes */

typedef short **Imatrix;           /* integer matrix */
typedef double **Fmatrix;          /* float matrix */
typedef char **Amatrix;            /* Adjacency matrix */

/*
 * Function Prototype
 */
#define Ivalloc(n) ((Ivector) calloc (n, sizeof (short)))
#define Fvalloc(n) ((Fvector) calloc (n, sizeof (double)))
#define Nqalloc(n) ((Nqueue) malloc (n * sizeof (short)))
#define Ivfree(iv) free (iv)
#define Fvfree(fv) free (fv)
#define Nqfree(nq) free (nq)
#define Ivzero(iv, n) memset (iv, 0, n * sizeof(short))

Imatrix Imalloc ( /* int n */ );   /* allocate an Imatrix of size n x n    */
Fmatrix Fmalloc ( /* int n */ );   /* allocate a  Fmatrix of size n x n    */
Amatrix Amalloc ( /* int n */ );   /* allocate an Amatrix of size n(n+1)/2 */
#define Imfree(Im) mfree ((void **)Im)
#define Fmfree(Fm) mfree ((void **)Fm)
#define Amfree(Am) mfree ((void **)Am)
void Imcopy ( /* Imatrix a, Imatrix b */ );  /* copy b to a */
void Amclear (/* Amatrix a */ );  /* clear a to 0 */
void Imzero ( /* Imatrix a */ );  /* clear a to 0 */

#define MIN(x, y) (((x)<(y)) ? x : y)
#define MAX(x, y) (((x)>(y)) ? x : y)

#endif


