#include <memory.h>
#include "datastruct.h"

Imatrix 
Imalloc (n)                /* allocate Imatrix of size n x n    */
     int n;
{
  int i;
  int *ip;
  Imatrix Im;

  ip = (int *) malloc (n * sizeof (short *) + sizeof (int));
  *(ip++)= n;
  Im = (Imatrix) ip;

  for (i=0; i<n; i++) Im[i] = (short *) calloc (n, sizeof (short));
  return Im;
}

Fmatrix 
Fmalloc (n)                /* allocate Fmatrix of size n x n    */
     int n;
{
  int i;
  int *ip;
  Fmatrix Fm;

  ip = (int *) malloc (n * sizeof (double *) + sizeof(int));
  *(ip++)= n;
  Fm = (Fmatrix) ip;

  for (i=0; i<n; i++) Fm[i] = (double *) calloc (n, sizeof (double));
  return Fm;
}

Amatrix Amalloc (n)                /* allocate Amatrix of size n(n+1)/2 */
int n;
{
  int i;
  int *ip;
  Amatrix Am;

  ip = (int *) malloc (n * sizeof (char *) + sizeof(int));
  *(ip++)= n;
  Am = (Amatrix) ip;

  for (i=0; i<n; i++) Am[i] = (char *) calloc (i+1, sizeof (char));
  return Am;
}


void mfree (m)                  /* free any matrix of size n x ? */
void **m;
{
  int n;

  n = *(((int *)m)-1);
  while (n--) free (m[n]);
  free (((int *)m)-1);
}

void Imcopy (a, b)
Imatrix a, b;
{
  int i, n;

  n = *(((int *)a)-1);
  for (i=0; i<n; i++) memcpy (a[i], b[i], n * sizeof (short));
}

void Amclear (a)
Amatrix a;
{
  int i, n;

  n = *(((int *)a)-1);
  for (i=0; i<n; i++) memset (a[i], 0, (i+1) * sizeof (char));
}

void Imzero (a)
Imatrix a;
{
  int i, n;

  n = *(((int *)a)-1);
  for (i=0; i<n; i++) memset (a[i], 0, n * sizeof (short));
}
