: #!/bin/sh
# *--perl--*
  eval 'exec perl $0 "$@"'
  if $running_under_some_shell;
# $Id: mirrord.pl,v 1.3 1995/07/10 18:20:44 dante Exp dante $
# Add the path this script was found in to the include path.
$mirrord_version = "0.20";
$dir = &real_dir_from_path( $0 );
unshift( @INC, $dir );

require 'ftp.pl';;
require 'ctime.pl';
# require 'dumpvar.pl';
require 'socket.ph'; # This is our own custom socket.ph, *NOT* sys/socket.ph
		     # Too bad perl is not more portable.

$installfile = "/usr/local/harvest/replica/INSTALL.html";

# Might have to hack this to get it to work correctly.
# Have a look in sys/wait.h for your systems local value.
$WNOHANG = 1;

$mirror_prog = "mirror";
$mirror_args = "-N";
$mirror_log = "/tmp/mirror.log";

$command_count = 1;
$update_count = 0;
$update_version = '';
$update_set = '';
$update_sites = '';
$update_failure = 0;

$update_command = '';		# Command to execute after an update has
				# completed.

$sync_message = '';
$sync_interval = 60 * 60; # Every 60 minutes.
$next_sync_time = time + $update_interval;

# This is a total hack.  It is to get around memory leak problems that
# mirrord has been having.  It should be tracked down, but it is slow growing
# and mirrord doesn't require a lot of state so..
$next_exec_time = 0;

$local_dir = '';
$local_ftp_dir = '';
$local_admin = '';
$local_user = '';
$local_host = '';
$local_version = '';
$local_version_file = '';
$local_ftp_version_file = '';
$local_master = 0;
$local_floodd = '';
$local_command = '';
$local_inetaddr = '';
$local_inet = '';
$local_port = 0;
$local_maintainer = '';
$source_host = '';
$logger_host = '';

$log_buffer_max = 20;
@log_buffer = ();
# $#log_buffer = 1;
@local_neighbors = '';

#
# Keep track of an update in progress
#
$update_id = 0; 		# current update id
$update_process = 0;		# current update process id
$update_process_start_time = 0;	# what tiem the update started.
				# We need this incase we have to kill
				# the update.

$reschedule_interval = 60 * 1;	# Rescedule failed updates.


# Do something when a child exits.
# $SIG{'CHLD'} = 'reap_child';

###########################################################################
# Intialize various associative arrays used to drive parts of the program.#
###########################################################################
$COMMANDS{'GET'}='process_http';
$COMMANDS{'UPDATE'}='get_command_data';
$COMMANDS{'NEW-VERSION'}='get_new_version_data';
$COMMANDS{'SYNC'}='get_command_data';

$UPDATE_FIELDS{'<VERSION>'} = 'version';
$UPDATE_FIELDS{'<VERSION-FILE>'} = 'version-file';
$UPDATE_FIELDS{'<SITE>'} = 'site';
$UPDATE_FIELDS{'<USER>'} = 'user';
$UPDATE_FIELDS{'<DIRECTORY>'} = 'directory';


$HTTPCOMMANDS{'/'}='http_statistics';
$HTTPCOMMANDS{'/dump'}='http_dump';
$HTTPCOMMANDS{'/new-version'}='http_new_version';
$HTTPCOMMANDS{'/parameters'}='http_parameters';
$HTTPCOMMANDS{'/statistics'}='http_statistics';
$HTTPCOMMANDS{'/synchronize'}='http_synchronize';
$HTTPCOMMANDS{'/trace_log'}='http_trace_log';
$HTTPCOMMANDS{'/update'}='http_statistics';
$HTTPCOMMANDS{'/update_log'}='http_update_log';
$HTTPCOMMANDS{'/mirror-statistics'}='http_mirror_statistics';

# Html pages.  We can just use `substitute_variables()' to plug in values.
# I thought it was kinda cute.
#
$HTTP_PAGES{'TITLE'} = '
<TITLE><Mirrord:$group_name@$local_host></TITLE>
<H1> The  $local_group Replication Group</A></H1>
<H2> <A HREF=http://excalibur.usc.edu/research/mirrord/mirrord.html>The Mirror Daemon Replication System</A></H2>
<H6> Version $mirrord_version </H6>
<H2> $local_host </H2>
<H4><A HREF="statistics">Statistics</A>/
<A HREF="update_log">Update Log</A>/
<A HREF="trace_log">Trace Log</A>/
<A HREF="synchronize">Synchronize</A>$local_command</H4>
</H4>
<H4> $sync_message </H4>
<H5> This page will not update automatically.  Reload for new status. </H5>
';

$HTTP_PAGES{'STATISTICS'} = '
<HTML>
<H3> Local Parameters </H3>
<UL>
<LI> Version: $local_version ($local_version_time)
<LI> Last Update: $local_last_update ($local_last_update_time)
<LI> Version File: $local_version_file
<LI> Originating site: <A HREF="http://$source_host:$port/">$source_host</A>
<LI> Directory: $local_dir
<LI> FTP-Directory: <A HREF="ftp://$local_host/$local_ftp_directory">$local_ftp_directory</A>
<LI> Floodd Daemon: <A HREF="http://$local_floodd/floodd">$local_floodd</A>
<LI> Neighbors: $neighbor_urls
<LI> Admin Directory: $local_admin
<LI> User: $local_user
<LI> Host: $local_host
<LI> Time: $local_date
</UL>
';

$HTTP_PAGES{'UPDATE_ENTRY'} = '
<LI>
Host: ($update_id) $site Version: $version ($version_time)
 Retry Time: $retry_time
</LI>
';

$HTTP_PAGES{'INPROGRESS'} = '
<H3> Mirror in Progress</H3>
<UL>
<LI> Pid: $update_process
<LI> Host: $remote_site
<LI> Version: $remote_version
<LI> Version File: $remote_file
<LI> User : $remote_user
<LI> Password: $remote_password
<LI> Directory: $remote_directory
</UL>
';

$HTTP_PAGES{'UPDATE_LOG'} = '
<H3> Log $update_log_date </H3>
';

$HTTP_PAGES{'LOCAL_LOG'} = '
<H3> Log $local_log_date </H3>
';

# Exit status for forked processes.

$NET_FAILURE    = 3;		# Some sort of network error
$PARAM_FAILURE  = 4;		# A parameter didn't work
$CONFIG_FAILURE = 5;		# A parameter didn't work
$MIRROR_FAILURE = 6;		# Mirror failed.
$UPDATE_FAILURE = 7;		# The update command failed.

#
# Parse command line switches
#
# -p port_num
# -l local_log_file
#
@SAVED_ARGV=@ARGV;
$mirrord_prog = $0;

&Getopts ('df:l:mp:t');

if ($opt_l)
{
    $local_log_file = $opt_l;
    open (LOG_FILE, ">$local_log_file") || die ("Could not open log file: $!");
    select (LOGFILE); $* = 1; select (STDOUT);
}

if ($opt_p)
{
    $port = $opt_p;
}
    
if ($opt_f)
{
    $configfile = $opt_f;
}

if ($opt_m)
{
    $local_master = 1;
    $local_command = "/<A HREF=new-version>New Version</A>";
}

if ($opt_d) {
    print "Searching library directories:";
    foreach $libr (@INC) {
      print " $libr";
    }
    print " for sys/socket.ph...\n";
} 

if ($#ARGV > 1)
{
    print STDERR "Usage: $ARGV[0] [opts]\n";
    print STDERR "Options:\n";
    print STDERR "-f\tconfig_file\n";
    print STDERR "-l\tlog_file\n";
    print STDERR "-p\tport_number:\n";
    print STDERR "-m  (define local site as master/read-only site)"; 
}


$configfile = "./mirrord.conf" unless $configfile;

&set_local_params;

$port = $local_port if ($port == 0);
$port = 4000 unless $port;


$sockaddr = 'S n a4 x8';
($name, $aliases, $proto) = getprotobyname ('tcp');

if ($port !~ /^\d+$/) {
    ($name, $aliases, $proto) = getservbyport($port, 'tcp');
}

chop ($local_host =`hostname`) if ($local_host eq '');
($name, $alias, $type , $len, $local_inet) = gethostbyname ($local_host);
local ($local_inetaddr) =  join (".", unpack ('C4', $local_inet));

$local_addr = pack ($sockaddr, &AF_INET, $port, "\0\0\0\0");

socket (SOCKET, &AF_INET, &SOCK_STREAM, $proto) || die "socket: $!";

setsockopt(SOCKET, &SOL_SOCKET, &SO_REUSEADDR, pack("l", 1));

# try and bind.
local ($retries) = 0;

while (!bind (SOCKET, $local_addr) && $retries < 10)
{
    sleep 30;
}

if ($retries >= 10)
{
    print STDERR "Could not bind to socket\n";
}

listen (SOCKET, 5) || die "listen: $!";
# Set SOCKET to be non buffered
select (SOCKET); $| = 1; select (stdout);


# Set up the next exec time (exec once a day)
$next_exec_time = time + 24 * 60 * 60;


# Test the loghost deamon in a tight loop
if ($opt_t)
{
    &notify_logger ("Log-Test: dante\n");
    exit 1;
}

&daemon;

sub 
daemon
{
    # loop forever

    for (;;) {
	$rin = $win = $ein = '';
	vec ($rin, fileno (SOCKET), 1) = 1;

	foreach $fh (keys %child_pipes)
	{
	    vec ($rin, fileno ($child_pipes{$fh}), 1) = 1;
	}

#	$timeout = $next_sync_time - time;
	$timeout = 10;

	&set_proc_title (":select()");
	($nfound, $timeleft) = 
	    select ($rout = $rin, $wout = $win, $eout = $ein, $timeout);

	if ($nfound > 0) {
	    # Check to see if the occured on the socket, if so, do an accept.
	    if ( vec ($rout, fileno (SOCKET), 1) == 1)
	    {
		&set_proc_title (":accept()");
		($addr = accept (NS, SOCKET)) || die $!;
		&process_command (NS, $addr);
		close (NS);
	    } 
	    else		# it must be a command result comming in
	    {
		foreach $fh (keys %child_pipes)
		{
		    if (vec ($eout, fileno ($child_pipes{$fh}), 1) == 1)
		    {
			close ($child_pipes{$fh});
			delete ($child_pipes{$fh});
		    }
		    elsif (vec ($rout, fileno ($child_pipes{$fh}), 1) == 1)
		    {
			&process_command_result ($child_pipes{$fh});
			close ($child_pipes{$fh});
			delete ($child_pipes{$fh});
		    }
		}
	    }
	}

	if ($next_sync_time <= time)
	{
	    &send_to_neighbors ("SYNC\n");
	    $next_sync_time = time + $sync_interval;
	}

	# The old test, just time out if update_proccess has been
	# running for a day.
        #	if ($update_process && $update_process_start_time && 
        #	    ((time - $update_process_start_time) > 24 * 3600))

	# The new stuff.
	# Stat the log file. If the log file has not changed in 15
	# minutes, assume the mirror process had hung so kill it.

	if ($update_process)
	{
	    local ($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,
		   $st_size,$st_atime,$st_mtime,$st_ctime,$st_blksize,
		   $st_blocks) = stat($mirror_log);
	    
	    if ((time - $st_mtime) > (15 * 60))
	    {
		kill 'TERM', $update_process;
		sleep 10;
		kill 'KILL', $update_process;
	    }
	}

	if ($update_process == 0)
	{
	    $update_id = &select_latest ();
	    if ($update_id != 0)
	    {
		local ($site) =
		    &match_field ($update_set{$update_id}, "<SITE>");
		local ($version) = 
		    &match_field ($update_set{$update_id}, "<VERSION>");
		if ($local_master != 0)
		{
		    # If we think we are a master sites, but someone else
		    # has a later version number, then
		    # 1) We aren't really a master site.
		    # 2) Someone else is lying
			
		    &log_message ('warning', "Received update notification, but we are the master site\n");
		    &log_message ('warning', "site: %s version: %s\n", 
				  $site, $version);
		}
		else
		{
		    &log_message ('info', 
				  "Updating from: $update_set{$update_id}\n\n");
		    &notify_logger ();
		    $update_process = &start_update ();
		    $update_process_start_time = time;

		    if ($update_process == -1)
		    {
			$update_process = 0;
			$update_id = 0;
			$update_process_start_time = 0;
		    }
		}
	    }
	    else
	    {
		# We are doing this to get around an apparent "memory leak"
		# in perl.  It seems that mirrord will continue to
		# grow over time to become unreasonable large.
		if ($next_exec_time < time)
		{
 		    close (SOCKET);
		    exec $mirrord_prog, @SAVED_ARGV;
		    die "Couln't exec mirrord: $!\n";
		}
	    }
	    
	}
	&reap_child ();
    }
}

sub
set_local_params
{
    local ($tmp);

    $local_version_file = 
         &local_file_field ("<VERSION-FILE>", $configfile) ||
	     die ("No VERSION-FILE specified in $configfile\n");

    $local_ftp_version_file = 
         &local_file_field ("<FTP-VERSION-FILE>", $configfile) ||
	     die ("No FTP-VERSION-FILE specified in $configfile\n");

    $local_ftp_directory = 
         &local_file_field ("<FTP-DIRECTORY>", $configfile) ||
	     die ("No FTP-DIRECTORY specified in $configfile\n");

    $local_floodd = 
         &local_file_field ("<FLOOD>", $configfile) ||
	     die ("No FLOOD specified in $configfile\n");

    $local_maintainer = 
         &local_file_field ("<MAINTAINER>", $configfile);

    $local_group = 
         &local_file_field ("<GROUP>", $configfile);

     if ($local_master == 0)
     {    
	 $local_master = 
	     &local_file_field ("<MASTER>", $configfile);
     }

    $update_command = 
         &local_file_field ("<UPDATE-COMMAND>", $configfile);

    $local_version = 
         &local_file_field ("<VERSION>", $local_version_file);

    $local_version_time = &gmt ($local_version);

    $local_last_update = 
         &local_file_field ("<LAST-UPDATE>", $local_version_file);

    $local_last_update_time = &gmt ($local_last_update);

    $local_dir = 
	&local_file_field ("<LOCAL-DIRECTORY>", $configfile) ||
	    die ("No LOCAL-DIRECTORY specified in $configfile\n");

    ($local_user = &local_file_field ("<USER>", $configfile)) ||
	chop ($local_user = `whoami`);
    
    ($local_host = &local_file_field ("<HOST>", $configfile)) ||
	chop ($local_host =`hostname`);	# 

    $local_admin = 
	&local_file_field ("<ADMIN-DIRECTORY>", $configfile) ||
	    &failure ($CONFIG_FAILURE, "No local admin directory specified\n");



    $local_port = 
	&local_file_field ("<PORT>", $configfile);

    $tmp = &local_file_field ("<MIRROR-PROG>", $configfile) 
	|| $mirror_prog;
    $mirror_prog = $tmp;

    $tmp = &local_file_field ("<MIRROR-ARGS>", $configfile)
	|| $mirror_args;

    $mirror_args = $tmp;

    $source_host = &local_file_field ("<SOURCE>", $local_version_file);

    $local_stat_file = &local_file_field ("<STATISTICS-FILE>", $configfile) ||
	"$local_admin/mirror.statistics";

    $logger_host = &local_file_field ("<LOGGER-HOST>", $configfile);

    $mirror_log = "$local_admin/mirrord.log";

    $mirror_config = "$local_admin/mirror.config";

    $replica_parameter_file = "$local_admin/replica.params";

    &set_neighbors ();
}

# 
# Go get the set of current neighbors.
# Currently this queries a flood daemon and just pulls the neighbor list from
# the statitics query.
#

sub
set_neighbors
{
    local (@tmp) = &get_neighbors_from_floodd ($local_floodd);

    if (@tmp ne '')
    {
	@local_neighbors = @tmp;
   }
}

#
# Debugging info.  Dump symbol table
#
sub 
http_dump
{
    local ($INPUT) = @_;
    local ($no_output) = 1;
    local ($local_date) = &ctime (time);
    local ($local_log_date);
    local ($_);

    local ($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
	   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = 
	       stat($local_log_file);

    $local_log_date = &ctime ($st_mtime) if ($st_mtime ne '');
    &http_output_template ($INPUT, $HTTP_PAGES{'TITLE'});
    &http_output_template ($INPUT, $HTTP_PAGES{'LOCAL_LOG'});

    print $INPUT "<PRE>\n";

    close (STDERR);
    close (STDOUT);

    open (STDOUT, "> /tmp/mirrord.dump") || (print $INPUT "Could not dump symbol table\n");
    open (STDERR, ">&STDOUT");

    &dumpvar ('main');
    foreach $package (grep(/^_\w+$/, keys(%_main)))
    {
	print "\nPACKAGE = $package\n";
	&dumpvar (substr($package, 1)) unless $package eq "_dumpvar";
    }
    close (STDIN);
    close (STDERR);

    open (FILE, "< /tmp/mirrord.dump") || (print $INPUT "No dump file\n");

    while (<FILE>)
    {
	# Make sure that the <VERSION> type stuff is not misinterpreted
	# by html browser.
	s/</&lt/g;
	s/>/&gt/g;
	print $INPUT $_;
    }
    close (FILE);
    print $INPUT "</PRE>\n"
 }
#
# Retrieve the log of the last update session.
#
sub 
http_update_log
{
    local ($INPUT) = @_;
    local ($no_output) = 1;
    local ($local_date) = &ctime (time);
    local ($update_log_date);
    local ($_);
    local ($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
	   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = 
	       stat($mirror_log);

    $update_log_date = &ctime ($st_mtime) if ($st_mtime ne '');
	
    &http_output_template ($INPUT, $HTTP_PAGES{'TITLE'});
    &http_output_template ($INPUT, $HTTP_PAGES{'UPDATE_LOG'});


    print $INPUT "<PRE>\n";
    open (FILE, "< $mirror_log") || (print $INPUT "No log file\n");

    while (<FILE>)
    {
	# Make sure that the <VERSION> type stuff is not miss interpreted
	# by html browser.
	s#<#&lt#g;
	s#>#&gt#g;
	print $INPUT $_;
    }
    close (FILE);
    print $INPUT "</PRE>\n"
 }

sub 
http_trace_log
{
    local ($INPUT) = @_;
    local ($no_output) = 1;
    local ($local_date) = &ctime (time);
    local ($local_log_date);
    local ($_);

    local ($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
	   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = 
	       stat($local_log_file);

    $local_log_date = &ctime ($st_mtime) if ($st_mtime ne '');
    &http_output_template ($INPUT, $HTTP_PAGES{'TITLE'});
    &http_output_template ($INPUT, $HTTP_PAGES{'LOCAL_LOG'});

    print $INPUT "<PRE>\n";
    open (FILE, "< $local_log_file") || (print $INPUT "No trace log file\n");

    while (<FILE>)
    {
	# Make sure that the <VERSION> type stuff is not misinterpreted
	# by html browser.
	s/</&lt/g;
	s/>/&gt/g;
	print $INPUT $_;
    }
    close (FILE);
    print $INPUT "</PRE>\n"
 }

sub 
http_mirror_statistics
{
    local ($INPUT) = @_;
    local ($no_output) = 1;
    local ($local_date) = &ctime (time);
    local ($update_log_date);
    local ($_);
    local ($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
	   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = 
	       stat($mirror_log);

    $update_log_date = &ctime ($st_mtime) if ($st_mtime ne '');
	
    &http_output_template ($INPUT, $HTTP_PAGES{'TITLE'});

    print $INPUT "<PRE>\n";
    open (FILE, "< $local_stat_file") || 
	(print $INPUT "No statistics file\n"); 

    while (<FILE>)
    {
	# Make sure that some of the html stuff is not miss interpreted
	# by html browser.
	s#<#&lt#g;
	s#>#&gt#g;
	print $INPUT $_;
    }
    close (FILE);
    print $INPUT "</PRE>\n"
    }

sub 
http_parameters
{
    local ($INPUT) = @_;
    local ($_);
    local ($group_name);
    local ($group_description);
    local ($floodd_data_port);
    local ($floodd_client_port);
    local ($mirrord_port);
    local ($broker_port);

    $_ = &read_file ($replica_parameter_file) || 
	"No replica parameters available\n";

    $group_name   	= &match_field ($_, "<GroupName>");
    $group_description 	= &match_field ($_, "<Description>");	
    $group_master   	= &match_field ($_, "<GroupMaster>");
    $floodd_data_port   = &match_field ($_, "<DataPort>");
    $floodd_client_port = &match_field ($_, "<ClientPort>");
    $mirrord_port 	= &match_field ($_, "<MirrordPort>");
    $broker_port  	= &match_field ($_, "<BrokerPort>");

    print $INPUT "<TITLE>Installation Parameters For Replicas</TITLE>\n";
    print $INPUT "<BODY>\n";
    print $INPUT "<P>\n";
    print $INPUT "<LI> GroupName: $group_name</LI>\n";
    print $INPUT "<LI> Description: $group_description</LI>\n" 
	if ($group_description ne '');
    print $INPUT "<LI> MasterSite: $group_master</LI>\n";
    print $INPUT "<LI> FlooddDataPort: $floodd_data_port</LI>\n";
    print $INPUT "<LI> FlooddClientPort: $floodd_client_port</LI>\n";
    print $INPUT "<LI> MirrordPort: $mirrord_port</LI>\n";
    print $INPUT "<LI> BrokerPort: $broker_port</LI>\n"
	if ($broker_port ne '');
    print $INPUT "</BODY>\n";
    print $INPUT "\n";
    close (FILE);
 }

#
# Send a 'SYNC' message to a neighbor.
# Basically we want to out a "SYNC" message to all of our neighbors.
# When they receive a sync message, they will distribute their current 
# update state.
# 
sub
http_synchronize
{
    local ($INPUT) = @_;
    &send_to_neighbors ("SYNC\n");
    $next_sync_time = time + $sync_interval;
    &http_statistics ($INPUT);
}

#
# Print some info about the broker in html.
#
sub 
http_statistics
{
    local ($INPUT) = @_;
    local ($no_output) = 1;
    local ($local_date) = &ctime (time);
    local ($neighbor_urls) = '';
    local ($id);
    local ($_);

    &http_output_template ($INPUT, $HTTP_PAGES{'TITLE'});

    for $host (@local_neighbors)
    {
	$neighbor_urls .= "<A HREF=\"http://$host:$port\">$host </A> ";
    }

    &http_output_template ($INPUT, $HTTP_PAGES{'STATISTICS'});

    if ($update_process != 0)
    {
	local ($update_spec)     = $update_set{$update_id};
	local ($remote_version)  = &match_field ($update_spec, "<VERSION>");
	local ($remote_site)     = &match_field ($update_spec, "<SITE>");
	local ($remote_file)     = &match_field ($update_spec, "<VERSION-FILE>");
	local ($remote_directory)= &match_field ($update_spec, "<DIRECTORY>");
	local ($remote_user)     = &match_field ($update_spec, "<USER>");
	if ($remote_user eq "ftp") 
	{
	    local ($remote_password) = "$local_user\@$local_host";
	}
	else
	{
	    local ($remote_password) = "********";
	}

	if ($update_spec eq '')
	{
	    &log_message ('error', 
			  "Null update spec: update_id = $update_id\n");
	    
	}
	if ($remote_version eq '')
	{
	    &log_message ('error', 
			  "Null remote version: update_id = $update_id\n");
	    &log_message ('error', 
			  "Spec: update_id = \`$update_spec\'\n");
	}

	&http_output_template ($INPUT, $HTTP_PAGES{'INPROGRESS'});
    }

    print $INPUT "<H3>Notification Set</H3>\n";
    print $INPUT "<UL>\n";
    foreach $id (keys %update_set)
    {
	local ($update_id) = $id;
	local ($spec) = $update_set{$id};
	local ($site) = &match_field ($spec, "<SITE>");
	local ($version) = &match_field ($spec, "<VERSION>");
	local ($retry_time) = &ctime ($update_time{$id});

	&http_output_template ($INPUT, $HTTP_PAGES{'UPDATE_ENTRY'});
	$no_output = 0;
    }
    if ($no_output)
    {
	print $INPUT "<H3>No pending update notifications</H3>";
    }

    print $INPUT "<P><I>Maintained by $local_maintainer</I><P>";
    print $INPUT "</UL>\n";

#    print $INPUT "<H2> Log </H2>\n";
#    print $INPUT "<PRE>\n";
#    for (@log_buffer)
#    {
#	# Make sure that the <VERSION> type stuff is not misinterpreted
#	# by html browser.
#	s/</&lt/g;
#	s/>/&gt/g;
#	print $INPUT $_;
#    }
#    print $INPUT "</PRE>\n";
}

sub
http_new_version
{
    local ($INPUT, $inetaddr) = @_;
    local ($ret_val);

    print PARENT "NEW-VERSION\n";
    print PARENT "<ADDRESS>\n$inetaddr\n</ADDRESS>\n";
    close (PARENT);
    &http_statistics ($INPUT);
}

#
# Process a nifty little html template.
#
sub
http_output_template 
{
    local ($INPUT, $data) = @_;
    local ($new) = &substitute_variables ($data);
    print $INPUT "$new";
}

#
# Process an http 'GET' request.
# Just look up the command in our table and eval it.
#
sub
process_http
{
    local ($INPUT, $command, $addr) = @_;
    local ($foo, $element, $tag, *attributes) = split (/[ \t]/, $_, 3);
    local ($routine) = $HTTPCOMMANDS{$element};
    if ($routine eq "") {
	&log_message ('info', "Unknown HTTP command: $element\n");
    }
    else 
    {
	#
	# We should put more of the common variable initialization here
	# for the http commands.
	#
	&set_neighbors ();

	local ($sync_time) = $next_sync_time - time;
	local ($sync_string) = '';
	$sync_message = sprintf ("%2d hours %2.2d minutes %2.2s seconds until next synchroniztion.", 
				 $sync_time / (60 * 60), 
				 ($sync_time % (60 * 60)) / 60,
				 $sync_time % (60 * 60 * 60));

	&log_message ('debug', "http: $element\n");
	eval "&$routine ($INPUT, \"$addr\")";
    }
}

#
# Read all data from socket until EOF and return it.
#
sub
get_command_data
{
    local ($INPUT, $command) = @_;
    local ($ret_val);
    local ($/) = -1;

    $ret_val = <$INPUT>;
    print PARENT "$command\n";
    print PARENT "$ret_val\n";
    close (PARENT);
}

sub
get_new_version_data
{
    local ($INPUT, $command, $inetaddr) = @_;
    local ($ret_val);
    local ($/) = -1;

    $ret_val = <$INPUT>;
    print PARENT "$command\n";
    print PARENT "<ADDRESS>\n$inetaddr\n</ADDRESS>\n";
    close (PARENT);
}

#
# Process a command from the command line interface.  We first fork to 
# prevent anything from hanging the process.
# A pipe is opened to the child to allow the child to send back data
# that can be read in a non-blocking manner by the parent.
# Possible commands are given in the assoc array $COMMANDS.
#
sub 
process_command
{
    local ($INPUT, $addr) = @_;
    local ($pid);
    local ($fh);
    local ($_);
    # Create a uniq file handle. This is insane.  Do I really have to do this?
    local ($READ) = $command_count++;

    # Fork off a child to do the reading and verification of the command.
    # The results will be written back via a pipe we fairly sure will
    # will be non blocking.
    pipe ($READ, PARENT);

    if (($pid = fork ()) != 0)
    {
	$child_processes{$pid} = "COMMAND";
	$child_pipes{$pid} = $READ;
	close (PARENT); 
	return;
    }

    #
    # Now in the child
    #

    # now close all those other pesky file descriptors.

    for $fh (%child_pipes)
    {
	close ($child_pipes{$fh});
    }

    # Close the read handle since we are only ever going to write
    # to this socket
    close (READ);

    # Get the inet address
    ($tmp_af, $remote_port, $remote_inet) = unpack ($sockaddr, $addr);

    # Get the first line of input
    $_ = <$INPUT>;

    # Write out a log message.  Any log messages written in the child
    # will not be recorded in the parent unless we output them to a syslog
    # or something.
    &log_message ('debug', $_);
    s/[\n\r]+//g;

    local ($command, $arg, $rest) = split (/[\s]/, $_, 3);
    local ($routine) = $COMMANDS{$command};

    if ($routine eq '') 
    {
	&log_message ('info', "Unknown command \`$command\'\n");
    }
    else {
	$inetaddr = join (".", unpack ('C4',$remote_inet));

	&log_message ('info', "processing \`$command\ ($routine)'\n");
	eval "&$routine ($INPUT, \"$command\", \"$inetaddr\")";
    }
    close ($INPUT);
    close (PARENT);
    exit (0);
}

#
# When child returns, it is either a forked command reading process, or it
# was a update attempt.
# If it was a update attempt, we check to see if errors occurs by examining
# the result codes returned by the child.  If an error occured we have to
# decide if we want to try and reschedule, or just dump the request.
# If no errors occured, we need to update our bookkeeping.
#
sub 
reap_child 
{
    local ($pid) = waitpid (-1, $WNOHANG);
    local ($return_val) = ($? >> 8);

    if (($pid == -1) || ($pid == 0))
    {
	return;
    }

    if ($pid == $update_process)
    {
	&log_message ('debug', "Reap_child: status = $return_val\n");
	if ($return_val == 0)
	{
	    local ($version) = 
		&local_file_field ("<VERSION>", $local_version_file);
	    if ($version != 0)
	    {
		$local_version = $version;
		$local_version_time = &gmt ($version);
	    }
	    $update_failure = 0;
	    &remove_from_update_set ($update_id);
	}
	else
	{
	    if ($return_val == $NET_FAILURE)
	    {
		# Reschedule.
		$update_time{$id} = time + $reschedule_interval;
		&log_message('info', "Network Failure: rescheduling: $update_set{$update_id}\n");
	    } 
	    elsif ($return_val == $PARAM_FAILURE)
	    {
		# Ditch the update notification request as bogus.
		&remove_from_update_set ($update_id);
		&log_message('info', "PARAM FAILURE: removing: $update_set{$update_id}\n");
	    }
	    elsif ($return_val == $CONFIG_FAILURE)
	    {
		&log_message ('error',
			      "Mirrord is misconfigured.  Exiting..\n");
		die ("Mirrord is misconfigured.  Exiting..\n");
	    }
	    elsif ($return_val == $UPDATE_FAILURE)
	    {
		&log_message ('error',
			      "`$update_command' failed.  Ignoring..\n");
	    }
	    else
	    {
		&log_message ('error', "Update process failed ($return_val)\n");
		&remove_from_update_set ($update_id);
		$update_failure++;
#		if ($update_failure > 20)
#		{
#		    &log_message ('error', "Too many update failures.  Aborting\n");
#		    die ("Too many update failures.  Aborting\n");
#		}
	    }
	}
	
	$update_process = 0;
	$update_process_start_time = 0;
	$update_id = 0;
    } 

    delete ($child_processes{$pid});
}

#
# Given the results of a command line interaction, processes it.
# We need to read the string returned and then invoke the correct
# handler.
#
sub
process_command_result 
{
    local ($INPUT) = @_;
    local ($errors);
    local ($data);
    local ($_);
    local ($/);
    local ($mode) = $/;
    $/="\n";
    $_ = <$INPUT>;
    s/[\n\r\s]+//g;
    local ($command) = $_;
    $/ = -1;
    $data = <$INPUT>;
    $/ = $mode;
    
    &log_message ('debug', "COMMAND: \`$command\'\n") if ($command);
    &log_message ('debug', "COMMAND RESULT: \`$data\'\n") if ($command);
    &set_neighbors ();
    &process_update_notification ($data) if ($command eq "UPDATE");
    &process_new_version ($data) if ($command eq "NEW-VERSION");
    &process_sync ($data) if ($command eq "SYNC");
}

#
# Create a new version by incrementing the VERSION file and
# distributing it to the neighbors.
# 
sub
process_new_version
{
    local ($data) = @_;
    local ($remote_inetaddr) = &match_field ($data, "<ADDRESS>");
    &log_message ('debug', "NEW-VERSION doing stuff\n");

    if ($local_master != 0)
    {
	if ($remote_inetaddr == $local_inetaddr)
	{
	    $local_version = time;
	    $local_version_time = &gmt ($local_version);
	    &update_version_file ($local_version);
	    &notify_neighbors ();
	}
	else
	{
	    &log_message ('warning',
			  "NEW-VERSION not authorized for your host.'\n");
	}
    }
    else
    {
	&log_message ('warning', "Can't generate new version.  Not master'\n");
    }
}

#
# Send out versions to neighbors
#
sub
process_sync
{
    &log_message ('debug', "SYNC doing stuff\n");
    &notify_neighbors ();
}

#
# Parse and deal with an update notification.
#
sub
process_update_notification
{
    local ($data) = @_;
    local ($errors);
    local ($spec);
    local ($value);

    # Check to see that we have all the right fields
    foreach $field (keys %UPDATE_FIELDS)
    {
        $value = &match_field ($data, $field);
	if ( $value eq '')
	{
	    &log_message ('error', "Missing $field\n");
	    $errors ++;
	}
	else
	{
	    $spec .= "$field\n";
	    $spec .= "$value\n";
	    $spec .= "<\/";
	    $spec .=  substr ($field, 1, length ($field) - 1);
	    $spec .= "\n";
	}
    }

    if ( $errors != 0)
    {
	&log_message ('error',  "Bad update notication\n");
    }
    else
    {
	&insert_in_update_set ($spec) if (! $local_master);
    }
}

#
# Read a file and return results as a string.
#
sub
read_file 
{
    local ($filename) = @_;
    local ($ret_value);
    local ($line);
    
    open (FILE, $filename) || return;
    while ($line = <FILE>)
    {
	$ret_value = $ret_value . $line;
    }
    close (FILE);
    return $ret_value;
}


#
# A tricky function.  We have a string contaning perl variables that we
# wish to evaluate.  This bit'o'magic does that.
#
sub
substitute_variables 
{
    local ($_) = @_;
    local ($ret_val) = '';
    local ($first) = 1;

    for (split(/\n/)) 
    {
	s/\\/\\\\/g;
	s/"/\\"/g;
	$ret_val = $ret_val . "\n" . eval qq/"$_"/;

	$first = 0;
    }
    return $ret_val;
}

# Match a multi line pattern from a string
# E.g.
# if $string =
# <COMMENT>
# This is
# A comment
# </COMMENT>
# `match_field ($string, "<COMMENT>")'  would return
# This is
# A coment
#
sub
match_field 
{
  local ($_, $begin) = @_;
  local ($end);
  local ($*);
  local ($value);

  $* = 1;

  $end = "<\/" . substr ($begin, 1, length ($begin) - 1);
  if (/^\s*$begin[\r]?\n([\n\s\S]*)[\r]?\n$end/)
  {
      if ($1[length ($1) - 1] eq "\r")
      {
	  $value = substr ($1, 0, length ($1) - 1);
      }
      else
      {
	  $value = $1;
      }
  }
  
  return $value;
}

#
# Maintain the update set.
# We need to ensure that we don't already have an update from the indicated
# site.
#
sub
insert_in_update_set
{
    local ($spec) = @_;

    local ($site) = &match_field ($spec, "<SITE>");
    local ($version) = &match_field ($spec, "<VERSION>");

    # See if we already have an update notification from this site for this
    # version
    if ($update_sites{$site} != 0)
    {
	local ($version_we_have) = 
	    &match_field ($update_set{$site}, "<VERSION>");
	return if ($site_version == $version_we_have);

#	&remove_from_update_set ($update_sites{$site});
    }
    
    if ($version <= $local_version)
    {
	return;
    }

    $update_count++;
    $update_set{$update_count} = $spec;
    $update_version{$update_count} = &match_field ($spec, "<VERSION>");
    $update_time{$update_count} = time;
    $update_sites{$site} = $update_count;
}

#
# Remove an update id from the all the places we stuff them.
#
sub
remove_from_update_set
{
    local ($id) = @_;
    local ($spec) = $update_set{$id};
    local ($site) = &match_field ($spec, "<SITE>");

    delete $update_set{$id};
    delete $update_version{$id};
    delete $update_time{$id};
    delete $update_sites{$site};
}

#
# Select a feasible site to mirror from
# 1) Remove any but the latest version.
# 2) Make sure update time is later than the current time.
# 3) Pick one of the remainder.
# We only return a value if we have waited a sufficient time for multiple
# requests to be returned.
# It might make sense to put this in the main loop so someone reading this
# code would have a clue as to what's happening, but it would really mess up
# flow there, and this is perl so who knows what is going on anyway.
#

sub
select_latest
{
    local (@feasible) = '';
    local ($latest) = '';
    local ($result) = '';

    # Compute a feasible set
    # Select those whose update times have expired.

    if ($#update_set == 0)
    {
	return 0;
    }


    # Check to see that we have waited a sufficient period of time to collect
    # several update requests.
    if ($next_select_time > 0 && $next_select_time < time)
    {
	return 0;
    }

    # If the update set is not empty, and we don't have a select time
    # then set it so we can wait for some more updates.
    if ($#update_set > 0 && $next_select_time == 0)
    {
	$next_select_time = time + 60;
	return 0;
    }
    
    # We have reached next_select_time, so lets reset it to 0, and then
    # select something.

    $next_select_time = 0;

    foreach $id (keys %update_set)
    {
	# remove old versions
	if ($update_version{$id} < $local_version)
	{
	    &log_message ('debug', "Removing UPDATE host: %s version: %s\n",
			  &match_field ($update_set{$update_id}, "<HOST>"),
			  &match_field ($update_set{$update_id}, "<VERSION>"));


	    delete $update_set{$id};
	    delete $update_version{$id};
	}
	elsif ($update_time{$id} <= time)
	{
	    # collect only the latest versions.

	    if ($update_version{$id} > $latest)
	    {
		$latest = $update_version{$id};
		@feasible = '';
	    }

	    if ($update_version{$id} == $latest)
	    {
		$bw = $bandwidth{$site};
		$bw = 1024 if ($bw <= 0);
		$rtt = $round_trip_time{$site};
		$rtt = 200 if ($rtt <= 0);
		$metric = $rtt / $bw;

		$feasible{$id} = $update_version {$id};
		push (@feasible, $id);
	    }
	}
    }

    if ($#feasible == 0)
    {
	return 0;
    }

    $result = @feasible[rand @feasible];

    return $result;
}

# 
# Retrieve a field from a configuration file.
#
sub
local_file_field
{
    local ($field, $filename) = @_;;
    local ($contents);
    local ($ret_value);

    $contents = &read_file ($filename);
    
    $ret_value = &match_field ($contents, $field);
    return $ret_value;
}

#
# Initiate an update.
# We do a fork and then call the function that calls the update program.
#
sub
start_update
{
    local ($fh);
    local ($id) = fork();

    if ($id == 0) 
    {
	# This is the child
	# Close old file descriptors
	for $fh (%child_pipes)
	{
	    close ($child_pipes{$fh});
	}
	# Do the update.
	# open an update log

	unlink ($mirror_log);
	open (STDOUT, ">$mirror_log") ||
	    &failure ($PARAM_FAILURE,
		     "Could not open logfile \'$mirror_log\'.\n");

	open (STDERR, ">&STDOUT");
	print STDOUT &ctime (time);

	&update_from_spec ($update_set{$update_id});
	exit 0;
    }
    elsif ($id > 0) 
    {
	# This is the parent
	return $id;
    }
}

#
# Setup and configure a mirror process to mirror the remote site.
# 
# Requires that the following variables be set:
#
# $configfile="/usr/local/harvest/replica/mirrord.conf";
# Assumes local paramss are already set:
# $local_dir
# $local_user
# $local_host
# $local_admin
#

#
sub
update_from_spec
{
    local ($update_spec)     = @_;
    local ($updated_remote_spec);
    local ($ret_val);
    local ($wait_status);
    local ($remote_site)     = &match_field ($update_spec, "<SITE>");
    local ($remote_file)     = &match_field ($update_spec, "<VERSION-FILE>");
    local ($remote_user)     = &match_field ($update_spec, "<USER>");
    chop  (local ($whoami) =`whoami`);
    local ($remote_password) = &match_field ($update_spec, "<PASSWORD>") ||
	(local ($remote_password) = "$whoami\@$local_host");
    local ($remote_directory)= &match_field ($update_spec, "<DIRECTORY>");

    $local_version_file = 
         &local_file_field ("<VERSION-FILE>", $configfile);
    local ($local_version) = 
         &local_file_field ("<VERSION>", $local_version_file);

    $remote_spec = &get_remote_spec ($remote_site, 
				    $remote_user,
				    $remote_password,
				    $remote_file)  ||
					die ("Couldn\'t get remote version");

    $remote_version = &match_field ($remote_spec, "<VERSION>");
    
    &log_message ('debug', "Remote version $remote_version, $local_version (local version)\n");
    if ($remote_version <= $local_version)
    {
       &log_message ('debug', "Remote version $remote_version <= $local_version (local version)\n");
	exit 0;
    }

    if ($remote_directory eq '')
    {
	&failure ($CONFIG_FAILURE, "Remote directory $remote_directory invalid\n");
    }
    # Okey dokey, now fire up the mirror process
    # Find out where the local directory goes

    $remote_config = &match_field ($remote_spec, "<UPDATE-TEMPLATE>");

    if ($remote_config eq "")
    {
	&failure ($CONFIG_FAILURE, "Could not get remote UPDATE-TEMPLATE\n");
    }

    open (CONFIG, "> $mirror_config") || die ("could not open config file \`$mirror_config\'");
    
    chmod 0600, $mirror_config;
    $remote_config = &substitute_variables ($remote_config);
    print CONFIG $remote_config;
    close (CONFIG);

    &log_message ('debug', "$mirror_prog $mirror_args $mirror_config");
    $ret_val = system ("$mirror_prog $mirror_args $mirror_config");

    &log_message ('debug', "system() returned $ret_val\n");
    
    # In the return value for mirror, the low 3 bits give the exit code
    # and if any transfers took place the 4 bit is set high.  We don't really
    # care if transfers took place, we just want to know if the thing worked, 
    # so we only check the low 3 bits.

    $wait_status = $ret_val & 15;
    $ret_val = ($ret_val >> 8) & 15;
       
    &log_message ('debug', "Mirror returned $ret_val\n");

    # Summarize the ftp log and append it to a log file
    ($host, $bytes, $objects) = &summarize_mirror_log ($mirror_log);

    if (open (STATFILE, ">> $local_stat_file\n"))
    {
	printf STATFILE "time: %d host: $host version: $remote_version bytes: $bytes objects: $objects\n",
	time;
	close (STATFILE);
    }

    if ($ret_val != 0 || ($wait_status != 0))
    {
	&failure ($MIRROR_FAILURE, "Mirror exited with status $ret_val");
    }
    # We need to update the VERSION file.
    &log_message ('info', "VERSION-FILE: $local_version_file\n");

    open (VERSION, "> $local_version_file.$$\n") || die ("Could not create version file $local_version_file.$$\n");

    $updated_remote_spec = &set_field ($remote_spec, "<LAST-UPDATE>", time);

    print VERSION $updated_remote_spec;
    close (VERSION);
    unlink ("$local_version_file");
    rename ("$local_version_file.$$", "$local_version_file");
    chmod (0644, $local_version_file);

    # Now run the update command
    if ($update_command ne '')
    {
	$ret_val = system ($update_command);
	$wait_status = $ret_val & 15;
	$ret_val = ($ret_val >> 8) & 15;
	if ($ret_val != 0 || ($wait_status != 0))
	{
	    &failure ($UPDATE_FAILURE, "Update exited with status $ret_val");
	}
    }
    exit 0
#    unlink ($mirror_config);
}

sub
get_remote_spec
{
    local ($remote, $user, $password, $remote_file) = @_;
    local ($ftp_port) = 21;
    local ($retry_call) = 1;
    local ($attempts) = 2;
    local ($local_file) = "/tmp/mirrord.version.$$";

    &ftp'open ($remote, $ftp_port, $retry_call, $attempts) ||
        &failure ($NET_FAILURE, "failed to open ftp:://$remote:$ftp_port");

  if (! &ftp'login( $user, $password))
    {
	$password = "********" if ($user ne "ftp");
	&failure ($PARAM_FAILURE, "failed to login ftp:://$remote:$ftp_port?user=$user,password=$password");
    }
    
    &ftp'type( $text_mode ? 'A' : 'I' );
    if (! &ftp'get( $remote_file, $local_file, 0))
    {  
       unlink ($local_file);
       &failure ($PARAM_FAILURE, "failed to get ftp:://$remote/$remote_file->$local_file");
    }

  &ftp'quit;
# outwit fontify with this lil'quote

  $file = &read_file ($local_file);
  unlink ($local_file);
  return $file;
}

sub
notify_neighbors
{
    local ($update_message) = &make_update_message ();

    &set_neighbors ();

    &send_to_neighbors ($update_message);
}

sub
send_to_neighbors
{
    local ($message) = @_;
    local ($site);

    for $site (@local_neighbors)
    {
	&log_message ('debug', $message);
	&enqueue_message ($site, $message);
    }
}

sub
update_version_file
{
    local ($version) = @_;
    local ($_);
    local ($*) = 0;
    &set_proc_title ("updating version: $version");
    $_ = &read_file ($local_version_file);
    # $_ contains the specification.  Now substitute in the
    # new version number.
    s/<VERSION>([\n\r\d]+)<\/VERSION>/<VERSION>\n$version\n<\/VERSION>/;
    open (VERSION, "> $local_version_file.$$") || 
	die ("Could not create version file $local_version_file.$$\n");
    
    print VERSION $_;
    close (VERSION);
    unlink ("$local_version_file");
    rename ("$local_version_file.$$", "$local_version_file");
    chmod (0644, $local_version_file);
}

sub
set_field
{
    local ($_, $begin, $value) = @_;
    local ($*) = 0;
    local ($end) = "</" . substr($begin, 1, length ($begin));

    if (/$begin[\r]?\n([\n\s\S]*)[\r]?\n$end/)
    {
	 s/$begin[\r]?\n([\n\s\S]*)[\r]?\n$end/$begin\n$value\n$end/;
     }

    # $_ contains the specification.  Now substitute in the
    # new value.
#    s/$begin([\n\r\d]+)$end/\n$value\n/;
    return ($_);
}

sub
failure
{
    local ($error, $message) = @_;
    $! = $error;
    &log_message ('error', $message);
    die ($message);
}

# 
# Get a list of neighbors from floodd.
#

sub
read_floodd_response
{
    local ($SOCKET) = @_;
    local ($ret_value);
    local ($stuff);
    local ($/) = -1;

    while ($stuff = <$SOCKET>)
    {
	$ret_value .= $stuff;
    }
    return $ret_value;
}

sub
get_neighbors_from_floodd
{
    local ($site) = @_;
    local ($SOCKET, $error) = &connect_to_site ($site);
    local ($response);

    if ($SOCKET eq '')
    {
	&log_message ('info', "Could not connect to \`$site\': $error\n");
	return;
    }

    select ($SOCKET); $| = 1; select (STDOUT);
    # get groups
    print $SOCKET "statistics\nquit\n";
    $response = &read_floodd_response ($SOCKET);
    close ($SOCKET);
    return (&get_neighbors_from_statistics ($response));
}

#
# Grab the neighbor information from the statistics info returnd
# by floodd.
# 
sub
get_neighbors_from_statistics 
{
    local ($stats) = @_;
    local ($*) = 1;
    local (@lines) = split (/\n/, $stats);
    local (@sites) = grep (/site-name/, @lines);
    local (@bw) = grep (/bandwidth/, @lines);
    local (@rtt) = grep (/round/, @lines);
    for (@bw)
    {
	s/[\s]*\(:bandwidth[\s]*|\)//g;
    }
    for (@rtt)
    {
	s/[\s]*\(:round-trip-time[\s]*|\)//g;
    }
    for (@sites)
    {
	s/[\s]*\(:site-name[\s]*|\)//g;
    }
    &log_message ('debug', "neighbors: @sites\n");
    %bandwidth='';
    %round_trip_time='';
    local ($i);
    for ($i = 1; $i <= $#sites; $i++)
    {
	$round_trip_time{@sites[$i]} = @rtt[$i - 1];
	$bandwidth{@sites[$i]} = @bw[$i - 1];
    }

    # Don't return the first site since that is the local site name.
    return @sites[1..$#sites];
}


#
# Establish a tcp connection to a named site.  The site can be of the form
# domainname[:portnumber].
#
sub
connect_to_site
{
    local ($site) = @_;
    local ($remote_host, $port) = split (/:/, $site);
    local ($sockaddr) = 'S n a4 x8';    

    if ($remote_host eq '')
    {
	return ('', "No Hostname specified");
    }
 
    if ($port eq '')
    {
	$port = $local_port;
    }

    local ($SOCKET) = ++$connect_number;

    local ($name, $aliases, $proto) = getprotobyname ('tcp');
    local ($name, $aliases, $port) = getservbyname ($port, 'tcp')
	unless $port =~ /^\d+$/;;

    (local ($name, $aliases, $type, $len, $local_inet) = 
     gethostbyname ($local_host)) || 
	 return ('', "gethostbyname(\"$local_host\" failed: $!");

    (local ($name, $aliases, $type, $len, $remote_inet) = 
     gethostbyname ($remote_host)) || 
	 return ('', "gethostbyname(\"$remote_host\" failed: $!");
    
    local ($local_addr) = pack ($sockaddr, &AF_INET, 0, $local_inet);
    local ($remote_addr) = pack ($sockaddr, &AF_INET, $port, $remote_inet);

    socket ($SOCKET, &AF_INET, &SOCK_STREAM, $proto) ||
	return ('', "Could not create socket: $!\n");

    
    local ($result) = bind ($SOCKET, $local_addr);
    if (!$result)
    {
	local($err) = $!;
	close ($SOCKET);
	return ('', "Could not bind socket: $err");
    }
    local ($result) = connect ($SOCKET, $remote_addr);

    if (! $result)
    {
	local($err) = $!;
	close ($SOCKET),
	return ('', "Could not connect to $remote_host:$port: $err\n");
    }
    return ($SOCKET, '');
}


sub 
make_update_message
{
    local ($ret_val);

    $ret_val = "UPDATE\n";
    $ret_val .= "<VERSION>\n$local_version\n</VERSION>\n";
    $ret_val .= "<SITE>\n$local_host\n</SITE>\n";
    $ret_val .= "<VERSION-FILE>\n$local_ftp_version_file\n</VERSION-FILE>\n";
    $ret_val .= "<USER>\n$local_user\n</USER>\n";
    $ret_val .= "<PASSWORD>\n$local_password\n</PASSWORD>\n" if ($local_password);
    $ret_val .= "<DIRECTORY>\n$local_ftp_directory\n</DIRECTORY>\n";

    &log_message ('debug',  "update message: $ret_val\n");
    return "$ret_val";
}

#
# Message handling stuff.
# We want to be able to send message to other sites aynchronously.
# but for now we do it synchronously.
#
sub
enqueue_message 
{
    local ($site, $message) = @_;

    return if ($site eq '');

    &log_message ('debug', "sending to \`$site\'\n");
    
    &set_proc_title ("sending to: $site");

    local ($SOCKET, $error) = &connect_to_site ($site);

    if ($SOCKET eq '') 
    {
	&log_message ('info', "Could not send to $site: $error\n");
    }
    print $SOCKET "$message\n";
    close ($SOCKET);
}

#
# A logging facility for error message
#
sub
log_message 
{
    local($priority) = shift;
    local($mask) = shift;
    local($time) = &ctime (time);
    local($message);
    local ($whoami);

    chop ($time);

    $message = $time . ": " . sprintf ($mask, @_);
    
    print LOG_FILE "$message"  if ($local_log_file);
    
    # Add this message to our log buffer.
    #
    if ($#log_buffer > $log_buffer_max)
    {
	shift @log_buffer;
    }
    push (@log_buffer, $message);
}

#
# Stoled this from mirror.pl
#
sub 
real_dir_from_path
{
    local( $program ) = @_;
    local( @prog_path ) = split( m:/: , $program );	# dir collection
    local( $dir );

    while( -l $program )				# follow symlink
    {
	$program = readlink( $program ); # 
	if( $program =~ m:^/: )		# full path?
	{
	    @prog_path = ();		# start dir collection anew
	}
	else 
	{
	    pop( @prog_path );		# discard file name
	}
	push( @prog_path, split( m:/:, $program ) );# add new parts
	    $program = join( '/', @prog_path );  # might be a symlink again...
    }
    pop( @prog_path );
    $dir = join( '/', @prog_path );
    
    if( ! $dir )
    {
	$dir = '.';
    }
    
    return $dir;
}

# Set the title of the procesure so PS gives useful information:
sub
set_proc_title 
{
local ($messasge) = @_;

    $0 = "mirrord:$local_group $message";
}

sub
gmt 
{
    local ($time) = @_;
    local ($result);

     $old = $ENV{'TZ'} if (defined ($ENV{'TZ'}));
    $ENV{'TZ'} = 'GMT';
    $result = &ctime($time);
    if (defined ($old))
    {
	$ENV{'TZ'} = $old ;
    }
    else
    {
	delete $ENV{'TZ'};
    }

    return $result;
}

# Go through the verbose output from mirror and compute the total
# bytes and objects sent.  The host is also returned.
# the return value is a tuple (host, bytes, object).
#
sub
summarize_mirror_log 
{
    local ($file) = @_;
    local ($ext) = $file;
    local ($total_bytes) = 0;
    local ($total_objects) = 0;

    if ($ext =~ /.*\.gz$/)
    {
	open (LOGFILE, "zcat $file|");
    }
    else
    {
	open (LOGFILE, "< $file");
    }

    while (<LOGFILE>)
    {
	if (/Connecting to (\S+)/)
	{
	    $host = $1;
	}

	if (/^Got[ \t]+([\d]+) bytes.*/)
	{
	    $total_bytes += $1;
	    $total_objects++;
	}
    }
    return ($host, $total_bytes, $total_objects);
}

sub
notify_logger
{
    local ($info) = @_;
    return if ($logger_host eq "");

    local ($id) = fork();

    if ($id == 0) 
    {
	# This is the child
	# Close old file descriptors
	for $fh (%child_pipes)
	{
	    close ($child_pipes{$fh});
	}

	# contact the stats host and pass back basic info.
	local ($SOCKET, $error) = &connect_to_site ($logger_host);

	if ($SOCKET eq '')
	{
	    &log_message ('info', "Could not connect to \`$logger_host\': $error\n");
	    return;
	}
	printf $SOCKET "Time:%d\nVersion:$version\nLocal-Host:$local_host\nUpdate-host:$site\n";
	print $SOCKET "$info\n" if ($info);
	print $SOCKET "\n";
	    
	close ($SOCKET);
	exit 0;
    }
}
;# getopts.pl - a better getopt.pl

;# Usage:
;#      do Getopts('a:bc');  # -a takes arg. -b & -c not. Sets opt_* as a
;#                           #  side effect.

sub Getopts {
    local($argumentative) = @_;
    local(@args,$_,$first,$rest);
    local($errs) = 0;
    local($[) = 0;

    @args = split( / */, $argumentative );
    while(@ARGV && ($_ = $ARGV[0]) =~ /^-(.)(.*)/) {
	($first,$rest) = ($1,$2);
	$pos = index($argumentative,$first);
	if($pos >= $[) {
	    if($args[$pos+1] eq ':') {
		shift(@ARGV);
		if($rest eq '') {
		    ++$errs unless @ARGV;
		    $rest = shift(@ARGV);
		}
		eval "\$opt_$first = \$rest;";
	    }
	    else {
		eval "\$opt_$first = 1";
		if($rest eq '') {
		    shift(@ARGV);
		}
		else {
		    $ARGV[0] = "-$rest";
		}
	    }
	}
	else {
	    print STDERR "Unknown option: $first\n";
	    ++$errs;
	    if($rest ne '') {
		$ARGV[0] = "-$rest";
	    }
	    else {
		shift(@ARGV);
	    }
	}
    }
    $errs == 0;
}


# 
# UpdateNotification:
#  VERSION
#  package-name (for ftp-mirror)
#  neighbor-name
#  ftp-mirror-configuration-template
#  username-to-use-for-remote
#  password-to-use-for-remote
#  topology
#MirrorPermission
#  sitename.

# *DataStructures*
#
# update_set: Contains  {update_request, retry_time} pairs
#
#    For all update in update_set
#      if (update.retry_time <  current_time)
#	 add to feasible_set;
#
#    Sort by feasible_set by version
#    purge_all_but_latest_versions (feasible_set)
#    result = random_select (feasible_set)
#    return (result);
#}
    
#}
#
#
#while (1)
#   {
#      wait until connection, or child_done
#      if (connection)
#       {
#	  CONNECTION = accept_connection
#	  read CONNECTION request;
#
#	  switch (request.type)
#	   {
#	    case UPDATE_NOTIFICATION:
#	       if (not master_site)
#	         insert (update_set, request)
#	       break;
#
#	    }
#	   close CONNECTION
#       }
#
#      if (child_done)
#   	{
#	  if (child_exit_status = BUSY || child_exit_status == FAILURE)
#	    {
#		# Add a minimum retry time
#		# and put last_update_spec back in retry_set?
# 	    }
#	}
#      purge_old_version_notifications (update_set);
#
#      if (!ftp_mirror_running) 
#	{
#
#	  update-spec = select_latest (update_set)
#	  spawn (do_ftp_mirror (update-spec))
#	  last_update_spec = update_spec;
#	}
#   }     
#}
#
#do_ftp_mirror (update-spec)
#{
#  remote_site = get_site (update_spec);
#  remote_version = get_version_from (remote_site)
#
#  if (remote_version < local_version)
#    exit (SUCCESS);
p#
#  # If we want to restrict the number of concurrent ftp-mirrors on the 
#  # remote sites, we would have to do something here like query the remote 
#  # daemon for permission to do it.  I can't see keeping a static count on the
#  # remote host since in the event of a failure it might not get cleaned up.
#  # A cute hack would be to just check the number of ftp daemons going 
#  # owned by the mirror user.
#
#    config = create_mirror_config (update-spec)
#
#    result = run ("ftp-mirror config remote_site");
#
#    if (result == FAILURE)
#      exit (FAILURE)
#
#    update_local_version ()
#
#    neighbors = get_neighbors (update-spec);
#
#    for n in neighbors do
#     send_update_notice (update-spec, n)
#
#    exit (SUCCESS)
#    }
#}
#
##
## Select a most promising candiate to replicate from.
##
#select_latest (update_set)
#{
#    For all update in update_set
#      if (update.retry_time <  current_time)
#	 add to feasible_set;
#
#    Sort by feasible_set by version
#    purge_all_but_latest_versions (feasible_set)
#    result = random_select (feasible_set)
#    return (result);
#}
#
## Run on the master sites.  Could be invoked by cron, or some.
#archived ()
#{
#  if (any files older than VERSION file)
#   { 
#     update_local_version ();
#	
#     update-spec = create_update_spec ();
#	
#     neighbors = get_neighbors (update-spec)
#
#     for n in neighbors do
#	send_update_notice (update-spec, n)
#   }
#}





