#ifndef _STATISTICS_H_
#define _STATISTICS_H_

typedef struct
{
  SiteID id;
  int round_trip_time;
  int bandwidth;
} Statistics;

Statistics *
statistics_new (SiteID id);

void
statistics_free (Statistics *stat);

void
statistics_update_rtt (Statistics *stat, struct timeval time);

void
statistics_update_bandwidth (Statistics *stat, int size, struct timeval time);

int
statistics_compare (Statistics *a, Statistics *b);

int
statistics_by_id (SiteID *id, Statistics *b);

#ifndef NOTSET
#define NOTSET -1
#endif
#endif /* _STATISTICS_H_ */
