#include <siteid.h>
#include <sys/types.h>
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

int
siteid_compare (SiteID *a, SiteID *b)
{
  if (a->addr.addr < b->addr.addr)
    return (-1);

  if (a->addr.addr == b->addr.addr)
    {
      if (a->port.port < b->port.port)
	return (-1);

      if (a->port.port == b->port.port)
	return (0);

      return (1);
    }

  return (1);
}

char *
siteid_to_string (SiteID *id)
{
  static char temp[17]; 
  sprintf (temp, "%d.%d.%d.%d:%d", 
	   id->addr.bytes[0],
	   id->addr.bytes[1],
	   id->addr.bytes[2],
	   id->addr.bytes[3],
	   ntohs(id->port.port));
  return (temp);
}
