#define MAXLINE	2048		/* max line length */
/*
**  Arrange to use either varargs or stdargs
*/

# ifdef __STDC__

# include <stdarg.h>

# define VA_LOCAL_DECL	va_list ap;
# define VA_START(f)	va_start(ap, f)
# define VA_END		va_end(ap)

# else

# include <varargs.h>

# define VA_LOCAL_DECL	va_list ap;
# define VA_START(f)	va_start(ap)
# define VA_END		va_end(ap)

# endif

/*
**  SETPROCTITLE -- set process title for ps
**
**      Parameters:
**              fmt -- a printf style format string.
**              a, b, c -- possible parameters to fmt.
**
**      Returns:
**              none.
**
**      Side Effects:
**              Clobbers argv of our main procedure so ps(1) will
**              display the title.
*/

#ifdef SETPROCTITLE
# ifdef HASSETPROCTITLE
   *** ERROR ***  Cannot have both SETPROCTITLE and HASSETPROCTITLE defined
# endif
# ifdef __hpux
#  include <sys/pstat.h>
# endif
# ifdef BSD4_4
#  include <machine/vmparam.h>
#  include <sys/exec.h>
#  ifdef __bsdi__
#   undef PS_STRINGS    /* BSDI 1.0 doesn't do PS_STRINGS as we expect */
#   define PROCTITLEPAD '\0'
#  endif
#  ifdef PS_STRINGS
#   define SETPROC_STATIC static
#  endif
# endif
# ifndef SETPROC_STATIC
#  define SETPROC_STATIC
# endif
#endif

#ifndef PROCTITLEPAD
# define PROCTITLEPAD   ' '
#endif

#ifndef HASSETPROCTITLE

/*VARARGS1*/
#ifdef __STDC__
setproctitle(char *fmt, ...)
#else
setproctitle(fmt, va_alist)
        char *fmt;
        va_dcl
#endif
{
# ifdef SETPROCTITLE
        register char *p;
        register int i;
        SETPROC_STATIC char buf[MAXLINE];
        VA_LOCAL_DECL
#  ifdef __hpux
        union pstun pst;
#  endif
        extern char **Argv;
        extern char *LastArgv;

        p = buf;

        /* print floodd: heading for grep */
        (void) strcpy(p, "floodd:");
        p += strlen(p);

        /* print the argument string */
        VA_START(fmt);
        (void) vsprintf(p, fmt, ap);
        VA_END;

        i = strlen(buf);

#  ifdef __hpux
        pst.pst_command = buf;
        pstat(PSTAT_SETCMD, pst, i, 0, 0);
#  else
#   ifdef PS_STRINGS
        PS_STRINGS->ps_nargvstr = 1;
        PS_STRINGS->ps_argvstr = buf;
#   else
        if (i > LastArgv - Argv[0] - 2)
        {
                i = LastArgv - Argv[0] - 2;
                buf[i] = '\0';
        }
        (void) strcpy(Argv[0], buf);
        p = &Argv[0][i];
        while (p < LastArgv)
                *p++ = PROCTITLEPAD;
#   endif
#  endif
# endif /* SETPROCTITLE */
}

#endif
