/* $Id: properties.h,v 1.2 1995/04/22 22:25:28 dante Exp $ */
#ifndef _PROPERTIES_H_
#define _PROPERTIES_H_

typedef char *CPFunction ();
typedef char **CPPFunction ();

/* A "property" is a tagged data item which can be retrieved or set by name.
   Different objects may have different properties; for example, a basketball
   player may have a `shots-attempted' property, while a baseball player may
   have a `lifetime-errors' property. */

typedef enum {
  Prop_String,
  Prop_Integer,
  Prop_Float,
  Prop_Properties,
  Prop_Stats,
  Prop_Pointer,
  Prop_List,
  Prop_Filename,
  Prop_Unknown
} Proptype;

/* A structure which is used to contain a property. */
typedef struct 
{
  Proptype type;	/* Underlying data type. */
  char *tag;		/* Character string describing the property. */
  int size;		/* Size of referenced object if Prop_Pointer. */
  void *value;		/* The value; one of Proptype types. */
  CPFunction *describer; /* Used if non-zero when describing a Prop_Pointer. */
} Property;

/* For every structure which contains an array of Property, the pointer
   to that array comes first in the structure.  This allows us to pass
   the object anonymously to the generic functions get_property () and
   put_property (); */

/* An anonymous structure for property functions. */
typedef struct 
{
  Property **properties;     /* The property list of this object. */
} AnonymousObject;

/* Function definitions */
void *
get_property_value (AnonymousObject *object, char *tag);

#define GET_PROPERTY_VALUE(object, tag) \
 get_property_value ((AnonymousObject *) object, tag)

Property *
get_property (AnonymousObject *object, char *tag);

Property *
get_property_by_key (AnonymousObject *object, char *tag, 
			 Proptype type, void *key);
Property *
get_propertylist_by_key (Property **props, char *tag, 
			 Proptype type, void *key);

#define GET_PROPERTY(object, tag) \
  get_property ((AnonymousObject *) object, tag)

#define OVERRIDE 	1
#define NO_OVERRIDE	2
#endif _PROPERTIES_H_
