/* $Id: message.c,v 1.1 1995/04/22 21:52:51 dante Exp $ */
#include <stdio.h>
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#include <siteid.h>
#include <message.h>

messageid_compare (MessageID *a, MessageID *b)
{
  int result;

  result = siteid_compare (&a->site, &b->site);
  if (result != 0)
    return (-2);

  return (timeval_compare (&a->time, &b->time));
#ifdef NEVER
  if (ntohl (a->time) < ntohl (b->time))
    return (-1);
  if (ntohl (a->time) > ntohl (b->time))
    return (1);
#endif
  return (0);
}
