/* $Id: list.c,v 1.2 1995/04/22 21:09:29 dante Exp $ */
#include <list.h>
#include <xmalloc.h>

extern void *xmalloc ();
extern void *xrealloc ();

void *
list_insert (list, element)
     List *list;
     void *element;
{
  /* increase the size of the list if we have to */
  if (list->count >= (list->max - 1))
    {
      list->max += 5;
      list->list = 
	xrealloc (list->list, list->max * sizeof (void *));
    }

  /* If we have no comparision function
   * just append the value
   */
  if (list->count == 0 || list->compare == NULL)
    {

      list->list[list->count++] = element;
      list->list[list->count] = list->null;
    }
  else /* Do an ordered insert */
    {
      int i;
      void *temp1, *temp2;

      temp1 = element;
      for (i = 0; i < list->count; i++)
	{
	  if (list->compare (element, list->list[i]) > 0)
	    {
	      temp1 = list->list[i];
	      list->list[i] = element;
	      break;
	    }
	}
      for (; i < list->count; i++)
	{
	  temp2 = list->list[i];
	  list->list[i] = temp1;
	  temp1 = temp2;
	}
      list->list[list->count++] = temp1;
    }
  list->list[list->count] = list->null;
  return (list->list);
}

void *
list_delete (list, element)
     List *list;
     void *element;
{
  int i;
  void *result = list->null;

  for (i = 0; i < list->count && element != list->list[i]; 
       i++);

  result = list->list[i];

  /* skip over client & compact the list */
  if (list->count > 0)
    list->count--;

  for (; i < list->count; i++)
    list->list[i] = list->list[i + 1];

  list->list[list->count] = list->null;
  return (result);
}

void *
list_pointer (list)
     List *list;
{
  return (list->list);
}

void *
list_index (list, i)
     List *list;
     int i;
{
  if (i < 0 || i >= list->count)
    return (list->null);

  return (list->list[i]);
}

/* TODO: implement a binary search if the list is ordered 
 */
void *
list_find (list, key, compare)
     List *list;
     void *key;
     int (*compare)();
{
  int i;
  for (i = 0; i < list->count; i++)
    if (compare)
      {
        if (compare(key, list->list[i]) == 0)
          return (list->list[i]);
      }
    else if (list->compare)
      {
	if (list->compare (key, list->list[i]) == 0)
	  return (list->list[i]);
      }
    else if (key == list->list[i])
      return (list->list[i]);

  return (list->null);
}

void
list_zero (list)
     List *list;
{
  list->count = 0;
  list->list[0] = NULL;
}


     
List *
list_new (null, compare)
     void *null;
     int (*compare)(void *a, void *b);
{
  List *list;

  list = xmalloc (sizeof (List));
  memset (list, 0, sizeof(List));
  list->max = 5;
  list->count = 0; 
  list->null = null;
  
  /* Methods */
  list->insert = list_insert;
  list->delete = list_delete;
  list->index = list_index;
  list->find = list_find;
  list->zero = list_zero;

  list->compare = compare;

  /* Create initial list */
  list->list = xmalloc (list->max * sizeof (void *));
  list->list[0] = list->null;

  return (list);
}

void
list_free (list)
     List *list;
{
  xfree (list->list);
  xfree (list);
}

void
list_free_elements (list, xfree)
     List *list;
     FreeFunc *xfree;
{
  int i;
  if (list == NULL)
    return;

  for (i = 0; i < list->count; i++)
    xfree (list->list[i]);

  list_zero (list);
}

