/* $Id: http.c,v 1.3 1995/07/25 20:06:05 dante Exp $ */
#include <stdio.h>
#include <ctype.h>
#include <floodd.h>
#include <config.h>
#include <bprintf.h>

typedef void http_func (int fd, char *command);

#define METHOD_GET	1
#define METHOD_POST	2

extern int client_count;
extern char *version;

char *navigation = "<H4><A HREF=\"/\">Home</A>/<A HREF=\"/statistics\">Statistics </A>/<A HREF=\"/local\">Local Parameters</A>/<A HREF=\"/estimates\">Estimates</A></H4><BR>";

char *refresh = "<META HTTP-EQUIV=\"Refresh\" CONTENT=120>";

void
http_not_found (char *url, int fd);


#define bprintf_int_field(buffer, preamble, field, value, postamble) \
{ \
   bprintf (buffer, "%s(%s %d)%s", preamble, field, value, postamble); \
}

typedef struct
{
  char *tag;
  char *value;
} Tag;

/* HTTP utility functions */
int
snarf_method (char *command)
{
  if (strncmp (command, "GET", 3) == 0)
    return (METHOD_GET);

  if (strncmp (command, "POST", 4) == 0)
    return (METHOD_POST);

  return (0);
}

char *
snarf_url (char *command)
{
  char *begin;
  char *end;
  char *url;
  int length = 0;

  begin = command;

  /* skip over "GET, or POST " */
  while (*begin && isalpha (*begin))
    begin++;

  if (begin == NULL)
    return (NULL);

  if (!isspace (*begin))
    return (NULL);

  begin++;

  end = begin;

  while (*end && !isspace (*end))
    {
      length++;
      end++;
    }

  if (begin == end)
    return (NULL);

  url = xmalloc (length + 1);
  strncpy (url, begin, length);
  url[length] = '\0';
  return (url);
}

char *
url_remainder (char *command, char *prefix)
{
  char *begin;
  char *end;
  char *pos;
  char *remainder;
  int length = 0;

  begin = strstr (command, prefix);

  if (begin == NULL)
    return (NULL);

  pos = prefix;
  while (*pos)
    {
      if (*begin == '\0')
	return (NULL);
      pos++;
      begin++;
    }

  end = begin;
  while (*end && !isspace (*end))
    {
      length++;
      end++;
    }
  remainder = xmalloc (length + 1);
  strncpy (remainder, begin, length);
  remainder[length] = '\0';

  return (remainder);
}

char *
http_next_line (char *buffer)
{
  char *ptr = strstr (buffer, "\r\n");
  if (*ptr == '\0')
    return (NULL);
  
  ptr++;
  ptr++;

  if (*ptr == '\0')
    return (NULL);

  return (ptr);
}

int
http_is_blank (char *buffer)
{
  return (strncmp (buffer, "\r\n", 2) == 0);
}

#ifdef NEVER
char **
http_parse_mime_fields (char *buffer)
{
  char **fields = NULL;
  char **fields_count = 0;
  char **fields_max = 4;
  char *line;
  char *end;
  int length;
  fields = xmalloc ((fields_max + 1) 8 sizeof (char **));
  fields[0] = NULL;
  /* Skip the URL */

  line = http_next_line (buffer);

  while (!http_is_blank (line))
    {
      /* Get the length of the line */
      length = 0;
      end = line;

      while (*end && (*end != '\n' && *end != '\r'))
	{
	  end++;
	  length++;
	}
      
      field = xmalloc (length + 1);
      strncpy (field, line, length);
      field[length] = '\0';

      if (field_count >= fields_max)
	{
	  fields_max *= 2;
	  fields = xrealloc ((fields_max + 1) 8 sizeof (char **));
	}
      fields[field_count++] = field;
    }
  fields[field_count] = NULL;
  
  return (fields);
}
#endif

/* Return a tag structure. The tag looks like:
 * foo=bar&
 */
Tag *
http_content_tag (char *buffer)
{
  Tag *tag;
  char *tag_begin;
  char *tag_end;
  int tag_length = 0;
  char *value_begin;
  char *value_end;
  int value_length = 0;

  tag_end = tag_begin = buffer;

  /* Get the tag */
  while (*tag_end != '&' && *tag_end != '=' && *tag_end != '\r')
    {
      tag_length++;
      tag_end++;
    }

  value_begin = tag_end;
  value_begin++;

  value_end = value_begin;
  while (*value_end != '&' && *value_end != '\r')
    {
      value_length++;
      value_end++;
    }

  /* Now create the tag and return it */
  
  tag = xmalloc (sizeof (Tag));
  tag->tag = xmalloc (tag_length + 1);
  strncpy (tag->tag, tag_begin, tag_length);
  tag->tag[tag_length] = '\0';

  tag->value = xmalloc (value_length + 1);
  strncpy (tag->value, value_begin, value_length);
  tag->value[value_length] = '\0';

  return (tag);
}

char *
http_next_tag (char *buffer)
{
  char *ptr;
  
  ptr = strchr (buffer, '&');
  if (ptr == NULL)
    return (NULL);
  ptr++;
  return (ptr);
}

/*
 * parse content fields
 * the content looks something like arg1=value1&arg2=value2..
 */

Tag **
http_parse_form_content_fields (char *buffer)
{
  Tag **fields = NULL;
  int fields_count = 0;
  int fields_max = 4;
  char *content;

  fields = xmalloc ((fields_max + 1) * sizeof (char **));
  fields[0] = NULL;

  content = buffer;
  /* find the beginnig of the content fields */
  /* skip the headers */

  while (content && !http_is_blank (content))
    content = http_next_line (content);

  if (content == NULL)
    return (fields);

  /* Skip the blank line */
  content = http_next_line (content);

  /* now parse the content */
  while (content && *content)
    {
      if (fields_count >= fields_max)
	{
	  fields_max *= 2;
	  fields = xrealloc (fields, (fields_max + 1) * sizeof (char **));
	}
      fields[fields_count++] = http_content_tag (content);
      content = http_next_tag (content);
    }

  fields[fields_count] = NULL;

  return (fields);
}

void
http_free_content_fields (Tag **fields)
{
  int i;
  if (fields == NULL)
    return;

  for (i = 0; fields[i]; i++)
    {
      xfree (fields[i]->tag);
      xfree (fields[i]->value);
      xfree (fields[i]);
    }
  xfree (fields);
}

#define output_buffer_and_return_void(fd, buffer) \
{ \
   client_output_buffer (fd, buffer->buffer, buffer->bindex); \
   buffer->buffer = NULL; \
   free_output_buffer (buffer); \
   return; \
}


void
html_header (BprintfBuffer *buffer, char *meta, char *subpage)
{
  bprintf (buffer, "HTTP/1.0 200 OK
Pragma: no-cache

<HTML>%s<TITLE>Floodd Daemon %s</TITLE><BODY>\n<CENTER><H2>Floodd %s<BR>%s<BR>%s<BR></H3>\n%s</CENTER>",
	   (meta) ? meta : "", subpage, version, whoami->name, subpage, navigation);
}

html_footer (BprintfBuffer *buffer)
{
  bprintf (buffer, "</BODY>\n</HTML>\n");
}


void
html_groupmembership (BprintfBuffer *buffer, char *gp_name)
{
  Group *group;
  int i;

  group = group_by_name (gp_name);
  if (group == NULL)
   {
     bprintf (buffer, "ERROR: No group %s\n", gp_name);
     return;
   }
 
  bprintf (buffer, "<OL>");

  for (i = 0; group->sites != NULL && group->sites[i] != NULL; i++)
  {
    bprintf (buffer, "<LI>site-name   <STRONG>%s</STRONG><BR>
hostname    %d<BR>
client-port %d<BR>
data-port %d",
	     sites[i]->name,
	     sites[i]->host,
	     sites[i]->client_port,
	     sites[i]->data_port);
  }
  bprintf (buffer, "</OL>\n");
}

void
html_group_parameters (BprintfBuffer *buffer, char *group_name)
{
  Group *group;

  if (group_name == NULL) 
    {
      bprintf (buffer, "ERROR: group name is NULL");
      return;
    }

  group = group_by_name (group_name);
  if (group == NULL) 
    {
      bprintf (buffer, "ERROR: no group `%s'", group_name);
      return;
    }

  bprintf (buffer, "<UL>");
  if (group->master_site != NULL) 
    bprintf (buffer, "<LI>master-site       %s", group->master_site->name);

  bprintf (buffer, "<LI>ping-period       %d seconds</LI>\n", 
	   group->ping_period);
  bprintf (buffer, "<LI>bandwidth_period  %d seconds</LI>\n",
	   group->bandwidth_period);
  bprintf (buffer, "<LI>update-period     %d seconds</LI>\n",
	   group->update_period);
  bprintf (buffer, "<LI>estimates-period  %d seconds</LI>\n",
	   group->estimates_period);
  bprintf (buffer, "</UL>");
}

/* translate topology string for html display,
   old format: (:topology
		((:siteid site) (:neighbor ...))
	        ...
	       )
   new format: TOPOLOGY
		HOST	NEIGHBORS
		site    neigbor ...
*/
void
html_topology_string (BprintfBuffer *buffer, char *topology)
{
  SiteID  site_id;
  SiteInfo *site;
  char *token;
  char *neighbor_list;
 
  bprintf (buffer, "<UL>\n");
  if (topology == NULL) 
    {
      bprintf (buffer, "<I>Topology not available</I></UL>");
      return;
    }

  bprintf (buffer, "<STRONG>  HOST              NEIGHBORS</STRONG>");
  topology = next_token (strstr (topology, ":topology "));
  neighbor_list = return_list (topology);
  while  (neighbor_list != NULL && *neighbor_list != '\0')
  {
    token = next_token (strstr (neighbor_list, ":site-id"));
    if (token == NULL) {
      break;
    }
 
    scan_siteid (token, &site_id);
    site = site_by_id (&site_id);
    bprintf (buffer, "<LI><I>%s</I> --> ",
	     (site)? site->name : "Unknown");

    token = (char *)strstr (topology, ":neighbors");
    token = next_token (token);
 
    while (*token != '\0' && *token != ')')
    {
      scan_siteid (token, &site_id);
      site = site_by_id (&site_id);
      bprintf (buffer, "%s ", (site)? site->name: "Unknown");
	       token = next_token (token);
    }
    topology = next_list (topology);
    xfree (neighbor_list);
    neighbor_list = return_list (topology);
  }
  xfree (neighbor_list);
  bprintf (buffer, "</UL>\n");
}
 
#define bprintf_int_stat(buffer, tag, value) \
  bprintf (buffer, "<TR><TD><B>%s</B></TD> <TD>%i</TD></TR>\n", \
	   tag, value);

#define bprintf_blocks_bytes(buffer, tag, blocks, bytes) \
  bprintf (buffer, "<TR><TD><B>%s</B></TD> <TD>%i blocks</TD><TD>%i bytes</TD></TR>\n", \
	   tag, blocks, bytes);

void
html_statistics_string (BprintfBuffer *buffer)
{
  int i, j;
  extern Queue *export_queue;
  extern int log_size_in_bytes;
  extern int log_size_in_messages;
  
  bprintf (buffer, "<TABLE>\n<TR><TH>Statistic</TH><TH>Value</TH></TR>");
  bprintf_int_stat (buffer, "clients-count", 	client_count);
  bprintf_int_stat (buffer, "log-size", 	log_size_in_bytes);
  bprintf_int_stat (buffer, "log-length", 	log_size_in_messages);
  bprintf_int_stat (buffer, "export-queue-length", export_queue->size);
  bprintf_int_stat (buffer, "holding-queue", 	whoami->datablocks_to_send->size);
  bprintf_int_stat (buffer, "data-storage-free",datablock_space (0));
  bprintf_int_stat (buffer, "data-storage-max", datablock_space (-1));
  
#ifdef STATISTICS
  bprintf (buffer, "<TR><TD><B>bandwidth-bytes-sent</B></TD> <TD><BW-BYTES-SENT>%i</BW-BYTES-SENT></TD></TR>",
	   count_bandwidth_bytes_sent (0));
  bprintf (buffer, "<TR><TD><B>bandwidth-bytes-received</B></TD> <TD><BW-BYTES-RECEIVED>%i</BW-BYTES-RECEIVED></TD></TR>",
	   count_bandwidth_bytes_received (0));
  bprintf (buffer, "<TR><TD><B>estimate-bytes-sent</B></TD> <TD><ESTIMATE-BYTES-SENT>%i</ESTIMATE-BYTES-SENT></TD></TR>", 
	   count_estimates_bytes_sent (0));
  bprintf (buffer, "<TR><TD><B>estimate-bytes-received</B></TD> <TD><ESTIMATE-BYTES-RECEIVED>%i</ESTIMATE-BYTES-RECEIVED></TD></TR>",
	   count_estimates_bytes_received (0));

/* Start of adding by erhyuan */

  bprintf_blocks_bytes (buffer, "block-send-out", 
			count_sendout_block( 0 ), count_sendout_byte( 0 ));

  bprintf_blocks_bytes (buffer, "block-received", 
			count_received_block( 0 ), count_received_byte( 0 ));

  bprintf_blocks_bytes (buffer, "block-duplicate",
			count_duplicate_block( 0 ), count_duplicate_byte( 0 ));
  bprintf_blocks_bytes (buffer, "block-purged-bandwidth",
			count_purge_block( 0, 0 ), count_purge_byte( 0, 0 ));
  bprintf_blocks_bytes (buffer, "block-purged-topology", 
			count_purge_block( 1, 0 ), count_purge_byte( 1, 0 ));
  bprintf_blocks_bytes (buffer, "block-purged-estimates",
			count_purge_block( 2, 0 ), count_purge_byte( 2, 0 ));

  bprintf_blocks_bytes (buffer, "block-purged-data",
			count_purge_block (3, 0), count_purge_byte (3, 0));

  bprintf_blocks_bytes (buffer, "block-purged-fedex",
			count_purge_block (4, 0), count_purge_byte (4, 0));

  bprintf_blocks_bytes (buffer, "block-purged-join",
			count_purge_block (5, 0), count_purge_byte (5, 0));
  bprintf_int_stat (buffer, "exported-forked-count", count_export ( 0 ));

/* End   of adding by erhyuan */

#endif /* STATISTICS */
  bprintf (buffer, "</TABLE>");

  bprintf (buffer, "<LI>Neighbor list:\n<UL>");
  /* Go through groups and get neighbor information  */

  for (j = 0; groups[j] != NULL; j++)
    {
      for (i = 0; 
	   groups[j]->neighbors != NULL && groups[j]->neighbors[i] != NULL;
	   i++)
	{
	  SiteID *siteid = groups[j]->neighbors[i];
	  SiteInfo *site = site_by_id (siteid);
      
	  if (site && site != whoami) 
	    {
	      bprintf (buffer, "<LI><BR>\n");
	      
	      bprintf (buffer, "site-name         <STRONG>%s</STRONG><BR>\n",
		       site->name);
	      
	      bprintf (buffer, "site-id           %s", 
		       siteid_to_string (siteid));

	      bprintf (buffer, "send-queue-length %i<BR>\n",
		       site->datablocks_to_send->size);

	      bprintf (buffer, "status %s<BR>\n", 
		       (site->status > 0) ? "up" : "down");
	    }
	}
    }
  bprintf (buffer, "</UL></UL>");
  html_footer (buffer);
}


void
html_estimates_string (BprintfBuffer *buffer)
{
  int i;
  Statistics  **stats;
  SiteInfo *site = NULL;

  stats = (Statistics **) whoami->estimates->list;
  bprintf (buffer, "<UL> ");
  if (stats == NULL || stats[0] == NULL) 
    {
      bprintf (buffer, "<I>Estimates not available</I>");
    }
  else 
    {
      bprintf (buffer, "<TABLE BORDER>\n");
      bprintf (buffer, "<TR><TH>Site</TH><TH>Bandwidth</TH><TH>Round Trip Time</TH></TR>\n");
      
      for (i = 0; stats && stats[i]; i++) 
	{
	  bprintf (buffer, "<TR>");
	  site = site_by_id (&(stats[i]->id));
	  bprintf (buffer, "<TR>");
	  bprintf (buffer, "<TD>");
	  if (site) 
	    bprintf (buffer, site->name);
	  else 
	    bprintf (buffer, siteid_to_string (&(stats[i]->id)));
	  bprintf (buffer, "</TD>");
	  bprintf (buffer, "<TD>%d</TD>",stats[i]->bandwidth);
	  bprintf (buffer, "<TD>%d</TD>",stats[i]->round_trip_time);
	  bprintf (buffer, "</TR>");
	}
    }
  bprintf (buffer, "</TABLE>");
}

#define bprintf_sitelabel(buffer, name, id)  \
bprintf (buffer, "<SITENAME>%s</SITENAME><BR><SITEID>%s</SITEID>", \
	 name, siteid_to_string (id)); 

void
html_estimates_table (BprintfBuffer *buffer)
{
  Group *group;
  int i, j, k;

  /* Generate a string containing the input for the topology
   * generator program 
   */

  for (k = 0; groups[k] != NULL; k++)
    {
      group = groups[k];

      bprintf (buffer, "<H2>Estimates for <GROUP>%s</GROUP></H2>", group->name);
      bprintf (buffer,  "<TABLE BORDER>\n<TR><TD>BW / RTT</TD>");

      for (i = 0; group->sites[i]; i++)
	{
	  bprintf (buffer, " <TH><SITEID>");
	  bprintf_sitelabel (buffer, 
				   group->sites[i]->name,
				   &group->sites[i]->id);
	  bprintf (buffer, "</SITEID></TH>\n");
	}

      bprintf (buffer, "</TR>\n");
      for (i = 0; group->sites[i]; i++)
	{
	  SiteInfo *site;

	  site = group->sites[i];
	  bprintf (buffer, "<TR><TH><SITEID>");
	  bprintf_sitelabel (buffer, 
			     group->sites[i]->name,
			     &group->sites[i]->id);

	  bprintf (buffer, "</SITEID></TH>");
	  for (j = 0; group->sites[j] != NULL; j++)
	    {
	      Statistics *stat;
	      int rtt;
	      int bandwidth;

	      stat = 
		LIST_FIND (group->sites[i]->estimates, &group->sites[j]->id,
			   statistics_by_id);

	      if (stat == NULL)
		{
		  rtt = -1.0;
		  bandwidth = -1.0;
		}
	      else
		{
		  rtt = stat->round_trip_time;
		  bandwidth = stat->bandwidth;
		}
	      /* nested table */
	      bprintf (buffer, "<TD>\n<TABLE>\n<TR><TD><BANDWIDTH>%d</BANDWIDTH></TD><TD><RTT>%d</RTT></TD></TR>\n</TABLE>\n</TD>\n</TD>\n", 
		       bandwidth, rtt);
	    }
	  bprintf (buffer, "</TR>\n");
	}
      bprintf (buffer, "</TABLE>\n");
    }
}


/*
 * HTML URL functions.
 */


void
http_cmd_group_data (char *gp_name, int fd)
{
  Group *group;
  BprintfBuffer *buffer;


  group = group_by_name (gp_name);
  if (group == NULL) 
    {
      http_not_found (gp_name, fd);
      return;
  }

  buffer = create_output_buffer ();

  html_header (buffer, NULL, "Group Description");

  bprintf (buffer, "<H3>Group: %s</H3>", gp_name);

  bprintf (buffer, "<H3>Topology:</H3>");
  html_topology_string (buffer, group->topology);
  bprintf (buffer, "<H3>Parameters</H3>");
  html_group_parameters (buffer, gp_name);
  html_footer (buffer);
  
  output_buffer_and_return_void (fd, buffer);
}

void
http_cmd_statistics (int fd, char *command)
{
  BprintfBuffer *buffer;
  buffer = create_output_buffer ();

  html_header (buffer, NULL, "Statistics");
  html_statistics_string (buffer);
  html_footer (buffer);
  output_buffer_and_return_void (fd, buffer);
}

void
http_access_denied (char *url, int fd)
{
  BprintfBuffer *buffer;

  buffer = create_output_buffer ();

  bprintf (buffer, "HTTP/1.0 401 Unauthorized

<HTML>
<HEAD>
<TITLE>Error</TITLE>
</HEAD>
<BODY>
<H1>Error 401</H1>

Unauthorized to access the document

</BODY>
</HTML>");

  output_buffer_and_return_void (fd, buffer);
}

void
http_not_found (char *url, int fd)
{
  BprintfBuffer *buffer;

  buffer = create_output_buffer ();

  bprintf (buffer, "HTTP/1.0 404 Not Found

<HTML>
<HEAD>
<TITLE>404 Not Found</TITLE>
</HEAD>
<BODY><H1>404 Not Found</H1>
The requested URL %s  was not found on this server.<P>
</BODY>
</HTML>", url);
  output_buffer_and_return_void (fd, buffer);
}

/* 
 * We assume that we are handeling "Basic" authentication.
 * If we do not have a password set, than everyone is authorized.  If
 * a password is set, then look throught the mime headers for an
 * Authorization: field.  If we dont find one, return an error.
 * if we do find one, decode the username password and compare it 
 * to whatever we have as a password. We ignore the username.
 */
int
mime_authorization (int fd, char *command)
{
  char plain_user_password[128];
  char encoded_user_password[128];
  char *authorization;
  char *pw;
  int n;

  if (password == NULL)
    return (1);

  authorization = strstr (command, "Authorization:");
  if (authorization == NULL)
    goto fail;

  n = sscanf (authorization, "%*s %*s %127s\n", encoded_user_password);
  
  if (n == 1)
    {
      UU_decode (encoded_user_password, 
		 plain_user_password, 
		 sizeof (plain_user_password));
      if (debug)
	printf ("Authorization: %s\n", plain_user_password);

      /* Match up the password */
      pw = strchr (plain_user_password, ':');
      if (pw != NULL)
	{
	  pw++;
	  if (strncmp (password, pw, strlen (password)) == 0)
	    return (1);
	}
    }

 fail:
  http_access_denied ("", fd);
  return (0);
}

# define HTTP_ESTIMATES 0x01
# define HTTP_TOPOLOGY 0x02
# define HTTP_STATISTICS 0x04

/* floodd home page */
void
http_cmd_home (int fd, char *command)
{
  int i;
  extern Queue *export_queue;
  char *ctime();
  time_t current_time;
  BprintfBuffer *buffer;


  buffer = create_output_buffer ();

  bprintf (buffer, "\n\n<HTML>
<TITLE>Flood Daemon %s</TITLE>
<BODY>
<CENTER>
<H1>Floodd Version %s</H1>
<H2>Host: %s</H2>
%s
<H5> This page will not update automatically.  Reload for new status.</H5>
<H5>Located at  longitude %3.1f lattitude %3.1f</H5>
</CENTER>",
	   whoami->name,
	   version,
	   whoami->host,
	   navigation,
	   whoami->longitude,
	   whoami->lattitude);

  /* for accessing mirrord, or some other application */ 
  if (auxillary_info != NULL)
    bprintf (buffer, "\n%s", auxillary_info);

  /* for forcing topology */
  for (i = 0; groups != NULL && groups[i] != NULL; i++) 
    {

      if (groups[i]->master_site == whoami)
	{
	  bprintf (buffer, "\n<H3> Force group <A HREF=\"/topology-force/%s\"> \
	%s topology update</A></H3>",groups[i]->name, groups[i]->name);
	}
      else
	{
	  if (groups[i]->master_site != NULL)
	    bprintf (buffer, "\n<H3>Group master for %s: <A HREF=\"http://%s:%d/floodd\">%s</A></H3>\n",
		       groups[i]->name, 
		       groups[i]->master_site->name,
		       groups[i]->master_site->client_port,
		       groups[i]->master_site->name);
	}
    }
  
  /* for statistics */
  bprintf (buffer, "\n<H3>Estimates<H3>\n");

  /* for estimates */
  html_estimates_string (buffer);

  /* Groups */
  bprintf (buffer, "\n<H3>Groups<H3>\n<UL>\n");

  for (i = 0; groups != NULL && groups[i] != NULL; i++)
    {

      bprintf (buffer, "\n<LI><A HREF=\"/groups/%s\">%s</A></LI>", 
	       groups[i]->name, groups[i]->name);
    }
  bprintf (buffer, "</UL>\n");

  /* sites */
  bprintf (buffer, "\n<H3>Sites<H3>\n<UL>\n");
  for (i = 0; sites != NULL && sites[i] != NULL; i++)
    {
      bprintf (buffer, 
	       "\n<LI><A HREF=\"http://%s:%i/floodd\"> %s:%i </A></LI>", 
	       sites[i]->host, sites[i]->client_port,
	       sites[i]->name, sites[i]->client_port);
    }
  bprintf (buffer, "\n</UL>");

  /* for local parameters */
  bprintf (buffer,"\n<H3><A HREF=\"/local\">Local Parameters </A></H3>");

  time(&current_time);
  bprintf (buffer, "\n<H3>Local Time: %s</H3>", ctime(&current_time));

  if (maintainer)
    bprintf (buffer, "<P><I>maintainer: %s</I></P><BR>\n", maintainer);

  html_footer (buffer);

  output_buffer_and_return_void (fd, buffer);
}

void
http_cmd_estimates (int fd, char *command)
{
  BprintfBuffer *buffer;
/*  strptr = http_estimates_string (); */
  
  buffer = create_output_buffer ();
  html_header (buffer, refresh, "Estimates");
  html_estimates_table (buffer);
  output_buffer_and_return_void (fd, buffer);
}

void
http_cmd_events (int fd, char *command)
{
  BprintfBuffer *buffer;

  buffer = create_output_buffer ();

  /* output a mime header */
  bprintf (buffer, "\n\n");
  bprintf (buffer, "<HTML><META HTTP-EQUIV=\"Refresh\" CONTENT=60>\n<TITLE>Floodd: Event Queue</TITLE>
<BODY>\n");

  event_queue_html (buffer);

  output_buffer_and_return_void (fd, buffer);
}

void
http_cmd_local_parameters (int fd, char *command)
{
  BprintfBuffer *buffer;

  buffer = create_output_buffer ();
  html_header (buffer, NULL, "Local Parameters");
  
  bprintf (buffer, "<LI>data-storage-max    %i", datablock_space (-1));
  bprintf (buffer, "<LI>site-purge-period   %i", site_purge_period);
  bprintf (buffer, "<LI>log-purge-period    %i", log_purge_period);
  bprintf (buffer, "<LI>bandwidth-size    %i", bandwidth_size);
  bprintf (buffer, "<LI>export-command %s", 
	   (export_command) ? export_command : "not-set");
  bprintf (buffer, "</UL>\n");
  html_footer (buffer);
  output_buffer_and_return_void (fd, buffer);	   
}

/* Process a request for group statistics.
 * since we don't know in advance what groups we will be dealing with
 * we need parse the url on the fly
 */

void
http_cmd_groups (int fd, char *command)
{
  char *group_name;

  /* find the group name */
  
  group_name = url_remainder (command, "/groups/");

  if (group_name == NULL)
    {
      http_not_found ("", fd);
      return;
    }

  http_cmd_group_data (group_name, fd);

  xfree (group_name);
}

void
http_cmd_force_topology (int fd, char *command)
{
  char *group_name;

  /* find the group name */
  
  
  group_name = url_remainder (command, "/topology-force/");

  if (group_name == NULL)
    {
      http_not_found ("", fd);
      return;
    }

  if (mime_authorization (fd, command))
    {
      Group *group;
      BprintfBuffer *buffer;
      group = group_by_name (group_name);
      
      if (group == NULL)
	{
	  http_not_found (group_name, fd);
	  goto done;
	}

      buffer = create_output_buffer ();
      html_header (buffer, NULL, "Force Topology");
      bprintf (buffer, "Forced topology update for %s\n",
	       group_name);
      html_footer (buffer);
      
      reschedule_topology (group);
      xfree (group_name);
      output_buffer_and_return_void (fd, buffer);
    }

 done:
  xfree (group_name);
}

#define bprintf_int_parameter(buffer, tag, value) \
  bprintf (buffer, "<TR><TD ALIGN=right><B>%s</B></TD> <TD><INPUT NAME=\"%s\" value=%d TYPE=int SIZE=10><TD>", \
	   tag, tag, value);

void
http_cmd_modify (int fd, char *command)
{
  BprintfBuffer *buffer;
  int i;

  
  buffer = create_output_buffer ();
  html_header (buffer, NULL, "Parameter Settings");
  bprintf (buffer, "<H2>Set Parameters</H2>\n<UL>\n");
  bprintf (buffer, "<A HREF=\"/modify/local\">local</A>\n");
  bprintf (buffer, "</UL>");

  /* Group parameters */
  bprintf (buffer, "<H2>Set Group Parameters</H2>\n<UL>\n");
  for (i = 0; groups[i] != NULL; i++)
    bprintf (buffer, "<LI><A HREF=\"/modify/groups/%s\">%s</A></LI>\n",
	     groups[i]->name,
	     groups[i]->name);
  bprintf (buffer, "</UL>\n");

  /* Site parameters */
  bprintf (buffer, "<H2>Set Site Parameters</H2>\n<UL>\n");
  for (i = 0; sites[i] != NULL; i++)
    bprintf (buffer, "<LI><A HREF=\"/modify/sites/%s\">%s</A></LI>\n",
	     sites[i]->name, sites[i]->name);

  bprintf (buffer, "</UL>\n");

  html_footer (buffer);
  output_buffer_and_return_void (fd, buffer);
}

void
http_cmd_modify_local (int fd, char *command)
{
  BprintfBuffer *buffer;

  buffer = create_output_buffer ();

  html_header (buffer, NULL, "Modify Local Parameter");
 
  bprintf (buffer, "<FORM ACTION=\"/set-parameters/local\" METHOD=POST>");
  bprintf (buffer, "<CENTER><TABLE>\n<TR><TH>Parameter</TH><TH>Value</TH></TR>");
  bprintf_int_parameter (buffer, "data-storage-max", datablock_space (0));

  bprintf_int_parameter (buffer, "site-purge-period", site_purge_period);
  bprintf_int_parameter (buffer, "log-purge-period", log_purge_period);
  bprintf_int_parameter (buffer, "bandwidth-size", bandwidth_size);
  bprintf (buffer, "</TABLE>");
  bprintf (buffer, "<P ALIGN=CENTER>");
  bprintf (buffer, "<INPUT VALUE=\"   OK   \" TYPE=submit SIZE=20>");
  bprintf (buffer, "<INPUT VALUE=\" Cancel \" TYPE=reset SIZE=20>");
  bprintf (buffer, "</CENTER>");
  bprintf (buffer, "</FORM>");
  html_footer (buffer);
  output_buffer_and_return_void (fd, buffer);
}

#ifdef NEVER
char *
html_generate_config_form (Fields *fields)
{

}
#endif

void
http_group_modify_form (int fd, char *group_name)
{
  Group *group;
  BprintfBuffer *buffer;
  
  buffer = create_output_buffer ();
    
  group = group_by_name (group_name);
  if (group == NULL) 
    {
      bprintf (buffer, "<HTML><BODY><PRE>");
      bprintf (buffer, "ERROR: No group `");
      bprintf (buffer, group_name);
      bprintf (buffer, "'\n");
      bprintf (buffer, "</PRE></BODY></HTML>");
      output_buffer_and_return_void (fd, buffer);
      return;
    }

  html_header (buffer, NULL, "Modify Group Parameters");
  bprintf (buffer,"<CENTER><H2>Group: %s</H2></CENTER>\n", group_name);
 
  bprintf (buffer, "<FORM ACTION=\"/set-parameters/groups/%s\" METHOD=POST>\n",
	   group_name);
  bprintf (buffer, "<INPUT TYPE=\"hidden\" NAME=\"group\" VALUE=\"%s\">\n",
	   group->name);
  bprintf (buffer, "<CENTER><TABLE>\n<TR><TH>Parameter</TH><TH>Value</TH></TR>");
  bprintf_int_parameter (buffer, "bandwidth-period", group->bandwidth_period);

  bprintf_int_parameter (buffer, "bandwidth-period", group->bandwidth_period);

  bprintf_int_parameter (buffer, "connectivity",     group->topology_connectivity);

  bprintf_int_parameter (buffer, "estimates-period", group->estimates_period);

  bprintf_int_parameter (buffer, "join-period",      group->join_period);

  bprintf_int_parameter (buffer, "max-size",         group->max_size);

  bprintf_int_parameter (buffer, "update-period",    group->update_period);
  bprintf (buffer, "</TABLE>");
  bprintf (buffer, "<P ALIGN=CENTER>");
  bprintf (buffer, "<INPUT VALUE=\"   OK   \" TYPE=submit SIZE=20>");
  bprintf (buffer, "<INPUT VALUE=\" Cancel \" TYPE=reset SIZE=20>");
  bprintf (buffer, "</CENTER>");
  bprintf (buffer, "</FORM>\n");
  html_footer (buffer);

  output_buffer_and_return_void (fd, buffer);
}


void
http_cmd_modify_groups (int fd, char *command)
{
  char *group_name;
  
  group_name = url_remainder (command, "/groups/");

  if (group_name == NULL)
    {
      http_not_found ("", fd);
      return;
    }

  http_group_modify_form (fd, group_name);
}


void
http_site_modify_form (int fd, char *site_name)
{
  SiteInfo *site;
  BprintfBuffer *buffer;
  
  buffer = create_output_buffer ();
    
  site = site_by_name (site_name);
  if (site == NULL) 
    {
      bprintf (buffer, "<HTML><BODY><PRE>");
      bprintf (buffer, "ERROR: No site named `%s'\n", site_name);
      bprintf (buffer, "</PRE></BODY></HTML>");
      output_buffer_and_return_void (fd, buffer);
      return;
    }

  html_header (buffer, NULL, "Modify Site Parameters");
  bprintf (buffer,"<CENTER><H2>Site : %s</H2></CENTER>\n", site_name);
 
  bprintf (buffer, "<FORM ACTION=\"/set-parameters/sites/%s\" METHOD=POST>\n",
	   site_name);
  bprintf (buffer, "<INPUT TYPE=\"hidden\" NAME=\"site\" VALUE=\"%s\">\n",
	   site->name);

  bprintf_int_parameter (buffer, "longitude", (int) site->longitude);

  bprintf_int_parameter (buffer, "lattitude", (int) site->lattitude);

  bprintf (buffer, "<P ALIGN=CENTER>");
  bprintf (buffer, "<INPUT VALUE=\"   OK   \" TYPE=submit SIZE=20>");
  bprintf (buffer, "<INPUT VALUE=\" Cancel \" TYPE=reset SIZE=20>");
 
  bprintf (buffer, "</FORM>\n");
  html_footer (buffer);

  output_buffer_and_return_void (fd, buffer);
}

void
http_cmd_modify_site (int fd, char *command)
{
  char *site_name;
  
  site_name = url_remainder (command, "/sites/");

  if (site_name == NULL)
    {
      http_not_found ("", fd);
      return;
    }

  http_site_modify_form (fd, site_name);
}

void
http_set_parameters (int fd, char *command)
{
  Tag **content_fields = http_parse_form_content_fields (command);
  Field *field;
  int i;

  for (i = 0; content_fields[i] != NULL; i++)
    {

      field = field_find (content_fields[i]->tag, local_fields);

      if (field != NULL)
	field->set (NULL, content_fields[i]->value, fd);
    }
  http_free_content_fields (content_fields);
}

void
http_set_group_parameters (int fd, char *command)
{
  Group *group = NULL;
  Field *field;
  Tag **content_fields = http_parse_form_content_fields (command);
  int i;
  
  /* Get the group name */
  for (i = 0; content_fields[i]->tag != NULL; i++)
    if (strcmp (content_fields[i]->tag, "group") == 0)
      {
	group = group_by_name (content_fields[i]->value);
	break;
      }

  if (group == NULL)
    {
      http_not_found ("", fd);
      http_free_content_fields (content_fields);
      return;
    }

  for (i = 0; content_fields[i] != NULL; i++)
    {

      field = field_find (content_fields[i]->tag, group_fields);

      if (field != NULL && field->set != NULL)
	field->set (group, content_fields[i]->value, fd);
    }
  http_free_content_fields (content_fields);
}


void
http_set_site_parameters (int fd, char *command)
{
  SiteInfo *site = NULL;
  Field *field;
  Tag **content_fields = http_parse_form_content_fields (command);
  int i;
  
  /* Get the group name */
  for (i = 0; content_fields[i]->tag != NULL; i++)
    if (strcmp (content_fields[i]->tag, "group") == 0)
      {
	site = site_by_name (content_fields[i]->value);
	break;
      }

  if (site == NULL)
    {
      http_not_found ("", fd);
      http_free_content_fields (content_fields);
      return;
    }

  for (i = 0; content_fields[i] != NULL; i++)
    {

      field = field_find (content_fields[i]->tag, site_fields);

      if (field != NULL && field->set != NULL)
	field->set (site, content_fields[i]->value, fd);
    }
  http_free_content_fields (content_fields);
}

#ifdef NEVER
void
http_something (int fd, char *command)
{
  SiteInfo *site = NULL;
  Field *field;
  int i;
  
  /* Get the group name */
  for (i = 0; content_fields[i]->tag != NULL; i++)
    if (strcmp (content_fields[i]->tag, "group") == 0)
      {
	site = site_by_name (content_fields[i]->value);
	break;
      }

  if (site == NULL)
    {
      http_not_found ("", fd);
      http_free_content_fields (content_fields);
      return;
    }

}
#endif

#define URL_WHOLE   0
#define URL_PARTIAL 1

typedef struct
{
  char *url;
  http_func *http_func;
  int partial;
} URL;

URL url_get_list[] =
{
  {"/", 		http_cmd_home,			URL_WHOLE},
  {"/events", 		http_cmd_events,		URL_WHOLE},
  {"/floodd", 		http_cmd_home,			URL_WHOLE},
  {"/local", 		http_cmd_local_parameters,	URL_WHOLE}, 
  {"/modify",		http_cmd_modify,		URL_WHOLE},
  {"/modify/local",	http_cmd_modify_local,		URL_WHOLE},
  {"/modify/groups/",	http_cmd_modify_groups,		URL_PARTIAL},
  {"/modify/sites/",	http_cmd_modify_site,		URL_PARTIAL},
  {"/estimates",	http_cmd_estimates,		URL_WHOLE}, 
  {"/statistics",	http_cmd_statistics,		URL_WHOLE},
  {"/groups/",		http_cmd_groups,		URL_PARTIAL},
  {"/topology-force/",	http_cmd_force_topology,	URL_PARTIAL},
  {NULL, NULL},
};

URL url_post_list[] =
{
  {"/set-parameters/local",	http_set_parameters,	URL_WHOLE},
  {"/set-parameters/groups/",	http_set_group_parameters, URL_PARTIAL},
  {"/set-parameters/sites/",	http_set_group_parameters, URL_PARTIAL},
#ifdef NEVER
  {"/post-data",		http_flood_data, URL_PARTIAL},
#endif
  {NULL, NULL},
};

int
exec_http_command (int fd, char *buffer)
{
  int i;

  int method = snarf_method (buffer);
  char *url = snarf_url (buffer);

  if (url == NULL)
    {
      http_not_found ("", fd);
      return (-1);
    }

  if (method == METHOD_GET)
    {
      for (i = 0; url_get_list[i].url != NULL; i++)
	{
	  if (url_get_list[i].partial == URL_PARTIAL)
	    {
	      if (strncmp (url_get_list[i].url, 
			   url, 
			   strlen (url_get_list[i].url)) == 0 )
		{
		  url_get_list[i].http_func (fd, buffer);
		  xfree (url);
		  return (0);
		}
	    }
	  else
	    {
	      if (strcmp (url_get_list[i].url, url) == 0)
		{
		  url_get_list[i].http_func (fd, buffer);
		  xfree (url);
		  return (0);
		}
	    }
	}
      http_not_found (url, fd);
    }

  if (method == METHOD_POST)
    {
      for (i = 0; url_post_list[i].url != NULL; i++)
	{
	  if (url_post_list[i].partial == URL_PARTIAL)
	    {
	      if (strncmp (url_post_list[i].url, 
			   url, 
			   strlen (url_post_list[i].url)) == 0 )
		{
		  url_post_list[i].http_func (fd, buffer);
		  xfree (url);
		  return (0);
		}
	    }
	  else
	    {
	      if (strcmp (url_post_list[i].url, url) == 0)
		{
		  url_post_list[i].http_func (fd, buffer);
		  xfree (url);
		  return (0);
		}
	    }
	}
      http_not_found (url, fd);
    }
  xfree (url);
  return (0);
}
