/* $Id: datablock.h,v 1.1 1995/04/22 21:45:49 dante Exp $ */
#ifndef _DATABLOCK_H_ 
#define _DATABLOCK_H_

/* Structure used to pass around hunks of data */
typedef struct
{
  Message header;
  int length;
  char *data;
  int refcount;
} DataBlock;

/* Datablock Types */

DataBlock *
datablock_new (int type, SiteID siteid, void *data, int length);

void
datablock_free (DataBlock *datablock);

int
datablock_read (DataBlock **datablock, int fd,  int *bytes_read);

int
datablock_write (DataBlock *datablock, int fd, int *bytes_read, int data_only);

DataBlock *
datablock_allocate (DataBlock *datablock);

DataBlock *
datablock_set_data (DataBlock *datablock, void *data, int length);


#define NOTSET -1
#endif /* _DATABLOCK_H_ */
