/* bprintf.h: Declarations of functions defined in bprintf.c. */

/* Author: Brian J. Fox (bfox@ua.com) Thu Apr 20 19:34:51 1995. */

#if !defined (_BPRINTF_H_)
#define _BPRINTF_H_

/* A structure used to hold onto a dynamically created buffer of text. */
typedef struct {
  char *buffer;
  int bindex;
  int bsize;
} BprintfBuffer;

/* Create a new empty output buffer. */
extern BprintfBuffer *create_output_buffer (void);

/* The main function in this library.  Print to BUFFER with FORMAT and
   any additional args. */
extern void bprintf (BprintfBuffer *buffer, char *format, ...);

/* Like bprintf, but after the va_list has been started. */
extern void vbprintf (BprintfBuffer *buffer, char *format, va_list args);

/* Free the contents of an output buffer. */
extern void free_output_buffer (BprintfBuffer *buffer);

#endif /* ! _BPRINTF_H_ */
