# forms.pl -- Handle forms data
#
# forms.pl,v 2.2 1994/06/23 16:50:30 sanders Exp
#
# by Tony Sanders <sanders@earth.com>, June 1994
#

package forms;

# $indent is a bit of optional data processing I put it for
# formatting the data nicely when you are emailing it.
# This is derived from code by Denis Howe <dbh@doc.ic.ac.uk>
# and Thomas A Fine <fine@cis.ohio-state.edu>
sub decode {
    local($form, *data, $indent, $key, $_) = @_;
    foreach $_ (split(/&/, $form)) {
	($key, $_) = split(/=/, $_, 2);
	$_   =~ s/\+/ /g;				# + -> space
	$key =~ s/\+/ /g;				# + -> space
	$_   =~ s/%([\da-f]{1,2})/pack(C,hex($1))/eig;	# undo % escapes
	$key =~ s/%([\da-f]{1,2})/pack(C,hex($1))/eig;	# undo % escapes
	$_   =~ s/[\r\n]+/\n\t/g if defined($indent);	# indent data after \n
	$data{$key} = $_;
    }
}
sub string {
    local(*form, $_, $key) = @_;
    $_ = "";
    foreach $key (keys %form) {
	$_ .= join("", $key, " = ", $form{$key}, "\n");
    }
    $_;
}

# You can use this function to test the results from submitting a
# form and make sure it's decoding like you expect.
sub test {
    local($path, $query) = @_;
    local($url) = join("", &main'printable($path), "?", &main'printable($query));
    local($from) = &main'hostname((unpack($main'sockaddr, $main'peeraddr))[2]);
    local(*form);

    &decode(($main'body || $query), *form, 1);

    &main'MIME_header('ok', 'text/html');
    print "<TITLE>Form results</TITLE>\n";
    print "<PRE>\n";
    print "Post: $from: $url\n\n", &string(*form), "\n";
    print "</PRE>\n";
}

# You can use this function to have the form emailed to a certain person
# Note that the email address and subject are the first two arguments...
sub emailto {
    local($whom, $subject, $path, $query) = @_;
    local($path) = &main'printable($path);
    local($from) = &main'hostname((unpack($main'sockaddr, $main'peeraddr))[2]);
    local(*form);

    &decode(($main'body || $query), *form, 1);

    open(MAILER, "| $main'plexus{'mailer'} -s '$subject: $from $path' $whom 2>/dev/null >/dev/null");
    print MAILER "FORM: $subject: $from $path\n";
    print MAILER &string(*form);
    print MAILER "End Of Message\n";
    close(MAILER);
    # Something like this is supposed to point to where we stored the document
    # &main'add_header(*main'out_headers, "URL: XXX");
    &main'MIME_header('ok', 'text/html');
    print "<TITLE>POSTED</TITLE>\n";
    print "Data Posted to $whom\n";
}

1;
