#
# log-simple.pl -- Simple logging functions
#
# log-simple.pl,v 2.2 1993/09/26 02:48:25 sanders Exp
#
# by Tony Sanders <sanders@bsdi.com>, Sept 1993

package logger;

$mailer = 'mail';		# must accept -s

sub init {
    local($log) = $main'plexus_log || shift;
    &main'debug("openlog $log");
    open(LOG, ">>$log") || die "$log: $!";
    select((select(LOG), $| = 1)[0]);
    &main'debug("logfd ", fileno(LOG));
}

sub message {
    local($msg) = @_;
    &main'set_timeout();
    &main'seize(LOG, &main'LOCK_EX);
    print LOG $msg;
    &main'seize(LOG, &main'LOCK_UN);
    &main'clear_timeout;
}

sub error {
    local($status, $msg) = @_;
    open(ERROR, "| $mailer -s 'Plexus: $status' webmaster 2>/dev/null >/dev/null");
    select((select(ERROR), $| = 1)[0]);
    print ERROR "Error: ", $msg, "\n";
    close(ERROR);
}

sub close { close(LOG); }

1;
