Date:         Tue, 11 Jan 1994 13:30:13 EST
From:         Scott Hutton <shutton@habanero.ucs.indiana.edu>
To:           Tony Sanders <sanders@BSDI.COM>
Subject:      Re: A contribution for Plexus3 

Here's the newest version, with a pointer to the docs.

 -Scott

- - - - - - - - - - - - - - - -CUT HERE- - - - - - - - - - - - - - - -
# rfc931.pl -- ident-based identity query
#
# Contributed by Scott Hutton (shutton@indiana.edu)
# rfc931.pl,v 1.1 1994/06/23 05:43:55 sanders Exp
#
# Examples:
# ($username, $remotehostname) = &main'rfc931;
# ($errortype, $remotehostname, $errorstring) = &main'rfc931;
#
# Full documentation available at:
#   http://scwww.ucs.indiana.edu/scpeople/shutton/rfc931.html


package rfc931;

$AF_INET = &main'AF_INET;
$SOCK_STREAM = &main'SOCK_STREAM;
$sockaddr = 'S n a4 x8';
($name, $aliases, $proto) = getprotobyname('tcp');
($name, $aliases, $authport) = getservbyname('auth', 'tcp');
$authport = $authport || 113;
$lsaddr = pack($sockaddr, $AF_INET, 0, (gethostbyname($main'hostname))[4]);

sub main'rfc931 {
    local($af, $rport, $rip) =	# dependent on Tony's code
	unpack($main'sockaddr, $main'peeraddr);

    $rhostname =  &main'hostname($rip);
    $rsaddr = pack($sockaddr, $AF_INET, $authport, $rip);

    # make connection or return error type as userid, error in third element
    socket(S, $AF_INET, $SOCK_STREAM, $proto) || 
	return('err.socket', $rhostname, $!);
    bind(S, $lsaddr) || return('err.bind', $rhostname, $!);
    connect(S, $rsaddr) || return('noauthd', $rhostname, $!);

    # turn off buffering and send query
    select(S); $| = 1; select(STDOUT);
    print S "$rport, $main'plexus_port\n";

    # parse response
    chop($resp = <S>);
    close(S);
    ($ports, $rtype, $ainfo1, $ainfo2) = split(/\s*:\s*/, $resp);
    $rtype =~ /userid/i && do {
        $ainfo2 =~ s/[^\w\.-]*//g;
	return ($ainfo2, $rhostname);
    };
    return ('unknown', $rhostname);
}

1;


# Local variables:
# mode: perl
# End:

