Date:         Tue, 28 Jun 1994 16:48:27 EDT
From:         "William C. Fenner" <fenner@cmf.nrl.navy.mil>
To:           sanders@bsdi.com
Subject:      info.pl for Plexus 3.0

# info.pl -- EMACS info file reader for Plexus
#
# fenner@cmf.nrl.navy.mil - William C. Fenner - June 1993
#
# Copyright (c) 1993     Advanced Research Projects Agency (ARPA/CSTO)
#                                   and the
#                        Naval Research Laboratory (NRL/CCS)
# All Rights Reserved.
# 
# Permission to use, copy, modify and distribute this software and its
# documentation is hereby granted, provided that both the copyright
# notice and this permission notice appear in all copies of the software,
# derivative works or modified versions, and any portions thereof, and
# that both notices appear in supporting documentation.
# 
# ARPA AND NRL ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
# AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
# RESULTING FROM THE USE OF THIS SOFTWARE.
#
#
# Configuration:
#
# Set info_root to the root of your local info tree.
# Example local.conf entry:
# load_path $http_sdir/contrib
# load	info.pl
# set	info_root	/usr/local/info/
#
#

# Cache tags of the current file
# doesn't work, this is supposed to be stateless
%info_curtags=();
$info_curfile='';

sub do_info {
    local($path, $query) = @_;
    local($file,$node,$nfile,$nnode);
    local(*INFO_CURFILE);
    local($newfile,$savebang,$offset,$state,$p);
    local($info_menu_ok,$info_menu,$info_lastblank);
    local($notehack);
    local($i,$j);
    local($info_root)=$main'plexus{'info_root'};

    $info_root .= "/" unless ($info_root =~ m|/$|);

    ($file,$node)=split(',',$path);
    $file = "dir" unless $file;
    $node = "Top" unless $node;
    $node=~s/%20/ /g;
    $node=~s/%23/#/g;
    $node=~s/%3F/?/gi;
	
    if ($file ne $info_curfile) {
	&debug("loading tags for $file (curfile is $info_curfile) pid is $$");
	&debug("info_root is $info_root");
	if (!open(INFO_CURFILE, $info_root . $file)) {
	    # If the file doesn't exist, try it lowercased.
	    $savebang=$! . "";
	    ($nfile=$file) =~ s/(.*)/\L\1/;
	    #&debug("modified $file to $nfile");
	    if (open(INFO_CURFILE, $info_root . $nfile)) {
		$file = $nfile;
	    } else {
		&error('not_found', "$file: $savebang");
	    }
	}
	$info_curfile=$file;
	%info_curtags=&info_get_tags(*INFO_CURFILE);
	#if ($debug) {
	#    foreach $i (keys %info_curtags) {
	#	&debug(sprintf("%s : %s %d",$i,split("\177",$info_curtags{$i})));
	#    }
	#}
    }
    if (!defined($info_curtags{$node})) {
	($nnode=$node) =~ s/(.*)/\L\1/;
	if (defined($info_curtags{$nnode})) {
	    $node=$nnode;
	} else {
	    # Okay, there's no node "Foo" or "foo" in the file.
	    # However, it seems that specifying "foo" when you mean "Foo"
	    # is perfectly valid.  Therefore, this yuck.
	    LOWERTAG:
	    foreach $i (keys %info_curtags) {
		($j=$i) =~ s/(.*)/\L\1/;
		if ($j eq $nnode) {
		    $node = $i;
		    last LOWERTAG;
		}
	    }
	    &error('not_found', "There is no node $node in file $file") unless defined($info_curtags{$node});
	}
    }
    ($newfile,$offset)=split("\177",$info_curtags{$node});
    if ($newfile eq $file) {
	*INPUT_FILE=*INFO_CURFILE;
    } else {
	&error('not_found', "$newfile: $!") unless open(INPUT_FILE, $info_root . $newfile);
	&debug("using $newfile in ");
    }
    &debug("file $info_curfile, offset $offset, for node $node");

# Fudge the offset some; it just has to be before the ^_ and the header.
    if ($offset < 4) {
	$offset = 0;
    } else {
	$offset -= 4;
    }
    seek(INPUT_FILE,$offset,0);
    $state = 0;
    LINE:
    while (<INPUT_FILE>) {
	    chop;
	    if (/\037/) {
		    $state=1;
		    next LINE;
	    }
	    if ($state == 0) {
		next LINE;
	    } elsif ($state == 1) {	# Reading first line of a node
		    if (/^Indirect:/i) {
			    $state = 0;	# skip indirect blocks now
		    } elsif (/^Tag table:/i) {
			    $state = 0;	# skip tag tables now
		    } elsif (/^End tag table/i) {
			    $state = 0;
		    } elsif (/node:\s*([^	,]+)/i) {
			    &debug("Got node $1, looking for $node\n");
			    last LINE if ($1 eq $node);
			    $state = 0;
		    } else {
			    #print STDERR "unknown first line\n$_\n";
			    $state=0;
		    }
	    }   
    }
    if (eof(INPUT_FILE)) {
	&error('not_found',"Could not find node '$node' in info file!");
    }
    print "<HEAD>\n";
    print "<TITLE>Info file $file - node $node</TITLE>\n";
    print "</HEAD><BODY>\n";
    $p=0;
    if (/up:\s*([^	,]+)/i) {
	print "Up: ",&info_make_anchor($1,$1),"\n";
	$p++;
    }
    # The info documentation says "previous", but lots of info files use
    # "prev".  Hooray for well documented file formats.
    if (/prev(ious)?:\s*([^	,]+)/i) {
	print "Previous: ",&info_make_anchor($2,$2),"\n";
	$p++;
    }
    if (/next:\s*([^	,]+)/i) {
	print "Next: ",&info_make_anchor($1,$1),"\n";
	$p++;
    }
    print "<P>\n" if $p;
    $info_menu_ok = 0;
    $notehack="";
    print "<PRE>";
    CONV:
    while (<INPUT_FILE>) {
	chop;
	last CONV if /\037/;
	if (/^\*\s+Menu:/) {
	    $info_menu_ok=1;
	    next CONV;
	}
	if ($notehack) {
	    # Insert saved partial note - see below

	    s/^(\s*)/\1$notehack /;
	    $notehack = "";
	}
# First deal with embedded references
	s/\*note\s+([^:]+):(:|\s*((\([^)]+\))?[^	,.]*))[	 ,.]?/&info_make_anchor($1, $2 eq ':' ? $1 : $3, 1)/egi;
	if (/\*note /i || /\*note$/i) {
	    # There must be a note across a line split.
	    # This is another annoying thing about info files.
	    #
	    # We save the rest of the line in $notehack, and deal
	    # with it next time around.  The assumption of one
	    # space between the end of this line and the start of the
	    # next line might break some info files, but it's the best
	    # assumption I could come up with.  Note that above, $notehack
	    # is inserted into the line after any initial whitespace,
	    # to preserve indents.

	    s/(\*note.*)$//i;
	    $notehack = $1;
	}
# Then check for menu items
	if (s/^\*\s+([^:]+):(:|\s*((\([^)]+\))?[^	,.]*))[	 ,.]*//) {
	    if (!$info_menu) {
		print "</PRE><DL>";
		$info_menu=1;
	    }
	    print "<DT>",&info_make_anchor($1,$2 eq ':' ? $1 : $3),"<DD>",
		    $_,"\n";
	    next CONV;
	}
	if (/^\s*$/) {
	    print "<P>\n" if (!$info_menu && !$info_lastblank);
	    $info_lastblank=1;
	    next CONV;
	}
	$info_lastblank=0;
	if ($info_menu && s/^\s+//) {	# indented lines continue menu items
	    print $_,"\n";
	    next CONV;
	}
	if ($info_menu) {
	    $info_menu=0;
	    print "</DL><PRE>\n";
	}
	print $_,"\n";
    }
    if ($info_menu) {
	print "</DL>\n";
    }
    if ($notehack) {
	print "</PRE><P>\n";
	print "<STRONG>Error parsing info file!</STRONG>  Here's the rest of the page, poorly formatted:\n";
	print "<P>\n";
	print $notehack,"\n";
    }
    print "</BODY>\n";
}

sub info_get_tags {
    local(*INFOFILE)=@_;
    local($state,$offset);
    local(%info_posn);
    local(@indirect,$indirect);
    local($fn,$offst,$node,$useme,$useoff);
    local($i);

    $state = 0;			# skip the first thing in an info file

    LINE:
    while (<INFOFILE>) {
	    chop;
	    if (/\037/) {
		    $state=1;
		    $offset=tell;
		    next LINE;
	    }
	    if ($state == 0) {	# skip the rest of this entry
		    next LINE;
	    } elsif ($state == 1) {	# Reading first line of a node
		    if (/^Indirect:/i) {
			    $state = 2;
		    } elsif (/^Tag table:/i) {
			    $state = 3;
		    } elsif (/^End tag table/i) {
			    $state = 0;
		    } elsif (/node:\s*(([^	,])*)/i) {
			    $info_posn{$1}=$info_curfile . "\177" . $offset;
			    $state = 0;
		    } else {
#			    print "unknown first line\n$_\n";
			    $state=0;
		    }
	    } elsif ($state == 2) {	# Read indirect table
		    @indirect[$#indirect + 1]=$_;
		    $indirect++;
	    } elsif ($state == 3) {
		    if (/^\(indirect\)/i) {
			    next LINE;		# if (!$indirect) die?
		    }
		    if (/node:\s+([^\177]+)\177(\d+)/i) {
			($node,$offset)=($1,$2);
			if (defined($info_posn{$i})) {
			    next LINE;		# believe our info
						# before tag table
			}
			#&debug("reading tag: $1 / $2\n");
			if ($indirect) {
			    INDIRECT:
			    foreach $i (@indirect) {
				($fn,$offst)=split(/: /,$i);
				if ($offst <= $offset) {
				    $useme=$fn;
				    $useoff=$offst;
				} else {
				    last INDIRECT;
				}
			    }
			    $info_posn{$node}=$useme . "\177" . ($offset - $useoff);
			} else {
			    $info_posn{$node}=$info_curfile . "\177" . $offset;
			}
		    } else {
			#print STDERR "unknown line in tag table:\n$_\n";
		    }
	    } else {
#		    print "state is $state\n";
		    $state = 0;
	    }
    }

    %info_posn;
}

sub info_make_anchor {
    local($label,$nod,$note)=@_;
    local($f,$n,$reldir);

    if ($note && !$nod) {
	# Another yucky case of notes splitting lines.  This time it was
	# probably  ... foo foo *note Nodename:
	#           node.
	#
	# If we just put the note back, the regular note hack code will
	# capture this case.  This is only necessary because there is no
	# good way to use a regexp to say "At least one of file or node
	# must be present", so the regexp captures an empty node.
	return "*note $label:";
    }
    ($f,$n) = $nod =~ /(\(.*\))?([^	,.]*)/;
    if ($f) {
	$f =~ s/\((.*)\)/\1/;
    } else {
	$f = $info_curfile;
    }
    $reldir="/info/$f";
    $n =~ s/ /%20/g;
    $n =~ s/#/%23/g;
    $n =~ s/\?/%3F/g;
    $reldir .= ",$n" if $n;

    "<A HREF=\"".$reldir."\">".$label."</A>";
}

1;

