Date:         Tue, 28 Jun 1994 16:43:05 EDT
From:         "William C. Fenner" <fenner@cmf.nrl.navy.mil>
To:           sanders@bsdi.com
Subject:      acl.pl for plexus 3.0

#
# acl.pl
#
# IP address access control
#
# The acl_file has three colon-seperated fields - direcotry, IP address, access
# access is either "allow" or "deny"; anything other than "allow" will be
# treated as "deny".
#
# The acl_file is only read once at startup, be careful of changes while
# running.
#
# An example local.conf entry:
#
# loadpath $http_dir/contrib
# # Access control
# load    acl.pl
# set     acl_file        /usr/local/www/server/acl_access
#
# An example acl_file:
#
# /man/cm:134.207.7.*:allow
# /man/cm:*:deny
# /:*:allow
#
# The first matching entry is the one that matters -- put longer
# entries first!

package acl;

sub main'access {
	local($fromfd, $peeraddr, $action, $dir, $version, $authuser)=@_;
	local($i,$ad);
	local($path,$address,$ok);
	local($fam,$port,$ipaddr) = unpack($main'sockaddr, $peeraddr);

	if (!$initialized) {
		$acl_file = $main'plexus{'acl_file'};

		open(ACL,$acl_file) || &error('forbidden',"$acl_file: $!");
			# If it's important enough to protect, it's important enough
			# to not get served at all if something is wrong.

		@acllist=<ACL>;
		close(ACL);

		grep((chop,s/\s*#.*//,0),@acllist);

		$initialized++;
	}


	$ad=join(".",unpack('C4',$ipaddr));
	$dir="/".$dir unless $dir=~m|^/|;

	$errmsg="Access to $action $dir is forbidden from your host";

	foreach $i (@acllist) {
		($path,$address,$ok)=split(/:/,$i);
		if ($dir =~ m|^$path|) {
			$address =~ s/\./\\./;
			$address =~ s/\*/.*/;
			if ($ad =~ /^${address}$/) {
				if ($ok eq "allow") {
					return 1;
				} elsif ($ok eq "deny") {
#					return 0;
					&main'error('unauthorized',$errmsg);
				} else {
					# foo!
					&main'error('unauthorized',$errmsg);
				}
			}
		}
	}

	&main'error('unauthorized',$errmsg);
	# default is no access
}

1;

