#
# access-filter.pl -- Disallow access to certain paths
#
# access-filter.pl,v 1.2 1993/10/02 07:13:06 sanders Exp
#
# by Tony Sanders <sanders@bsdi.com>, Oct 1993
#
# Read a configuration file and disallow certain paths
# Requires configuration.

sub access {
    local($fromfd, $peeraddr, $action, $path, $version) = @_;
    local($pat);
    foreach $pat (@access_filter'lines) {
        if ((chop $pat) eq 'p') {
            # pass
            /$pat/ && last;
	} else {
	    # fail
	    /$pat/ && &main'error('forbidden', "$action $path invalid");
	}
    }
}

package access_filter;

&access_filter'config($main'plexus{'access-filter-config'});

sub config {
    &main'debug("config $_[0]");
    local($config) = shift || die "access-filter: no config file\n";
    local($pat);
    @lines = ();
    &main'open(CONFIG, $config) || die "$config: $!";
    while (<CONFIG>) {
        if (/^\s*pass\s*(.*)/) { $pat = &main'globpat($1); push(@lines, $pat . 'p'); next; }
        if (/^\s*fail\s*(.*)/) { $pat = &main'globpat($1); push(@lines, $pat . 'f'); next; }
    }
    close(CONFIG);
}

1;
