//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLWindow
//	Include File:	turlwind.h
//	Purpose:	Provide a window for a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-09-94	Split all members into seperate files.
#define Uses_TProgram
#define Uses_TDeskTop
#include"turlwind.h"

TURLWindow::TURLWindow(const char *cp_URL) :
	TWindow(TProgram::deskTop->getExtent(), NULL, Number()),
	TWindowInit(&TWindow::initFrame)	{
//	Purpose:	Constructor for the URL window
//	Arguments:	cp_URL	The url to create the window for.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created

	//	Set our window options and size, no draw buffering.
	options |= ofTileable;
	TRect TR = getExtent();
	TR.grow(-1, -1);

	//	No view yet.
	TURLV = NULL;
	B_isIndex = False;

	//	Create the stack of visited anchors for this window.
	TNSCp_visited = new TNSCollection(1, 1);
	if(TNSCp_visited == NULL)	{
		doslynxmessage("Unable to allocate memory for window.");
		OwnerClose();
	}

	//	Attempt to load the document.
	URLoader(cp_URL);
}
