//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TURLWindow
//	Include File:	turlwind.h
//	Purpose:	Provide a window for a view for a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		03-29-94	created
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_THistory
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TButton
#include"turlwind.h"

void TURLWindow::IndexQuery()	{
//	Purpose:	Query the user for and index search string.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		03-29-94	created

	//	First, check to make sure is a searchable index.
	if(B_isIndex == False)	{
		doslynxmessage("View is not a searchable index.");
		return;
	}

	//	General use rectangle.
	auto TRect TR(0, 0, 50, 7);

	//	Create a dialog that asks for the search string.
	TDialog *TDp_index = new TDialog(TR, "Searchable Index");
	if(TDp_index == NULL)	{
		doslynxmessage("Unable to create index dialog.");
		return;
	}

	//	Set some dialog options.
	TDp_index->options |= ofCentered;

	//      Make the input line to enter the dos device to print to.
	TR = TRect(6, 2, 44, 3);
	TInputLine *TILp_searchString = new TInputLine(TR, usi_TILURLSize - 1);
	TDp_index->insert(TILp_searchString);


	//	Make the input line's label.
	TR = TRect(5, 1, 27, 2);
	TLabel *TLp_prompt = new TLabel(TR, "~E~nter a Search String",
		TILp_searchString);
	TDp_index->insert(TLp_prompt);

	//	Make the input line's history.
	TR = TRect(45, 2, 48, 3);
	THistory *THp_indexHist = new THistory(TR, TILp_searchString,
		usi_IndexHist);
	TDp_index->insert(THp_indexHist);

	//	Insert the Ok and Cancel buttons.
	auto TButton *TBp_button;
	TR = TRect(9, 4, 21, 6);
	TBp_button = new TButton(TR, "~O~K", cmOK, bfDefault);
	TDp_index->insert(TBp_button);
	TR = TRect(24, 4, 36, 6);
	TBp_button = new TButton(TR, "~C~ancel", cmCancel, bfNormal);
	TDp_index->insert(TBp_button);

	//	Stay in the device name field.
	TDp_index->selectNext(False);

	//	Draw the dialog.
	TDp_index->drawView();

	//	Execute the dialog.
	if(TProgram::deskTop->execView(TDp_index) != cmCancel)	{
		//	User didn't cancel, save what we got and attempt
		//	the load.
		auto char ca_buffer[usi_TILURLSize];
		TILp_searchString->getData(ca_buffer);
		URLoader(TURLV->getURL(), ca_buffer);
	}

	//	Done with dialog.
	destroy(TDp_index);
	return;
}