//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
#define Uses_TScreen
#include"turlview.h"

void TURLView::draw()	{
//	Purpose:	Draws the view on the screen.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		This member takes the place of any possible output in
//		the gridtext functions.
//	Revision History:
//		01-10-94	created
//		02-01-04	Endlessly complicated this function by taking
//				all formatting away from the gridtext
//				functions also.
//		02-22-94	Began modifications to work with the
//				serialized rendered image produced by
//				FormatIntoLines.
//				Would create a buffer to read data into,
//				but is redundant since file io is already
//				buffered.  Maybe later as a speed increase.

	//	Drawing buffer.
	TDrawBuffer TDB;

	//	Determine the video's mode and set our index into a manual
	//	pallette for each display mode.
	auto int usi_colorindex;
	switch(TScreen::screenMode & 0x00FF)	{
	case TDisplay::smMono:
		usi_colorindex = 1U;
		break;
	case TDisplay::smBW80:
		usi_colorindex = 2U;
		break;
	default:
		usi_colorindex = 0U;
		break;
	}

	//	Figure the size of a buffer to read in all information needed
	//	to draw the view.
	auto Line L_draw;
	auto signed long int sli_amount;
	auto signed long int sli_offset;
	//	First, read into mem the last line viewable.
	sli_offset = (signed long int)(TNSCp_lines->at((delta.y + size.y - 1
		< limit.y) ? delta.y + size.y - 1: limit.y - 1));
	fsp_temp->seekg(sli_offset);
	fsp_temp->read((char *)(&L_draw), sizeof(Line));
	//	Figure the amount.
	sli_amount = sli_offset + (signed long int)sizeof(Line) +
		(signed long int)L_draw.ssi_length -
		(signed long int)(TNSCp_lines->at(delta.y));
	//	Reset the offset to the offset of the first viewable line.
	sli_offset = (signed long int)(TNSCp_lines->at(delta.y));
	fsp_temp->seekg(sli_offset);
	//	Create a buffer and fill it.
	auto char *cp_draw = new char[(size_t)sli_amount];
	if(cp_draw == NULL)	{
		doslynxmessage("Not enough memory to draw view.");
		return;
	}
	fsp_temp->read(cp_draw, (signed short int)sli_amount);
	if(fsp_temp->gcount() != sli_amount)	{
		doslynxmessage("Error in reading rendered image file.");
		delete[](cp_draw);
		return;
	}

	//	If the selected anchor is not within the part of the rendered
	//	file read, then we should select the first viewable anchor.
	if(TAp_selected != NULL)	{
		if(TAp_selected->getEnd() <= sli_offset || TAp_selected->
			getBegin() >= sli_offset + sli_amount)	{
			//	Attempt to find an anchor in the view.
			auto TextAttribute *TAp_saveSelected = TAp_selected;
			auto ccIndex ccI;

			for(ccI = 0; ccI < TNSCp_anchors->getCount(); ccI++)
			{
				TAp_selected = (TextAttribute *)(TNSCp_anchors
					->at(ccI));
				if(TAp_selected->getEnd() >= sli_offset &&
					TAp_selected->getBegin() <= sli_offset
					+ sli_amount)	{
					break;
				}
			}

			//	Restore the old anchor if none found.
			if(ccI == TNSCp_anchors->getCount())	{
				TAp_selected = TAp_saveSelected;
			}
		}
	}

	//	For faster display through calling the HTMLColor function,
	//	Set the first possible anchor in or past the read offset
	//	now.
	ssi_fasterpussycat = 0;
	if(TNSCp_anchors->getCount())	{
		auto ccIndex ccI;
		auto TextAttribute *TAp_fasterpussycat;

		for(ccI = 0; ccI < TNSCp_anchors->getCount(); ccI++)	{
			TAp_fasterpussycat = (TextAttribute *)(TNSCp_anchors
				->at(ccI));
			//	Break out if the end of this anchor
			//	is greater than the beginning of the offset.
			if(TAp_fasterpussycat->getEnd() >= sli_offset)
			{
				break;
			}
		}

		//	If none are found, mark it as the index anyway,
		//	will cause loop in HTMLColor to now execute.
		ssi_fasterpussycat = ccI;
	}

	//	Loop through the viewable lines in the view.
	for(unsigned short int usi_screen = 0U; usi_screen < size.y;
		usi_screen++)	{

		//	Fill the draw buffer with spaces.
		TDB.moveChar(0, ' ', TextColor, size.x);

		//	Read the line information from the file.
		//	Check to see if there are lines to display.
		if(delta.y + usi_screen < limit.y)	{
			//	Figure the line position in our read buffer.
			auto signed short int ssi_offset = (signed short int)
				((signed long int)(TNSCp_lines->
				at(delta.y + usi_screen)) - sli_offset);
			//	Fill the line structure with information.
			L_draw.ssi_length = ((Line *)(cp_draw + ssi_offset))->
				ssi_length;
			L_draw.ssi_indent = ((Line *)(cp_draw + ssi_offset))->
				ssi_indent;
			//	Increase our current offset.
			ssi_offset += sizeof(Line);

			//	Loop through the width of the view.
			for(unsigned short int usi_width = 0U;
				usi_width < size.x; usi_width++)
			{
				//	Continue on if nothing.
				if(usi_width + delta.x <
					L_draw.ssi_indent)	{
					continue;
				}
				//	Check the line length,
				//	if beyond no use in continuing
				if(usi_width + delta.x >=
					L_draw.ssi_indent +
					L_draw.ssi_length)	{
					break;
				}

				//	Continue if the character is a \r
				//	Display's funny.
				if(*(cp_draw + ssi_offset) == '\r')	{
					continue;
				}

				//	display since in the line.
				TDB.putAttribute(usi_width, HTMLColor(
					sli_offset + (signed long int)
					ssi_offset, usi_colorindex));
				TDB.putChar(usi_width,
					*(cp_draw + ssi_offset));
				ssi_offset++;
			}
		}

		//	Draw the buffer to the view.
		writeBuf(0, usi_screen, size.x, 1, TDB);
	}

	//	Release the drawing buffer.
	delete[](cp_draw);
}
