//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
#define Uses_TProgram
#include"turlview.h"
#include"trace.h"
#include"globals.h"
extern "C"	{
#include"image.h"
};

TURLView::TURLView(const TRect& TR_bounds, TScrollBar *TSBp_x,
	TScrollBar *TSBp_y, const char *cp_URL, const char *cp_Index) :
	TScroller(TR_bounds, TSBp_x, TSBp_y)	{
//	Purpose:	Constructor of a URL view
//	Arguments:	TR_bounds	The rectangle of the view.
//			TSB_x		The horizontal scroll bar, 0 if none.
//			TSB_y		The vertical scroll bar, 0 if none.
//			cp_URL		The URL to load into the view.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-22-94	Modified so the rendered file is opened and
//				left open until view is destroyed.

#ifndef RELEASE
	trace("Creating view.");
#endif // RELEASE

	//	Set this view to be the current globally.
	::TURLV_current = this;

	//	No temporary file yet.
	fsp_temp = NULL;

	//	We don't have an image to display yet.
	cp_imagename = NULL;

	//	So far, we are valid.
	B_valid = True;

	//	This isn't a download, yet.
	B_download = False;

	//	Set our hyperdocument, temp file, and selected anchor to
	//	nothing.
	HTp_HyperDoc = NULL;
	TAp_selected = NULL;
	TTNp_temp = NULL;
	HTCAp_2BSelected = NULL;

	//	Haven't performed a search in this view yet.
	usi_lastSearchLine = usi_lastSearchOffset = 0U;
	TAp_search = NULL;

	//	Create our line and anchor collection.
	//	The line collection limit and delta are so big, because
	//	the collections seem to fail after many inserts.  By raising
	//	these numbers, it seems the collection has a longer life.
	//	Some files have a large number of lines.
	//	Try http://kufacts.cc.ukans.edu:8002/cwis/user.listing
	TNSCp_lines = new TNSCollection(200, 200);
	TNSCp_anchors = new TNSCollection(10, 10);
	if(TNSCp_lines == NULL || TNSCp_anchors == NULL)	{
		B_valid = False;
	}
	else	{
		//	Define how our view can grow.
		growMode = gfGrowHiX | gfGrowHiY;

		//	Load the url.
		auto Boolean B_considerValid = loadURL(cp_URL, cp_Index);

		//	We possibly now hold an image filename.
#ifndef RELEASE
		trace("Checking for image.");
#endif // RELEASE
		if(cp_imagename != NULL)	{
			//	We have to inform our DosLynx that there
			//	is an image to display after we are destroyed.
			//	It will be up to other DosLynx code to free
			//	the cp_imagename string.
#ifndef RELEASE
			trace("Image " << cp_imagename << " found.");
#endif // RELEASE
			TEvent TE_image;

			TE_image.what = evCommand;
			TE_image.message.command = cmImage;
			TE_image.message.infoPtr = (void *)cp_imagename;

			TProgram::application->handleEvent(TE_image);
			return;
		}

		if(B_valid != False)	{
			B_valid = B_considerValid;
		}

		//	If loaded a HText.
		if(B_valid == True)	{
#ifndef RELEASE
			trace("Successful load being rendered to file.");
#endif // RELEASE
			//	Set the HText to know how many views are
			//	looking at it.  This will avoid the HText
			//	from being freed if we surpass the loaded
			//	limit.
			HTp_HyperDoc->usi_Views++;

			//	Create the temporary file object.
			TTNp_temp = new TTempName(cp_TempDir);
			if(TTNp_temp == NULL)	{
				B_valid = False;
			}
			else	{
				//	Next, we format the document exactly
				//	for the view.
				FormatHTML();

				//	Open the rendered file, and leave
				//	open until the window is closed.
				fsp_temp = new fstream(TTNp_temp->getName(),
						ios::in | ios::binary |
						ios::nocreate);
				if(fsp_temp == NULL)	{
					doslynxmessage("Unable to open "
						"rendered file " <<
						TTNp_temp->getName());
					B_valid = False;
				}

				//	If there is a selected anchor from
				//	the start, then we must adjust the
				//	view to begin drawing at that
				//	anchor.
				if(TAp_selected != NULL)	{
					//	Find the line the anchor is
					//	in.
					for(delta.y = 0; delta.y < TNSCp_lines
						->getCount(); delta.y++)
					{
						if(TAp_selected->getBegin() <=
							(signed long int)
							(TNSCp_lines->
							at(delta.y)))	{
							break;
						}
					}
				}
				//	Otherwise, select the first anchor,
				//	if there is one.
				else	{
					if(TNSCp_anchors->getCount() != 0)
					{
						TAp_selected =
							(TextAttribute *)
							(TNSCp_anchors->at(0));
					}
				}
			}
		}
	}
}
