#define Uses_MsgBox
#define Uses_TProgram
#define Uses_TButton
#define Uses_TDialog
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_TDeskTop
#include"tcapture.h"
#include"tpasswor.h"

//	C callable rourtines using CPP.
extern "C"	{

#include"capalloc.h"
#include"capstdio.h"
#include "HTAlert.h"

#include "tcp.h"
#include <ctype.h>

PUBLIC void HTAlert ARGS1(CONST char *, Msg)
{
    fprintf(stderr, "WWW Alert:  %s\n", Msg);
}


PUBLIC void HTProgress ARGS1(CONST char *, Msg)
{
    fprintf(stderr, "WWW:  %s ...\n", Msg);
}


PUBLIC BOOL HTConfirm ARGS1(CONST char *, Msg)
{
	auto unsigned short int usi_msg = messageBox(Msg, mfYesButton |
		mfNoButton | mfConfirmation);

	if(cmYes == usi_msg)	{
		return(YES);
	}
	else	{
		return(NO);
	}
}


PUBLIC char * HTPrompt ARGS2(CONST char *, Msg, CONST char *, deflt)
{
	//	General use rectangle.
	auto TRect TR(0, 0, 50, 7);

	//	Create a dialog that asks for some WWW info.
	TDialog *TDp_WWW = new TDialog(TR, Msg);
	if(TDp_WWW == NULL)	{
		doslynxmessage("Unable to create WWW dialog.");
		auto char *cp_default = NULL;
		StrAllocCopy(cp_default, deflt);
		return(cp_default);
	}

	//	Set some dialog options.
	TDp_WWW->options |= ofCentered;

	//      Make the input line to enter the information.
	TR = TRect(6, 2, 44, 3);
	TInputLine *TILp_inputLine = new TInputLine(TR, usi_TILURLSize - 1);
	//	Put in the default response
	if(deflt != NULL && *deflt != '\0')	{
		TILp_inputLine->setData((void *)deflt);
	}
	TDp_WWW->insert(TILp_inputLine);


	//	Make the input line's label.
	auto char ca_buffer[usi_TILURLSize];
	TR = TRect(5, 1, 25, 2);
	sprintf(ca_buffer, "~W~WW %s", Msg);
	TLabel *TLp_prompt = new TLabel(TR, ca_buffer, TILp_inputLine);
	TDp_WWW->insert(TLp_prompt);

	//	Insert the Ok button.  The user has to enter something....
	auto TButton *TBp_button;
	TR = TRect(19, 4, 31, 6);
	TBp_button = new TButton(TR, "~O~K", cmOK, bfDefault);
	TDp_WWW->insert(TBp_button);

	//	Stay in the input line.
	TDp_WWW->selectNext(False);

	//	Draw the dialog.
	TDp_WWW->drawView();

	//	Execute the dialog.
	TProgram::deskTop->execView(TDp_WWW);

	//	User can't cancel, save what we got as the proper input,
	//	or use the default.
	TILp_inputLine->getData(ca_buffer);

	//	Take out whitespaces....
	auto char *cp_nowhite;
	while(isspace(ca_buffer[0]))	{
		cp_nowhite = ca_buffer + 1;
		do	{
			*(cp_nowhite - 1) = *cp_nowhite;
		}
		while(*cp_nowhite);
	}

	//	If no string, use the default.
	if(strlen(ca_buffer) == 0)	{
		strcpy(ca_buffer, deflt);
	}

	//	Done with dialog.
	TObject::destroy(TDp_WWW);

	//	Return input.
	auto char *cp_returnval = NULL;
	StrAllocCopy(cp_returnval, ca_buffer);
	return(cp_returnval);
}


PUBLIC char * HTPromptPassword ARGS1(CONST char *, Msg)
{
	//	General use rectangle.
	auto TRect TR(0, 0, 50, 7);

	//	Create a dialog that asks for some WWW info.
	TDialog *TDp_password = new TDialog(TR, "Password");
	if(TDp_password == NULL)	{
		doslynxmessage("Unable to create password dialog.");
		auto char *cp_default = NULL;
		StrAllocCopy(cp_default, "");
		return(cp_default);
	}

	//	Set some dialog options.
	TDp_password->options |= ofCentered;

	//      Make the input line to enter the information.
	TR = TRect(6, 2, 44, 3);
	TPasswordInputLine *TPILp_passwordLine = new TPasswordInputLine(TR,
		usi_TILURLSize - 1);
	TDp_password->insert(TPILp_passwordLine);


	//	Make the input line's label.
	auto char ca_buffer[usi_TILURLSize];
	sprintf(ca_buffer, "~W~WW %s", Msg);
	TR = TRect(5, 1, 25, 2);
	TLabel *TLp_prompt = new TLabel(TR, ca_buffer, TPILp_passwordLine);
	TDp_password->insert(TLp_prompt);

	//	Insert the Ok button.  The user has to enter something....
	auto TButton *TBp_button;
	TR = TRect(19, 4, 31, 6);
	TBp_button = new TButton(TR, "~O~K", cmOK, bfDefault);
	TDp_password->insert(TBp_button);

	//	Stay in the input line.
	TDp_password->selectNext(False);

	//	Draw the dialog.
	TDp_password->drawView();

	//	Execute the dialog.
	TProgram::deskTop->execView(TDp_password);

	//	User can't cancel, save what we got as the proper input,
	//	or use the default.
	TPILp_passwordLine->getData(ca_buffer);

	//	Done with dialog.
	TObject::destroy(TDp_password);

	//	Return input.
	auto char *cp_result = NULL;
	StrAllocCopy(cp_result, ca_buffer);
	return(cp_result);
}


/*	Prompt both username and password	HTPromptUsernameAndPassword()
**	---------------------------------
** On entry,
**	Msg		is the prompting message.
**	*username and
**	*password	are char pointers; they are changed
**			to point to result strings.
**
**			If *username is not NULL, it is taken
**			to point to  a default value.
**			Initial value of *password is
**			completely discarded.
**
** On exit,
**	*username and *password point to newly allocated
**	strings -- original strings pointed to by them
**	are NOT freed.
**
*/
PUBLIC void HTPromptUsernameAndPassword ARGS3(CONST char *,	Msg,
					      char **,		username,
					      char **,		password)
{
    if (Msg)
	fprintf(stderr, "WWW: %s\n", Msg);
    *username = HTPrompt("Username: ", *username);
    *password = HTPromptPassword("Password: ");
}


}; // extern "C"