// created by jay 0.7 (c) 1998 Axel.Schreiner@informatik.uni-osnabrueck.de

#line 2 "cs-parser.jay"
//
// cs-parser.jay: The Parser for the C# compiler
//
// Authors: Miguel de Icaza (miguel@gnome.org)
//          Ravi Pratap     (ravi@ximian.com)
//          Marek Safar	    (marek.safar@gmail.com)
//
// Dual Licensed under the terms of the GNU GPL and the MIT X11 license
//
// (C) 2001 Ximian, Inc (http://www.ximian.com)
// (C) 2004-2011 Novell, Inc
// Copyright 2011-2012 Xamarin Inc.
//

using System.Text;
using System.IO;
using System;
using System.Collections.Generic;

namespace ICSharpCode.NRefactory.MonoCSharp
{
	/// <summary>
	///    The C# Parser
	/// </summary>
	public class CSharpParser
	{
		[Flags]
		enum ParameterModifierType
		{
			Ref		= 1 << 1,
			Out		= 1 << 2,
			This	= 1 << 3,
			Params	= 1 << 4,
			Arglist	= 1 << 5,
			DefaultValue = 1 << 6,
			
			All = Ref | Out | This | Params | Arglist | DefaultValue,
			PrimaryConstructor = Ref | Out | Params | DefaultValue
		}
		
		static readonly object ModifierNone = 0;
	
		NamespaceContainer current_namespace;
		TypeContainer current_container;
		TypeDefinition current_type;
		PropertyBase current_property;
		EventProperty current_event;
		EventField current_event_field;
		FieldBase current_field;
	
		/// <summary>
		///   Current block is used to add statements as we find
		///   them.  
		/// </summary>
		Block      current_block;
		
		BlockVariable current_variable;

		Delegate   current_delegate;
		
		AnonymousMethodExpression current_anonymous_method;

		/// <summary>
		///   This is used by the unary_expression code to resolve
		///   a name against a parameter.  
		/// </summary>
		
		// FIXME: This is very ugly and it's very hard to reset it correctly
		// on all places, especially when some parameters are autogenerated.
		ParametersCompiled current_local_parameters;

		bool parsing_anonymous_method;
		
		bool async_block;

		///
		/// An out-of-band stack.
		///
		Stack<object> oob_stack;

		///
		/// Controls the verbosity of the errors produced by the parser
		///
		int yacc_verbose_flag;

		/// 
		/// Used by the interactive shell, flags whether EOF was reached
		/// and an error was produced
		///
		public bool UnexpectedEOF;

		///
		/// The current file.
		///
		readonly CompilationSourceFile file;

		///
		/// Temporary Xml documentation cache.
		/// For enum types, we need one more temporary store.
		///
		string tmpComment;
		string enumTypeComment;
	       		
		/// Current attribute target
		string current_attr_target;
		
		ParameterModifierType valid_param_mod;
		
		bool default_parameter_used;

		/// When using the interactive parser, this holds the
		/// resulting expression
		public Class InteractiveResult;

		//
		// Keeps track of global data changes to undo on parser error
		//
		public Undo undo;

		bool? interactive_async;
		
		Stack<Linq.QueryBlock> linq_clause_blocks;

		ModuleContainer module;
		
		readonly CompilerContext compiler;
		readonly LanguageVersion lang_version;
		readonly bool doc_support;
		readonly CompilerSettings settings;
		readonly Report report;
		
		//
		// Instead of allocating carrier array everytime we
		// share the bucket for very common constructs which can never
		// be recursive
		//
		List<Parameter> parameters_bucket;
		
		//
		// Full AST support members
		//
		LocationsBag lbag;
		List<Tuple<Modifiers, Location>> mod_locations;
		Location parameterModifierLocation, savedLocation, savedEventAssignLocation;
		Location savedAttrParenOpenLocation, savedAttrParenCloseLocation, savedOperatorLocation;
		Stack<List<Location>> locationListStack = new Stack<List<Location>> (); // used for type parameters
		Stack<Location> opt_intoStack = new Stack<Location> ();

		bool HadAttributeParens;
		List<Location> attributeArgumentCommas = new List<Location> ();
		List<Location> parameterListCommas = new List<Location> ();
		Stack<Location> location_stack;
#line default

  /** error output stream.
      It should be changeable.
    */
  public System.IO.TextWriter ErrorOutput = System.Console.Out;

  /** simplified error message.
      @see <a href="#yyerror(java.lang.String, java.lang.String[])">yyerror</a>
    */
  public void yyerror (string message) {
    yyerror(message, null);
  }
#pragma warning disable 649
  /* An EOF token */
  public int eof_token;
#pragma warning restore 649
  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected vector of acceptable tokens, if available.
    */
  public void yyerror (string message, string[] expected) {
    if ((yacc_verbose_flag > 0) && (expected != null) && (expected.Length  > 0)) {
      ErrorOutput.Write (message+", expecting");
      for (int n = 0; n < expected.Length; ++ n)
        ErrorOutput.Write (" "+expected[n]);
        ErrorOutput.WriteLine ();
    } else
      ErrorOutput.WriteLine (message);
  }

  /** debugging support, requires the package jay.yydebug.
      Set to null to suppress debugging messages.
    */
//t  internal yydebug.yyDebug debug;

  protected const int yyFinal = 7;
//t // Put this array into a separate class so it is only initialized if debugging is actually used
//t // Use MarshalByRefObject to disable inlining
//t class YYRules : MarshalByRefObject {
//t  public static readonly string [] yyRule = {
//t    "$accept : compilation_unit",
//t    "compilation_unit : outer_declaration opt_EOF",
//t    "$$1 :",
//t    "compilation_unit : interactive_parsing $$1 opt_EOF",
//t    "compilation_unit : documentation_parsing",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations opt_attributes",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives attribute_sections",
//t    "outer_declaration : error",
//t    "opt_EOF :",
//t    "opt_EOF : EOF",
//t    "extern_alias_directives : extern_alias_directive",
//t    "extern_alias_directives : extern_alias_directives extern_alias_directive",
//t    "extern_alias_directive : EXTERN_ALIAS IDENTIFIER IDENTIFIER SEMICOLON",
//t    "extern_alias_directive : EXTERN_ALIAS error",
//t    "using_directives : using_directive",
//t    "using_directives : using_directives using_directive",
//t    "using_directive : using_namespace",
//t    "using_namespace : USING opt_static namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING opt_static IDENTIFIER ASSIGN namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING error",
//t    "opt_static :",
//t    "opt_static : STATIC",
//t    "$$2 :",
//t    "$$3 :",
//t    "namespace_declaration : opt_attributes NAMESPACE namespace_name $$2 OPEN_BRACE $$3 opt_extern_alias_directives opt_using_directives opt_namespace_or_type_declarations CLOSE_BRACE opt_semicolon_error",
//t    "namespace_declaration : opt_attributes NAMESPACE namespace_name",
//t    "opt_semicolon_error :",
//t    "opt_semicolon_error : SEMICOLON",
//t    "opt_semicolon_error : error",
//t    "namespace_name : IDENTIFIER",
//t    "namespace_name : namespace_name DOT IDENTIFIER",
//t    "namespace_name : error",
//t    "opt_semicolon :",
//t    "opt_semicolon : SEMICOLON",
//t    "opt_comma :",
//t    "opt_comma : COMMA",
//t    "opt_using_directives :",
//t    "opt_using_directives : using_directives",
//t    "opt_extern_alias_directives :",
//t    "opt_extern_alias_directives : extern_alias_directives",
//t    "opt_namespace_or_type_declarations :",
//t    "opt_namespace_or_type_declarations : namespace_or_type_declarations",
//t    "namespace_or_type_declarations : namespace_or_type_declaration",
//t    "namespace_or_type_declarations : namespace_or_type_declarations namespace_or_type_declaration",
//t    "namespace_or_type_declaration : type_declaration",
//t    "namespace_or_type_declaration : namespace_declaration",
//t    "namespace_or_type_declaration : attribute_sections CLOSE_BRACE",
//t    "type_declaration : class_declaration",
//t    "type_declaration : struct_declaration",
//t    "type_declaration : interface_declaration",
//t    "type_declaration : enum_declaration",
//t    "type_declaration : delegate_declaration",
//t    "opt_attributes :",
//t    "opt_attributes : attribute_sections",
//t    "attribute_sections : attribute_section",
//t    "attribute_sections : attribute_sections attribute_section",
//t    "$$4 :",
//t    "attribute_section : OPEN_BRACKET $$4 attribute_section_cont",
//t    "$$5 :",
//t    "attribute_section_cont : attribute_target COLON $$5 attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : IDENTIFIER error",
//t    "attribute_section_cont : error",
//t    "attribute_target : IDENTIFIER",
//t    "attribute_target : EVENT",
//t    "attribute_target : RETURN",
//t    "attribute_list : attribute",
//t    "attribute_list : attribute_list COMMA attribute",
//t    "$$6 :",
//t    "attribute : attribute_name $$6 opt_attribute_arguments",
//t    "attribute_name : namespace_or_type_expr",
//t    "opt_attribute_arguments :",
//t    "opt_attribute_arguments : OPEN_PARENS attribute_arguments CLOSE_PARENS",
//t    "attribute_arguments :",
//t    "attribute_arguments : positional_or_named_argument",
//t    "attribute_arguments : named_attribute_argument",
//t    "attribute_arguments : attribute_arguments COMMA positional_or_named_argument",
//t    "attribute_arguments : attribute_arguments COMMA named_attribute_argument",
//t    "positional_or_named_argument : expression",
//t    "positional_or_named_argument : named_argument",
//t    "positional_or_named_argument : error",
//t    "$$7 :",
//t    "named_attribute_argument : IDENTIFIER ASSIGN $$7 expression",
//t    "named_argument : identifier_inside_body COLON opt_named_modifier named_argument_expr",
//t    "named_argument_expr : expression_or_error",
//t    "opt_named_modifier :",
//t    "opt_named_modifier : REF",
//t    "opt_named_modifier : OUT",
//t    "opt_class_member_declarations :",
//t    "opt_class_member_declarations : class_member_declarations",
//t    "class_member_declarations : class_member_declaration",
//t    "class_member_declarations : class_member_declarations class_member_declaration",
//t    "class_member_declaration : constant_declaration",
//t    "class_member_declaration : field_declaration",
//t    "class_member_declaration : method_declaration",
//t    "class_member_declaration : property_declaration",
//t    "class_member_declaration : event_declaration",
//t    "class_member_declaration : indexer_declaration",
//t    "class_member_declaration : operator_declaration",
//t    "class_member_declaration : constructor_declaration",
//t    "class_member_declaration : primary_constructor_body",
//t    "class_member_declaration : destructor_declaration",
//t    "class_member_declaration : type_declaration",
//t    "class_member_declaration : attributes_without_members",
//t    "class_member_declaration : incomplete_member",
//t    "class_member_declaration : error",
//t    "$$8 :",
//t    "primary_constructor_body : OPEN_BRACE $$8 opt_statement_list block_end",
//t    "$$9 :",
//t    "$$10 :",
//t    "$$11 :",
//t    "$$12 :",
//t    "$$13 :",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT $$9 type_declaration_name $$10 opt_primary_parameters opt_class_base opt_type_parameter_constraints_clauses $$11 OPEN_BRACE $$12 opt_class_member_declarations CLOSE_BRACE $$13 opt_semicolon",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT error",
//t    "$$14 :",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type IDENTIFIER $$14 constant_initializer opt_constant_declarators SEMICOLON",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type error",
//t    "opt_constant_declarators :",
//t    "opt_constant_declarators : constant_declarators",
//t    "constant_declarators : constant_declarator",
//t    "constant_declarators : constant_declarators constant_declarator",
//t    "constant_declarator : COMMA IDENTIFIER constant_initializer",
//t    "$$15 :",
//t    "constant_initializer : ASSIGN $$15 constant_initializer_expr",
//t    "constant_initializer : error",
//t    "constant_initializer_expr : constant_expression",
//t    "constant_initializer_expr : array_initializer",
//t    "$$16 :",
//t    "field_declaration : opt_attributes opt_modifiers member_type IDENTIFIER $$16 opt_field_initializer opt_field_declarators SEMICOLON",
//t    "$$17 :",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type IDENTIFIER $$17 fixed_field_size opt_fixed_field_declarators SEMICOLON",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type error SEMICOLON",
//t    "opt_field_initializer :",
//t    "$$18 :",
//t    "opt_field_initializer : ASSIGN $$18 variable_initializer",
//t    "opt_field_declarators :",
//t    "opt_field_declarators : field_declarators",
//t    "field_declarators : field_declarator",
//t    "field_declarators : field_declarators field_declarator",
//t    "field_declarator : COMMA IDENTIFIER",
//t    "$$19 :",
//t    "field_declarator : COMMA IDENTIFIER ASSIGN $$19 variable_initializer",
//t    "opt_fixed_field_declarators :",
//t    "opt_fixed_field_declarators : fixed_field_declarators",
//t    "fixed_field_declarators : fixed_field_declarator",
//t    "fixed_field_declarators : fixed_field_declarators fixed_field_declarator",
//t    "fixed_field_declarator : COMMA IDENTIFIER fixed_field_size",
//t    "$$20 :",
//t    "fixed_field_size : OPEN_BRACKET $$20 expression CLOSE_BRACKET",
//t    "fixed_field_size : OPEN_BRACKET error",
//t    "variable_initializer : expression",
//t    "variable_initializer : array_initializer",
//t    "variable_initializer : error",
//t    "$$21 :",
//t    "method_declaration : method_header $$21 method_body_expression_block",
//t    "$$22 :",
//t    "$$23 :",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name OPEN_PARENS $$22 opt_formal_parameter_list CLOSE_PARENS $$23 opt_type_parameter_constraints_clauses",
//t    "$$24 :",
//t    "$$25 :",
//t    "$$26 :",
//t    "method_header : opt_attributes opt_modifiers PARTIAL VOID $$24 method_declaration_name OPEN_PARENS $$25 opt_formal_parameter_list CLOSE_PARENS $$26 opt_type_parameter_constraints_clauses",
//t    "method_header : opt_attributes opt_modifiers member_type modifiers method_declaration_name OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name error",
//t    "method_body_expression_block : method_body",
//t    "method_body_expression_block : expression_block",
//t    "method_body : block",
//t    "method_body : SEMICOLON",
//t    "$$27 :",
//t    "expression_block : ARROW $$27 expression SEMICOLON",
//t    "opt_formal_parameter_list :",
//t    "opt_formal_parameter_list : formal_parameter_list",
//t    "formal_parameter_list : fixed_parameters",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array",
//t    "formal_parameter_list : fixed_parameters COMMA arglist_modifier",
//t    "formal_parameter_list : parameter_array COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array COMMA error",
//t    "formal_parameter_list : arglist_modifier COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA ARGLIST COMMA error",
//t    "formal_parameter_list : parameter_array",
//t    "formal_parameter_list : arglist_modifier",
//t    "formal_parameter_list : error",
//t    "fixed_parameters : fixed_parameter",
//t    "fixed_parameters : fixed_parameters COMMA fixed_parameter",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type identifier_inside_body",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type identifier_inside_body OPEN_BRACKET CLOSE_BRACKET",
//t    "fixed_parameter : attribute_sections error",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type error",
//t    "$$28 :",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type identifier_inside_body ASSIGN $$28 constant_expression",
//t    "opt_parameter_modifier :",
//t    "opt_parameter_modifier : parameter_modifiers",
//t    "parameter_modifiers : parameter_modifier",
//t    "parameter_modifiers : parameter_modifiers parameter_modifier",
//t    "parameter_modifier : REF",
//t    "parameter_modifier : OUT",
//t    "parameter_modifier : THIS",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER ASSIGN constant_expression",
//t    "parameter_array : opt_attributes params_modifier type error",
//t    "params_modifier : PARAMS",
//t    "params_modifier : PARAMS parameter_modifier",
//t    "params_modifier : PARAMS params_modifier",
//t    "arglist_modifier : ARGLIST",
//t    "$$29 :",
//t    "$$30 :",
//t    "$$31 :",
//t    "$$32 :",
//t    "property_declaration : opt_attributes opt_modifiers member_type member_declaration_name $$29 OPEN_BRACE $$30 accessor_declarations $$31 CLOSE_BRACE $$32 opt_property_initializer",
//t    "$$33 :",
//t    "property_declaration : opt_attributes opt_modifiers member_type member_declaration_name $$33 expression_block",
//t    "opt_property_initializer :",
//t    "$$34 :",
//t    "opt_property_initializer : ASSIGN $$34 property_initializer SEMICOLON",
//t    "property_initializer : expression",
//t    "property_initializer : array_initializer",
//t    "$$35 :",
//t    "$$36 :",
//t    "indexer_declaration : opt_attributes opt_modifiers member_type indexer_declaration_name OPEN_BRACKET $$35 opt_formal_parameter_list CLOSE_BRACKET $$36 indexer_body",
//t    "indexer_body : OPEN_BRACE accessor_declarations CLOSE_BRACE",
//t    "indexer_body : expression_block",
//t    "accessor_declarations : get_accessor_declaration",
//t    "accessor_declarations : get_accessor_declaration accessor_declarations",
//t    "accessor_declarations : set_accessor_declaration",
//t    "accessor_declarations : set_accessor_declaration accessor_declarations",
//t    "accessor_declarations : error",
//t    "$$37 :",
//t    "get_accessor_declaration : opt_attributes opt_modifiers GET $$37 accessor_body",
//t    "$$38 :",
//t    "set_accessor_declaration : opt_attributes opt_modifiers SET $$38 accessor_body",
//t    "accessor_body : block",
//t    "accessor_body : SEMICOLON",
//t    "accessor_body : error",
//t    "$$39 :",
//t    "$$40 :",
//t    "$$41 :",
//t    "$$42 :",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE $$39 type_declaration_name $$40 opt_class_base opt_type_parameter_constraints_clauses $$41 OPEN_BRACE opt_interface_member_declarations CLOSE_BRACE $$42 opt_semicolon",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE error",
//t    "opt_interface_member_declarations :",
//t    "opt_interface_member_declarations : interface_member_declarations",
//t    "interface_member_declarations : interface_member_declaration",
//t    "interface_member_declarations : interface_member_declarations interface_member_declaration",
//t    "interface_member_declaration : constant_declaration",
//t    "interface_member_declaration : field_declaration",
//t    "interface_member_declaration : method_declaration",
//t    "interface_member_declaration : property_declaration",
//t    "interface_member_declaration : event_declaration",
//t    "interface_member_declaration : indexer_declaration",
//t    "interface_member_declaration : operator_declaration",
//t    "interface_member_declaration : constructor_declaration",
//t    "interface_member_declaration : type_declaration",
//t    "$$43 :",
//t    "operator_declaration : opt_attributes opt_modifiers operator_declarator $$43 method_body_expression_block",
//t    "operator_type : type_expression_or_array",
//t    "operator_type : VOID",
//t    "$$44 :",
//t    "operator_declarator : operator_type OPERATOR overloadable_operator OPEN_PARENS $$44 opt_formal_parameter_list CLOSE_PARENS",
//t    "operator_declarator : conversion_operator_declarator",
//t    "overloadable_operator : BANG",
//t    "overloadable_operator : TILDE",
//t    "overloadable_operator : OP_INC",
//t    "overloadable_operator : OP_DEC",
//t    "overloadable_operator : TRUE",
//t    "overloadable_operator : FALSE",
//t    "overloadable_operator : PLUS",
//t    "overloadable_operator : MINUS",
//t    "overloadable_operator : STAR",
//t    "overloadable_operator : DIV",
//t    "overloadable_operator : PERCENT",
//t    "overloadable_operator : BITWISE_AND",
//t    "overloadable_operator : BITWISE_OR",
//t    "overloadable_operator : CARRET",
//t    "overloadable_operator : OP_SHIFT_LEFT",
//t    "overloadable_operator : OP_SHIFT_RIGHT",
//t    "overloadable_operator : OP_EQ",
//t    "overloadable_operator : OP_NE",
//t    "overloadable_operator : OP_GT",
//t    "overloadable_operator : OP_LT",
//t    "overloadable_operator : OP_GE",
//t    "overloadable_operator : OP_LE",
//t    "overloadable_operator : IS",
//t    "$$45 :",
//t    "conversion_operator_declarator : IMPLICIT OPERATOR type OPEN_PARENS $$45 opt_formal_parameter_list CLOSE_PARENS",
//t    "$$46 :",
//t    "conversion_operator_declarator : EXPLICIT OPERATOR type OPEN_PARENS $$46 opt_formal_parameter_list CLOSE_PARENS",
//t    "conversion_operator_declarator : IMPLICIT error",
//t    "conversion_operator_declarator : EXPLICIT error",
//t    "constructor_declaration : constructor_declarator constructor_body",
//t    "$$47 :",
//t    "$$48 :",
//t    "constructor_declarator : opt_attributes opt_modifiers IDENTIFIER $$47 OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS $$48 opt_constructor_initializer",
//t    "constructor_body : block_prepared",
//t    "constructor_body : SEMICOLON",
//t    "opt_constructor_initializer :",
//t    "opt_constructor_initializer : constructor_initializer",
//t    "$$49 :",
//t    "constructor_initializer : COLON BASE OPEN_PARENS $$49 opt_argument_list CLOSE_PARENS",
//t    "$$50 :",
//t    "constructor_initializer : COLON THIS OPEN_PARENS $$50 opt_argument_list CLOSE_PARENS",
//t    "constructor_initializer : COLON error",
//t    "constructor_initializer : error",
//t    "$$51 :",
//t    "destructor_declaration : opt_attributes opt_modifiers TILDE $$51 IDENTIFIER OPEN_PARENS CLOSE_PARENS method_body",
//t    "$$52 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name $$52 opt_event_initializer opt_event_declarators SEMICOLON",
//t    "$$53 :",
//t    "$$54 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name OPEN_BRACE $$53 event_accessor_declarations $$54 CLOSE_BRACE",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type error",
//t    "opt_event_initializer :",
//t    "$$55 :",
//t    "opt_event_initializer : ASSIGN $$55 event_variable_initializer",
//t    "opt_event_declarators :",
//t    "opt_event_declarators : event_declarators",
//t    "event_declarators : event_declarator",
//t    "event_declarators : event_declarators event_declarator",
//t    "event_declarator : COMMA IDENTIFIER",
//t    "$$56 :",
//t    "event_declarator : COMMA IDENTIFIER ASSIGN $$56 event_variable_initializer",
//t    "$$57 :",
//t    "event_variable_initializer : $$57 variable_initializer",
//t    "event_accessor_declarations : add_accessor_declaration remove_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration add_accessor_declaration",
//t    "event_accessor_declarations : add_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration",
//t    "event_accessor_declarations : error",
//t    "$$58 :",
//t    "add_accessor_declaration : opt_attributes opt_modifiers ADD $$58 event_accessor_block",
//t    "$$59 :",
//t    "remove_accessor_declaration : opt_attributes opt_modifiers REMOVE $$59 event_accessor_block",
//t    "event_accessor_block : opt_semicolon",
//t    "event_accessor_block : block",
//t    "attributes_without_members : attribute_sections CLOSE_BRACE",
//t    "incomplete_member : opt_attributes opt_modifiers member_type CLOSE_BRACE",
//t    "$$60 :",
//t    "$$61 :",
//t    "$$62 :",
//t    "enum_declaration : opt_attributes opt_modifiers ENUM type_declaration_name opt_enum_base $$60 OPEN_BRACE $$61 opt_enum_member_declarations $$62 CLOSE_BRACE opt_semicolon",
//t    "opt_enum_base :",
//t    "opt_enum_base : COLON type",
//t    "opt_enum_base : COLON error",
//t    "opt_enum_member_declarations :",
//t    "opt_enum_member_declarations : enum_member_declarations",
//t    "opt_enum_member_declarations : enum_member_declarations COMMA",
//t    "enum_member_declarations : enum_member_declaration",
//t    "enum_member_declarations : enum_member_declarations COMMA enum_member_declaration",
//t    "enum_member_declaration : opt_attributes IDENTIFIER",
//t    "$$63 :",
//t    "enum_member_declaration : opt_attributes IDENTIFIER $$63 ASSIGN constant_expression",
//t    "enum_member_declaration : opt_attributes IDENTIFIER error",
//t    "enum_member_declaration : attributes_without_members",
//t    "$$64 :",
//t    "$$65 :",
//t    "$$66 :",
//t    "delegate_declaration : opt_attributes opt_modifiers DELEGATE member_type type_declaration_name OPEN_PARENS $$64 opt_formal_parameter_list CLOSE_PARENS $$65 opt_type_parameter_constraints_clauses $$66 SEMICOLON",
//t    "opt_nullable :",
//t    "opt_nullable : INTERR_NULLABLE",
//t    "namespace_or_type_expr : member_name",
//t    "namespace_or_type_expr : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "namespace_or_type_expr : qualified_alias_member IDENTIFIER generic_dimension",
//t    "member_name : simple_name_expr",
//t    "member_name : namespace_or_type_expr DOT IDENTIFIER opt_type_argument_list",
//t    "member_name : namespace_or_type_expr DOT IDENTIFIER generic_dimension",
//t    "simple_name_expr : IDENTIFIER opt_type_argument_list",
//t    "simple_name_expr : IDENTIFIER generic_dimension",
//t    "opt_type_argument_list :",
//t    "opt_type_argument_list : OP_GENERICS_LT type_arguments OP_GENERICS_GT",
//t    "opt_type_argument_list : OP_GENERICS_LT error",
//t    "type_arguments : type",
//t    "type_arguments : type_arguments COMMA type",
//t    "$$67 :",
//t    "type_declaration_name : IDENTIFIER $$67 opt_type_parameter_list",
//t    "member_declaration_name : method_declaration_name",
//t    "method_declaration_name : type_declaration_name",
//t    "method_declaration_name : explicit_interface IDENTIFIER opt_type_parameter_list",
//t    "indexer_declaration_name : THIS",
//t    "indexer_declaration_name : explicit_interface THIS",
//t    "explicit_interface : IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : qualified_alias_member IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : explicit_interface IDENTIFIER opt_type_argument_list DOT",
//t    "opt_type_parameter_list :",
//t    "opt_type_parameter_list : OP_GENERICS_LT_DECL type_parameters OP_GENERICS_GT",
//t    "type_parameters : type_parameter",
//t    "type_parameters : type_parameters COMMA type_parameter",
//t    "type_parameter : opt_attributes opt_type_parameter_variance IDENTIFIER",
//t    "type_parameter : error",
//t    "type_and_void : type_expression_or_array",
//t    "type_and_void : VOID",
//t    "member_type : type_and_void",
//t    "type : type_expression_or_array",
//t    "type : void_invalid",
//t    "simple_type : type_expression",
//t    "simple_type : void_invalid",
//t    "parameter_type : type_expression_or_array",
//t    "parameter_type : VOID",
//t    "type_expression_or_array : type_expression",
//t    "type_expression_or_array : type_expression rank_specifiers",
//t    "type_expression : namespace_or_type_expr opt_nullable",
//t    "type_expression : namespace_or_type_expr pointer_stars",
//t    "type_expression : builtin_type_expression",
//t    "void_invalid : VOID",
//t    "builtin_type_expression : builtin_types opt_nullable",
//t    "builtin_type_expression : builtin_types pointer_stars",
//t    "builtin_type_expression : VOID pointer_stars",
//t    "type_list : base_type_name",
//t    "type_list : type_list COMMA base_type_name",
//t    "base_type_name : type",
//t    "builtin_types : OBJECT",
//t    "builtin_types : STRING",
//t    "builtin_types : BOOL",
//t    "builtin_types : DECIMAL",
//t    "builtin_types : FLOAT",
//t    "builtin_types : DOUBLE",
//t    "builtin_types : integral_type",
//t    "integral_type : SBYTE",
//t    "integral_type : BYTE",
//t    "integral_type : SHORT",
//t    "integral_type : USHORT",
//t    "integral_type : INT",
//t    "integral_type : UINT",
//t    "integral_type : LONG",
//t    "integral_type : ULONG",
//t    "integral_type : CHAR",
//t    "primary_expression : type_name_expression",
//t    "primary_expression : literal",
//t    "primary_expression : array_creation_expression",
//t    "primary_expression : parenthesized_expression",
//t    "primary_expression : default_value_expression",
//t    "primary_expression : invocation_expression",
//t    "primary_expression : element_access",
//t    "primary_expression : this_access",
//t    "primary_expression : base_access",
//t    "primary_expression : post_increment_expression",
//t    "primary_expression : post_decrement_expression",
//t    "primary_expression : object_or_delegate_creation_expression",
//t    "primary_expression : anonymous_type_expression",
//t    "primary_expression : typeof_expression",
//t    "primary_expression : sizeof_expression",
//t    "primary_expression : checked_expression",
//t    "primary_expression : unchecked_expression",
//t    "primary_expression : pointer_member_access",
//t    "primary_expression : anonymous_method_expression",
//t    "primary_expression : undocumented_expressions",
//t    "primary_expression : interpolated_string",
//t    "type_name_expression : simple_name_expr",
//t    "type_name_expression : IDENTIFIER GENERATE_COMPLETION",
//t    "type_name_expression : member_access",
//t    "literal : boolean_literal",
//t    "literal : LITERAL",
//t    "literal : NULL",
//t    "boolean_literal : TRUE",
//t    "boolean_literal : FALSE",
//t    "interpolated_string : INTERPOLATED_STRING interpolations INTERPOLATED_STRING_END",
//t    "interpolated_string : INTERPOLATED_STRING_END",
//t    "interpolations : interpolation",
//t    "interpolations : interpolations INTERPOLATED_STRING interpolation",
//t    "interpolation : expression",
//t    "interpolation : expression COMMA expression",
//t    "$$68 :",
//t    "interpolation : expression COLON $$68 LITERAL",
//t    "$$69 :",
//t    "interpolation : expression COMMA expression COLON $$69 LITERAL",
//t    "open_parens_any : OPEN_PARENS",
//t    "open_parens_any : OPEN_PARENS_CAST",
//t    "close_parens : CLOSE_PARENS",
//t    "close_parens : COMPLETE_COMPLETION",
//t    "parenthesized_expression : OPEN_PARENS expression CLOSE_PARENS",
//t    "parenthesized_expression : OPEN_PARENS expression COMPLETE_COMPLETION",
//t    "member_access : primary_expression DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : primary_expression DOT identifier_inside_body generic_dimension",
//t    "member_access : primary_expression INTERR_OPERATOR DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : builtin_types DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : BASE DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : AWAIT DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : qualified_alias_member identifier_inside_body opt_type_argument_list",
//t    "member_access : qualified_alias_member identifier_inside_body generic_dimension",
//t    "member_access : primary_expression DOT GENERATE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT IDENTIFIER GENERATE_COMPLETION",
//t    "invocation_expression : primary_expression open_parens_any opt_argument_list close_parens",
//t    "invocation_expression : primary_expression open_parens_any argument_list error",
//t    "invocation_expression : primary_expression open_parens_any error",
//t    "opt_object_or_collection_initializer :",
//t    "opt_object_or_collection_initializer : object_or_collection_initializer",
//t    "object_or_collection_initializer : OPEN_BRACE opt_member_initializer_list close_brace_or_complete_completion",
//t    "object_or_collection_initializer : OPEN_BRACE member_initializer_list COMMA CLOSE_BRACE",
//t    "opt_member_initializer_list :",
//t    "opt_member_initializer_list : member_initializer_list",
//t    "member_initializer_list : member_initializer",
//t    "member_initializer_list : member_initializer_list COMMA member_initializer",
//t    "member_initializer_list : member_initializer_list error",
//t    "member_initializer : IDENTIFIER ASSIGN initializer_value",
//t    "member_initializer : AWAIT ASSIGN initializer_value",
//t    "member_initializer : GENERATE_COMPLETION",
//t    "member_initializer : non_assignment_expression opt_COMPLETE_COMPLETION",
//t    "member_initializer : OPEN_BRACE expression_list CLOSE_BRACE",
//t    "member_initializer : OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET ASSIGN initializer_value",
//t    "member_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "initializer_value : expression",
//t    "initializer_value : object_or_collection_initializer",
//t    "opt_argument_list :",
//t    "opt_argument_list : argument_list",
//t    "argument_list : argument_or_named_argument",
//t    "argument_list : argument_list COMMA argument",
//t    "argument_list : argument_list COMMA named_argument",
//t    "argument_list : argument_list COMMA error",
//t    "argument_list : COMMA error",
//t    "argument : expression",
//t    "argument : non_simple_argument",
//t    "argument_or_named_argument : argument",
//t    "argument_or_named_argument : named_argument",
//t    "non_simple_argument : REF variable_reference",
//t    "non_simple_argument : REF declaration_expression",
//t    "non_simple_argument : OUT variable_reference",
//t    "non_simple_argument : OUT declaration_expression",
//t    "non_simple_argument : ARGLIST OPEN_PARENS argument_list CLOSE_PARENS",
//t    "non_simple_argument : ARGLIST OPEN_PARENS CLOSE_PARENS",
//t    "declaration_expression : OPEN_PARENS declaration_expression CLOSE_PARENS",
//t    "declaration_expression : variable_type identifier_inside_body",
//t    "declaration_expression : variable_type identifier_inside_body ASSIGN expression",
//t    "variable_reference : expression",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "element_access : primary_expression INTERR_OPERATOR OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments error",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR error",
//t    "expression_list : expression_or_error",
//t    "expression_list : expression_list COMMA expression_or_error",
//t    "expression_list_arguments : expression_list_argument",
//t    "expression_list_arguments : expression_list_arguments COMMA expression_list_argument",
//t    "expression_list_argument : expression",
//t    "expression_list_argument : named_argument",
//t    "this_access : THIS",
//t    "base_access : BASE OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "base_access : BASE OPEN_BRACKET error",
//t    "post_increment_expression : primary_expression OP_INC",
//t    "post_decrement_expression : primary_expression OP_DEC",
//t    "object_or_delegate_creation_expression : NEW new_expr_type open_parens_any opt_argument_list CLOSE_PARENS opt_object_or_collection_initializer",
//t    "object_or_delegate_creation_expression : NEW new_expr_type object_or_collection_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET opt_rank_specifier opt_array_initializer",
//t    "array_creation_expression : NEW new_expr_type rank_specifiers opt_array_initializer",
//t    "array_creation_expression : NEW rank_specifier array_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET CLOSE_BRACKET OPEN_BRACKET_EXPR error CLOSE_BRACKET",
//t    "array_creation_expression : NEW new_expr_type error",
//t    "$$70 :",
//t    "new_expr_type : $$70 simple_type",
//t    "anonymous_type_expression : NEW OPEN_BRACE anonymous_type_parameters_opt_comma CLOSE_BRACE",
//t    "anonymous_type_expression : NEW OPEN_BRACE GENERATE_COMPLETION",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters_opt",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters COMMA",
//t    "anonymous_type_parameters_opt :",
//t    "anonymous_type_parameters_opt : anonymous_type_parameters",
//t    "anonymous_type_parameters : anonymous_type_parameter",
//t    "anonymous_type_parameters : anonymous_type_parameters COMMA anonymous_type_parameter",
//t    "anonymous_type_parameters : COMPLETE_COMPLETION",
//t    "anonymous_type_parameters : anonymous_type_parameter COMPLETE_COMPLETION",
//t    "anonymous_type_parameter : identifier_inside_body ASSIGN variable_initializer",
//t    "anonymous_type_parameter : identifier_inside_body",
//t    "anonymous_type_parameter : member_access",
//t    "anonymous_type_parameter : error",
//t    "opt_rank_specifier :",
//t    "opt_rank_specifier : rank_specifiers",
//t    "rank_specifiers : rank_specifier",
//t    "rank_specifiers : rank_specifier rank_specifiers",
//t    "rank_specifier : OPEN_BRACKET CLOSE_BRACKET",
//t    "rank_specifier : OPEN_BRACKET dim_separators CLOSE_BRACKET",
//t    "dim_separators : COMMA",
//t    "dim_separators : dim_separators COMMA",
//t    "opt_array_initializer :",
//t    "opt_array_initializer : array_initializer",
//t    "array_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "array_initializer : OPEN_BRACE variable_initializer_list opt_comma CLOSE_BRACE",
//t    "variable_initializer_list : variable_initializer",
//t    "variable_initializer_list : variable_initializer_list COMMA variable_initializer",
//t    "typeof_expression : TYPEOF open_parens_any typeof_type_expression CLOSE_PARENS",
//t    "typeof_type_expression : type_and_void",
//t    "typeof_type_expression : error",
//t    "generic_dimension : GENERIC_DIMENSION",
//t    "qualified_alias_member : IDENTIFIER DOUBLE_COLON",
//t    "sizeof_expression : SIZEOF open_parens_any type CLOSE_PARENS",
//t    "sizeof_expression : SIZEOF open_parens_any type error",
//t    "checked_expression : CHECKED open_parens_any expression CLOSE_PARENS",
//t    "checked_expression : CHECKED error",
//t    "unchecked_expression : UNCHECKED open_parens_any expression CLOSE_PARENS",
//t    "unchecked_expression : UNCHECKED error",
//t    "pointer_member_access : primary_expression OP_PTR IDENTIFIER opt_type_argument_list",
//t    "$$71 :",
//t    "anonymous_method_expression : DELEGATE opt_anonymous_method_signature $$71 block",
//t    "$$72 :",
//t    "anonymous_method_expression : ASYNC DELEGATE opt_anonymous_method_signature $$72 block",
//t    "opt_anonymous_method_signature :",
//t    "opt_anonymous_method_signature : anonymous_method_signature",
//t    "$$73 :",
//t    "anonymous_method_signature : OPEN_PARENS $$73 opt_formal_parameter_list CLOSE_PARENS",
//t    "default_value_expression : DEFAULT open_parens_any type CLOSE_PARENS",
//t    "unary_expression : primary_expression",
//t    "unary_expression : BANG prefixed_unary_expression",
//t    "unary_expression : TILDE prefixed_unary_expression",
//t    "unary_expression : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "unary_expression : AWAIT prefixed_unary_expression",
//t    "unary_expression : BANG error",
//t    "unary_expression : TILDE error",
//t    "unary_expression : OPEN_PARENS_CAST type CLOSE_PARENS error",
//t    "unary_expression : AWAIT error",
//t    "prefixed_unary_expression : unary_expression",
//t    "prefixed_unary_expression : PLUS prefixed_unary_expression",
//t    "prefixed_unary_expression : MINUS prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_INC prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_DEC prefixed_unary_expression",
//t    "prefixed_unary_expression : STAR prefixed_unary_expression",
//t    "prefixed_unary_expression : BITWISE_AND prefixed_unary_expression",
//t    "prefixed_unary_expression : PLUS error",
//t    "prefixed_unary_expression : MINUS error",
//t    "prefixed_unary_expression : OP_INC error",
//t    "prefixed_unary_expression : OP_DEC error",
//t    "prefixed_unary_expression : STAR error",
//t    "prefixed_unary_expression : BITWISE_AND error",
//t    "multiplicative_expression : prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression DIV prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression PERCENT prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR error",
//t    "multiplicative_expression : multiplicative_expression DIV error",
//t    "multiplicative_expression : multiplicative_expression PERCENT error",
//t    "additive_expression : multiplicative_expression",
//t    "additive_expression : additive_expression PLUS multiplicative_expression",
//t    "additive_expression : additive_expression MINUS multiplicative_expression",
//t    "additive_expression : additive_expression PLUS error",
//t    "additive_expression : additive_expression MINUS error",
//t    "additive_expression : additive_expression AS type",
//t    "additive_expression : additive_expression IS pattern_type_expr opt_identifier",
//t    "additive_expression : additive_expression IS pattern_expr",
//t    "additive_expression : additive_expression AS error",
//t    "additive_expression : additive_expression IS error",
//t    "additive_expression : AWAIT IS type",
//t    "additive_expression : AWAIT AS type",
//t    "pattern_type_expr : variable_type",
//t    "pattern_expr : literal",
//t    "pattern_expr : PLUS prefixed_unary_expression",
//t    "pattern_expr : MINUS prefixed_unary_expression",
//t    "pattern_expr : sizeof_expression",
//t    "pattern_expr : default_value_expression",
//t    "pattern_expr : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "pattern_expr : STAR",
//t    "pattern_expr : pattern_expr_invocation",
//t    "pattern_expr : pattern_property",
//t    "pattern_expr_invocation : type_name_expression OPEN_PARENS opt_pattern_list CLOSE_PARENS",
//t    "pattern_property : type_name_expression OPEN_BRACE pattern_property_list CLOSE_BRACE",
//t    "pattern_property_list : pattern_property_entry",
//t    "pattern_property_list : pattern_property_list COMMA pattern_property_entry",
//t    "pattern_property_entry : identifier_inside_body IS pattern",
//t    "pattern : pattern_expr",
//t    "pattern : pattern_type_expr opt_identifier",
//t    "opt_pattern_list :",
//t    "opt_pattern_list : pattern_list",
//t    "pattern_list : pattern_argument",
//t    "pattern_list : pattern_list COMMA pattern_argument",
//t    "pattern_argument : pattern",
//t    "pattern_argument : IDENTIFIER COLON pattern",
//t    "shift_expression : additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT error",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT error",
//t    "relational_expression : shift_expression",
//t    "relational_expression : relational_expression OP_LT shift_expression",
//t    "relational_expression : relational_expression OP_GT shift_expression",
//t    "relational_expression : relational_expression OP_LE shift_expression",
//t    "relational_expression : relational_expression OP_GE shift_expression",
//t    "relational_expression : relational_expression OP_LT error",
//t    "relational_expression : relational_expression OP_GT error",
//t    "relational_expression : relational_expression OP_LE error",
//t    "relational_expression : relational_expression OP_GE error",
//t    "equality_expression : relational_expression",
//t    "equality_expression : equality_expression OP_EQ relational_expression",
//t    "equality_expression : equality_expression OP_NE relational_expression",
//t    "equality_expression : equality_expression OP_EQ error",
//t    "equality_expression : equality_expression OP_NE error",
//t    "and_expression : equality_expression",
//t    "and_expression : and_expression BITWISE_AND equality_expression",
//t    "and_expression : and_expression BITWISE_AND error",
//t    "exclusive_or_expression : and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET error",
//t    "inclusive_or_expression : exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR error",
//t    "conditional_and_expression : inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND error",
//t    "conditional_or_expression : conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR error",
//t    "null_coalescing_expression : conditional_or_expression",
//t    "null_coalescing_expression : conditional_or_expression OP_COALESCING null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression error",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON error",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON CLOSE_BRACE",
//t    "assignment_expression : prefixed_unary_expression ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MULT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_DIV_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MOD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_ADD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SUB_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_LEFT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_RIGHT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_AND_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_OR_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_XOR_ASSIGN expression",
//t    "lambda_parameter_list : lambda_parameter",
//t    "lambda_parameter_list : lambda_parameter_list COMMA lambda_parameter",
//t    "lambda_parameter : parameter_modifier parameter_type identifier_inside_body",
//t    "lambda_parameter : parameter_type identifier_inside_body",
//t    "lambda_parameter : IDENTIFIER",
//t    "lambda_parameter : AWAIT",
//t    "opt_lambda_parameter_list :",
//t    "opt_lambda_parameter_list : lambda_parameter_list",
//t    "$$74 :",
//t    "lambda_expression_body : $$74 expression",
//t    "lambda_expression_body : block",
//t    "lambda_expression_body : error",
//t    "expression_or_error : expression",
//t    "expression_or_error : error",
//t    "$$75 :",
//t    "lambda_expression : IDENTIFIER ARROW $$75 lambda_expression_body",
//t    "$$76 :",
//t    "lambda_expression : AWAIT ARROW $$76 lambda_expression_body",
//t    "$$77 :",
//t    "lambda_expression : ASYNC identifier_inside_body ARROW $$77 lambda_expression_body",
//t    "$$78 :",
//t    "$$79 :",
//t    "lambda_expression : OPEN_PARENS_LAMBDA $$78 opt_lambda_parameter_list CLOSE_PARENS ARROW $$79 lambda_expression_body",
//t    "$$80 :",
//t    "$$81 :",
//t    "lambda_expression : ASYNC OPEN_PARENS_LAMBDA $$80 opt_lambda_parameter_list CLOSE_PARENS ARROW $$81 lambda_expression_body",
//t    "expression : assignment_expression",
//t    "expression : non_assignment_expression",
//t    "non_assignment_expression : conditional_expression",
//t    "non_assignment_expression : lambda_expression",
//t    "non_assignment_expression : query_expression",
//t    "non_assignment_expression : ARGLIST",
//t    "undocumented_expressions : REFVALUE OPEN_PARENS non_assignment_expression COMMA type CLOSE_PARENS",
//t    "undocumented_expressions : REFTYPE open_parens_any expression CLOSE_PARENS",
//t    "undocumented_expressions : MAKEREF open_parens_any expression CLOSE_PARENS",
//t    "constant_expression : expression",
//t    "boolean_expression : expression",
//t    "opt_primary_parameters :",
//t    "opt_primary_parameters : primary_parameters",
//t    "primary_parameters : OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "opt_primary_parameters_with_class_base :",
//t    "opt_primary_parameters_with_class_base : class_base",
//t    "opt_primary_parameters_with_class_base : primary_parameters",
//t    "opt_primary_parameters_with_class_base : primary_parameters class_base",
//t    "$$82 :",
//t    "opt_primary_parameters_with_class_base : primary_parameters class_base OPEN_PARENS $$82 opt_argument_list CLOSE_PARENS",
//t    "$$83 :",
//t    "$$84 :",
//t    "$$85 :",
//t    "$$86 :",
//t    "class_declaration : opt_attributes opt_modifiers opt_partial CLASS $$83 type_declaration_name $$84 opt_primary_parameters_with_class_base opt_type_parameter_constraints_clauses $$85 OPEN_BRACE opt_class_member_declarations CLOSE_BRACE $$86 opt_semicolon",
//t    "opt_partial :",
//t    "opt_partial : PARTIAL",
//t    "opt_modifiers :",
//t    "opt_modifiers : modifiers",
//t    "modifiers : modifier",
//t    "modifiers : modifiers modifier",
//t    "modifier : NEW",
//t    "modifier : PUBLIC",
//t    "modifier : PROTECTED",
//t    "modifier : INTERNAL",
//t    "modifier : PRIVATE",
//t    "modifier : ABSTRACT",
//t    "modifier : SEALED",
//t    "modifier : STATIC",
//t    "modifier : READONLY",
//t    "modifier : VIRTUAL",
//t    "modifier : OVERRIDE",
//t    "modifier : EXTERN",
//t    "modifier : VOLATILE",
//t    "modifier : UNSAFE",
//t    "modifier : ASYNC",
//t    "opt_class_base :",
//t    "opt_class_base : class_base",
//t    "class_base : COLON type_list",
//t    "class_base : COLON type_list error",
//t    "opt_type_parameter_constraints_clauses :",
//t    "opt_type_parameter_constraints_clauses : type_parameter_constraints_clauses",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clause",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clauses type_parameter_constraints_clause",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER COLON type_parameter_constraints",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER error",
//t    "type_parameter_constraints : type_parameter_constraint",
//t    "type_parameter_constraints : type_parameter_constraints COMMA type_parameter_constraint",
//t    "type_parameter_constraint : type",
//t    "type_parameter_constraint : NEW OPEN_PARENS CLOSE_PARENS",
//t    "type_parameter_constraint : CLASS",
//t    "type_parameter_constraint : STRUCT",
//t    "opt_type_parameter_variance :",
//t    "opt_type_parameter_variance : type_parameter_variance",
//t    "type_parameter_variance : OUT",
//t    "type_parameter_variance : IN",
//t    "$$87 :",
//t    "block : OPEN_BRACE $$87 opt_statement_list block_end",
//t    "block_end : CLOSE_BRACE",
//t    "block_end : COMPLETE_COMPLETION",
//t    "$$88 :",
//t    "block_prepared : OPEN_BRACE $$88 opt_statement_list CLOSE_BRACE",
//t    "block_prepared : CLOSE_BRACE",
//t    "$$89 :",
//t    "block_prepared_strict : OPEN_BRACE $$89 opt_statement_list CLOSE_BRACE",
//t    "opt_statement_list :",
//t    "opt_statement_list : statement_list",
//t    "statement_list : statement",
//t    "statement_list : statement_list statement",
//t    "statement : block_variable_declaration",
//t    "statement : valid_declaration_statement",
//t    "statement : labeled_statement",
//t    "statement : IDENTIFIER error",
//t    "statement : error",
//t    "interactive_statement_list : interactive_statement",
//t    "interactive_statement_list : interactive_statement_list interactive_statement",
//t    "interactive_statement : block_variable_declaration",
//t    "interactive_statement : interactive_valid_declaration_statement",
//t    "interactive_statement : labeled_statement",
//t    "valid_declaration_statement : block",
//t    "valid_declaration_statement : empty_statement",
//t    "valid_declaration_statement : expression_statement",
//t    "valid_declaration_statement : selection_statement",
//t    "valid_declaration_statement : iteration_statement",
//t    "valid_declaration_statement : jump_statement",
//t    "valid_declaration_statement : try_statement",
//t    "valid_declaration_statement : checked_statement",
//t    "valid_declaration_statement : unchecked_statement",
//t    "valid_declaration_statement : lock_statement",
//t    "valid_declaration_statement : using_statement",
//t    "valid_declaration_statement : unsafe_statement",
//t    "valid_declaration_statement : fixed_statement",
//t    "interactive_valid_declaration_statement : block",
//t    "interactive_valid_declaration_statement : empty_statement",
//t    "interactive_valid_declaration_statement : interactive_expression_statement",
//t    "interactive_valid_declaration_statement : selection_statement",
//t    "interactive_valid_declaration_statement : iteration_statement",
//t    "interactive_valid_declaration_statement : jump_statement",
//t    "interactive_valid_declaration_statement : try_statement",
//t    "interactive_valid_declaration_statement : checked_statement",
//t    "interactive_valid_declaration_statement : unchecked_statement",
//t    "interactive_valid_declaration_statement : lock_statement",
//t    "interactive_valid_declaration_statement : using_statement",
//t    "interactive_valid_declaration_statement : unsafe_statement",
//t    "interactive_valid_declaration_statement : fixed_statement",
//t    "embedded_statement : valid_declaration_statement",
//t    "embedded_statement : block_variable_declaration",
//t    "embedded_statement : labeled_statement",
//t    "embedded_statement : error",
//t    "empty_statement : SEMICOLON",
//t    "$$90 :",
//t    "labeled_statement : identifier_inside_body COLON $$90 statement",
//t    "variable_type : variable_type_simple",
//t    "variable_type : variable_type_simple rank_specifiers",
//t    "variable_type_simple : type_name_expression opt_nullable",
//t    "variable_type_simple : type_name_expression pointer_stars",
//t    "variable_type_simple : builtin_type_expression",
//t    "variable_type_simple : void_invalid",
//t    "pointer_stars : pointer_star",
//t    "pointer_stars : pointer_star pointer_stars",
//t    "pointer_star : STAR",
//t    "identifier_inside_body : IDENTIFIER",
//t    "identifier_inside_body : AWAIT",
//t    "$$91 :",
//t    "block_variable_declaration : variable_type identifier_inside_body $$91 opt_local_variable_initializer opt_variable_declarators semicolon_or_handle_error_close_brace",
//t    "$$92 :",
//t    "block_variable_declaration : CONST variable_type identifier_inside_body $$92 const_variable_initializer opt_const_declarators SEMICOLON",
//t    "semicolon_or_handle_error_close_brace : SEMICOLON",
//t    "semicolon_or_handle_error_close_brace : CLOSE_BRACE",
//t    "opt_local_variable_initializer :",
//t    "opt_local_variable_initializer : ASSIGN block_variable_initializer",
//t    "opt_local_variable_initializer : error",
//t    "opt_variable_declarators :",
//t    "opt_variable_declarators : variable_declarators",
//t    "opt_using_or_fixed_variable_declarators :",
//t    "opt_using_or_fixed_variable_declarators : variable_declarators",
//t    "variable_declarators : variable_declarator",
//t    "variable_declarators : variable_declarators variable_declarator",
//t    "variable_declarator : COMMA identifier_inside_body",
//t    "variable_declarator : COMMA identifier_inside_body ASSIGN block_variable_initializer",
//t    "const_variable_initializer :",
//t    "const_variable_initializer : ASSIGN constant_initializer_expr",
//t    "opt_const_declarators :",
//t    "opt_const_declarators : const_declarators",
//t    "const_declarators : const_declarator",
//t    "const_declarators : const_declarators const_declarator",
//t    "const_declarator : COMMA identifier_inside_body ASSIGN constant_initializer_expr",
//t    "block_variable_initializer : variable_initializer",
//t    "block_variable_initializer : STACKALLOC simple_type OPEN_BRACKET_EXPR expression CLOSE_BRACKET",
//t    "block_variable_initializer : STACKALLOC simple_type",
//t    "expression_statement : statement_expression SEMICOLON",
//t    "expression_statement : statement_expression COMPLETE_COMPLETION",
//t    "expression_statement : statement_expression CLOSE_BRACE",
//t    "interactive_expression_statement : interactive_statement_expression SEMICOLON",
//t    "interactive_expression_statement : interactive_statement_expression COMPLETE_COMPLETION",
//t    "statement_expression : expression",
//t    "interactive_statement_expression : expression",
//t    "interactive_statement_expression : error",
//t    "selection_statement : if_statement",
//t    "selection_statement : switch_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement ELSE embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression error",
//t    "$$93 :",
//t    "switch_statement : SWITCH open_parens_any expression CLOSE_PARENS OPEN_BRACE $$93 opt_switch_sections CLOSE_BRACE",
//t    "switch_statement : SWITCH open_parens_any expression error",
//t    "opt_switch_sections :",
//t    "opt_switch_sections : switch_sections",
//t    "switch_sections : switch_section",
//t    "switch_sections : switch_sections switch_section",
//t    "switch_sections : error",
//t    "switch_section : switch_labels statement_list",
//t    "switch_labels : switch_label",
//t    "switch_labels : switch_labels switch_label",
//t    "switch_label : CASE constant_expression COLON",
//t    "switch_label : CASE constant_expression error",
//t    "switch_label : DEFAULT_COLON",
//t    "iteration_statement : while_statement",
//t    "iteration_statement : do_statement",
//t    "iteration_statement : for_statement",
//t    "iteration_statement : foreach_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression CLOSE_PARENS SEMICOLON",
//t    "do_statement : DO embedded_statement error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression error",
//t    "$$94 :",
//t    "for_statement : FOR open_parens_any $$94 for_statement_cont",
//t    "$$95 :",
//t    "for_statement_cont : opt_for_initializer SEMICOLON $$95 for_statement_condition",
//t    "for_statement_cont : opt_for_initializer CLOSE_PARENS",
//t    "$$96 :",
//t    "for_statement_condition : opt_for_condition SEMICOLON $$96 for_statement_end",
//t    "for_statement_condition : boolean_expression CLOSE_PARENS",
//t    "for_statement_end : opt_for_iterator CLOSE_PARENS embedded_statement",
//t    "for_statement_end : error",
//t    "opt_for_initializer :",
//t    "opt_for_initializer : for_initializer",
//t    "$$97 :",
//t    "for_initializer : variable_type identifier_inside_body $$97 opt_local_variable_initializer opt_variable_declarators",
//t    "for_initializer : statement_expression_list",
//t    "opt_for_condition :",
//t    "opt_for_condition : boolean_expression",
//t    "opt_for_iterator :",
//t    "opt_for_iterator : for_iterator",
//t    "for_iterator : statement_expression_list",
//t    "statement_expression_list : statement_expression",
//t    "statement_expression_list : statement_expression_list COMMA statement_expression",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "$$98 :",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body IN expression CLOSE_PARENS $$98 embedded_statement",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "jump_statement : break_statement",
//t    "jump_statement : continue_statement",
//t    "jump_statement : goto_statement",
//t    "jump_statement : return_statement",
//t    "jump_statement : throw_statement",
//t    "jump_statement : yield_statement",
//t    "break_statement : BREAK SEMICOLON",
//t    "continue_statement : CONTINUE SEMICOLON",
//t    "continue_statement : CONTINUE error",
//t    "goto_statement : GOTO identifier_inside_body SEMICOLON",
//t    "goto_statement : GOTO CASE constant_expression SEMICOLON",
//t    "goto_statement : GOTO DEFAULT SEMICOLON",
//t    "return_statement : RETURN opt_expression SEMICOLON",
//t    "return_statement : RETURN expression error",
//t    "return_statement : RETURN error",
//t    "throw_statement : THROW opt_expression SEMICOLON",
//t    "throw_statement : THROW expression error",
//t    "throw_statement : THROW error",
//t    "yield_statement : identifier_inside_body RETURN opt_expression SEMICOLON",
//t    "yield_statement : identifier_inside_body RETURN expression error",
//t    "yield_statement : identifier_inside_body BREAK SEMICOLON",
//t    "opt_expression :",
//t    "opt_expression : expression",
//t    "try_statement : TRY block catch_clauses",
//t    "try_statement : TRY block FINALLY block",
//t    "try_statement : TRY block catch_clauses FINALLY block",
//t    "try_statement : TRY block error",
//t    "catch_clauses : catch_clause",
//t    "catch_clauses : catch_clauses catch_clause",
//t    "opt_identifier :",
//t    "opt_identifier : identifier_inside_body",
//t    "catch_clause : CATCH opt_catch_filter block",
//t    "$$99 :",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS $$99 opt_catch_filter_or_error",
//t    "catch_clause : CATCH open_parens_any error",
//t    "opt_catch_filter_or_error : opt_catch_filter block_prepared",
//t    "opt_catch_filter_or_error : error",
//t    "opt_catch_filter :",
//t    "$$100 :",
//t    "opt_catch_filter : WHEN $$100 open_parens_any expression CLOSE_PARENS",
//t    "checked_statement : CHECKED block",
//t    "unchecked_statement : UNCHECKED block",
//t    "$$101 :",
//t    "unsafe_statement : UNSAFE $$101 block",
//t    "lock_statement : LOCK open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "lock_statement : LOCK open_parens_any expression error",
//t    "$$102 :",
//t    "$$103 :",
//t    "fixed_statement : FIXED open_parens_any variable_type identifier_inside_body $$102 using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators CLOSE_PARENS $$103 embedded_statement",
//t    "$$104 :",
//t    "$$105 :",
//t    "using_statement : USING open_parens_any variable_type identifier_inside_body $$104 using_initialization CLOSE_PARENS $$105 embedded_statement",
//t    "using_statement : USING open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "using_statement : USING open_parens_any expression error",
//t    "using_initialization : using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators",
//t    "using_initialization : error",
//t    "using_or_fixed_variable_initializer :",
//t    "using_or_fixed_variable_initializer : ASSIGN variable_initializer",
//t    "query_expression : first_from_clause query_body",
//t    "query_expression : nested_from_clause query_body",
//t    "query_expression : first_from_clause COMPLETE_COMPLETION",
//t    "query_expression : nested_from_clause COMPLETE_COMPLETION",
//t    "first_from_clause : FROM_FIRST identifier_inside_body IN expression",
//t    "first_from_clause : FROM_FIRST type identifier_inside_body IN expression",
//t    "nested_from_clause : FROM identifier_inside_body IN expression",
//t    "nested_from_clause : FROM type identifier_inside_body IN expression",
//t    "$$106 :",
//t    "from_clause : FROM identifier_inside_body IN $$106 expression_or_error",
//t    "$$107 :",
//t    "from_clause : FROM type identifier_inside_body IN $$107 expression_or_error",
//t    "query_body : query_body_clauses select_or_group_clause opt_query_continuation",
//t    "query_body : select_or_group_clause opt_query_continuation",
//t    "query_body : query_body_clauses COMPLETE_COMPLETION",
//t    "query_body : query_body_clauses error",
//t    "query_body : error",
//t    "$$108 :",
//t    "select_or_group_clause : SELECT $$108 expression_or_error",
//t    "$$109 :",
//t    "$$110 :",
//t    "select_or_group_clause : GROUP $$109 expression_or_error $$110 by_expression",
//t    "by_expression : BY expression_or_error",
//t    "by_expression : error",
//t    "query_body_clauses : query_body_clause",
//t    "query_body_clauses : query_body_clauses query_body_clause",
//t    "query_body_clause : from_clause",
//t    "query_body_clause : let_clause",
//t    "query_body_clause : where_clause",
//t    "query_body_clause : join_clause",
//t    "query_body_clause : orderby_clause",
//t    "$$111 :",
//t    "let_clause : LET identifier_inside_body ASSIGN $$111 expression_or_error",
//t    "$$112 :",
//t    "where_clause : WHERE $$112 expression_or_error",
//t    "$$113 :",
//t    "$$114 :",
//t    "$$115 :",
//t    "join_clause : JOIN identifier_inside_body IN $$113 expression_or_error ON $$114 expression_or_error EQUALS $$115 expression_or_error opt_join_into",
//t    "$$116 :",
//t    "$$117 :",
//t    "$$118 :",
//t    "join_clause : JOIN type identifier_inside_body IN $$116 expression_or_error ON $$117 expression_or_error EQUALS $$118 expression_or_error opt_join_into",
//t    "opt_join_into :",
//t    "opt_join_into : INTO identifier_inside_body",
//t    "$$119 :",
//t    "orderby_clause : ORDERBY $$119 orderings",
//t    "orderings : order_by",
//t    "$$120 :",
//t    "orderings : order_by COMMA $$120 orderings_then_by",
//t    "orderings_then_by : then_by",
//t    "$$121 :",
//t    "orderings_then_by : orderings_then_by COMMA $$121 then_by",
//t    "order_by : expression",
//t    "order_by : expression ASCENDING",
//t    "order_by : expression DESCENDING",
//t    "then_by : expression",
//t    "then_by : expression ASCENDING",
//t    "then_by : expression DESCENDING",
//t    "opt_query_continuation :",
//t    "$$122 :",
//t    "opt_query_continuation : INTO identifier_inside_body $$122 query_body",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER EOF",
//t    "interactive_parsing : EVAL_USING_DECLARATIONS_UNIT_PARSER using_directives opt_COMPLETE_COMPLETION",
//t    "$$123 :",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER $$123 interactive_statement_list opt_COMPLETE_COMPLETION",
//t    "interactive_parsing : EVAL_COMPILATION_UNIT_PARSER interactive_compilation_unit",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations",
//t    "opt_COMPLETE_COMPLETION :",
//t    "opt_COMPLETE_COMPLETION : COMPLETE_COMPLETION",
//t    "close_brace_or_complete_completion : CLOSE_BRACE",
//t    "close_brace_or_complete_completion : COMPLETE_COMPLETION",
//t    "documentation_parsing : DOC_SEE doc_cref",
//t    "doc_cref : doc_type_declaration_name opt_doc_method_sig",
//t    "doc_cref : builtin_types opt_doc_method_sig",
//t    "doc_cref : VOID opt_doc_method_sig",
//t    "doc_cref : builtin_types DOT IDENTIFIER opt_doc_method_sig",
//t    "doc_cref : doc_type_declaration_name DOT THIS",
//t    "$$124 :",
//t    "doc_cref : doc_type_declaration_name DOT THIS OPEN_BRACKET $$124 opt_doc_parameters CLOSE_BRACKET",
//t    "doc_cref : EXPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : IMPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : OPERATOR overloadable_operator opt_doc_method_sig",
//t    "doc_type_declaration_name : type_declaration_name",
//t    "doc_type_declaration_name : doc_type_declaration_name DOT type_declaration_name",
//t    "opt_doc_method_sig :",
//t    "$$125 :",
//t    "opt_doc_method_sig : OPEN_PARENS $$125 opt_doc_parameters CLOSE_PARENS",
//t    "opt_doc_parameters :",
//t    "opt_doc_parameters : doc_parameters",
//t    "doc_parameters : doc_parameter",
//t    "doc_parameters : doc_parameters COMMA doc_parameter",
//t    "doc_parameter : opt_parameter_modifier parameter_type",
//t  };
//t public static string getRule (int index) {
//t    return yyRule [index];
//t }
//t}
  protected static readonly string [] yyNames = {    
    "end-of-file",null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,"EOF","NONE","ERROR",
    "FIRST_KEYWORD","ABSTRACT","AS","ADD","BASE","BOOL","BREAK","BYTE",
    "CASE","CATCH","CHAR","CHECKED","CLASS","CONST","CONTINUE","DECIMAL",
    "DEFAULT","DELEGATE","DO","DOUBLE","ELSE","ENUM","EVENT","EXPLICIT",
    "EXTERN","FALSE","FINALLY","FIXED","FLOAT","FOR","FOREACH","GOTO",
    "IF","IMPLICIT","IN","INT","INTERFACE","INTERNAL","IS","LOCK","LONG",
    "NAMESPACE","NEW","NULL","OBJECT","OPERATOR","OUT","OVERRIDE",
    "PARAMS","PRIVATE","PROTECTED","PUBLIC","READONLY","REF","RETURN",
    "REMOVE","SBYTE","SEALED","SHORT","SIZEOF","STACKALLOC","STATIC",
    "STRING","STRUCT","SWITCH","THIS","THROW","TRUE","TRY","TYPEOF",
    "UINT","ULONG","UNCHECKED","UNSAFE","USHORT","USING","VIRTUAL","VOID",
    "VOLATILE","WHERE","WHILE","ARGLIST","PARTIAL","ARROW","FROM",
    "FROM_FIRST","JOIN","ON","EQUALS","SELECT","GROUP","BY","LET",
    "ORDERBY","ASCENDING","DESCENDING","INTO","INTERR_NULLABLE",
    "EXTERN_ALIAS","REFVALUE","REFTYPE","MAKEREF","ASYNC","AWAIT",
    "INTERR_OPERATOR","WHEN","INTERPOLATED_STRING",
    "INTERPOLATED_STRING_END","GET","SET","LAST_KEYWORD","OPEN_BRACE",
    "CLOSE_BRACE","OPEN_BRACKET","CLOSE_BRACKET","OPEN_PARENS",
    "CLOSE_PARENS","DOT","COMMA","COLON","SEMICOLON","TILDE","PLUS",
    "MINUS","BANG","ASSIGN","OP_LT","OP_GT","BITWISE_AND","BITWISE_OR",
    "STAR","PERCENT","DIV","CARRET","INTERR","DOUBLE_COLON","OP_INC",
    "OP_DEC","OP_SHIFT_LEFT","OP_SHIFT_RIGHT","OP_LE","OP_GE","OP_EQ",
    "OP_NE","OP_AND","OP_OR","OP_MULT_ASSIGN","OP_DIV_ASSIGN",
    "OP_MOD_ASSIGN","OP_ADD_ASSIGN","OP_SUB_ASSIGN",
    "OP_SHIFT_LEFT_ASSIGN","OP_SHIFT_RIGHT_ASSIGN","OP_AND_ASSIGN",
    "OP_XOR_ASSIGN","OP_OR_ASSIGN","OP_PTR","OP_COALESCING",
    "OP_GENERICS_LT","OP_GENERICS_LT_DECL","OP_GENERICS_GT","LITERAL",
    "IDENTIFIER","OPEN_PARENS_LAMBDA","OPEN_PARENS_CAST",
    "GENERIC_DIMENSION","DEFAULT_COLON","OPEN_BRACKET_EXPR",
    "EVAL_STATEMENT_PARSER","EVAL_COMPILATION_UNIT_PARSER",
    "EVAL_USING_DECLARATIONS_UNIT_PARSER","DOC_SEE","GENERATE_COMPLETION",
    "COMPLETE_COMPLETION","UMINUS",
  };

  /** index-checked interface to yyNames[].
      @param token single character or %token value.
      @return token name or [illegal] or [unknown].
    */
//t  public static string yyname (int token) {
//t    if ((token < 0) || (token > yyNames.Length)) return "[illegal]";
//t    string name;
//t    if ((name = yyNames[token]) != null) return name;
//t    return "[unknown]";
//t  }

#pragma warning disable 414
  int yyExpectingState;
#pragma warning restore 414
  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
    */
  protected int [] yyExpectingTokens (int state){
    int token, n, len = 0;
    bool[] ok = new bool[yyNames.Length];
    if ((n = yySindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    if ((n = yyRindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    int [] result = new int [len];
    for (n = token = 0; n < len;  ++ token)
      if (ok[token]) result[n++] = token;
    return result;
  }
  protected string[] yyExpecting (int state) {
    int [] tokens = yyExpectingTokens (state);
    string [] result = new string[tokens.Length];
    for (int n = 0; n < tokens.Length;  n++)
      result[n++] = yyNames[tokens [n]];
    return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @param yydebug debug message writer implementing yyDebug, or null.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex, Object yyd)
				 {
//t    this.debug = (yydebug.yyDebug)yyd;
    return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
      This is not final so that it can be overwritten outside of invocations
      of yyparse().
    */
  protected int yyMax;

  /** executed at the beginning of a reduce action.
      Used as $$ = yyDefault($1), prior to the user-specified action, if any.
      Can be overwritten to provide deep copy, etc.
      @param first value for $1, or null.
      @return first.
    */
  protected Object yyDefault (Object first) {
    return first;
  }

	static int[] global_yyStates;
	static object[] global_yyVals;
#pragma warning disable 649
	protected bool use_global_stacks;
#pragma warning restore 649
	object[] yyVals;					// value stack
	object yyVal;						// value stack ptr
	int yyToken;						// current input
	int yyTop;

  /** the generated parser.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex)
  {
    if (yyMax <= 0) yyMax = 256;		// initial size
    int yyState = 0;                   // state stack ptr
    int [] yyStates;               	// state stack 
    yyVal = null;
    yyToken = -1;
    int yyErrorFlag = 0;				// #tks to shift
	if (use_global_stacks && global_yyStates != null) {
		yyVals = global_yyVals;
		yyStates = global_yyStates;
   } else {
		yyVals = new object [yyMax];
		yyStates = new int [yyMax];
		if (use_global_stacks) {
			global_yyVals = yyVals;
			global_yyStates = yyStates;
		}
	}

    /*yyLoop:*/ for (yyTop = 0;; ++ yyTop) {
      if (yyTop >= yyStates.Length) {			// dynamically increase
        global::System.Array.Resize (ref yyStates, yyStates.Length+yyMax);
        global::System.Array.Resize (ref yyVals, yyVals.Length+yyMax);
      }
      yyStates[yyTop] = yyState;
      yyVals[yyTop] = yyVal;
//t      if (debug != null) debug.push(yyState, yyVal);

      /*yyDiscarded:*/ while (true) {	// discarding a token does not change stack
        int yyN;
        if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t              debug.lex(yyState, yyToken, yyname(yyToken), yyLex.value());
          }
          if ((yyN = yySindex[yyState]) != 0 && ((yyN += yyToken) >= 0)
              && (yyN < yyTable.Length) && (yyCheck[yyN] == yyToken)) {
//t            if (debug != null)
//t              debug.shift(yyState, yyTable[yyN], yyErrorFlag-1);
            yyState = yyTable[yyN];		// shift to yyN
            yyVal = yyLex.value();
            yyToken = -1;
            if (yyErrorFlag > 0) -- yyErrorFlag;
            goto continue_yyLoop;
          }
          if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
              && yyN < yyTable.Length && yyCheck[yyN] == yyToken)
            yyN = yyTable[yyN];			// reduce (yyN)
          else
            switch (yyErrorFlag) {
  
            case 0:
              yyExpectingState = yyState;
              // yyerror(String.Format ("syntax error, got token `{0}'", yyname (yyToken)), yyExpecting(yyState));
//t              if (debug != null) debug.error("syntax error");
              if (yyToken == 0 /*eof*/ || yyToken == eof_token) throw new yyParser.yyUnexpectedEof ();
              goto case 1;
            case 1: case 2:
              yyErrorFlag = 3;
              do {
                if ((yyN = yySindex[yyStates[yyTop]]) != 0
                    && (yyN += Token.yyErrorCode) >= 0 && yyN < yyTable.Length
                    && yyCheck[yyN] == Token.yyErrorCode) {
//t                  if (debug != null)
//t                    debug.shift(yyStates[yyTop], yyTable[yyN], 3);
                  yyState = yyTable[yyN];
                  yyVal = yyLex.value();
                  goto continue_yyLoop;
                }
//t                if (debug != null) debug.pop(yyStates[yyTop]);
              } while (-- yyTop >= 0);
//t              if (debug != null) debug.reject();
              throw new yyParser.yyException("irrecoverable syntax error");
  
            case 3:
              if (yyToken == 0) {
//t                if (debug != null) debug.reject();
                throw new yyParser.yyException("irrecoverable syntax error at end-of-file");
              }
//t              if (debug != null)
//t                debug.discard(yyState, yyToken, yyname(yyToken),
//t  							yyLex.value());
              yyToken = -1;
              goto continue_yyDiscarded;		// leave stack alone
            }
        }
        int yyV = yyTop + 1-yyLen[yyN];
//t        if (debug != null)
//t          debug.reduce(yyState, yyStates[yyV-1], yyN, YYRules.getRule (yyN), yyLen[yyN]);
        yyVal = yyV > yyTop ? null : yyVals[yyV]; // yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
        switch (yyN) {
case 1:
#line 392 "cs-parser.jay"
  {
		Lexer.check_incorrect_doc_comment ();
	  }
  break;
case 2:
#line 393 "cs-parser.jay"
  { Lexer.CompleteOnEOF = false; }
  break;
case 6:
  case_6();
  break;
case 7:
#line 412 "cs-parser.jay"
  {
		module.AddAttributes ((Attributes) yyVals[0+yyTop], current_namespace);
	  }
  break;
case 8:
  case_8();
  break;
case 13:
  case_13();
  break;
case 14:
#line 457 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 17:
  case_17();
  break;
case 18:
  case_18();
  break;
case 19:
  case_19();
  break;
case 20:
  case_20();
  break;
case 23:
  case_23();
  break;
case 24:
  case_24();
  break;
case 25:
  case_25();
  break;
case 26:
  case_26();
  break;
case 29:
  case_29();
  break;
case 30:
  case_30();
  break;
case 31:
  case_31();
  break;
case 32:
  case_32();
  break;
case 45:
  case_45();
  break;
case 46:
#line 660 "cs-parser.jay"
  {
		current_namespace.DeclarationFound = true;
	  }
  break;
case 47:
  case_47();
  break;
case 55:
  case_55();
  break;
case 56:
  case_56();
  break;
case 57:
  case_57();
  break;
case 58:
  case_58();
  break;
case 59:
  case_59();
  break;
case 60:
  case_60();
  break;
case 61:
  case_61();
  break;
case 62:
  case_62();
  break;
case 63:
  case_63();
  break;
case 64:
  case_64();
  break;
case 65:
#line 787 "cs-parser.jay"
  { yyVal = "event"; PushLocation (GetLocation (yyVals[0+yyTop])); }
  break;
case 66:
#line 788 "cs-parser.jay"
  { yyVal = "return"; PushLocation (GetLocation (yyVals[0+yyTop])); }
  break;
case 67:
#line 795 "cs-parser.jay"
  {
		yyVal = new List<Attribute> (4) { (Attribute) yyVals[0+yyTop] };
	  }
  break;
case 68:
  case_68();
  break;
case 69:
#line 812 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 70:
  case_70();
  break;
case 72:
#line 840 "cs-parser.jay"
  { yyVal = null; HadAttributeParens = false;  }
  break;
case 73:
  case_73();
  break;
case 74:
#line 852 "cs-parser.jay"
  { yyVal = null; }
  break;
case 75:
  case_75();
  break;
case 76:
  case_76();
  break;
case 77:
  case_77();
  break;
case 78:
  case_78();
  break;
case 79:
#line 896 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 81:
  case_81();
  break;
case 82:
#line 909 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 83:
  case_83();
  break;
case 84:
  case_84();
  break;
case 86:
#line 940 "cs-parser.jay"
  { yyVal = null; }
  break;
case 87:
#line 944 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Ref;
	  }
  break;
case 88:
#line 948 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Out;
	  }
  break;
case 91:
  case_91();
  break;
case 92:
  case_92();
  break;
case 106:
  case_106();
  break;
case 107:
  case_107();
  break;
case 108:
  case_108();
  break;
case 109:
#line 1025 "cs-parser.jay"
  {
	  }
  break;
case 110:
  case_110();
  break;
case 111:
  case_111();
  break;
case 112:
  case_112();
  break;
case 113:
  case_113();
  break;
case 114:
  case_114();
  break;
case 115:
#line 1075 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 116:
  case_116();
  break;
case 117:
  case_117();
  break;
case 118:
  case_118();
  break;
case 121:
#line 1124 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 122:
#line 1128 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 123:
  case_123();
  break;
case 124:
#line 1144 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 125:
  case_125();
  break;
case 126:
  case_126();
  break;
case 129:
  case_129();
  break;
case 130:
  case_130();
  break;
case 131:
  case_131();
  break;
case 132:
  case_132();
  break;
case 133:
#line 1223 "cs-parser.jay"
  {
		report.Error (1641, GetLocation (yyVals[-1+yyTop]), "A fixed size buffer field must have the array size specifier after the field name");
	  }
  break;
case 135:
  case_135();
  break;
case 136:
  case_136();
  break;
case 139:
#line 1253 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 140:
#line 1257 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 141:
  case_141();
  break;
case 142:
#line 1270 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 143:
  case_143();
  break;
case 146:
#line 1289 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 147:
#line 1293 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 148:
  case_148();
  break;
case 149:
#line 1309 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 150:
  case_150();
  break;
case 151:
  case_151();
  break;
case 154:
  case_154();
  break;
case 155:
  case_155();
  break;
case 156:
  case_156();
  break;
case 157:
#line 1377 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 158:
  case_158();
  break;
case 159:
  case_159();
  break;
case 160:
#line 1416 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 161:
  case_161();
  break;
case 162:
#line 1426 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 163:
  case_163();
  break;
case 164:
  case_164();
  break;
case 165:
  case_165();
  break;
case 169:
#line 1504 "cs-parser.jay"
  { savedLocation = GetLocation (yyVals[0+yyTop]); yyVal = null; }
  break;
case 170:
  case_170();
  break;
case 171:
  case_171();
  break;
case 172:
#line 1528 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 174:
  case_174();
  break;
case 175:
  case_175();
  break;
case 176:
  case_176();
  break;
case 177:
  case_177();
  break;
case 178:
  case_178();
  break;
case 179:
  case_179();
  break;
case 180:
  case_180();
  break;
case 181:
#line 1600 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[0+yyTop] } );
	  }
  break;
case 182:
#line 1604 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[0+yyTop])) }, true);
	  }
  break;
case 183:
  case_183();
  break;
case 184:
  case_184();
  break;
case 185:
  case_185();
  break;
case 186:
  case_186();
  break;
case 187:
  case_187();
  break;
case 188:
  case_188();
  break;
case 189:
  case_189();
  break;
case 190:
#line 1685 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 191:
  case_191();
  break;
case 192:
#line 1726 "cs-parser.jay"
  { yyVal = Parameter.Modifier.NONE; }
  break;
case 194:
#line 1734 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 195:
  case_195();
  break;
case 196:
  case_196();
  break;
case 197:
  case_197();
  break;
case 198:
  case_198();
  break;
case 199:
  case_199();
  break;
case 200:
  case_200();
  break;
case 201:
  case_201();
  break;
case 202:
  case_202();
  break;
case 203:
  case_203();
  break;
case 204:
#line 1828 "cs-parser.jay"
  {
		Error_DuplicateParameterModifier (GetLocation (yyVals[-1+yyTop]), Parameter.Modifier.PARAMS);
	  }
  break;
case 205:
  case_205();
  break;
case 206:
  case_206();
  break;
case 207:
  case_207();
  break;
case 208:
  case_208();
  break;
case 209:
  case_209();
  break;
case 210:
#line 1878 "cs-parser.jay"
  {
		current_property = null;
	  }
  break;
case 211:
  case_211();
  break;
case 212:
  case_212();
  break;
case 214:
  case_214();
  break;
case 215:
  case_215();
  break;
case 218:
#line 1940 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 219:
  case_219();
  break;
case 220:
  case_220();
  break;
case 221:
#line 1986 "cs-parser.jay"
  {
		lbag.AppendToMember (current_property, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 222:
  case_222();
  break;
case 227:
  case_227();
  break;
case 228:
  case_228();
  break;
case 229:
  case_229();
  break;
case 230:
  case_230();
  break;
case 231:
  case_231();
  break;
case 233:
  case_233();
  break;
case 234:
  case_234();
  break;
case 235:
#line 2127 "cs-parser.jay"
  {
	  }
  break;
case 236:
  case_236();
  break;
case 237:
  case_237();
  break;
case 238:
  case_238();
  break;
case 239:
  case_239();
  break;
case 240:
#line 2167 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);	  
	  }
  break;
case 243:
  case_243();
  break;
case 244:
  case_244();
  break;
case 245:
#line 2192 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 246:
#line 2196 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 251:
#line 2204 "cs-parser.jay"
  {
	  	report.Error (567, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain operators");
	  }
  break;
case 252:
#line 2208 "cs-parser.jay"
  {
	  	report.Error (526, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain contructors");
	  }
  break;
case 253:
#line 2212 "cs-parser.jay"
  {
	  	report.Error (524, GetLocation (yyVals[0+yyTop]), "Interfaces cannot declare classes, structs, interfaces, delegates, or enumerations");
	  }
  break;
case 254:
#line 2218 "cs-parser.jay"
  {
	  }
  break;
case 255:
  case_255();
  break;
case 257:
  case_257();
  break;
case 258:
  case_258();
  break;
case 259:
  case_259();
  break;
case 261:
#line 2312 "cs-parser.jay"
  { yyVal = Operator.OpType.LogicalNot; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 262:
#line 2313 "cs-parser.jay"
  { yyVal = Operator.OpType.OnesComplement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 263:
#line 2314 "cs-parser.jay"
  { yyVal = Operator.OpType.Increment; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 264:
#line 2315 "cs-parser.jay"
  { yyVal = Operator.OpType.Decrement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 265:
#line 2316 "cs-parser.jay"
  { yyVal = Operator.OpType.True; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 266:
#line 2317 "cs-parser.jay"
  { yyVal = Operator.OpType.False; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 267:
#line 2319 "cs-parser.jay"
  { yyVal = Operator.OpType.Addition; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 268:
#line 2320 "cs-parser.jay"
  { yyVal = Operator.OpType.Subtraction; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 269:
#line 2322 "cs-parser.jay"
  { yyVal = Operator.OpType.Multiply; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 270:
#line 2323 "cs-parser.jay"
  {  yyVal = Operator.OpType.Division; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 271:
#line 2324 "cs-parser.jay"
  { yyVal = Operator.OpType.Modulus; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 272:
#line 2325 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseAnd; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 273:
#line 2326 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 274:
#line 2327 "cs-parser.jay"
  { yyVal = Operator.OpType.ExclusiveOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 275:
#line 2328 "cs-parser.jay"
  { yyVal = Operator.OpType.LeftShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 276:
#line 2329 "cs-parser.jay"
  { yyVal = Operator.OpType.RightShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 277:
#line 2330 "cs-parser.jay"
  { yyVal = Operator.OpType.Equality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 278:
#line 2331 "cs-parser.jay"
  { yyVal = Operator.OpType.Inequality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 279:
#line 2332 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 280:
#line 2333 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 281:
#line 2334 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 282:
#line 2335 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 283:
  case_283();
  break;
case 284:
#line 2349 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 285:
  case_285();
  break;
case 286:
#line 2372 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 287:
  case_287();
  break;
case 288:
  case_288();
  break;
case 289:
  case_289();
  break;
case 290:
  case_290();
  break;
case 291:
  case_291();
  break;
case 292:
  case_292();
  break;
case 293:
  case_293();
  break;
case 295:
#line 2496 "cs-parser.jay"
  { current_block = null; yyVal = null; }
  break;
case 298:
#line 2508 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 299:
  case_299();
  break;
case 300:
#line 2518 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 301:
  case_301();
  break;
case 302:
  case_302();
  break;
case 303:
  case_303();
  break;
case 304:
  case_304();
  break;
case 305:
  case_305();
  break;
case 306:
  case_306();
  break;
case 307:
  case_307();
  break;
case 308:
  case_308();
  break;
case 309:
  case_309();
  break;
case 310:
  case_310();
  break;
case 311:
  case_311();
  break;
case 313:
#line 2645 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 314:
  case_314();
  break;
case 317:
#line 2663 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 318:
#line 2667 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 319:
  case_319();
  break;
case 320:
#line 2680 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 321:
  case_321();
  break;
case 322:
  case_322();
  break;
case 323:
#line 2705 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 326:
  case_326();
  break;
case 327:
  case_327();
  break;
case 328:
  case_328();
  break;
case 329:
  case_329();
  break;
case 330:
  case_330();
  break;
case 331:
  case_331();
  break;
case 332:
  case_332();
  break;
case 333:
  case_333();
  break;
case 335:
  case_335();
  break;
case 336:
  case_336();
  break;
case 337:
  case_337();
  break;
case 338:
  case_338();
  break;
case 339:
  case_339();
  break;
case 340:
  case_340();
  break;
case 342:
  case_342();
  break;
case 343:
  case_343();
  break;
case 346:
#line 2893 "cs-parser.jay"
  {
		lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 348:
  case_348();
  break;
case 349:
  case_349();
  break;
case 350:
  case_350();
  break;
case 351:
  case_351();
  break;
case 352:
  case_352();
  break;
case 354:
#line 2967 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 355:
  case_355();
  break;
case 356:
#line 2986 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = false;
	  }
  break;
case 357:
  case_357();
  break;
case 359:
  case_359();
  break;
case 361:
  case_361();
  break;
case 362:
  case_362();
  break;
case 364:
  case_364();
  break;
case 365:
  case_365();
  break;
case 366:
  case_366();
  break;
case 367:
  case_367();
  break;
case 369:
  case_369();
  break;
case 370:
  case_370();
  break;
case 371:
  case_371();
  break;
case 372:
  case_372();
  break;
case 373:
#line 3111 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 374:
  case_374();
  break;
case 375:
  case_375();
  break;
case 377:
  case_377();
  break;
case 378:
  case_378();
  break;
case 379:
  case_379();
  break;
case 380:
  case_380();
  break;
case 381:
  case_381();
  break;
case 382:
  case_382();
  break;
case 384:
  case_384();
  break;
case 385:
  case_385();
  break;
case 386:
  case_386();
  break;
case 387:
  case_387();
  break;
case 388:
  case_388();
  break;
case 390:
#line 3236 "cs-parser.jay"
  {
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 391:
#line 3243 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 397:
  case_397();
  break;
case 399:
#line 3273 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 400:
  case_400();
  break;
case 401:
#line 3292 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 403:
  case_403();
  break;
case 404:
  case_404();
  break;
case 405:
#line 3313 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 406:
#line 3317 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 407:
  case_407();
  break;
case 408:
  case_408();
  break;
case 409:
  case_409();
  break;
case 410:
#line 3351 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Object, GetLocation (yyVals[0+yyTop])); }
  break;
case 411:
#line 3352 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.String, GetLocation (yyVals[0+yyTop])); }
  break;
case 412:
#line 3353 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Bool, GetLocation (yyVals[0+yyTop])); }
  break;
case 413:
#line 3354 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Decimal, GetLocation (yyVals[0+yyTop])); }
  break;
case 414:
#line 3355 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Float, GetLocation (yyVals[0+yyTop])); }
  break;
case 415:
#line 3356 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Double, GetLocation (yyVals[0+yyTop])); }
  break;
case 417:
#line 3361 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.SByte, GetLocation (yyVals[0+yyTop])); }
  break;
case 418:
#line 3362 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Byte, GetLocation (yyVals[0+yyTop])); }
  break;
case 419:
#line 3363 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Short, GetLocation (yyVals[0+yyTop])); }
  break;
case 420:
#line 3364 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UShort, GetLocation (yyVals[0+yyTop])); }
  break;
case 421:
#line 3365 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Int, GetLocation (yyVals[0+yyTop])); }
  break;
case 422:
#line 3366 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UInt, GetLocation (yyVals[0+yyTop])); }
  break;
case 423:
#line 3367 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Long, GetLocation (yyVals[0+yyTop])); }
  break;
case 424:
#line 3368 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.ULong, GetLocation (yyVals[0+yyTop])); }
  break;
case 425:
#line 3369 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Char, GetLocation (yyVals[0+yyTop])); }
  break;
case 448:
  case_448();
  break;
case 452:
#line 3413 "cs-parser.jay"
  { yyVal = new NullLiteral (GetLocation (yyVals[0+yyTop])); }
  break;
case 453:
#line 3417 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, true, GetLocation (yyVals[0+yyTop])); }
  break;
case 454:
#line 3418 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, false, GetLocation (yyVals[0+yyTop])); }
  break;
case 455:
#line 3425 "cs-parser.jay"
  {
		yyVal = new InterpolatedString ((StringLiteral) yyVals[-2+yyTop], (List<Expression>) yyVals[-1+yyTop], (StringLiteral) yyVals[0+yyTop]);
	  }
  break;
case 456:
#line 3429 "cs-parser.jay"
  {
		yyVal = new InterpolatedString ((StringLiteral) yyVals[0+yyTop], null, null);
	  }
  break;
case 457:
  case_457();
  break;
case 458:
  case_458();
  break;
case 459:
#line 3452 "cs-parser.jay"
  {
		yyVal = new InterpolatedStringInsert ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 460:
  case_460();
  break;
case 461:
#line 3462 "cs-parser.jay"
  {
		lexer.parsing_interpolation_format = true;
	  }
  break;
case 462:
  case_462();
  break;
case 463:
#line 3474 "cs-parser.jay"
  {
		lexer.parsing_interpolation_format = true;
	  }
  break;
case 464:
  case_464();
  break;
case 469:
  case_469();
  break;
case 470:
#line 3516 "cs-parser.jay"
  {
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 471:
  case_471();
  break;
case 472:
  case_472();
  break;
case 473:
  case_473();
  break;
case 474:
  case_474();
  break;
case 475:
  case_475();
  break;
case 476:
  case_476();
  break;
case 477:
  case_477();
  break;
case 478:
  case_478();
  break;
case 479:
#line 3577 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null,GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 480:
  case_480();
  break;
case 481:
#line 3585 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null, lexer.Location);
	  }
  break;
case 482:
  case_482();
  break;
case 483:
  case_483();
  break;
case 484:
  case_484();
  break;
case 485:
  case_485();
  break;
case 486:
#line 3615 "cs-parser.jay"
  { yyVal = null; }
  break;
case 488:
  case_488();
  break;
case 489:
  case_489();
  break;
case 490:
#line 3637 "cs-parser.jay"
  { yyVal = null; }
  break;
case 491:
#line 3641 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	}
  break;
case 492:
  case_492();
  break;
case 493:
  case_493();
  break;
case 494:
  case_494();
  break;
case 495:
  case_495();
  break;
case 496:
  case_496();
  break;
case 497:
#line 3680 "cs-parser.jay"
  {
		yyVal = new CompletionElementInitializer (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 498:
  case_498();
  break;
case 499:
  case_499();
  break;
case 500:
  case_500();
  break;
case 501:
  case_501();
  break;
case 504:
#line 3720 "cs-parser.jay"
  { yyVal = null; }
  break;
case 506:
  case_506();
  break;
case 507:
  case_507();
  break;
case 508:
  case_508();
  break;
case 509:
  case_509();
  break;
case 510:
  case_510();
  break;
case 511:
#line 3774 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 515:
  case_515();
  break;
case 516:
#line 3792 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Ref);
	  }
  break;
case 517:
  case_517();
  break;
case 518:
#line 3801 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
	  }
  break;
case 519:
  case_519();
  break;
case 520:
  case_520();
  break;
case 521:
  case_521();
  break;
case 522:
  case_522();
  break;
case 523:
  case_523();
  break;
case 525:
  case_525();
  break;
case 526:
  case_526();
  break;
case 527:
  case_527();
  break;
case 528:
  case_528();
  break;
case 529:
  case_529();
  break;
case 530:
  case_530();
  break;
case 531:
  case_531();
  break;
case 532:
  case_532();
  break;
case 533:
#line 3928 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 535:
#line 3936 "cs-parser.jay"
  {
		yyVal = new This (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 536:
  case_536();
  break;
case 537:
  case_537();
  break;
case 538:
#line 3956 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostIncrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 539:
#line 3963 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostDecrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 540:
  case_540();
  break;
case 541:
  case_541();
  break;
case 542:
  case_542();
  break;
case 543:
  case_543();
  break;
case 544:
  case_544();
  break;
case 545:
  case_545();
  break;
case 546:
  case_546();
  break;
case 547:
#line 4030 "cs-parser.jay"
  {
		++lexer.parsing_type;
	  }
  break;
case 548:
  case_548();
  break;
case 549:
  case_549();
  break;
case 550:
#line 4052 "cs-parser.jay"
  {
		yyVal = new EmptyCompletion ();
	  }
  break;
case 553:
#line 4061 "cs-parser.jay"
  { yyVal = null; }
  break;
case 555:
  case_555();
  break;
case 556:
  case_556();
  break;
case 557:
#line 4083 "cs-parser.jay"
  {
		yyVal = new EmptyCompletion ();
	  }
  break;
case 558:
#line 4087 "cs-parser.jay"
  {
	  	yyVal = yyVals[-1+yyTop];
	  }
  break;
case 559:
  case_559();
  break;
case 560:
  case_560();
  break;
case 561:
  case_561();
  break;
case 562:
  case_562();
  break;
case 566:
  case_566();
  break;
case 567:
  case_567();
  break;
case 568:
  case_568();
  break;
case 569:
#line 4147 "cs-parser.jay"
  {
		yyVal = 2;
	  }
  break;
case 570:
#line 4151 "cs-parser.jay"
  {
		yyVal = ((int) yyVals[-1+yyTop]) + 1;
	  }
  break;
case 571:
#line 4158 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 572:
#line 4162 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 573:
  case_573();
  break;
case 574:
  case_574();
  break;
case 575:
  case_575();
  break;
case 576:
  case_576();
  break;
case 577:
  case_577();
  break;
case 579:
  case_579();
  break;
case 580:
  case_580();
  break;
case 581:
  case_581();
  break;
case 582:
  case_582();
  break;
case 583:
  case_583();
  break;
case 584:
  case_584();
  break;
case 585:
  case_585();
  break;
case 586:
  case_586();
  break;
case 587:
  case_587();
  break;
case 588:
  case_588();
  break;
case 589:
#line 4295 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], false, GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 590:
  case_590();
  break;
case 591:
#line 4308 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], true, GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 592:
  case_592();
  break;
case 593:
#line 4325 "cs-parser.jay"
  {
		yyVal = ParametersCompiled.Undefined;
	  }
  break;
case 595:
#line 4333 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 596:
  case_596();
  break;
case 597:
  case_597();
  break;
case 599:
#line 4359 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.LogicalNot, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 600:
#line 4363 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.OnesComplement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 601:
  case_601();
  break;
case 602:
  case_602();
  break;
case 603:
  case_603();
  break;
case 604:
  case_604();
  break;
case 605:
  case_605();
  break;
case 606:
  case_606();
  break;
case 608:
#line 4427 "cs-parser.jay"
  { 
	  	yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 609:
#line 4431 "cs-parser.jay"
  { 
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 610:
#line 4435 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 611:
#line 4439 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 612:
#line 4443 "cs-parser.jay"
  {
		yyVal = new Indirection ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 613:
#line 4447 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.AddressOf, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 614:
  case_614();
  break;
case 615:
  case_615();
  break;
case 616:
  case_616();
  break;
case 617:
  case_617();
  break;
case 618:
  case_618();
  break;
case 619:
  case_619();
  break;
case 621:
  case_621();
  break;
case 622:
  case_622();
  break;
case 623:
  case_623();
  break;
case 624:
  case_624();
  break;
case 625:
  case_625();
  break;
case 626:
  case_626();
  break;
case 628:
  case_628();
  break;
case 629:
  case_629();
  break;
case 630:
  case_630();
  break;
case 631:
  case_631();
  break;
case 632:
#line 4555 "cs-parser.jay"
  {
		yyVal = new As ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 633:
  case_633();
  break;
case 634:
  case_634();
  break;
case 635:
  case_635();
  break;
case 636:
  case_636();
  break;
case 637:
  case_637();
  break;
case 638:
  case_638();
  break;
case 641:
#line 4611 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 642:
#line 4615 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 645:
  case_645();
  break;
case 646:
#line 4626 "cs-parser.jay"
  {
		yyVal = new WildcardPattern (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 649:
#line 4635 "cs-parser.jay"
  {
		yyVal = new RecursivePattern ((ATypeNameExpression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 650:
#line 4642 "cs-parser.jay"
  {
		yyVal = new PropertyPattern ((ATypeNameExpression) yyVals[-3+yyTop], (List<PropertyPatternMember>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 651:
  case_651();
  break;
case 652:
  case_652();
  break;
case 653:
  case_653();
  break;
case 655:
  case_655();
  break;
case 656:
#line 4684 "cs-parser.jay"
  {
		yyVal = new Arguments (0);
	  }
  break;
case 658:
  case_658();
  break;
case 659:
  case_659();
  break;
case 660:
#line 4710 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 661:
  case_661();
  break;
case 663:
  case_663();
  break;
case 664:
  case_664();
  break;
case 665:
  case_665();
  break;
case 666:
  case_666();
  break;
case 668:
  case_668();
  break;
case 669:
  case_669();
  break;
case 670:
  case_670();
  break;
case 671:
  case_671();
  break;
case 672:
  case_672();
  break;
case 673:
  case_673();
  break;
case 674:
  case_674();
  break;
case 675:
  case_675();
  break;
case 677:
  case_677();
  break;
case 678:
  case_678();
  break;
case 679:
  case_679();
  break;
case 680:
  case_680();
  break;
case 682:
  case_682();
  break;
case 683:
  case_683();
  break;
case 685:
  case_685();
  break;
case 686:
  case_686();
  break;
case 688:
  case_688();
  break;
case 689:
  case_689();
  break;
case 691:
  case_691();
  break;
case 692:
  case_692();
  break;
case 694:
  case_694();
  break;
case 695:
  case_695();
  break;
case 697:
  case_697();
  break;
case 699:
  case_699();
  break;
case 700:
  case_700();
  break;
case 701:
  case_701();
  break;
case 702:
  case_702();
  break;
case 703:
  case_703();
  break;
case 704:
  case_704();
  break;
case 705:
  case_705();
  break;
case 706:
  case_706();
  break;
case 707:
  case_707();
  break;
case 708:
  case_708();
  break;
case 709:
  case_709();
  break;
case 710:
  case_710();
  break;
case 711:
  case_711();
  break;
case 712:
  case_712();
  break;
case 713:
  case_713();
  break;
case 714:
  case_714();
  break;
case 715:
  case_715();
  break;
case 716:
  case_716();
  break;
case 717:
  case_717();
  break;
case 718:
  case_718();
  break;
case 719:
  case_719();
  break;
case 720:
#line 5055 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 721:
  case_721();
  break;
case 722:
#line 5066 "cs-parser.jay"
  {
		start_block (Location.Null);
	  }
  break;
case 723:
  case_723();
  break;
case 725:
  case_725();
  break;
case 727:
  case_727();
  break;
case 728:
  case_728();
  break;
case 729:
  case_729();
  break;
case 730:
  case_730();
  break;
case 731:
  case_731();
  break;
case 732:
  case_732();
  break;
case 733:
  case_733();
  break;
case 734:
#line 5133 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 735:
  case_735();
  break;
case 736:
  case_736();
  break;
case 737:
#line 5147 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;	  
	  }
  break;
case 738:
  case_738();
  break;
case 739:
  case_739();
  break;
case 745:
#line 5172 "cs-parser.jay"
  {
		yyVal = new ArglistAccess (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 746:
  case_746();
  break;
case 747:
  case_747();
  break;
case 748:
  case_748();
  break;
case 750:
#line 5201 "cs-parser.jay"
  {
		yyVal = new BooleanExpression ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 751:
#line 5208 "cs-parser.jay"
  {
	  	yyVal = null;
	  }
  break;
case 753:
  case_753();
  break;
case 754:
#line 5229 "cs-parser.jay"
  {
	  	yyVal = null;
	  }
  break;
case 755:
#line 5233 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 756:
#line 5237 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 757:
#line 5241 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 758:
  case_758();
  break;
case 759:
  case_759();
  break;
case 760:
#line 5266 "cs-parser.jay"
  {
	  }
  break;
case 761:
  case_761();
  break;
case 762:
  case_762();
  break;
case 763:
  case_763();
  break;
case 764:
  case_764();
  break;
case 765:
#line 5318 "cs-parser.jay"
  { yyVal = null; }
  break;
case 766:
#line 5320 "cs-parser.jay"
  { yyVal = yyVals[0+yyTop]; StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[0+yyTop])); }
  break;
case 767:
  case_767();
  break;
case 768:
#line 5333 "cs-parser.jay"
  {
		lexer.parsing_modifiers = false;		
	  }
  break;
case 770:
  case_770();
  break;
case 771:
  case_771();
  break;
case 772:
  case_772();
  break;
case 773:
  case_773();
  break;
case 774:
  case_774();
  break;
case 775:
  case_775();
  break;
case 776:
  case_776();
  break;
case 777:
  case_777();
  break;
case 778:
  case_778();
  break;
case 779:
  case_779();
  break;
case 780:
  case_780();
  break;
case 781:
  case_781();
  break;
case 782:
  case_782();
  break;
case 783:
  case_783();
  break;
case 784:
  case_784();
  break;
case 785:
  case_785();
  break;
case 788:
  case_788();
  break;
case 789:
  case_789();
  break;
case 791:
#line 5463 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 792:
  case_792();
  break;
case 793:
  case_793();
  break;
case 794:
  case_794();
  break;
case 795:
  case_795();
  break;
case 796:
  case_796();
  break;
case 797:
  case_797();
  break;
case 798:
  case_798();
  break;
case 799:
  case_799();
  break;
case 800:
#line 5556 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Class, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 801:
#line 5560 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Struct, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 802:
#line 5567 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 803:
  case_803();
  break;
case 804:
  case_804();
  break;
case 805:
  case_805();
  break;
case 806:
  case_806();
  break;
case 807:
#line 5612 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 808:
  case_808();
  break;
case 809:
  case_809();
  break;
case 810:
  case_810();
  break;
case 811:
  case_811();
  break;
case 812:
  case_812();
  break;
case 813:
  case_813();
  break;
case 814:
  case_814();
  break;
case 819:
#line 5674 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 820:
#line 5678 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 822:
  case_822();
  break;
case 823:
  case_823();
  break;
case 826:
#line 5712 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 827:
#line 5716 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 856:
  case_856();
  break;
case 857:
  case_857();
  break;
case 858:
  case_858();
  break;
case 859:
  case_859();
  break;
case 860:
  case_860();
  break;
case 863:
  case_863();
  break;
case 864:
  case_864();
  break;
case 865:
  case_865();
  break;
case 869:
  case_869();
  break;
case 870:
#line 5857 "cs-parser.jay"
  {
		yyVal = ComposedTypeSpecifier.CreatePointer (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 872:
#line 5865 "cs-parser.jay"
  {
	  	yyVal = Error_AwaitAsIdentifier (yyVals[0+yyTop]);
	  }
  break;
case 873:
  case_873();
  break;
case 874:
  case_874();
  break;
case 875:
  case_875();
  break;
case 876:
  case_876();
  break;
case 878:
  case_878();
  break;
case 880:
  case_880();
  break;
case 881:
  case_881();
  break;
case 885:
  case_885();
  break;
case 888:
  case_888();
  break;
case 889:
  case_889();
  break;
case 890:
#line 5979 "cs-parser.jay"
  {
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
	  }
  break;
case 891:
  case_891();
  break;
case 896:
  case_896();
  break;
case 898:
  case_898();
  break;
case 899:
  case_899();
  break;
case 900:
  case_900();
  break;
case 901:
#line 6029 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 902:
  case_902();
  break;
case 903:
#line 6039 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 904:
#line 6040 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 905:
  case_905();
  break;
case 906:
  case_906();
  break;
case 907:
  case_907();
  break;
case 910:
  case_910();
  break;
case 911:
  case_911();
  break;
case 912:
  case_912();
  break;
case 913:
#line 6112 "cs-parser.jay"
  {
		start_block (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 914:
  case_914();
  break;
case 915:
  case_915();
  break;
case 916:
#line 6132 "cs-parser.jay"
  {
		report.Warning (1522, 1, current_block.StartLocation, "Empty switch block"); 
	  }
  break;
case 920:
#line 6142 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 922:
  case_922();
  break;
case 923:
#line 6159 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 924:
  case_924();
  break;
case 925:
  case_925();
  break;
case 926:
#line 6188 "cs-parser.jay"
  {
		yyVal = new SwitchLabel (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 931:
  case_931();
  break;
case 932:
  case_932();
  break;
case 933:
  case_933();
  break;
case 934:
  case_934();
  break;
case 935:
  case_935();
  break;
case 936:
  case_936();
  break;
case 937:
#line 6249 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 938:
  case_938();
  break;
case 939:
#line 6264 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 940:
  case_940();
  break;
case 941:
  case_941();
  break;
case 942:
#line 6285 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 943:
  case_943();
  break;
case 944:
  case_944();
  break;
case 945:
  case_945();
  break;
case 946:
#line 6319 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 948:
  case_948();
  break;
case 949:
  case_949();
  break;
case 951:
#line 6343 "cs-parser.jay"
  { yyVal = null; }
  break;
case 953:
#line 6348 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 957:
  case_957();
  break;
case 958:
  case_958();
  break;
case 959:
  case_959();
  break;
case 960:
  case_960();
  break;
case 961:
  case_961();
  break;
case 962:
  case_962();
  break;
case 963:
  case_963();
  break;
case 970:
  case_970();
  break;
case 971:
  case_971();
  break;
case 972:
  case_972();
  break;
case 973:
  case_973();
  break;
case 974:
  case_974();
  break;
case 975:
  case_975();
  break;
case 976:
  case_976();
  break;
case 977:
  case_977();
  break;
case 978:
  case_978();
  break;
case 979:
  case_979();
  break;
case 980:
  case_980();
  break;
case 981:
  case_981();
  break;
case 982:
  case_982();
  break;
case 983:
  case_983();
  break;
case 984:
  case_984();
  break;
case 987:
#line 6594 "cs-parser.jay"
  {
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], (List<Catch>) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), false);
	  }
  break;
case 988:
  case_988();
  break;
case 989:
  case_989();
  break;
case 990:
  case_990();
  break;
case 991:
  case_991();
  break;
case 992:
  case_992();
  break;
case 995:
  case_995();
  break;
case 996:
  case_996();
  break;
case 997:
  case_997();
  break;
case 998:
  case_998();
  break;
case 999:
#line 6685 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 1000:
  case_1000();
  break;
case 1001:
#line 6697 "cs-parser.jay"
  {
		lexer.parsing_catch_when = false;
	  }
  break;
case 1002:
#line 6701 "cs-parser.jay"
  {
		lexer.parsing_catch_when = false;
	  }
  break;
case 1003:
  case_1003();
  break;
case 1004:
#line 6716 "cs-parser.jay"
  {
		yyVal = new Checked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 1005:
#line 6723 "cs-parser.jay"
  {
		yyVal = new Unchecked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 1006:
  case_1006();
  break;
case 1007:
#line 6733 "cs-parser.jay"
  {
		yyVal = new Unsafe ((Block) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 1008:
  case_1008();
  break;
case 1009:
  case_1009();
  break;
case 1010:
  case_1010();
  break;
case 1011:
  case_1011();
  break;
case 1012:
  case_1012();
  break;
case 1013:
  case_1013();
  break;
case 1014:
  case_1014();
  break;
case 1015:
  case_1015();
  break;
case 1016:
  case_1016();
  break;
case 1017:
  case_1017();
  break;
case 1019:
  case_1019();
  break;
case 1020:
#line 6838 "cs-parser.jay"
  {
		Error_MissingInitializer (lexer.Location);
	  }
  break;
case 1021:
  case_1021();
  break;
case 1022:
  case_1022();
  break;
case 1023:
  case_1023();
  break;
case 1024:
  case_1024();
  break;
case 1025:
  case_1025();
  break;
case 1026:
  case_1026();
  break;
case 1027:
  case_1027();
  break;
case 1028:
  case_1028();
  break;
case 1029:
  case_1029();
  break;
case 1030:
#line 6943 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1031:
  case_1031();
  break;
case 1032:
#line 6958 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1033:
  case_1033();
  break;
case 1034:
  case_1034();
  break;
case 1035:
  case_1035();
  break;
case 1037:
  case_1037();
  break;
case 1038:
  case_1038();
  break;
case 1039:
#line 7022 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1040:
  case_1040();
  break;
case 1041:
  case_1041();
  break;
case 1042:
  case_1042();
  break;
case 1043:
  case_1043();
  break;
case 1044:
#line 7061 "cs-parser.jay"
  {
	  	yyVal = new object[] { yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]) };
	  }
  break;
case 1045:
  case_1045();
  break;
case 1047:
  case_1047();
  break;
case 1053:
#line 7090 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1054:
  case_1054();
  break;
case 1055:
#line 7109 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1056:
  case_1056();
  break;
case 1057:
  case_1057();
  break;
case 1058:
  case_1058();
  break;
case 1059:
  case_1059();
  break;
case 1060:
  case_1060();
  break;
case 1061:
  case_1061();
  break;
case 1062:
  case_1062();
  break;
case 1063:
  case_1063();
  break;
case 1064:
  case_1064();
  break;
case 1066:
  case_1066();
  break;
case 1067:
  case_1067();
  break;
case 1068:
  case_1068();
  break;
case 1070:
  case_1070();
  break;
case 1071:
  case_1071();
  break;
case 1073:
  case_1073();
  break;
case 1074:
  case_1074();
  break;
case 1075:
#line 7310 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 1076:
  case_1076();
  break;
case 1077:
  case_1077();
  break;
case 1078:
#line 7327 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 1079:
  case_1079();
  break;
case 1080:
  case_1080();
  break;
case 1082:
  case_1082();
  break;
case 1083:
  case_1083();
  break;
case 1086:
  case_1086();
  break;
case 1087:
  case_1087();
  break;
case 1095:
#line 7452 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedName = (MemberName) yyVals[0+yyTop];
	  }
  break;
case 1096:
#line 7459 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
	  }
  break;
case 1097:
  case_1097();
  break;
case 1098:
  case_1098();
  break;
case 1099:
  case_1099();
  break;
case 1100:
#line 7482 "cs-parser.jay"
  {
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }
  break;
case 1101:
#line 7486 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 1102:
  case_1102();
  break;
case 1103:
  case_1103();
  break;
case 1104:
  case_1104();
  break;
case 1105:
  case_1105();
  break;
case 1107:
#line 7522 "cs-parser.jay"
  {
		yyVal = new MemberName (((MemberName) yyVals[-2+yyTop]), (MemberName) yyVals[0+yyTop]);
	  }
  break;
case 1109:
#line 7530 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 1110:
#line 7534 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 1111:
#line 7541 "cs-parser.jay"
  {
		yyVal = new List<DocumentationParameter> (0);
	  }
  break;
case 1113:
  case_1113();
  break;
case 1114:
  case_1114();
  break;
case 1115:
  case_1115();
  break;
#line default
        }
        yyTop -= yyLen[yyN];
        yyState = yyStates[yyTop];
        int yyM = yyLhs[yyN];
        if (yyState == 0 && yyM == 0) {
//t          if (debug != null) debug.shift(0, yyFinal);
          yyState = yyFinal;
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t               debug.lex(yyState, yyToken,yyname(yyToken), yyLex.value());
          }
          if (yyToken == 0) {
//t            if (debug != null) debug.accept(yyVal);
            return yyVal;
          }
          goto continue_yyLoop;
        }
        if (((yyN = yyGindex[yyM]) != 0) && ((yyN += yyState) >= 0)
            && (yyN < yyTable.Length) && (yyCheck[yyN] == yyState))
          yyState = yyTable[yyN];
        else
          yyState = yyDgoto[yyM];
//t        if (debug != null) debug.shift(yyStates[yyTop], yyState);
	 goto continue_yyLoop;
      continue_yyDiscarded: ;	// implements the named-loop continue: 'continue yyDiscarded'
      }
    continue_yyLoop: ;		// implements the named-loop continue: 'continue yyLoop'
    }
  }

/*
 All more than 3 lines long rules are wrapped into a method
*/
void case_6()
#line 400 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			Attributes attrs = (Attributes) yyVals[0+yyTop];
			report.Error (1730, attrs.Attrs [0].Location,
				"Assembly and module attributes must precede all other elements except using clauses and extern alias declarations");

			current_namespace.UnattachedAttributes = attrs;
		}
	  }

void case_8()
#line 414 "cs-parser.jay"
{
		if (yyToken == Token.EXTERN_ALIAS)
			report.Error (439, lexer.Location, "An extern alias declaration must precede all other elements");
		else
			Error_SyntaxError (yyToken);
	  }

void case_13()
#line 434 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "alias") {
			syntax_error (lt.Location, "`alias' expected");
		} else {
			if (lang_version == LanguageVersion.ISO_1)
				FeatureIsNotAvailable (lt.Location, "external alias");

			lt = (LocatedToken) yyVals[-1+yyTop];
			if (lt.Value == QualifiedAliasMember.GlobalAlias) {
				RootNamespace.Error_GlobalNamespaceRedefined (report, lt.Location);
			}
			
			var na = new UsingExternAlias (new SimpleMemberName (lt.Value, lt.Location), GetLocation (yyVals[-3+yyTop]));
			current_namespace.AddUsing (na);
			
			lbag.AddLocation (na, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_17()
#line 467 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_18()
#line 475 "cs-parser.jay"
{
		UsingClause uc;
		if (yyVals[-2+yyTop] != null) {
			if (lang_version <= LanguageVersion.V_5)
				FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "using static");

			uc = new UsingType ((ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
			lbag.AddLocation (uc, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			uc = new UsingNamespace ((ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
			lbag.AddLocation (uc, GetLocation (yyVals[0+yyTop]));
		}

		current_namespace.AddUsing (uc);
	  }

void case_19()
#line 491 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		if (lang_version != LanguageVersion.ISO_1 && lt.Value == "global") {
			report.Warning (440, 2, lt.Location,
			 "An alias named `global' will not be used when resolving `global::'. The global namespace will be used instead");
		}

		if (yyVals[-4+yyTop] != null) {
			report.Error (8085, GetLocation (yyVals[-4+yyTop]), "A `using static' directive cannot be used to declare an alias");
		}

		var un = new UsingAliasNamespace (new SimpleMemberName (lt.Value, lt.Location), (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		current_namespace.AddUsing (un);
		
		lbag.AddLocation (un, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_20()
#line 508 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	 }

void case_23()
#line 526 "cs-parser.jay"
{
		Attributes attrs = (Attributes) yyVals[-2+yyTop];
		var name = (MemberName) yyVals[0+yyTop];
		if (attrs != null) {
			bool valid_global_attrs = true;
			if ((current_namespace.DeclarationFound || current_namespace != file)) {
				valid_global_attrs = false;
			} else {
				foreach (var a in attrs.Attrs) {
					if (a.ExplicitTarget == "assembly" || a.ExplicitTarget == "module")
						continue;
						
					valid_global_attrs = false;
					break;
				}
			}
			
			if (!valid_global_attrs)
				report.Error (1671, name.Location, "A namespace declaration cannot have modifiers or attributes");
		}
	
		module.AddAttributes (attrs, current_namespace);
		
		var ns = new NamespaceContainer (name, current_namespace);
		current_namespace.AddTypeContainer (ns);
		current_container = current_namespace = ns;
	  }

void case_24()
#line 554 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_25()
#line 559 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  
		current_container = current_namespace = current_namespace.Parent;
	  }

void case_26()
#line 568 "cs-parser.jay"
{
		report.Error (1514, lexer.Location, "Unexpected symbol `{0}', expecting `.' or `{{'", GetSymbolName (yyToken));

		var name = (MemberName) yyVals[0+yyTop];		
		var ns = new NamespaceContainer (name, current_namespace);
		lbag.AddLocation (ns, GetLocation (yyVals[-1+yyTop]));
		current_namespace.AddTypeContainer (ns);
	  }

void case_29()
#line 582 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_30()
#line 590 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName (lt.Value, lt.Location);
	  }

void case_31()
#line 595 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, lt.Location);		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_32()
#line 601 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new MemberName ("<invalid>", lexer.Location);
	  }

void case_45()
#line 639 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			TypeContainer ds = (TypeContainer)yyVals[0+yyTop];

			if ((ds.ModFlags & (Modifiers.PRIVATE | Modifiers.PROTECTED)) != 0){
				report.Error (1527, ds.Location, 
				"Namespace elements cannot be explicitly declared as private, protected or protected internal");
			}

			/* Here is a trick, for explicit attributes we don't know where they belong to until*/
			/* we parse succeeding declaration hence we parse them as normal and re-attach them*/
			/* when we know whether they are global (assembly:, module:) or local (type:).*/
			if (ds.OptAttributes != null) {
				ds.OptAttributes.ConvertGlobalAttributes (ds, current_namespace, !current_namespace.DeclarationFound && current_namespace == file);
			}
		}
		current_namespace.DeclarationFound = true;
	  }

void case_47()
#line 661 "cs-parser.jay"
{
		current_namespace.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1518, lexer.Location, "Attributes must be attached to class, delegate, enum, interface or struct");
		lexer.putback ('}');
	  }

void case_55()
#line 694 "cs-parser.jay"
{
		var sect = (List<Attribute>) yyVals[0+yyTop];
		yyVal = new Attributes (sect);
	  }

void case_56()
#line 699 "cs-parser.jay"
{
		Attributes attrs = yyVals[-1+yyTop] as Attributes;
		var sect = (List<Attribute>) yyVals[0+yyTop];
		if (attrs == null)
			attrs = new Attributes (sect);
		else if (sect != null)
			attrs.AddAttributes (sect);
		yyVal = attrs;
	  }

void case_57()
#line 712 "cs-parser.jay"
{
	  	PushLocation (GetLocation (yyVals[0+yyTop]));
		lexer.parsing_attribute_section = true;
	  }

void case_58()
#line 717 "cs-parser.jay"
{
		lexer.parsing_attribute_section = false;
		yyVal = yyVals[0+yyTop];
	  }

void case_59()
#line 725 "cs-parser.jay"
{
		current_attr_target = (string) yyVals[-1+yyTop];
		if (current_attr_target == "assembly" || current_attr_target == "module") {
			Lexer.check_incorrect_doc_comment ();
		}
	  }

void case_60()
#line 732 "cs-parser.jay"
{
		/* when attribute target is invalid*/
		if (current_attr_target == string.Empty)
			yyVal = new List<Attribute> (0);
		else
			yyVal = yyVals[-2+yyTop];
		lbag.InsertLocation (yyVal, 0, GetLocation (yyVals[-4+yyTop]));
		lbag.InsertLocation (yyVal, 0, PopLocation ());
		lbag.InsertLocation (yyVal, 0, PopLocation ());
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		}

		current_attr_target = null;
		lexer.parsing_attribute_section = false;
 	  }

void case_61()
#line 751 "cs-parser.jay"
{
		yyVal = yyVals[-2+yyTop];
		lbag.InsertLocation (yyVal, 0, PopLocation ());
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (yyVal, GetLocation(yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (yyVal, GetLocation(yyVals[0+yyTop]));
		}
	  }

void case_62()
#line 761 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		var lt = (LocatedToken) yyVals[-1+yyTop];
		var tne = new SimpleName (lt.Value, null, lt.Location);

		yyVal = new List<Attribute> () {
			new Attribute (null, tne, null, GetLocation (yyVals[-1+yyTop]), false)
		};
	  }

void case_63()
#line 772 "cs-parser.jay"
{
		if (CheckAttributeTarget (yyToken, GetTokenName (yyToken), GetLocation (yyVals[0+yyTop])).Length > 0)
			Error_SyntaxError (yyToken);

 		yyVal = null;
	  }

void case_64()
#line 782 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = CheckAttributeTarget (yyToken, lt.Value, lt.Location);
		PushLocation (GetLocation (yyVals[0+yyTop]));
	  }

void case_68()
#line 797 "cs-parser.jay"
{
		var attrs = (List<Attribute>) yyVals[-2+yyTop];
		if (attrs != null) {
			attrs.Add ((Attribute) yyVals[0+yyTop]);
	  		lbag.AddLocation (attrs, GetLocation (yyVals[-1+yyTop]));
	  	}

		yyVal = attrs;
	  }

void case_70()
#line 814 "cs-parser.jay"
{
		--lexer.parsing_block;
		
		var tne = (ATypeNameExpression) yyVals[-2+yyTop];
		if (tne.HasTypeArguments) {
			report.Error (404, tne.Location, "Attributes cannot be generic");
		}
		Arguments [] arguments = (Arguments []) yyVals[0+yyTop];

		yyVal = new Attribute (current_attr_target, tne, (Arguments[]) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), lexer.IsEscapedIdentifier (tne));
		if (arguments != null) {
			attributeArgumentCommas.Insert (0, savedAttrParenOpenLocation);
			attributeArgumentCommas.Add (savedAttrParenCloseLocation);
			lbag.AddLocation (yyVal, attributeArgumentCommas);
			attributeArgumentCommas.Clear ();
		} else if (HadAttributeParens) {
			lbag.AddLocation (yyVal, savedAttrParenOpenLocation, savedAttrParenCloseLocation);
		}
	  }

void case_73()
#line 842 "cs-parser.jay"
{
		savedAttrParenOpenLocation = GetLocation (yyVals[-2+yyTop]);
		savedAttrParenCloseLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = yyVals[-1+yyTop];
		HadAttributeParens = true;
	  }

void case_75()
#line 854 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);
		yyVal = new Arguments [] { a, null };
	  }

void case_76()
#line 860 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);  
		yyVal = new Arguments [] { null, a };
	  }

void case_77()
#line 866 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] != null) {
			report.Error (1016, ((Argument) yyVals[0+yyTop]).Expr.Location, "Named attribute arguments must appear after the positional arguments");
			o [0] = new Arguments (4);
		}
		
		Arguments args = ((Arguments) o [0]);
		if (args.Count > 0 && !(yyVals[0+yyTop] is NamedArgument) && args [args.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
		
		args.Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_78()
#line 881 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] == null) {
			o [1] = new Arguments (4);
		}

		((Arguments) o [1]).Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_81()
#line 899 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_83()
#line 911 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop]);	  
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_84()
#line 921 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "named argument");
			
		/* Avoid boxing in common case (no modifier)*/
		var arg_mod = yyVals[-1+yyTop] == null ? Argument.AType.None : (Argument.AType) yyVals[-1+yyTop];
			
		var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop], arg_mod);
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_91()
#line 958 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
		lexer.parsing_block = 0;
	  }

void case_92()
#line 963 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
		lexer.parsing_block = 0;
	  }

void case_106()
#line 984 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `{0}' in class, struct, or interface member declaration",
			GetSymbolName (yyToken));
		yyVal = null;
		lexer.parsing_generic_declaration = false;
	  }

void case_107()
#line 994 "cs-parser.jay"
{
		current_local_parameters = current_type.PrimaryConstructorParameters;
		if (current_local_parameters == null) {
			report.Error (9010, GetLocation (yyVals[0+yyTop]), "Primary constructor body is not allowed");
			current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		}

		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_108()
#line 1005 "cs-parser.jay"
{
		current_local_parameters = null;
		var t = current_type as ClassOrStruct;
		if (t != null) {
			var b = (ToplevelBlock) yyVals[0+yyTop];
			if (t.PrimaryConstructorBlock != null) {
				report.Error (8041, b.StartLocation, "Primary constructor already has a body");
			} else {
				t.PrimaryConstructorBlock = b;
			}
		}
	  }

void case_110()
#line 1027 "cs-parser.jay"
{ 
		lexer.ConstraintsParsing = true;
		valid_param_mod = ParameterModifierType.PrimaryConstructor;
		push_current_container (new Struct (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
	  }

void case_111()
#line 1036 "cs-parser.jay"
{
		valid_param_mod = 0;
		lexer.ConstraintsParsing = false;

		if (yyVals[-2+yyTop] != null)
			current_type.PrimaryConstructorParameters = (ParametersCompiled) yyVals[-2+yyTop];

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();

		
		lexer.parsing_modifiers = true;
	  }

void case_112()
#line 1053 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_113()
#line 1058 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_114()
#line 1064 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_116()
#line 1082 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var mod = (Modifiers) yyVals[-3+yyTop];
		current_field = new Const (current_type, (FullNamedExpression) yyVals[-1+yyTop], mod, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_field);
		
		if ((mod & Modifiers.STATIC) != 0) {
			report.Error (504, current_field.Location, "The constant `{0}' cannot be marked static", current_field.GetSignatureForError ());
		}
		
		yyVal = current_field;
	  }

void case_117()
#line 1095 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_field = null;
	  }

void case_118()
#line 1108 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddMember (new Const (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], MemberName.Null, (Attributes) yyVals[-4+yyTop]));
	  }

void case_123()
#line 1133 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_125()
#line 1146 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_126()
#line 1152 "cs-parser.jay"
{
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
		yyVal = null;
	  }

void case_129()
#line 1167 "cs-parser.jay"
{
	  	lexer.parsing_generic_declaration = false;

		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (670, GetLocation (yyVals[-1+yyTop]), "Fields cannot have void type");
			
		var lt = (LocatedToken) yyVals[0+yyTop];
		current_field = new Field (current_type, type, (Modifiers) yyVals[-2+yyTop], new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-3+yyTop]);
		current_type.AddField (current_field);
		yyVal = current_field;
	  }

void case_130()
#line 1182 "cs-parser.jay"
{ 
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
			
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
		current_field = null;
	  }

void case_131()
#line 1195 "cs-parser.jay"
{ 
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "fixed size buffers");

		var lt = (LocatedToken) yyVals[0+yyTop];
		current_field = new FixedField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop],
			new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
			
		current_type.AddField (current_field);
	  }

void case_132()
#line 1206 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
	    }

		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];	    
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
	    current_field = null;
	  }

void case_135()
#line 1229 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_136()
#line 1235 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_field.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendToMember (current_field, GetLocation (yyVals[-2+yyTop]));
		end_block (lexer.Location);
		current_local_parameters = null;
	  }

void case_141()
#line 1262 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_143()
#line 1272 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_148()
#line 1298 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];	  
		yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_150()
#line 1311 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_151()
#line 1317 "cs-parser.jay"
{
		report.Error (443, lexer.Location, "Value or constant expected");
		yyVal = null;
	  }

void case_154()
#line 1327 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_155()
#line 1336 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.NotAllowed;

		/* Was added earlier in the case of body being eof for full ast*/
	  }

void case_156()
#line 1343 "cs-parser.jay"
{
		Method method = (Method) yyVals[-2+yyTop];
		method.Block = (ToplevelBlock) yyVals[0+yyTop];
		async_block = false;
		
		if (method.Block == null) {
			lbag.AppendToMember (method, savedLocation); /* semicolon*/
			method.ParameterInfo.CheckParameters (method);

			if ((method.ModFlags & Modifiers.ASYNC) != 0) {
				report.Error (1994, method.Location, "`{0}': The async modifier can only be used with methods that have a body",
					method.GetSignatureForError ());
			}
		} else {
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, method.Location, "`{0}': interface members cannot have a definition",
					method.GetSignatureForError ());
			}
		}

		current_local_parameters = null;

		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_158()
#line 1379 "cs-parser.jay"
{
		valid_param_mod = 0;
		MemberName name = (MemberName) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-5+yyTop], (Modifiers) yyVals[-6+yyTop],
				     name, current_local_parameters, (Attributes) yyVals[-7+yyTop]);

		current_type.AddMember (method);

		async_block = (method.ModFlags & Modifiers.ASYNC) != 0;

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = method;

		lexer.ConstraintsParsing = true;
	  }

void case_159()
#line 1400 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null) {
			var method = (Method) yyVals[-1+yyTop];
			method.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);
		}

		yyVal = yyVals[-1+yyTop];
	  }

void case_161()
#line 1419 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
	  	valid_param_mod = ParameterModifierType.All;
	  }

void case_163()
#line 1428 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;

		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		var modifiers = (Modifiers) yyVals[-10+yyTop];
		modifiers |= Modifiers.PARTIAL;

		var method = Method.Create (current_type, new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-8+yyTop])),
				     modifiers, name, current_local_parameters, (Attributes) yyVals[-11+yyTop]);

		current_type.AddMember (method);

		async_block = (method.ModFlags & Modifiers.ASYNC) != 0;

		if (yyVals[0+yyTop] != null)
			method.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[-9+yyTop]));
		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_164()
#line 1459 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-3+yyTop];
		report.Error (1585, name.Location, 
			"Member modifier `{0}' must precede the member type and name", ModifiersExtensions.Name ((Modifiers) yyVals[-4+yyTop]));

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-5+yyTop],
					    0, name, (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);

		current_type.AddMember (method);

		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_165()
#line 1480 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.Undefined;

		MemberName name = (MemberName) yyVals[-1+yyTop];
		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-3+yyTop],
									name, current_local_parameters, (Attributes) yyVals[-4+yyTop]);

		current_type.AddMember (method);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_170()
#line 1509 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6) {
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "expression bodied members");
		}

		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	 }

void case_171()
#line 1518 "cs-parser.jay"
{
		lexer.parsing_block = 0;
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		var b = end_block (GetLocation (yyVals[0+yyTop]));
		b.IsCompilerGenerated = true;
		yyVal = b;
	 }

void case_174()
#line 1534 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
	  	yyVal = new ParametersCompiled (pars_list.ToArray ());
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_175()
#line 1540 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray ()); 
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_176()
#line 1549 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[0+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_177()
#line 1558 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[-2+yyTop] } );			
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_178()
#line 1566 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_179()
#line 1579 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[-2+yyTop])) }, true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_180()
#line 1586 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_183()
#line 1606 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_184()
#line 1614 "cs-parser.jay"
{
		parameters_bucket.Clear ();
		Parameter p = (Parameter) yyVals[0+yyTop];
		parameters_bucket.Add (p);
		parameterListCommas.Clear ();
		default_parameter_used = p.HasDefaultValue;
		yyVal = parameters_bucket;
	  }

void case_185()
#line 1623 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter) yyVals[0+yyTop];
		if (p != null) {
			if (p.HasExtensionMethodModifier)
				report.Error (1100, p.Location, "The parameter modifier `this' can only be used on the first parameter");
			else if (!p.HasDefaultValue && default_parameter_used)
				report.Error (1737, p.Location, "Optional parameter cannot precede required parameters");

			default_parameter_used |= p.HasDefaultValue;
			pars.Add (p);
			
			parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		}
		
		yyVal = yyVals[-2+yyTop];
	  }

void case_186()
#line 1647 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_187()
#line 1656 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		report.Error (1552, lt.Location, "Array type specifier, [], must appear before parameter name");
		yyVal = new Parameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Parameter.Modifier) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_188()
#line 1663 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter (null, null, Parameter.Modifier.NONE, (Attributes) yyVals[-1+yyTop], l);
	  }

void case_189()
#line 1672 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], l);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_191()
#line 1687 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		if (lang_version <= LanguageVersion.V_3) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "optional parameter");
		}
		
		Parameter.Modifier mod = (Parameter.Modifier) yyVals[-5+yyTop];
		if (mod != Parameter.Modifier.NONE) {
			switch (mod) {
			case Parameter.Modifier.REF:
			case Parameter.Modifier.OUT:
				report.Error (1741, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
				
			case Parameter.Modifier.This:
				report.Error (1743, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
			default:
				throw new NotImplementedException (mod.ToString ());
			}
				
			mod = Parameter.Modifier.NONE;
		}
		
		if ((valid_param_mod & ParameterModifierType.DefaultValue) == 0)
			report.Error (1065, GetLocation (yyVals[-2+yyTop]), "Optional parameter is not valid in this context");
		
		var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-4+yyTop], lt.Value, mod, (Attributes) yyVals[-6+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation, GetLocation (yyVals[-2+yyTop])); /* parameterModifierLocation should be ignored when mod == NONE*/
		
		if (yyVals[0+yyTop] != null)
			((Parameter) yyVal).DefaultValue = new DefaultParameterValueExpression ((Expression) yyVals[0+yyTop]);
	  }

void case_195()
#line 1736 "cs-parser.jay"
{
		Parameter.Modifier p2 = (Parameter.Modifier)yyVals[0+yyTop];
  		Parameter.Modifier mod = (Parameter.Modifier)yyVals[-1+yyTop] | p2;
  		if (((Parameter.Modifier)yyVals[-1+yyTop] & p2) == p2) {
  			Error_DuplicateParameterModifier (lexer.Location, p2);
  		} else {
	  		switch (mod & ~Parameter.Modifier.This) {
  				case Parameter.Modifier.REF:
					report.Error (1101, lexer.Location, "The parameter modifiers `this' and `ref' cannot be used altogether");
  					break;
   				case Parameter.Modifier.OUT:
					report.Error (1102, lexer.Location, "The parameter modifiers `this' and `out' cannot be used altogether");
  					break;
  				default:
 					report.Error (1108, lexer.Location, "A parameter cannot have specified more than one modifier");
 					break;
 			}
  		}
  		yyVal = mod;
	  }

void case_196()
#line 1760 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Ref) == 0)
	  		Error_ParameterModifierNotValid ("ref", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.REF;
	  }

void case_197()
#line 1767 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Out) == 0)
	  		Error_ParameterModifierNotValid ("out", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.OUT;
	  }

void case_198()
#line 1774 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.This) == 0)
	  		Error_ParameterModifierNotValid ("this", GetLocation (yyVals[0+yyTop]));

	  	if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "extension methods");
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = Parameter.Modifier.This;
	  }

void case_199()
#line 1787 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_200()
#line 1793 "cs-parser.jay"
{
		report.Error (1751, GetLocation (yyVals[-4+yyTop]), "Cannot specify a default value for a parameter array");
		
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Attributes) yyVals[-5+yyTop], lt.Location);		
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_201()
#line 1801 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Attributes) yyVals[-3+yyTop], Location.Null);
	  }

void case_202()
#line 1810 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.Params) == 0)
			report.Error (1670, (GetLocation (yyVals[0+yyTop])), "The `params' modifier is not allowed in current context");
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_203()
#line 1816 "cs-parser.jay"
{
		Parameter.Modifier mod = (Parameter.Modifier)yyVals[0+yyTop];
		if ((mod & Parameter.Modifier.This) != 0) {
			report.Error (1104, GetLocation (yyVals[-1+yyTop]), "The parameter modifiers `this' and `params' cannot be used altogether");
		} else {
			report.Error (1611, GetLocation (yyVals[-1+yyTop]), "The params parameter cannot be declared as ref or out");
		}	  
		savedLocation = GetLocation (yyVals[-1+yyTop]);
	  }

void case_205()
#line 1833 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Arglist) == 0)
	  		report.Error (1669, GetLocation (yyVals[0+yyTop]), "__arglist is not valid in this context");
	  }

void case_206()
#line 1844 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
	  }

void case_207()
#line 1850 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		current_property = new Property (current_type, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);
			
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", current_property.GetSignatureForError ());					
			
		current_type.AddMember (current_property);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		
		lexer.PropertyParsing = true;
	  }

void case_208()
#line 1864 "cs-parser.jay"
{
		lexer.PropertyParsing = false;
		
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();				
	  }

void case_209()
#line 1871 "cs-parser.jay"
{
		lbag.AppendToMember (current_property, GetLocation (yyVals[0+yyTop]));
		lexer.parsing_modifiers = true;
	  }

void case_211()
#line 1883 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_212()
#line 1890 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		var property = new Property (current_type, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);

		property.Get = new Property.GetMethod (property, Modifiers.COMPILER_GENERATED, null, property.Location);
		property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];

		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, property.Get.Block.StartLocation,
				"`{0}': interface members cannot have a definition", property.GetSignatureForError ());
		}

		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", property.GetSignatureForError ());

		current_type.AddMember (property);

		current_local_parameters = null;
	  }

void case_214()
#line 1915 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_215()
#line 1921 "cs-parser.jay"
{
		--lexer.parsing_block;
		((Property)current_property).Initializer = (Expression) yyVals[-1+yyTop];
		lbag.AppendToMember (current_property, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		end_block (GetLocation (yyVals[0+yyTop]));
		current_local_parameters = null;
	  }

void case_219()
#line 1942 "cs-parser.jay"
{
		valid_param_mod = 0;
		var type = (FullNamedExpression) yyVals[-5+yyTop];
		Indexer indexer = new Indexer (current_type, type, (MemberName) yyVals[-4+yyTop], (Modifiers) yyVals[-6+yyTop], (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);
			
		current_property = indexer;

  		current_type.AddIndexer (indexer);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
  		
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (620, GetLocation (yyVals[-5+yyTop]), "`{0}': indexer return type cannot be `void'", indexer.GetSignatureForError ());  		

		if (indexer.ParameterInfo.IsEmpty) {
			report.Error (1551, GetLocation (yyVals[-3+yyTop]), "Indexers must have at least one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		lexer.PropertyParsing = true;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];
	  }

void case_220()
#line 1968 "cs-parser.jay"
{
 		lexer.PropertyParsing = false;
		current_local_parameters = null;

		if (current_property.AccessorFirst != null && current_property.AccessorFirst.Block == null)
			((Indexer) current_property).ParameterInfo.CheckParameters (current_property);
	  
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();
			
		current_property = null;		
	  }

void case_222()
#line 1988 "cs-parser.jay"
{
		current_property.Get = new Indexer.GetIndexerMethod (current_property, Modifiers.COMPILER_GENERATED, current_local_parameters, null, current_property.Location);
		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];
	  }

void case_227()
#line 2000 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_BRACE) {
	  		report.Error (548, lexer.Location, "`{0}': property or indexer must have at least one accessor", current_property.GetSignatureForError ());
		} else {
			if (yyToken == Token.SEMICOLON)
				report.Error (1597, lexer.Location, "Semicolon after method or accessor block is not valid");
			else
				report.Error (1014, GetLocation (yyVals[0+yyTop]), "A get or set accessor expected");
		}
	  }

void case_228()
#line 2014 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
	  
		if (current_property.Get != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
		
		if (current_property is Indexer) {
			current_property.Get = new Indexer.GetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop], ((Indexer)current_property).ParameterInfo.Clone (),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Get = new Property.GetMethod (current_property,
				(Modifiers) yyVals[-1+yyTop], (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}	
	  
		current_local_parameters = current_property.Get.ParameterInfo;	  
		lexer.PropertyParsing = false;
	  }

void case_229()
#line 2035 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
	  		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];			
	  	
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Get.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Get.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Get, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Get, GetModifierLocations (), savedLocation);
		}
	  
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support)
			if (Lexer.doc_state == XmlCommentState.Error)
				Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_230()
#line 2059 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
		
		if (current_property.Set != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
	  
		if (current_property is Indexer) {
			current_property.Set = new Indexer.SetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop],
				ParametersCompiled.MergeGenerated (compiler,
				((Indexer)current_property).ParameterInfo, true, new Parameter (
					current_property.TypeExpression, "value", Parameter.Modifier.NONE, null, GetLocation (yyVals[0+yyTop])),
					null),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Set = new Property.SetMethod (current_property, (Modifiers) yyVals[-1+yyTop], 
				ParametersCompiled.CreateImplicitParameter (current_property.TypeExpression, GetLocation (yyVals[0+yyTop])),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}
		
		current_local_parameters = current_property.Set.ParameterInfo;	
		lexer.PropertyParsing = false;
	  }

void case_231()
#line 2085 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {		
			current_property.Set.Block = (ToplevelBlock) yyVals[0+yyTop];
		
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Set.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Set.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Set, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Set, GetModifierLocations (), savedLocation);
		}
		
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support
			&& Lexer.doc_state == XmlCommentState.Error)
			Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_233()
#line 2110 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = null;
	  }

void case_234()
#line 2115 "cs-parser.jay"
{
	  	Error_SyntaxError (1043, yyToken, "Invalid accessor body");
	  	yyVal = null;
	  }

void case_236()
#line 2129 "cs-parser.jay"
{
		lexer.ConstraintsParsing = true;
		push_current_container (new Interface (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));		
	  }

void case_237()
#line 2136 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_238()
#line 2150 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_239()
#line 2156 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_243()
#line 2177 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
		lexer.parsing_block = 0;
	  }

void case_244()
#line 2182 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
		lexer.parsing_block = 0;
	  }

void case_255()
#line 2220 "cs-parser.jay"
{
		OperatorDeclaration decl = (OperatorDeclaration) yyVals[-2+yyTop];
		if (decl != null) {
			Operator op = new Operator (
				current_type, decl.optype, decl.ret_type, (Modifiers) yyVals[-3+yyTop], 
				current_local_parameters,
				(ToplevelBlock) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop], decl.location);
				
			if (op.Block == null)
				op.ParameterInfo.CheckParameters (op);

			if (doc_support) {
				op.DocComment = tmpComment;
				Lexer.doc_state = XmlCommentState.Allowed;
			}

			/* Note again, checking is done in semantic analysis*/
			current_type.AddOperator (op);

			lbag.AddMember (op, GetModifierLocations (), lbag.GetLocations (decl));
			if (yyVals[0+yyTop] == null) { /* Semicolon*/
				lbag.AddLocation (op, savedLocation); 
			}
		}
		
		current_local_parameters = null;
	  }

void case_257()
#line 2252 "cs-parser.jay"
{
		report.Error (590, GetLocation (yyVals[0+yyTop]), "User-defined operators cannot return void");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_258()
#line 2260 "cs-parser.jay"
{
		valid_param_mod = ParameterModifierType.DefaultValue;
		if ((Operator.OpType) yyVals[-1+yyTop] == Operator.OpType.Is)
			valid_param_mod |= ParameterModifierType.Out;
	  }

void case_259()
#line 2266 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		Operator.OpType op = (Operator.OpType) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];
		
		int p_count = current_local_parameters.Count;
		if (p_count == 1) {
			if (op == Operator.OpType.Addition)
				op = Operator.OpType.UnaryPlus;
			else if (op == Operator.OpType.Subtraction)
				op = Operator.OpType.UnaryNegation;
		}
		
		if (IsUnaryOperator (op)) {
			if (p_count == 2) {
				report.Error (1020, loc, "Overloadable binary operator expected");
			} else if (p_count != 1) {
				report.Error (1535, loc, "Overloaded unary operator `{0}' takes one parameter",
					Operator.GetName (op));
			}
		} else if (op == Operator.OpType.Is) {
			/* TODO: Special checks for is operator*/
		} else {
			if (p_count == 1) {
				report.Error (1019, loc, "Overloadable unary operator expected");
			} else if (p_count != 2) {
				report.Error (1534, loc, "Overloaded binary operator `{0}' takes two parameters",
					Operator.GetName (op));
			}
		}
		
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (op, (FullNamedExpression) yyVals[-6+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), savedOperatorLocation, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_283()
#line 2337 "cs-parser.jay"
{
		if (lang_version != LanguageVersion.Experimental)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "is user operator");
		savedOperatorLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = Operator.OpType.Is;
	  }

void case_285()
#line 2351 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  

		if (current_local_parameters.Count != 1) {
			report.Error (1535, loc, "Overloaded unary operator `implicit' takes one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_287()
#line 2374 "cs-parser.jay"
{
		valid_param_mod = 0;
		
		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  

		if (current_local_parameters.Count != 1) {
			report.Error (1535, loc, "Overloaded unary operator `explicit' takes one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Explicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_288()
#line 2393 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_289()
#line 2399 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	yyVal = new OperatorDeclaration (Operator.OpType.Explicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_290()
#line 2409 "cs-parser.jay"
{ 
		Constructor c = (Constructor) yyVals[-1+yyTop];
		c.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (doc_support)
			c.DocComment = ConsumeStoredComment ();

		current_local_parameters = null;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_291()
#line 2426 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		valid_param_mod = ParameterModifierType.All;
	  }

void case_292()
#line 2435 "cs-parser.jay"
{
		valid_param_mod = 0;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];
		
		var lt = (LocatedToken) yyVals[-4+yyTop];
		var mods = (Modifiers) yyVals[-5+yyTop];
		var c = new Constructor (current_type, lt.Value, mods, (Attributes) yyVals[-6+yyTop], current_local_parameters, lt.Location);

		if (lt.Value != current_container.MemberName.Name) {
			report.Error (1520, c.Location, "Class, struct, or interface method must have a return type");
		} else if ((mods & Modifiers.STATIC) != 0) {
			if (!current_local_parameters.IsEmpty) {
				report.Error (132, c.Location, "`{0}': The static constructor must be parameterless",
					c.GetSignatureForError ());
			}

			if ((mods & Modifiers.AccessibilityMask) != 0){
				report.Error (515, c.Location,
					"`{0}': static constructor cannot have an access modifier",
					c.GetSignatureForError ());
			}
		} else {
			if (current_type.Kind == MemberKind.Struct && current_local_parameters.IsEmpty) {
				if (lang_version < LanguageVersion.V_6)
					FeatureIsNotAvailable (GetLocation (yyVals[-4+yyTop]), "struct parameterless instance constructor");

				if ((mods & Modifiers.PUBLIC) == 0) {
					report.Error (8075, c.Location, "`{0}': Structs parameterless instance constructor must be public", c.GetSignatureForError ());
				}
			}
		}

		current_type.AddConstructor (c);
		lbag.AddMember (c, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;

		/**/
		/* start block here, so possible anonymous methods inside*/
		/* constructor initializer can get correct parent block*/
		/**/
	  	start_block (lexer.Location);
	  }

void case_293()
#line 2478 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			var c = (Constructor) yyVals[-1+yyTop];
			c.Initializer = (ConstructorInitializer) yyVals[0+yyTop];
			
			if (c.IsStatic) {
				report.Error (514, c.Location,
					"`{0}': static constructor cannot have an explicit `this' or `base' constructor call",
					c.GetSignatureForError ());
			}
		}

		yyVal = yyVals[-1+yyTop];
	  }

void case_299()
#line 2510 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorBaseInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_301()
#line 2520 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorThisInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_302()
#line 2526 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
		yyVal = new ConstructorThisInitializer (null, GetLocation (yyVals[0+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_303()
#line 2532 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_304()
#line 2540 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
		
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_305()
#line 2549 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		if (lt.Value != current_container.MemberName.Name){
			report.Error (574, lt.Location, "Name of destructor must match name of class");
		} else if (current_container.Kind != MemberKind.Class){
			report.Error (575, lt.Location, "Only class types can contain destructor");
		}
		
		Destructor d = new Destructor (current_type, (Modifiers) yyVals[-6+yyTop],
			ParametersCompiled.EmptyReadOnlyParameters, (Attributes) yyVals[-7+yyTop], lt.Location);
		d.Identifier = lt.Value;
		if (doc_support)
			d.DocComment = ConsumeStoredComment ();
		  
		d.Block = (ToplevelBlock) yyVals[0+yyTop];
		current_type.AddMember (d);
		lbag.AddMember (d, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));

		current_local_parameters = null;
	  }

void case_306()
#line 2575 "cs-parser.jay"
{
		current_event_field = new EventField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], (MemberName) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_event_field);
		
		if (current_event_field.MemberName.ExplicitInterface != null) {
			report.Error (71, current_event_field.Location, "`{0}': An explicit interface implementation of an event must use property syntax",
			current_event_field.GetSignatureForError ());
		}
		
		yyVal = current_event_field;
	  }

void case_307()
#line 2589 "cs-parser.jay"
{
		if (doc_support) {
			current_event_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		if (current_event_field.Initializer != null) {
			lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), savedEventAssignLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		current_event_field = null;
	  }

void case_308()
#line 2605 "cs-parser.jay"
{
		current_event = new EventProperty (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-4+yyTop], (MemberName) yyVals[-1+yyTop], (Attributes) yyVals[-5+yyTop]);
		current_type.AddMember (current_event);
		lbag.AddMember (current_event, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		
		lexer.EventParsing = true;
	  }

void case_309()
#line 2613 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface)
			report.Error (69, GetLocation (yyVals[-2+yyTop]), "Event in interface cannot have add or remove accessors");
	  
		lexer.EventParsing = false;
	  }

void case_310()
#line 2620 "cs-parser.jay"
{
		if (doc_support) {
			current_event.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AppendToMember (current_event, GetLocation (yyVals[-1+yyTop]));
	  	current_event = null;	
		current_local_parameters = null;
	  }

void case_311()
#line 2633 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddMember (new EventField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], MemberName.Null, (Attributes) yyVals[-4+yyTop]));
	  }

void case_314()
#line 2647 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	savedEventAssignLocation = GetLocation (yyVals[-2+yyTop]);
		current_event_field.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_319()
#line 2672 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_321()
#line 2682 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_322()
#line 2691 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (68, lexer.Location, "`{0}': event in interface cannot have an initializer",
				current_event_field.GetSignatureForError ());
		}
		
	  	if ((current_event_field.ModFlags & Modifiers.ABSTRACT) != 0) {
			report.Error (74, lexer.Location, "`{0}': abstract event cannot have an initializer",
				current_event_field.GetSignatureForError ());
	  	}		
	  }

void case_326()
#line 2712 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_327()
#line 2717 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_328()
#line 2722 "cs-parser.jay"
{ 
		report.Error (1055, GetLocation (yyVals[0+yyTop]), "An add or remove accessor expected");
		yyVal = null;
	  }

void case_329()
#line 2730 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Add = new EventProperty.AddDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Add.ParameterInfo;
		
		lbag.AddMember (current_event.Add, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_330()
#line 2742 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Add.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Add.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Add.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_331()
#line 2758 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Remove = new EventProperty.RemoveDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Remove.ParameterInfo;

		lbag.AddMember (current_event.Remove, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_332()
#line 2770 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Remove.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Remove.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Remove.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_333()
#line 2786 "cs-parser.jay"
{
		report.Error (73, lexer.Location, "An add or remove accessor must have a body");
		yyVal = null;
	  }

void case_335()
#line 2795 "cs-parser.jay"
{
		current_type.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1519, GetLocation (yyVals[-1+yyTop]), "An attribute is missing member declaration");
		lexer.putback ('}');
	  }

void case_336()
#line 2806 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `}' in class, struct, or interface member declaration");
 
		lexer.putback ('}');

	  	lexer.parsing_generic_declaration = false;
		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		current_field = new Field (current_type, type, (Modifiers) yyVals[-2+yyTop], MemberName.Null, (Attributes) yyVals[-3+yyTop]);
		current_type.AddField (current_field);
		lbag.AddMember (current_field, GetModifierLocations ());
		yyVal = current_field;
	  }

void case_337()
#line 2826 "cs-parser.jay"
{
		if (doc_support)
			enumTypeComment = Lexer.consume_doc_comment ();
	  }

void case_338()
#line 2831 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;

		MemberName name = (MemberName) yyVals[-3+yyTop];
		if (name.IsGeneric) {
			report.Error (1675, name.Location, "Enums cannot have type parameters");
		}
		
		push_current_container (new Enum (current_container, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-5+yyTop], name, (Attributes) yyVals[-6+yyTop]), null);
		if (yyVals[-2+yyTop] != null) {
			lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_339()
#line 2848 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
	  
	  	/* here will be evaluated after CLOSE_BLACE is consumed.*/
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_340()
#line 2856 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[-1+yyTop]));
		if (yyVals[0+yyTop] != null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
		}
		if (doc_support)
			current_container.DocComment = enumTypeComment;
			
		--lexer.parsing_declaration;

/*			if (doc_support)*/
/*				em.DocComment = ev.DocComment;*/

		yyVal = pop_current_class ();
	  }

void case_342()
#line 2876 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		yyVal = yyVals[0+yyTop];
	 }

void case_343()
#line 2881 "cs-parser.jay"
{
	 	Error_TypeExpected (GetLocation (yyVals[-1+yyTop]));
		yyVal = null;
	 }

void case_348()
#line 2899 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = yyVals[0+yyTop];
	  }

void case_349()
#line 2907 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-1+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_350()
#line 2920 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
	  }

void case_351()
#line 2928 "cs-parser.jay"
{ 
		--lexer.parsing_block;
		
		var lt = (LocatedToken) yyVals[-3+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
	  	em.Initializer = new ConstInitializer (em, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	((Enum) current_type).AddEnumMember (em);
		
		if (doc_support)
			em.DocComment = ConsumeStoredComment ();

		yyVal = em;
	  }

void case_352()
#line 2942 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (LocatedToken) yyVals[-1+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-2+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_355()
#line 2969 "cs-parser.jay"
{
		valid_param_mod = 0;

		ParametersCompiled p = (ParametersCompiled) yyVals[-1+yyTop];

		Delegate del = new Delegate (current_container, (FullNamedExpression) yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (MemberName) yyVals[-4+yyTop], p, (Attributes) yyVals[-8+yyTop]);

		p.CheckParameters (del);

		current_container.AddTypeContainer (del);

		current_delegate = del;
		lexer.ConstraintsParsing = true;
	  }

void case_357()
#line 2988 "cs-parser.jay"
{
		if (doc_support) {
			current_delegate.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  
		if (yyVals[-2+yyTop] != null)
			current_delegate.SetConstraints ((List<Constraints>) yyVals[-2+yyTop]);
		lbag.AddMember (current_delegate, GetModifierLocations (), GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));

		yyVal = current_delegate;

		current_delegate = null;
	  }

void case_359()
#line 3007 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "nullable types");
	  
	  	yyVal = ComposedTypeSpecifier.CreateNullable (GetLocation (yyVals[0+yyTop]));
	  }

void case_361()
#line 3018 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, savedLocation, GetLocation (yyVals[-1+yyTop]));
	  }

void case_362()
#line 3026 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_364()
#line 3038 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_365()
#line 3044 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_366()
#line 3053 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);
	  }

void case_367()
#line 3058 "cs-parser.jay"
{  
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (int) yyVals[0+yyTop], lt.Location);
	  }

void case_369()
#line 3070 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[0+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	
		yyVal = yyVals[-1+yyTop];;
	  }

void case_370()
#line 3081 "cs-parser.jay"
{
		Error_TypeExpected (lexer.Location);
		yyVal = new TypeArguments ();
	  }

void case_371()
#line 3089 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Push (new List<Location> ());
	  }

void case_372()
#line 3096 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_374()
#line 3113 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters)yyVals[0+yyTop], lt.Location);
	  }

void case_375()
#line 3122 "cs-parser.jay"
{
	  	MemberName mn = (MemberName)yyVals[0+yyTop];
	  	if (mn.TypeParameters != null)
	  		syntax_error (mn.Location, string.Format ("Member `{0}' cannot declare type arguments",
	  			mn.GetSignatureForError ()));
	  }

void case_377()
#line 3133 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters) yyVals[0+yyTop], (ATypeNameExpression) yyVals[-2+yyTop], lt.Location);
	  }

void case_378()
#line 3142 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, GetLocation (yyVals[0+yyTop]));
	  }

void case_379()
#line 3147 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, null, (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_380()
#line 3155 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_381()
#line 3161 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-3+yyTop];
		var lt2 = (LocatedToken) yyVals[-2+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[-1+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, savedLocation, GetLocation (yyVals[0+yyTop]));
	  }

void case_382()
#line 3169 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberAccess ((ATypeNameExpression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_384()
#line 3179 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
	  
		yyVal = yyVals[-1+yyTop];
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	  }

void case_385()
#line 3193 "cs-parser.jay"
{
		var tparams = new TypeParameters ();
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		locationListStack.Push (new List<Location> ());
	  }

void case_386()
#line 3200 "cs-parser.jay"
{
		var tparams = (TypeParameters) yyVals[-2+yyTop];
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_387()
#line 3210 "cs-parser.jay"
{
		var lt = (LocatedToken)yyVals[0+yyTop];
		var variance = (VarianceDecl) yyVals[-1+yyTop];
		yyVal = new TypeParameter (new MemberName (lt.Value, lt.Location), (Attributes)yyVals[-2+yyTop], variance);
		if (variance != null)
			lbag.AddLocation (yyVal, savedLocation);
  	  }

void case_388()
#line 3218 "cs-parser.jay"
{
  	  	if (GetTokenName (yyToken) == "type")
			report.Error (81, GetLocation (yyVals[0+yyTop]), "Type parameter declaration must be an identifier not a type");
		else
			Error_SyntaxError (yyToken);
			
  	  	yyVal = new TypeParameter (MemberName.Null, null, null);
  	  }

void case_397()
#line 3262 "cs-parser.jay"
{
		report.Error (1536, GetLocation (yyVals[0+yyTop]), "Invalid parameter type `void'");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_400()
#line 3278 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			var sn = yyVals[-1+yyTop] as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		}
	  }

void case_403()
#line 3298 "cs-parser.jay"
{
		Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_404()
#line 3306 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_407()
#line 3322 "cs-parser.jay"
{
		var types = new List<FullNamedExpression> (2);
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_408()
#line 3328 "cs-parser.jay"
{
		var types = (List<FullNamedExpression>) yyVals[-2+yyTop];
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AddLocation (types, GetLocation (yyVals[-1+yyTop]));
		yyVal = types;
	  }

void case_409()
#line 3338 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast) {
			report.Error (1521, GetLocation (yyVals[0+yyTop]), "Invalid base type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
		}
		yyVal = yyVals[0+yyTop];
	  }

void case_448()
#line 3403 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
	       yyVal = new CompletionSimpleName (MemberName.MakeName (lt.Value, null), lt.Location);
	  }

void case_457()
#line 3434 "cs-parser.jay"
{
		var list = new List<Expression> ();
		list.Add ((InterpolatedStringInsert) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_458()
#line 3440 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((StringLiteral) yyVals[-1+yyTop]);
		list.Add ((InterpolatedStringInsert) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_460()
#line 3454 "cs-parser.jay"
{
		yyVal = new InterpolatedStringInsert ((Expression) yyVals[-2+yyTop]) {
			Alignment = (Expression)yyVals[0+yyTop]
		};
	  }

void case_462()
#line 3464 "cs-parser.jay"
{
		lexer.parsing_interpolation_format = false;

		yyVal = new InterpolatedStringInsert ((Expression) yyVals[-3+yyTop]) {
			Format = (string)yyVals[0+yyTop]
		};
	  }

void case_464()
#line 3476 "cs-parser.jay"
{
		lexer.parsing_interpolation_format = false;

		yyVal = new InterpolatedStringInsert ((Expression) yyVals[-5+yyTop]) {
			Alignment = (Expression)yyVals[-3+yyTop],
			Format = (string) yyVals[0+yyTop]
		};
	  }

void case_469()
#line 3509 "cs-parser.jay"
{
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_471()
#line 3521 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_472()
#line 3527 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_473()
#line 3533 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "null propagating operator");

		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new ConditionalMemberAccess ((Expression) yyVals[-4+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_474()
#line 3542 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_475()
#line 3548 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_476()
#line 3554 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new SimpleName ("await", ((LocatedToken) yyVals[-3+yyTop]).Location), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_477()
#line 3560 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, savedLocation, GetLocation (yyVals[-1+yyTop]));
	  }

void case_478()
#line 3568 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_480()
#line 3578 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
	  }

void case_482()
#line 3586 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
 	  }

void case_483()
#line 3594 "cs-parser.jay"
{
		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_484()
#line 3599 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_485()
#line 3606 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Invocation ((Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_488()
#line 3621 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] == null) {
	  		yyVal = new CollectionOrObjectInitializers (GetLocation (yyVals[-2+yyTop]));
	  	} else {
	  		yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	}
 		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_489()
#line 3630 "cs-parser.jay"
{
	  	yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_492()
#line 3646 "cs-parser.jay"
{
	  	var a = new List<Expression> ();
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_493()
#line 3652 "cs-parser.jay"
{
	  	var a = (List<Expression>)yyVals[-2+yyTop];
	  	a.Add ((Expression) yyVals[0+yyTop]);
		lbag.AddLocation (a, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = a;
	  }

void case_494()
#line 3658 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_495()
#line 3666 "cs-parser.jay"
{
	  	var lt = (LocatedToken) yyVals[-2+yyTop];
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_496()
#line 3672 "cs-parser.jay"
{
	  	var lt = (LocatedToken) Error_AwaitAsIdentifier (yyVals[-2+yyTop]);
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_498()
#line 3681 "cs-parser.jay"
{
		CompletionSimpleName csn = yyVals[-1+yyTop] as CompletionSimpleName;
		if (csn == null)
			yyVal = new CollectionElementInitializer ((Expression)yyVals[-1+yyTop]);
		else
			yyVal = new CompletionElementInitializer (csn.Prefix, csn.Location);
	  }

void case_499()
#line 3689 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null)
			yyVal = new CollectionElementInitializer (GetLocation (yyVals[-2+yyTop]));
		else {
	  		yyVal = new CollectionElementInitializer ((List<Expression>)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
		}
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_500()
#line 3699 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6)
			FeatureIsNotAvailable (GetLocation (yyVals[-4+yyTop]), "dictionary initializer");

		yyVal = new DictionaryElementInitializer ((List<Expression>)yyVals[-3+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_501()
#line 3707 "cs-parser.jay"
{
	  	report.Error (1920, GetLocation (yyVals[-1+yyTop]), "An element initializer cannot be empty");
		yyVal = new CollectionElementInitializer (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_506()
#line 3726 "cs-parser.jay"
{ 
		Arguments list = new Arguments (4);
		list.Add ((Argument) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_507()
#line 3732 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		if (list [list.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) list [list.Count - 1]);
		
		list.Add ((Argument) yyVals[0+yyTop]);
		lbag.AddLocation (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_508()
#line 3742 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		NamedArgument a = (NamedArgument) yyVals[0+yyTop];
		for (int i = 0; i < list.Count; ++i) {
			NamedArgument na = list [i] as NamedArgument;
			if (na != null && na.Name == a.Name)
				report.Error (1740, na.Location, "Named argument `{0}' specified multiple times",
					na.Name);
		}
		
		list.Add (a);
		lbag.AddLocation (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_509()
#line 3757 "cs-parser.jay"
{
	  	if (lexer.putback_char == -1)
	  		lexer.putback (')'); /* TODO: Wrong but what can I do*/
		Error_SyntaxError (yyToken);
		yyVal = yyVals[-2+yyTop];
	  }

void case_510()
#line 3764 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[-1+yyTop]), "An argument is missing");
	  	yyVal = null;
	  }

void case_515()
#line 3785 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Ref);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_517()
#line 3794 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_519()
#line 3803 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_520()
#line 3808 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist (GetLocation (yyVals[-2+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_521()
#line 3816 "cs-parser.jay"
{
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_522()
#line 3833 "cs-parser.jay"
{
		if (lang_version != LanguageVersion.Experimental)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "declaration expression");

		var lt = (LocatedToken) yyVals[0+yyTop];
		var lv = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (lv);
		yyVal = new DeclarationExpression ((FullNamedExpression) yyVals[-1+yyTop], lv);
	  }

void case_523()
#line 3843 "cs-parser.jay"
{
		if (lang_version != LanguageVersion.Experimental)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "declaration expression");

		var lt = (LocatedToken) yyVals[-2+yyTop];
		var lv = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (lv);
		yyVal = new DeclarationExpression ((FullNamedExpression) yyVals[-3+yyTop], lv) {
			Initializer = (Expression) yyVals[0+yyTop]
		};
	  }

void case_525()
#line 3862 "cs-parser.jay"
{
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_526()
#line 3867 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "null propagating operator");

		yyVal = new ElementAccess ((Expression) yyVals[-4+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop])) {
			ConditionalAccess = true
		};

		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_527()
#line 3878 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_528()
#line 3883 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_529()
#line 3891 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_530()
#line 3897 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AddLocation (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_531()
#line 3907 "cs-parser.jay"
{
		Arguments args = new Arguments (4);
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_532()
#line 3913 "cs-parser.jay"
{
		Arguments args = (Arguments) yyVals[-2+yyTop];
		if (args [args.Count - 1] is NamedArgument && !(yyVals[0+yyTop] is NamedArgument))
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
	  
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AddLocation (args, GetLocation (yyVals[-1+yyTop]));
		yyVal = args;	  
	  }

void case_536()
#line 3941 "cs-parser.jay"
{
	  	yyVal = new ElementAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_537()
#line 3946 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = new ElementAccess (null, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_540()
#line 3968 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			if (lang_version <= LanguageVersion.ISO_2)
				FeatureIsNotAvailable (GetLocation (yyVals[-5+yyTop]), "object initializers");
				
			yyVal = new NewInitialize ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		} else {
			yyVal = new New ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], GetLocation (yyVals[-5+yyTop]));
		}
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_541()
#line 3981 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "collection initializers");
	  
		yyVal = new NewInitialize ((FullNamedExpression) yyVals[-1+yyTop], null, (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_542()
#line 3993 "cs-parser.jay"
{
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], (List<Expression>) yyVals[-3+yyTop],
				new ComposedTypeSpecifier (((List<Expression>) yyVals[-3+yyTop]).Count, GetLocation (yyVals[-4+yyTop])) {
	  				Next = (ComposedTypeSpecifier) yyVals[-1+yyTop]
			  	}, (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_543()
#line 4001 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] == null)
	  		report.Error (1586, GetLocation (yyVals[-3+yyTop]), "Array creation must have array size or array initializer");

		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-2+yyTop], (ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_544()
#line 4008 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "implicitly typed arrays");
	  
		yyVal = new ImplicitlyTypedArrayCreation ((ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_545()
#line 4015 "cs-parser.jay"
{
		report.Error (178, GetLocation (yyVals[-1+yyTop]), "Invalid rank specifier, expecting `,' or `]'");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], null, GetLocation (yyVals[-6+yyTop]));
	  }

void case_546()
#line 4020 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		/* It can be any of new expression, create the most common one*/
		yyVal = new New ((FullNamedExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_548()
#line 4032 "cs-parser.jay"
{
		--lexer.parsing_type;
		yyVal = yyVals[0+yyTop];
	  }

void case_549()
#line 4040 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "anonymous types");

		yyVal = new NewAnonymousType ((List<AnonymousTypeParameter>) yyVals[-1+yyTop], current_container, GetLocation (yyVals[-3+yyTop]));
		
		/* TODO: lbag comma location*/
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_555()
#line 4067 "cs-parser.jay"
{
	  	var a = new List<AnonymousTypeParameter> (4);
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_556()
#line 4073 "cs-parser.jay"
{
	  	var a = (List<AnonymousTypeParameter>) yyVals[-2+yyTop];
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	lbag.AddLocation (a, GetLocation (yyVals[-1+yyTop]));

	  	yyVal = a;
	  }

void case_559()
#line 4092 "cs-parser.jay"
{
		var lt = (LocatedToken)yyVals[-2+yyTop];
	  	yyVal = new AnonymousTypeParameter ((Expression)yyVals[0+yyTop], lt.Value, lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_560()
#line 4098 "cs-parser.jay"
{
		var lt = (LocatedToken)yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (new SimpleName (lt.Value, lt.Location),
	  		lt.Value, lt.Location);
	  }

void case_561()
#line 4104 "cs-parser.jay"
{
	  	MemberAccess ma = (MemberAccess) yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (ma, ma.Name, ma.Location);
	  }

void case_562()
#line 4109 "cs-parser.jay"
{
		report.Error (746, lexer.Location,
			"Invalid anonymous type member declarator. Anonymous type members must be a member assignment, simple name or member access expression");
		yyVal = null;
	  }

void case_566()
#line 4124 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_567()
#line 4132 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension (1, GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_568()
#line 4137 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension ((int)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_573()
#line 4167 "cs-parser.jay"
{
		var ai = new ArrayInitializer (0, GetLocation (yyVals[-1+yyTop]));
		ai.VariableDeclaration = current_variable;
		lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		yyVal = ai;
	  }

void case_574()
#line 4174 "cs-parser.jay"
{
		var ai = new ArrayInitializer ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
		ai.VariableDeclaration = current_variable;
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (ai, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		}
		yyVal = ai;
	  }

void case_575()
#line 4188 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_576()
#line 4194 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AddLocation (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_577()
#line 4204 "cs-parser.jay"
{
		yyVal = new TypeOf ((FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_579()
#line 4213 "cs-parser.jay"
{
	 	Error_TypeExpected (lexer.Location);
	 	yyVal = null;
	 }

void case_580()
#line 4221 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "generics");

		yyVal = yyVals[0+yyTop];
	  }

void case_581()
#line 4231 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (lt.Location, "namespace alias qualifier");
		savedLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = lt;		
	  }

void case_582()
#line 4242 "cs-parser.jay"
{ 
		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_583()
#line 4247 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_584()
#line 4257 "cs-parser.jay"
{
		yyVal = new CheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_585()
#line 4262 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new CheckedExpr (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_586()
#line 4271 "cs-parser.jay"
{
		yyVal = new UnCheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_587()
#line 4276 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnCheckedExpr (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_588()
#line 4285 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new Indirection ((Expression) yyVals[-3+yyTop], GetLocation (yyVals[-2+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_590()
#line 4297 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), PopLocation (), PopLocation ());
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_592()
#line 4310 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), PopLocation (), PopLocation ());
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_596()
#line 4335 "cs-parser.jay"
{
		valid_param_mod = 0;
	  	yyVal = yyVals[-1+yyTop];
	  	PushLocation (GetLocation (yyVals[-1+yyTop]));
	  	PushLocation (GetLocation (yyVals[-3+yyTop]));
	  }

void case_597()
#line 4345 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "default value expression");

		yyVal = new DefaultValueExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_601()
#line 4365 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_602()
#line 4370 "cs-parser.jay"
{
		if (!async_block) {
			 if (current_anonymous_method is LambdaExpression) {
				report.Error (4034, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing lambda expression is marked with the `async' modifier");
			} else if (current_anonymous_method != null) {
				report.Error (4035, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing anonymous method is marked with the `async' modifier");
			} else if (interactive_async != null) {
				current_block.Explicit.RegisterAsyncAwait ();
				interactive_async = true;
			} else {
				report.Error (4033, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing method is marked with the `async' modifier");
			}
		} else {
			current_block.Explicit.RegisterAsyncAwait ();
		}
		
		yyVal = new Await ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_603()
#line 4392 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.LogicalNot, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_604()
#line 4398 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.OnesComplement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_605()
#line 4404 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_606()
#line 4411 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Await (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_614()
#line 4449 "cs-parser.jay"
{ 
		Error_SyntaxError (yyToken);

	  	yyVal = new Unary (Unary.Operator.UnaryPlus, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_615()
#line 4455 "cs-parser.jay"
{ 
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.UnaryNegation, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_616()
#line 4461 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_617()
#line 4467 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_618()
#line 4473 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Indirection (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_619()
#line 4479 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.AddressOf, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_621()
#line 4489 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_622()
#line 4494 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_623()
#line 4499 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_624()
#line 4504 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_625()
#line 4511 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_626()
#line 4518 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_628()
#line 4529 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_629()
#line 4534 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_630()
#line 4539 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_631()
#line 4546 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_633()
#line 4557 "cs-parser.jay"
{
		var is_expr = new Is ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] != null) {
			if (lang_version != LanguageVersion.Experimental)
				FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "type pattern matching");

			var lt = (LocatedToken) yyVals[0+yyTop];
			is_expr.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (is_expr.Variable);
		}

		yyVal = is_expr;
	  }

void case_634()
#line 4571 "cs-parser.jay"
{
		var is_expr = new Is ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
		if (lang_version != LanguageVersion.Experimental)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "pattern matching");

		yyVal = is_expr;
	  }

void case_635()
#line 4579 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new As ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_636()
#line 4585 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Is ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_637()
#line 4591 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new Is (new SimpleName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_638()
#line 4596 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new As (new SimpleName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_645()
#line 4619 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_651()
#line 4647 "cs-parser.jay"
{
		var list = new List<PropertyPatternMember> ();
		list.Add ((PropertyPatternMember) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_652()
#line 4653 "cs-parser.jay"
{
		var list = (List<PropertyPatternMember>) yyVals[-2+yyTop];
		list.Add ((PropertyPatternMember) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_653()
#line 4662 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new PropertyPatternMember (lt.Value, (Expression) yyVals[0+yyTop], lt.Location);
	  }

void case_655()
#line 4671 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
			var lt = (LocatedToken) yyVals[0+yyTop];
			var variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (variable);
		}
	  }

void case_658()
#line 4690 "cs-parser.jay"
{
		Arguments args = new Arguments (4);
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_659()
#line 4696 "cs-parser.jay"
{
		Arguments args = (Arguments) yyVals[-2+yyTop];
		if (args [args.Count - 1] is NamedArgument && !(yyVals[0+yyTop] is NamedArgument))
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);

		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_661()
#line 4712 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop]);
	  }

void case_663()
#line 4721 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_664()
#line 4726 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_665()
#line 4731 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_666()
#line 4738 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_668()
#line 4749 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThan, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_669()
#line 4754 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThan, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_670()
#line 4759 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThanOrEqual, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_671()
#line 4764 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_672()
#line 4769 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LessThan, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_673()
#line 4776 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.GreaterThan, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_674()
#line 4783 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LessThanOrEqual, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_675()
#line 4790 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_677()
#line 4801 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Equality, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_678()
#line 4806 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Inequality, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_679()
#line 4811 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Equality, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_680()
#line 4818 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Inequality, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_682()
#line 4829 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_683()
#line 4834 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_685()
#line 4845 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_686()
#line 4850 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_688()
#line 4861 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_689()
#line 4866 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_691()
#line 4877 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_692()
#line 4882 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LogicalAnd, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_694()
#line 4893 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_695()
#line 4898 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LogicalOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_697()
#line 4909 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "null coalescing operator");
			
		yyVal = new Nullable.NullCoalescingOperator ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_699()
#line 4921 "cs-parser.jay"
{
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_700()
#line 4926 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-3+yyTop]), (Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_701()
#line 4932 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_702()
#line 4939 "cs-parser.jay"
{
		Error_SyntaxError (Token.CLOSE_BRACE);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
		lexer.putback ('}');
	  }

void case_703()
#line 4950 "cs-parser.jay"
{
		yyVal = new SimpleAssign ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_704()
#line 4955 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_705()
#line 4960 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_706()
#line 4965 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_707()
#line 4970 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_708()
#line 4975 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_709()
#line 4980 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_710()
#line 4985 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_711()
#line 4990 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_712()
#line 4995 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_713()
#line 5000 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_714()
#line 5008 "cs-parser.jay"
{
		var pars = new List<Parameter> (4);
		pars.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Clear ();
		yyVal = pars;
	  }

void case_715()
#line 5015 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter)yyVals[0+yyTop];
		if (pars[0].GetType () != p.GetType ()) {
			report.Error (748, p.Location, "All lambda parameters must be typed either explicitly or implicitly");
		}
		
		pars.Add (p);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = pars;
	  }

void case_716()
#line 5031 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], null, lt.Location);
	  }

void case_717()
#line 5037 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, Parameter.Modifier.NONE, null, lt.Location);
	  }

void case_718()
#line 5043 "cs-parser.jay"
{
	  	var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_719()
#line 5048 "cs-parser.jay"
{
	  	var lt = (LocatedToken) Error_AwaitAsIdentifier (yyVals[0+yyTop]);
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_721()
#line 5056 "cs-parser.jay"
{ 
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
		yyVal = new ParametersCompiled (pars_list.ToArray ());
		lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_723()
#line 5068 "cs-parser.jay"
{
		Block b = end_block (Location.Null);
		b.IsCompilerGenerated = true;
		b.AddStatement (new ContextualReturn ((Expression) yyVals[0+yyTop]));
		yyVal = b;
	  }

void case_725()
#line 5076 "cs-parser.jay"
{
	  	/* Handles only cases like foo = x.FirstOrDefault (l => );*/
	  	/* where we must restore current_variable*/
		Block b = end_block (Location.Null);
		b.IsCompilerGenerated = true;

		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_727()
#line 5090 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_728()
#line 5098 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];	
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), false, lt.Location);
	  }

void case_729()
#line 5104 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_730()
#line 5109 "cs-parser.jay"
{
		var lt = (LocatedToken) Error_AwaitAsIdentifier (yyVals[-1+yyTop]);
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), false, lt.Location);
	  }

void case_731()
#line 5115 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_732()
#line 5120 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), true, lt.Location);
	  }

void case_733()
#line 5126 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_735()
#line 5135 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], false, GetLocation (yyVals[-4+yyTop]));
	  }

void case_736()
#line 5140 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_738()
#line 5149 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], true, GetLocation (yyVals[-5+yyTop]));
	  }

void case_739()
#line 5154 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_746()
#line 5177 "cs-parser.jay"
{
		yyVal = new RefValueExpr ((Expression) yyVals[-3+yyTop], (FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_747()
#line 5182 "cs-parser.jay"
{
		yyVal = new RefTypeExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_748()
#line 5187 "cs-parser.jay"
{
		yyVal = new MakeRefExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));	  
	  }

void case_753()
#line 5214 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];

		/* Cannot use opt_formal_parameter_list because it can be shared instance for empty parameters*/
	  	lbag.AppendToMember (current_container, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));

		if (lang_version != LanguageVersion.Experimental)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "primary constructor");
	  }

void case_758()
#line 5243 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_type.PrimaryConstructorBaseArgumentsStart = GetLocation (yyVals[0+yyTop]);
	  }

void case_759()
#line 5248 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
		current_type.PrimaryConstructorBaseArguments = (Arguments) yyVals[-1+yyTop];
		--lexer.parsing_block;

		yyVal = yyVals[-5+yyTop];
	  }

void case_761()
#line 5268 "cs-parser.jay"
{
		lexer.ConstraintsParsing = true;

		Class c = new Class (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]);
		if (((c.ModFlags & Modifiers.STATIC) != 0) && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (c.Location, "static classes");
		}
			
		push_current_container (c, yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
		valid_param_mod = ParameterModifierType.PrimaryConstructor;
	  }

void case_762()
#line 5282 "cs-parser.jay"
{
		valid_param_mod = 0;
		lexer.ConstraintsParsing = false;

		if (yyVals[-1+yyTop] != null)
			current_type.PrimaryConstructorParameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_763()
#line 5300 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_764()
#line 5306 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_767()
#line 5325 "cs-parser.jay"
{
	    mod_locations = null;
		yyVal = ModifierNone;
		lexer.parsing_modifiers = false;
	  }

void case_770()
#line 5339 "cs-parser.jay"
{ 
		var m1 = (Modifiers) yyVals[-1+yyTop];
		var m2 = (Modifiers) yyVals[0+yyTop];

		if ((m1 & m2) != 0) {
			report.Error (1004, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"Duplicate `{0}' modifier", ModifiersExtensions.Name (m2));
		} else if ((m2 & Modifiers.AccessibilityMask) != 0 && (m1 & Modifiers.AccessibilityMask) != 0 &&
			((m2 | m1 & Modifiers.AccessibilityMask) != (Modifiers.PROTECTED | Modifiers.INTERNAL))) {
			report.Error (107, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"More than one protection modifier specified");
		}
		
		yyVal = m1 | m2;
	  }

void case_771()
#line 5358 "cs-parser.jay"
{
		yyVal = Modifiers.NEW;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		
		if (current_container.Kind == MemberKind.Namespace)
			report.Error (1530, GetLocation (yyVals[0+yyTop]), "Keyword `new' is not allowed on namespace elements");
	  }

void case_772()
#line 5366 "cs-parser.jay"
{
		yyVal = Modifiers.PUBLIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_773()
#line 5371 "cs-parser.jay"
{
		yyVal = Modifiers.PROTECTED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_774()
#line 5376 "cs-parser.jay"
{
		yyVal = Modifiers.INTERNAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_775()
#line 5381 "cs-parser.jay"
{
		yyVal = Modifiers.PRIVATE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_776()
#line 5386 "cs-parser.jay"
{
		yyVal = Modifiers.ABSTRACT;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_777()
#line 5391 "cs-parser.jay"
{
		yyVal = Modifiers.SEALED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_778()
#line 5396 "cs-parser.jay"
{
		yyVal = Modifiers.STATIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_779()
#line 5401 "cs-parser.jay"
{
		yyVal = Modifiers.READONLY;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_780()
#line 5406 "cs-parser.jay"
{
		yyVal = Modifiers.VIRTUAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_781()
#line 5411 "cs-parser.jay"
{
		yyVal = Modifiers.OVERRIDE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_782()
#line 5416 "cs-parser.jay"
{
		yyVal = Modifiers.EXTERN;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_783()
#line 5421 "cs-parser.jay"
{
		yyVal = Modifiers.VOLATILE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_784()
#line 5426 "cs-parser.jay"
{
		yyVal = Modifiers.UNSAFE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_785()
#line 5433 "cs-parser.jay"
{
		yyVal = Modifiers.ASYNC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_788()
#line 5446 "cs-parser.jay"
{
		current_type.SetBaseTypes ((List<FullNamedExpression>) yyVals[0+yyTop]);
		lbag.AppendToMember (current_type, GetLocation (yyVals[-1+yyTop]));
	 }

void case_789()
#line 5451 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.SetBaseTypes ((List<FullNamedExpression>) yyVals[-1+yyTop]);
	  }

void case_792()
#line 5468 "cs-parser.jay"
{
		var constraints = new List<Constraints> (1);
		constraints.Add ((Constraints) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_793()
#line 5474 "cs-parser.jay"
{
		var constraints = (List<Constraints>) yyVals[-1+yyTop];
		Constraints new_constraint = (Constraints)yyVals[0+yyTop];

		foreach (Constraints c in constraints) {
			if (new_constraint.TypeParameter.Value == c.TypeParameter.Value) {
				report.Error (409, new_constraint.Location,
					"A constraint clause has already been specified for type parameter `{0}'",
					new_constraint.TypeParameter.Value);
			}
		}

		constraints.Add (new_constraint);
		yyVal = constraints;
	  }

void case_794()
#line 5493 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), (List<FullNamedExpression>) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_795()
#line 5499 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_796()
#line 5509 "cs-parser.jay"
{
		var constraints = new List<FullNamedExpression> (1);
		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_797()
#line 5515 "cs-parser.jay"
{
		var constraints = (List<FullNamedExpression>) yyVals[-2+yyTop];
		var prev = constraints [constraints.Count - 1] as SpecialContraintExpr;
		if (prev != null && (prev.Constraint & SpecialConstraint.Constructor) != 0) {			
			report.Error (401, GetLocation (yyVals[-1+yyTop]), "The `new()' constraint must be the last constraint specified");
		}
		
		prev = yyVals[0+yyTop] as SpecialContraintExpr;
		if (prev != null) {
			if ((prev.Constraint & (SpecialConstraint.Class | SpecialConstraint.Struct)) != 0) {
				report.Error (449, prev.Location, "The `class' or `struct' constraint must be the first constraint specified");			
			} else {
			 	prev = constraints [0] as SpecialContraintExpr;
			 	if (prev != null && (prev.Constraint & SpecialConstraint.Struct) != 0) {			
					report.Error (451, GetLocation (yyVals[0+yyTop]), "The `new()' constraint cannot be used with the `struct' constraint");
				}
			}
		}

		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AddLocation (constraints, GetLocation (yyVals[-1+yyTop]));
		yyVal = constraints;
	  }

void case_798()
#line 5542 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast)
			report.Error (706, GetLocation (yyVals[0+yyTop]), "Invalid constraint type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
	  
	  	yyVal = yyVals[0+yyTop];
	  }

void case_799()
#line 5549 "cs-parser.jay"
{
		yyVal = new SpecialContraintExpr (SpecialConstraint.Constructor, GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_803()
#line 5569 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (lexer.Location, "generic type variance");
		
		yyVal = yyVals[0+yyTop];
	  }

void case_804()
#line 5579 "cs-parser.jay"
{
		yyVal = new VarianceDecl (Variance.Covariant, GetLocation (yyVals[0+yyTop]));
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_805()
#line 5584 "cs-parser.jay"
{
		yyVal = new VarianceDecl (Variance.Contravariant, GetLocation (yyVals[0+yyTop]));
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_806()
#line 5605 "cs-parser.jay"
{
		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_808()
#line 5617 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_809()
#line 5622 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (lexer.Location);
	  }

void case_810()
#line 5631 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_811()
#line 5636 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_812()
#line 5640 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol '}', expected '{'");
		lexer.putback ('}');
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_813()
#line 5649 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_814()
#line 5654 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_822()
#line 5682 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		var lt =(LocatedToken) yyVals[-1+yyTop];
		var sn = new SimpleName (lt.Value, lt.Location);
		current_block.AddStatement(new StatementErrorExpression (sn));
		yyVal = null;
	}

void case_823()
#line 5691 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_856()
#line 5755 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_857()
#line 5760 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_858()
#line 5765 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_859()
#line 5773 "cs-parser.jay"
{
		/* Uses lexer.Location because semicolon location is not kept in quick mode*/
		yyVal = new EmptyStatement (lexer.Location);
	  }

void case_860()
#line 5781 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		LabeledStatement labeled = new LabeledStatement (lt.Value, current_block, lt.Location);
		lbag.AddLocation (labeled, GetLocation (yyVals[0+yyTop]));
		current_block.AddLabel (labeled);
		current_block.AddStatement (labeled);
	  }

void case_863()
#line 5794 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] is VarExpr)
			yyVals[-1+yyTop] = new SimpleName ("var", ((VarExpr) yyVals[-1+yyTop]).Location);
	  
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_864()
#line 5810 "cs-parser.jay"
{ 
		/* Ok, the above "primary_expression" is there to get rid of*/
		/* both reduce/reduce and shift/reduces in the grammar, it should*/
		/* really just be "type_name".  If you use type_name, a reduce/reduce*/
		/* creeps up.  If you use namespace_or_type_name (which is all we need*/
		/* really) two shift/reduces appear.*/
		/* */

		/* So the super-trick is that primary_expression*/
		/* can only be either a SimpleName or a MemberAccess. */
		/* The MemberAccess case arises when you have a fully qualified type-name like :*/
		/* Foo.Bar.Blah i;*/
		/* SimpleName is when you have*/
		/* Blah i;*/
		
		var expr = (ATypeNameExpression) yyVals[-1+yyTop];
		if (yyVals[0+yyTop] == null) {
			if (expr.Name == "var" && expr is SimpleName)
				yyVal = new VarExpr (expr.Location);
			else
				yyVal = yyVals[-1+yyTop];
		} else {
			yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		}
	  }

void case_865()
#line 5836 "cs-parser.jay"
{
		var expr = (ATypeNameExpression) yyVals[-1+yyTop];
		yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_869()
#line 5847 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_873()
#line 5870 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariable ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_874()
#line 5877 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		if (yyVals[-2+yyTop] != null)
			lbag.AddLocation (yyVal, PopLocation (), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_875()
#line 5886 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockConstant ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_876()
#line 5893 "cs-parser.jay"
{
		if (current_variable.Initializer != null) {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = current_variable;;
		current_variable = null;
	  }

void case_878()
#line 5906 "cs-parser.jay"
{
		/* Redundant, but wont regress*/
		report.Error (1525, lexer.Location, "Unexpected symbol }");
		lexer.putback ('}');
		yyVal = yyVals[0+yyTop];
	  }

void case_880()
#line 5917 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		PushLocation (GetLocation (yyVals[-1+yyTop]));
		yyVal = current_variable;
	  }

void case_881()
#line 5923 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
		}
	  }

void case_885()
#line 5941 "cs-parser.jay"
{
		foreach (var d in current_variable.Declarators) {
			if (d.Initializer == null)
				Error_MissingInitializer (d.Variable.Location);
		}
	  }

void case_888()
#line 5956 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclarator (li, null);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-1+yyTop]));
	  }

void case_889()
#line 5965 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_891()
#line 5981 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_896()
#line 5999 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		var d = new BlockVariableDeclarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_898()
#line 6012 "cs-parser.jay"
{
		yyVal = new StackAlloc ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_899()
#line 6017 "cs-parser.jay"
{
		report.Error (1575, GetLocation (yyVals[-1+yyTop]), "A stackalloc expression requires [] after type");
		yyVal = new StackAlloc ((Expression) yyVals[0+yyTop], null, GetLocation (yyVals[-1+yyTop]));		
	  }

void case_900()
#line 6025 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_902()
#line 6031 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		report.Error (1002, GetLocation (yyVals[0+yyTop]), "; expected");
		lexer.putback ('}');
	  }

void case_905()
#line 6049 "cs-parser.jay"
{
		ExpressionStatement s = yyVals[0+yyTop] as ExpressionStatement;
		if (s == null) {
			var expr = yyVals[0+yyTop] as Expression;
			yyVal = new StatementErrorExpression (expr);
		} else {
			yyVal = new StatementExpression (s);
		}
	  }

void case_906()
#line 6062 "cs-parser.jay"
{
		Expression expr = (Expression) yyVals[0+yyTop];
		yyVal = new StatementExpression (new OptionalAssign (expr, lexer.Location));
	  }

void case_907()
#line 6067 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_910()
#line 6081 "cs-parser.jay"
{ 
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		yyVal = new If ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_911()
#line 6090 "cs-parser.jay"
{
		yyVal = new If ((BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		if (yyVals[-2+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_912()
#line 6100 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new If ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_914()
#line 6114 "cs-parser.jay"
{
		yyVal = new Switch ((Expression) yyVals[-5+yyTop], (ExplicitBlock) current_block.Explicit, GetLocation (yyVals[-7+yyTop]));	
		end_block (GetLocation (yyVals[0+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_915()
#line 6120 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Switch ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));	
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_922()
#line 6151 "cs-parser.jay"
{
	  	var label = (SwitchLabel) yyVals[0+yyTop];
	  	label.SectionStart = true;
		current_block.AddStatement (label);
	  }

void case_924()
#line 6164 "cs-parser.jay"
{
	 	yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	 	lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	 }

void case_925()
#line 6169 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_931()
#line 6200 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new While ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_932()
#line 6208 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new While ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_933()
#line 6218 "cs-parser.jay"
{
		yyVal = new Do ((Statement) yyVals[-5+yyTop], (BooleanExpression) yyVals[-2+yyTop], GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_934()
#line 6223 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Do ((Statement) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), Location.Null);
	  }

void case_935()
#line 6228 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Do ((Statement) yyVals[-4+yyTop], (BooleanExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_936()
#line 6238 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[0+yyTop]));
		current_block.IsCompilerGenerated = true;
		For f = new For (GetLocation (yyVals[-1+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, current_block.StartLocation);
		yyVal = f;
	  }

void case_938()
#line 6255 "cs-parser.jay"
{
		For f =  (For) yyVals[-2+yyTop];
		f.Initializer = (Statement) yyVals[-1+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[0+yyTop]));
		yyVal = f;
	  }

void case_940()
#line 6265 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol ')', expected ';'");
		For f =  (For) yyVals[-2+yyTop];
		f.Initializer = (Statement) yyVals[-1+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[0+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	}

void case_941()
#line 6276 "cs-parser.jay"
{
		For f =  (For) yyVals[-2+yyTop];
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[0+yyTop]));
		yyVal = f;
	  }

void case_943()
#line 6287 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol ')', expected ';'");
		For f =  (For) yyVals[-2+yyTop];
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[0+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	}

void case_944()
#line 6299 "cs-parser.jay"
{
		For f =  (For) yyVals[-3+yyTop];
		f.Iterator = (Statement) yyVals[-2+yyTop];
		
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		f.Statement = (Statement) yyVals[0+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[-1+yyTop]));

		yyVal = end_block (GetLocation (yyVals[-1+yyTop]));
	  }

void case_945()
#line 6312 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = end_block (current_block.StartLocation);
	  }

void case_948()
#line 6325 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariable ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_949()
#line 6332 "cs-parser.jay"
{
		yyVal = current_variable;
		if (yyVals[-1+yyTop] != null)
			lbag.AddLocation (current_variable, PopLocation ());

		current_variable = null;
	  }

void case_957()
#line 6359 "cs-parser.jay"
{
	  	var sl = yyVals[-2+yyTop] as StatementList;
	  	if (sl == null) {
	  		sl = new StatementList ((Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop]);
			lbag.AddStatement (sl, GetLocation (yyVals[-1+yyTop]));
	  	} else {
	  		sl.Add ((Statement) yyVals[0+yyTop]);
	  		lbag.AddLocation (sl, GetLocation (yyVals[-1+yyTop]));
	  		
	  	}
	  		
		yyVal = sl;
	  }

void case_958()
#line 6376 "cs-parser.jay"
{
		report.Error (230, GetLocation (yyVals[-3+yyTop]), "Type and identifier are both required in a foreach statement");

		start_block (GetLocation (yyVals[-2+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_959()
#line 6389 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		var lt = (LocatedToken) yyVals[-1+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_960()
#line 6406 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-5+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		yyVal = li;
	  }

void case_961()
#line 6416 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		Foreach f = new Foreach ((Expression) yyVals[-6+yyTop], (LocalVariable) yyVals[-1+yyTop], (Expression) yyVals[-3+yyTop], (Statement) yyVals[0+yyTop], current_block, GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (f, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		end_block (GetLocation (yyVals[-2+yyTop]));
		
		yyVal = f;
	  }

void case_962()
#line 6427 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = yyVals[-1+yyTop] as LocatedToken;
		var li = lt != null ? new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location) : null;
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_963()
#line 6440 "cs-parser.jay"
{
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = f;
	  }

void case_970()
#line 6460 "cs-parser.jay"
{
		yyVal = new Break (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_971()
#line 6468 "cs-parser.jay"
{
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_972()
#line 6473 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
	  }

void case_973()
#line 6481 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new Goto (lt.Value, GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_974()
#line 6487 "cs-parser.jay"
{
		yyVal = new GotoCase ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_975()
#line 6492 "cs-parser.jay"
{
		yyVal = new GotoDefault (GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_976()
#line 6500 "cs-parser.jay"
{
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_977()
#line 6505 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_978()
#line 6510 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_979()
#line 6518 "cs-parser.jay"
{
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_980()
#line 6523 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_981()
#line 6528 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Throw (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_982()
#line 6536 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_983()
#line 6552 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		var lt = (LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_984()
#line 6570 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.ParametersBlock.TopBlock.IsIterator = true;
		yyVal = new YieldBreak (lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_988()
#line 6596 "cs-parser.jay"
{
		yyVal = new TryFinally ((Statement) yyVals[-2+yyTop], (ExplicitBlock) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_989()
#line 6601 "cs-parser.jay"
{
		yyVal = new TryFinally (new TryCatch ((Block) yyVals[-3+yyTop], (List<Catch>) yyVals[-2+yyTop], GetLocation (yyVals[-4+yyTop]), true), (ExplicitBlock) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_990()
#line 6606 "cs-parser.jay"
{
		Error_SyntaxError (1524, yyToken);
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), false);
	  }

void case_991()
#line 6614 "cs-parser.jay"
{
		var l = new List<Catch> (2);

		l.Add ((Catch) yyVals[0+yyTop]);
		yyVal = l;
	  }

void case_992()
#line 6621 "cs-parser.jay"
{
		var l = (List<Catch>) yyVals[-1+yyTop];
		
		Catch c = (Catch) yyVals[0+yyTop];
		var prev_catch = l [l.Count - 1];
		if (prev_catch.IsGeneral && prev_catch.Filter == null) {
			report.Error (1017, c.loc, "Try statement already has an empty catch block");
		}
		
		l.Add (c);
		yyVal = l;
	  }

void case_995()
#line 6642 "cs-parser.jay"
{
	  	var c = new Catch ((ExplicitBlock) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	c.Filter = (CatchFilterExpression) yyVals[-1+yyTop];
	  	yyVal = c;
	  }

void case_996()
#line 6648 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		var c = new Catch ((ExplicitBlock) current_block, GetLocation (yyVals[-4+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-2+yyTop];

		if (yyVals[-1+yyTop] != null) {
			var lt = (LocatedToken) yyVals[-1+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (c.Variable);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;
		lexer.parsing_catch_when = true;
	  }

void case_997()
#line 6664 "cs-parser.jay"
{
	  	((Catch) yyVals[-1+yyTop]).Filter = (CatchFilterExpression) yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_998()
#line 6669 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_PARENS) {
			report.Error (1015, lexer.Location,
				"A type that derives from `System.Exception', `object', or `string' expected");
		} else {
			Error_SyntaxError (yyToken);
		}
		
		yyVal = new Catch (null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_1000()
#line 6687 "cs-parser.jay"
{
		end_block (Location.Null);
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_1003()
#line 6703 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_5)
			FeatureIsNotAvailable (GetLocation (yyVals[-4+yyTop]), "exception filter");

		yyVal = new CatchFilterExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_1006()
#line 6728 "cs-parser.jay"
{
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_1008()
#line 6738 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Lock ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_1009()
#line 6746 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Lock ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_1010()
#line 6756 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.FixedVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Fixed.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_1011()
#line 6766 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_1012()
#line 6771 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Fixed f = new Fixed ((Fixed.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_1013()
#line 6784 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.UsingVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Using.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_1014()
#line 6794 "cs-parser.jay"
{
		yyVal = current_variable;	  
		current_variable = null;
	  }

void case_1015()
#line 6799 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Using.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-2+yyTop]));
		current_block.AddStatement (u);
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_1016()
#line 6809 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Using ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_1017()
#line 6817 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new Using ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_1019()
#line 6828 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  }

void case_1021()
#line 6840 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AddLocation (current_variable, GetLocation (yyVals[-1+yyTop]));
		yyVal = current_variable;
	  }

void case_1022()
#line 6852 "cs-parser.jay"
{
		lexer.query_parsing = false;
			
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1023()
#line 6864 "cs-parser.jay"
{
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1024()
#line 6875 "cs-parser.jay"
{
	        lexer.query_parsing = false;
		yyVal = yyVals[-1+yyTop];

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1025()
#line 6882 "cs-parser.jay"
{
	        yyVal = yyVals[-1+yyTop];
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1026()
#line 6891 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var clause = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (clause, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (clause);
	  }

void case_1027()
#line 6901 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var clause = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (clause, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (clause);
	  }

void case_1028()
#line 6916 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var clause = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (clause, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (clause);
	  }

void case_1029()
#line 6926 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var clause = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (clause, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (clause);
	  }

void case_1031()
#line 6945 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_1033()
#line 6960 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);

		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-4+yyTop]
		};
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_1034()
#line 6979 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[-1+yyTop];
		
		if (yyVals[0+yyTop] != null)
			head.Next = (Linq.AQueryClause)yyVals[0+yyTop];
				
		if (yyVals[-2+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-2+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_1035()
#line 6994 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[0+yyTop];

		if (yyVals[-1+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-1+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_1037()
#line 7007 "cs-parser.jay"
{
		report.Error (742, GetLocation (yyVals[0+yyTop]), "Unexpected symbol `{0}'. A query body must end with select or group clause", GetSymbolName (yyToken));
		yyVal = yyVals[-1+yyTop];
	  }

void case_1038()
#line 7012 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_1040()
#line 7024 "cs-parser.jay"
{
		yyVal = new Linq.Select ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1041()
#line 7031 "cs-parser.jay"
{
	  	if (linq_clause_blocks == null)
	  		linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  	linq_clause_blocks.Push ((Linq.QueryBlock)current_block);
	  }

void case_1042()
#line 7039 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_1043()
#line 7046 "cs-parser.jay"
{
		var obj = (object[]) yyVals[0+yyTop];

		yyVal = new Linq.GroupBy ((Linq.QueryBlock)current_block, (Expression)yyVals[-2+yyTop], linq_clause_blocks.Pop (), (Expression)obj[0], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, (Location) obj[1]);
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1045()
#line 7063 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new object[2] { null, Location.Null };
	  }

void case_1047()
#line 7072 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-1+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_1054()
#line 7092 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
	  	yyVal = new Linq.Let ((Linq.QueryBlock) current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  	
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_1056()
#line 7111 "cs-parser.jay"
{
		yyVal = new Linq.Where ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1057()
#line 7121 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_1058()
#line 7129 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_1059()
#line 7137 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_1060()
#line 7145 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();

		var lt = (LocatedToken) yyVals[-10+yyTop];	
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-11+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
			
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location);

			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-11+yyTop]));	
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), opt_intoStack.Pop ());
		}

		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);
	  }

void case_1061()
#line 7183 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_1062()
#line 7191 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_1063()
#line 7199 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_1064()
#line 7207 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();
		
		var lt = (LocatedToken) yyVals[-10+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;		
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
		
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location); /* TODO:*/
			
			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};			
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), opt_intoStack.Pop ());
		}
		
		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);		
	  }

void case_1066()
#line 7253 "cs-parser.jay"
{
		opt_intoStack.Push (GetLocation (yyVals[-1+yyTop]));
		yyVal = yyVals[0+yyTop];
	  }

void case_1067()
#line 7261 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		lbag.AddLocation (current_block, GetLocation (yyVals[0+yyTop]));
	  }

void case_1068()
#line 7266 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		yyVal = yyVals[0+yyTop];
	  }

void case_1070()
#line 7277 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_1071()
#line 7284 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	  }

void case_1073()
#line 7293 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock ((Linq.QueryBlock) current_block, lexer.Location);	 
	 }

void case_1074()
#line 7300 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	 }

void case_1076()
#line 7312 "cs-parser.jay"
{
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1077()
#line 7317 "cs-parser.jay"
{
		yyVal = new Linq.OrderByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1079()
#line 7329 "cs-parser.jay"
{
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1080()
#line 7334 "cs-parser.jay"
{
		yyVal = new Linq.ThenByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1082()
#line 7344 "cs-parser.jay"
{
		/* query continuation block is not linked with query block but with block*/
		/* before. This means each query can use same range variable names for*/
		/* different identifiers.*/

		current_block.SetEndLocation (GetLocation (yyVals[-1+yyTop]));
		current_block = current_block.Parent;
	
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);		
	  }

void case_1083()
#line 7360 "cs-parser.jay"
{
		var current_block = linq_clause_blocks.Pop ();	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
  		yyVal = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, null, rv, GetLocation (yyVals[-3+yyTop])) {
  			next = (Linq.AQueryClause)yyVals[0+yyTop]
  		};
	  }

void case_1086()
#line 7387 "cs-parser.jay"
{ 
		current_container = current_type = new Class (current_container, new MemberName ("<InteractiveExpressionClass>"), Modifiers.PUBLIC, null);

		/* (ref object retval)*/
		Parameter [] mpar = new Parameter [1];
		mpar [0] = new Parameter (new TypeExpression (compiler.BuiltinTypes.Object, Location.Null), "$retval", Parameter.Modifier.REF, null, Location.Null);

		ParametersCompiled pars = new ParametersCompiled (mpar);
		var mods = Modifiers.PUBLIC | Modifiers.STATIC;
		if (settings.Unsafe)
			mods |= Modifiers.UNSAFE;

		current_local_parameters = pars;
		var method = new InteractiveMethod (
			current_type,
			new TypeExpression (compiler.BuiltinTypes.Void, Location.Null),
			mods,
			pars);
			
		current_type.AddMember (method);			
		oob_stack.Push (method);

		interactive_async = false;

		++lexer.parsing_block;
		start_block (lexer.Location);
	  }

void case_1087()
#line 7415 "cs-parser.jay"
{
		--lexer.parsing_block;
		var method = (InteractiveMethod) oob_stack.Pop ();
		method.Block = (ToplevelBlock) end_block(lexer.Location);

		if (interactive_async == true) {
			method.ChangeToAsync ();
		}

		InteractiveResult = (Class) pop_current_class ();
		current_local_parameters = null;
	  }

void case_1097()
#line 7461 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-1+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_1098()
#line 7467 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_1099()
#line 7473 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-3+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value);
	  }

void case_1102()
#line 7488 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-6+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }

void case_1103()
#line 7493 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Explicit;
		yyVal = null;
	  }

void case_1104()
#line 7501 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Implicit;
		yyVal = null;
	  }

void case_1105()
#line 7509 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop];
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = (Operator.OpType) yyVals[-1+yyTop];
		yyVal = null;
	  }

void case_1113()
#line 7547 "cs-parser.jay"
{
		var parameters = new List<DocumentationParameter> ();
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_1114()
#line 7553 "cs-parser.jay"
{
		var parameters = yyVals[-2+yyTop] as List<DocumentationParameter>;
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_1115()
#line 7562 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != null)
			yyVal = new DocumentationParameter ((Parameter.Modifier) yyVals[-1+yyTop], (FullNamedExpression) yyVals[0+yyTop]);
		else
			yyVal = new DocumentationParameter ((FullNamedExpression) yyVals[0+yyTop]);
	  }

#line default
   static readonly short [] yyLhs  = {              -1,
    0,    4,    0,    0,    1,    1,    1,    1,    2,    2,
   11,   11,   12,   12,   13,   13,   14,   15,   15,   15,
   16,   16,   20,   21,   18,   18,   23,   23,   23,   19,
   19,   19,   24,   24,   25,   25,    7,    7,    6,    6,
   22,   22,    8,    8,   26,   26,   26,   27,   27,   27,
   27,   27,    9,    9,   10,   10,   35,   33,   38,   34,
   34,   34,   34,   36,   36,   36,   37,   37,   42,   39,
   40,   41,   41,   43,   43,   43,   43,   43,   44,   44,
   44,   48,   45,   47,   51,   50,   50,   50,   53,   53,
   54,   54,   55,   55,   55,   55,   55,   55,   55,   55,
   55,   55,   55,   55,   55,   55,   69,   64,   74,   76,
   79,   80,   81,   29,   29,   84,   56,   56,   85,   85,
   86,   86,   87,   89,   83,   83,   88,   88,   94,   57,
   98,   57,   57,   93,  101,   93,   95,   95,  102,  102,
  103,  104,  103,   99,   99,  105,  105,  106,  107,   97,
   97,  100,  100,  100,  110,   58,  113,  114,  108,  115,
  116,  117,  108,  108,  108,  109,  109,  119,  119,  122,
  120,  112,  112,  123,  123,  123,  123,  123,  123,  123,
  123,  123,  123,  124,  124,  127,  127,  127,  127,  130,
  127,  128,  128,  131,  131,  132,  132,  132,  125,  125,
  125,  133,  133,  133,  126,  135,  137,  138,  140,   59,
  141,   59,  139,  143,  139,  142,  142,  145,  147,   61,
  146,  146,  136,  136,  136,  136,  136,  151,  148,  152,
  149,  150,  150,  150,  153,  154,  155,  157,   30,   30,
  156,  156,  158,  158,  159,  159,  159,  159,  159,  159,
  159,  159,  159,  161,   62,  162,  162,  165,  160,  160,
  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,
  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,
  164,  164,  164,  167,  166,  168,  166,  166,  166,   63,
  171,  173,  169,  170,  170,  172,  172,  177,  175,  178,
  175,  175,  175,  179,   65,  181,   60,  184,  185,   60,
   60,  180,  187,  180,  182,  182,  188,  188,  189,  190,
  189,  191,  186,  183,  183,  183,  183,  183,  195,  192,
  196,  193,  194,  194,   66,   67,  198,  200,  201,   31,
  197,  197,  197,  199,  199,  199,  202,  202,  203,  204,
  203,  203,  203,  205,  206,  207,   32,  208,  208,   17,
   17,   17,  209,  209,  209,  213,  213,  211,  211,  211,
  214,  214,  216,   73,  134,  111,  111,  144,  144,  217,
  217,  217,  215,  215,  218,  218,  219,  219,  221,  221,
   92,   82,   82,   96,   96,  129,  129,  163,  163,  223,
  223,  223,  222,  226,  226,  226,  228,  228,  229,  227,
  227,  227,  227,  227,  227,  227,  230,  230,  230,  230,
  230,  230,  230,  230,  230,  231,  231,  231,  231,  231,
  231,  231,  231,  231,  231,  231,  231,  231,  231,  231,
  231,  231,  231,  231,  231,  231,  232,  232,  232,  233,
  233,  233,  254,  254,  252,  252,  255,  255,  256,  256,
  257,  256,  258,  256,  259,  259,  260,  260,  235,  235,
  253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
  253,  253,  237,  237,  237,  262,  262,  263,  263,  264,
  264,  266,  266,  266,  267,  267,  267,  267,  267,  267,
  267,  268,  268,  176,  176,  261,  261,  261,  261,  261,
  273,  273,  272,  272,  274,  274,  274,  274,  274,  274,
  276,  276,  276,  275,  238,  238,  238,  238,  271,  271,
  278,  278,  279,  279,  239,  240,  240,  241,  242,  243,
  243,  234,  234,  234,  234,  234,  284,  280,  244,  244,
  285,  285,  286,  286,  287,  287,  287,  287,  288,  288,
  288,  288,  281,  281,  224,  224,  283,  283,  289,  289,
  282,  282,   91,   91,  290,  290,  245,  291,  291,  212,
  210,  246,  246,  247,  247,  248,  248,  249,  293,  250,
  294,  250,  292,  292,  296,  295,  236,  297,  297,  297,
  297,  297,  297,  297,  297,  297,  298,  298,  298,  298,
  298,  298,  298,  298,  298,  298,  298,  298,  298,  299,
  299,  299,  299,  299,  299,  299,  300,  300,  300,  300,
  300,  300,  300,  300,  300,  300,  300,  300,  301,  303,
  303,  303,  303,  303,  303,  303,  303,  303,  304,  305,
  307,  307,  308,  309,  309,  306,  306,  310,  310,  311,
  311,  312,  312,  312,  312,  312,  313,  313,  313,  313,
  313,  313,  313,  313,  313,  314,  314,  314,  314,  314,
  315,  315,  315,  316,  316,  316,  317,  317,  317,  318,
  318,  318,  319,  319,  319,  320,  320,  321,  321,  321,
  321,  321,  322,  322,  322,  322,  322,  322,  322,  322,
  322,  322,  322,  323,  323,  324,  324,  324,  324,  325,
  325,  327,  326,  326,  326,   52,   52,  329,  328,  330,
  328,  331,  328,  332,  333,  328,  334,  335,  328,   46,
   46,  269,  269,  269,  269,  251,  251,  251,   90,  337,
   75,   75,  338,  339,  339,  339,  339,  341,  339,  342,
  343,  344,  345,   28,   72,   72,   71,   71,  118,  118,
  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,
  346,  346,  346,  346,  346,   77,   77,  340,  340,   78,
   78,  347,  347,  348,  348,  349,  349,  350,  350,  350,
  350,  220,  220,  351,  351,  352,  121,   70,   70,  353,
  174,  174,  355,  354,   68,   68,  356,  356,  357,  357,
  357,  357,  357,  361,  361,  362,  362,  362,  359,  359,
  359,  359,  359,  359,  359,  359,  359,  359,  359,  359,
  359,  363,  363,  363,  363,  363,  363,  363,  363,  363,
  363,  363,  363,  363,  377,  377,  377,  377,  364,  378,
  360,  277,  277,  379,  379,  379,  379,  225,  225,  380,
   49,   49,  382,  358,  386,  358,  384,  384,  381,  381,
  381,  383,  383,  390,  390,  389,  389,  391,  391,  385,
  385,  387,  387,  392,  392,  393,  388,  388,  388,  365,
  365,  365,  376,  376,  394,  395,  395,  366,  366,  396,
  396,  396,  399,  397,  397,  398,  398,  400,  400,  400,
  401,  402,  402,  403,  403,  403,  367,  367,  367,  367,
  404,  404,  405,  405,  405,  409,  406,  412,  408,  408,
  415,  411,  411,  414,  414,  410,  410,  418,  417,  417,
  413,  413,  416,  416,  420,  419,  419,  407,  407,  421,
  407,  407,  407,  368,  368,  368,  368,  368,  368,  422,
  423,  423,  424,  424,  424,  425,  425,  425,  426,  426,
  426,  427,  427,  427,  428,  428,  369,  369,  369,  369,
  429,  429,  302,  302,  430,  433,  430,  430,  432,  432,
  431,  434,  431,  370,  371,  435,  374,  372,  372,  437,
  438,  375,  440,  441,  373,  373,  373,  439,  439,  436,
  436,  336,  336,  336,  336,  442,  442,  444,  444,  446,
  445,  447,  445,  443,  443,  443,  443,  443,  451,  449,
  452,  454,  449,  453,  453,  448,  448,  455,  455,  455,
  455,  455,  460,  456,  461,  457,  462,  463,  464,  458,
  466,  467,  468,  458,  465,  465,  470,  459,  469,  473,
  469,  472,  475,  472,  471,  471,  471,  474,  474,  474,
  450,  476,  450,    3,    3,  477,    3,    3,  478,  478,
  270,  270,  265,  265,    5,  479,  479,  479,  479,  479,
  483,  479,  479,  479,  479,  480,  480,  481,  484,  481,
  482,  482,  485,  485,  486,
  };
   static readonly short [] yyLen = {           2,
    2,    0,    3,    1,    2,    4,    3,    1,    0,    1,
    1,    2,    4,    2,    1,    2,    1,    4,    6,    2,
    0,    1,    0,    0,   11,    3,    0,    1,    1,    1,
    3,    1,    0,    1,    0,    1,    0,    1,    0,    1,
    0,    1,    1,    2,    1,    1,    2,    1,    1,    1,
    1,    1,    0,    1,    1,    2,    0,    3,    0,    6,
    3,    2,    1,    1,    1,    1,    1,    3,    0,    3,
    1,    0,    3,    0,    1,    1,    3,    3,    1,    1,
    1,    0,    4,    4,    1,    0,    1,    1,    0,    1,
    1,    2,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    0,    4,    0,    0,
    0,    0,    0,   17,    5,    0,    9,    5,    0,    1,
    1,    2,    3,    0,    3,    1,    1,    1,    0,    8,
    0,    9,    6,    0,    0,    3,    0,    1,    1,    2,
    2,    0,    5,    0,    1,    1,    2,    3,    0,    4,
    2,    1,    1,    1,    0,    3,    0,    0,   10,    0,
    0,    0,   12,    8,    5,    1,    1,    1,    1,    0,
    4,    0,    1,    1,    3,    3,    3,    5,    3,    5,
    1,    1,    1,    1,    3,    4,    6,    2,    4,    0,
    7,    0,    1,    1,    2,    1,    1,    1,    4,    6,
    4,    1,    2,    2,    1,    0,    0,    0,    0,   12,
    0,    6,    0,    0,    4,    1,    1,    0,    0,   10,
    3,    1,    1,    2,    1,    2,    1,    0,    5,    0,
    5,    1,    1,    1,    0,    0,    0,    0,   15,    5,
    0,    1,    1,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    0,    5,    1,    1,    0,    7,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    0,    7,    0,    7,    2,    2,    2,
    0,    0,    9,    1,    1,    0,    1,    0,    6,    0,
    6,    2,    1,    0,    8,    0,    9,    0,    0,   10,
    5,    0,    0,    3,    0,    1,    1,    2,    2,    0,
    5,    0,    2,    2,    2,    1,    1,    1,    0,    5,
    0,    5,    1,    1,    2,    4,    0,    0,    0,   12,
    0,    2,    2,    0,    1,    2,    1,    3,    2,    0,
    5,    3,    1,    0,    0,    0,   13,    0,    1,    1,
    3,    3,    1,    4,    4,    2,    2,    0,    3,    2,
    1,    3,    0,    3,    1,    1,    3,    1,    2,    3,
    4,    4,    0,    3,    1,    3,    3,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    2,    2,
    2,    1,    1,    2,    2,    2,    1,    3,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    2,    1,    1,
    1,    1,    1,    1,    3,    1,    1,    3,    1,    3,
    0,    4,    0,    6,    1,    1,    1,    1,    3,    3,
    4,    4,    5,    4,    4,    4,    3,    3,    3,    4,
    3,    4,    4,    4,    3,    0,    1,    3,    4,    0,
    1,    1,    3,    2,    3,    3,    1,    2,    3,    5,
    2,    1,    1,    0,    1,    1,    3,    3,    3,    2,
    1,    1,    1,    1,    2,    2,    2,    2,    4,    3,
    3,    2,    4,    1,    4,    5,    4,    3,    1,    3,
    1,    3,    1,    1,    1,    4,    3,    2,    2,    6,
    3,    7,    4,    3,    7,    3,    0,    2,    4,    3,
    1,    2,    0,    1,    1,    3,    1,    2,    3,    1,
    1,    1,    0,    1,    1,    2,    2,    3,    1,    2,
    0,    1,    2,    4,    1,    3,    4,    1,    1,    1,
    2,    4,    4,    4,    2,    4,    2,    4,    0,    4,
    0,    5,    0,    1,    0,    4,    4,    1,    2,    2,
    4,    2,    2,    2,    4,    2,    1,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    1,
    3,    3,    3,    3,    3,    3,    1,    3,    3,    3,
    3,    3,    4,    3,    3,    3,    3,    3,    1,    1,
    2,    2,    1,    1,    4,    1,    1,    1,    4,    4,
    1,    3,    3,    1,    2,    0,    1,    1,    3,    1,
    3,    1,    3,    3,    3,    3,    1,    3,    3,    3,
    3,    3,    3,    3,    3,    1,    3,    3,    3,    3,
    1,    3,    3,    1,    3,    3,    1,    3,    3,    1,
    3,    3,    1,    3,    3,    1,    3,    1,    5,    4,
    5,    5,    3,    3,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    1,    3,    3,    2,    1,    1,    0,
    1,    0,    2,    1,    1,    1,    1,    0,    4,    0,
    4,    0,    5,    0,    0,    7,    0,    0,    8,    1,
    1,    1,    1,    1,    1,    6,    4,    4,    1,    1,
    0,    1,    3,    0,    1,    1,    2,    0,    6,    0,
    0,    0,    0,   15,    0,    1,    0,    1,    1,    2,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    0,    1,    2,    3,    0,
    1,    1,    2,    4,    3,    1,    3,    1,    3,    1,
    1,    0,    1,    1,    1,    0,    4,    1,    1,    0,
    4,    1,    0,    4,    0,    1,    1,    2,    1,    1,
    1,    2,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    0,
    4,    1,    2,    2,    2,    1,    1,    1,    2,    1,
    1,    1,    0,    6,    0,    7,    1,    1,    0,    2,
    1,    0,    1,    0,    1,    1,    2,    2,    4,    0,
    2,    0,    1,    1,    2,    4,    1,    5,    2,    2,
    2,    2,    2,    2,    1,    1,    1,    1,    1,    5,
    7,    4,    0,    8,    4,    0,    1,    1,    2,    1,
    2,    1,    2,    3,    3,    1,    1,    1,    1,    1,
    5,    4,    7,    3,    6,    0,    4,    0,    4,    2,
    0,    4,    2,    3,    1,    0,    1,    0,    5,    1,
    0,    1,    0,    1,    1,    1,    3,    4,    5,    0,
    9,    5,    4,    1,    1,    1,    1,    1,    1,    2,
    2,    2,    3,    4,    3,    3,    3,    2,    3,    3,
    2,    4,    4,    3,    0,    1,    3,    4,    5,    3,
    1,    2,    0,    1,    3,    0,    7,    3,    2,    1,
    0,    0,    5,    2,    2,    0,    3,    5,    4,    0,
    0,   10,    0,    0,    9,    5,    4,    2,    1,    0,
    2,    2,    2,    2,    2,    4,    5,    4,    5,    0,
    5,    0,    6,    3,    2,    2,    2,    1,    0,    3,
    0,    0,    5,    2,    1,    1,    2,    1,    1,    1,
    1,    1,    0,    5,    0,    3,    0,    0,    0,   12,
    0,    0,    0,   13,    0,    2,    0,    3,    1,    0,
    4,    1,    0,    4,    1,    2,    2,    1,    2,    2,
    0,    0,    4,    2,    3,    0,    4,    2,    2,    3,
    0,    1,    1,    1,    2,    2,    2,    2,    4,    3,
    0,    7,    4,    4,    3,    1,    3,    0,    0,    4,
    0,    1,    1,    3,    2,
  };
   static readonly short [] yyDefRed = {            0,
    8,    0,    0,    0,    0,    0,    0,    0,    2,    4,
    0,    0,   11,   14,    0, 1084,    0,    0, 1088,    0,
    0,   15,   17,  412,  418,  425,  413,  415,    0,  414,
    0,  421,  423,  410,    0,  417,  419,  411,  422,  424,
  420,    0,  373, 1106,    0,  416, 1095,    0,   10,    1,
    0,    0,    0,   12,    0,  907,    0,    0,    0,    0,
    0,    0,    0,    0,  454,    0,    0,    0,    0,    0,
    0,    0,  452,    0,    0,    0,  535,    0,  453,    0,
    0,    0, 1006,    0,    0,    0,  745,    0,    0,    0,
    0,    0,    0,    0,    0,  456,  806,    0,  859,    0,
    0,    0,    0,    0,    0,    0,    0,  451,    0,  734,
    0,  906,    0,  842,    0,  447,  867,  866,    0,    0,
    0,  427,  428,  429,  430,  431,  432,  433,  434,  435,
  436,  437,  438,  439,  440,  441,  442,  443,  444,  445,
  446,  449,  450,  741,    0,  607,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  742,  740,
  743,  744,  826,  828,    0,  824,  827,  843,  845,  846,
  847,  848,  849,  850,  851,  852,  853,  854,  844,    0,
    0,  908,  909,  927,  928,  929,  930,  964,  965,  966,
  967,  968,  969,    0,    0,    0,   20,   22,    0, 1092,
   16, 1085,    0,    0,  266,  283,  265,  262,  267,  268,
  261,  280,  279,  272,  273,  269,  271,  270,  274,  263,
  264,  275,  276,  282,  281,  277,  278,    0, 1109, 1098,
    0,    0, 1097,    0, 1096,    3,   57,    0,    0,    0,
   46,   43,   45,   48,   49,   50,   51,   52,   55,   13,
    0,    0,    0,  970,  585,  465,  466, 1004,    0,    0,
    0,    0,    0,    0,    0,    0,  972,  971,    0,  595,
  589,  594,  858,  905,  829,  856,  855,  857,  830,  831,
  832,  833,  834,  835,  836,  837,  838,  839,  840,  841,
    0,    0,    0,  936,    0,    0,    0,  872,  871,    0,
    0,    0,    0,    0,    0,    0,    0,  978,    0,    0,
    0,    0,  426,    0,    0,    0,  981,    0,    0,    0,
    0,  587, 1005,    0,    0,    0,  870,  406,    0,    0,
    0,    0,    0,    0,  392,  360,    0,  363,  393,    0,
  402,    0,    0,    0,    0,    0,    0,    0,  737,    0,
  606,    0,    0,  730,    0,    0,  602,    0,    0,  457,
    0,    0,  604,  600,  614,  608,  615,  609,  603,  599,
  619,  613,  618,  612,  616,  610,  617,  611,  728,  581,
    0,  580,  448,  366,  367,    0,    0,    0,    0,    0,
  860,    0,  359,    0,  404,  405,    0,    0,  538,  539,
    0,    0,    0,  864,  865,  873,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1087,
  825,  863,    0,  903,  904, 1038, 1055,    0,    0, 1039,
 1041,    0, 1067, 1024, 1022, 1048,    0,    0, 1046, 1049,
 1050, 1051, 1052, 1025, 1023,    0,    0,    0,    0,    0,
    0, 1105,    0,    0,  374,    0,    0, 1107,    0,    0,
   44,  776,  782,  774,    0,  771,  781,  775,  773,  772,
  779,  777,  778,  784,  780,  783,  785,    0,    0,  769,
   47,   56,  537,    0,  533,  534,    0,    0,  531,    0,
  875,    0,    0,    0,  934,    0,  902,  900,  901,    0,
    0,    0,  749,    0,  975,  973,  750,    0,    0,  562,
    0,    0,  550,  557,    0,    0,    0,  551,    0,    0,
  567,  569,    0,  546,    0,    0,    0,    0,    0,  541,
    0,  544,  548,  395,  394,  977,  976,    0,    0,  980,
  979,  990,    0,    0,    0,  991,  579,    0,  389,  578,
    0,    0, 1007,    0,    0,  869,    0,    0,  400,  401,
    0,    0,    0,  399,    0,    0,    0,  620,    0,    0,
  591,    0,  732,  638,  637,    0,    0,    0,  461,    0,
  455,  823,    0,    0,    0,  817,  819,  820,  821,  469,
  470,    0,  370,  371,    0,  197,  196,  198,    0,  719,
    0,    0,    0,  396,    0,  714,    0,    0,  984,    0,
    0,    0,  477,  478,    0,  481,    0,    0,    0,    0,
  479,    0,    0,  528,    0,  485,    0,    0,    0,    0,
  511,  514,    0,    0,  506,  513,  512,    0,  703,  704,
  705,  706,  707,  708,  709,  710,  711,  713,  712,  624,
  621,  626,  623,  625,  622,  635,  632,  636,    0,    0,
  646,    0,    0,    0,    0,    0,  639,    0,  634,  647,
  648,  630,    0,  631,    0,  665,    0,    0,  666,    0,
  672,    0,  673,    0,  674,    0,  675,    0,  679,    0,
  680,    0,  683,    0,  686,    0,  689,    0,  692,    0,
  695,    0,  697,    0,  566,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1037, 1036,    0, 1047,    0, 1035,
    0,   18, 1103, 1104,    0,    0,  194,    0,    0, 1113,
  388,    0,    0,    0,  385, 1099, 1101,   63,   65,   66,
    0,    0,   58,    0,    0,   67,   69,   32,   30,    0,
    0,    0,  766,    0,  770,  475,    0,  536,    0,  584,
    0,  597,  183,  205,    0,    0,    0,  173,    0,    0,
    0,  184,  590,    0, 1010,    0,  956,  937,    0,  947,
    0,  958,    0,  974,  912,    0, 1009,    0,    0,  549,
    0,  558,  568,  570,    0,    0,    0,    0,  497,    0,
    0,  492,    0,    0,  727,  726,  529,    0,  572,  543,
    0,    0,  154,  573,  152,  153,  575,    0,  583,  582,
  915,    0, 1002,    0,    0,  988,    0,  992,  577,  586,
 1017,    0, 1013,  932,    0,    0, 1028,    0,  361,  362,
 1026,    0,    0,  747,  748,    0,    0,    0,  725,  724,
  731,    0,  476,    0,    0,  458,  822,  808,  809,  807,
  818,  729,    0,  369,  717,    0,    0,    0,  605,  601,
  983,  982,  861,  482,  474,    0,    0,  480,  471,  472,
  588,  527,  525,    0,  524,  517,  518,    0,  515,  516,
    0,  510,  467,  468,  483,  484,    0,  881,    0,    0,
  641,  642,    0,    0,    0,  994,  633,  700,    0, 1056,
 1030,    0, 1057,    0, 1040, 1042, 1053,    0, 1068,    0,
 1034, 1082,    0, 1115,  195, 1110,    0,  805,  804,    0,
  803,    0,  384,    0,   62,   59,    0,    0,    0,    0,
    0,    0,  391,    0,  760,    0,    0,   88,   87,    0,
  532,    0,    0,    0,    0,    0,  188,  596,    0,    0,
    0,    0,    0,  948,  940,  938,    0,  959,    0,    0,
 1008,  559,  556,    0,  501,    0,    0,    0, 1093, 1094,
  488,  494,    0,  498,    0,    0,    0,    0,    0,    0,
  913,    0,  998,    0,  995,  989, 1016,    0,  931,  364,
  365, 1029, 1027,    0,  592,    0,  733,  723,  463,  462,
  372,  716,  715,  735,  473,  526,    0,    0,  520,    0,
  509,  508,  507,    0,  897,  880,    0,    0,    0,  886,
    0,    0,    0,  651,    0,    0,  654,    0,  660,    0,
  658,  701,  702,  699,    0, 1032,    0, 1061,    0,    0,
 1076, 1077, 1070,    0,   19, 1114,  387,  386,    0,    0,
   68,   61,    0,   70,   31,   24,    0,    0,  337,    0,
  240,    0,  115,    0,   84,   85,  891,  127,  128,    0,
    0,    0,  894,  203,  204,    0,    0,    0,    0,  176,
  185,  177,  179,  935,    0,    0,    0,    0,    0,  957,
    0,    0,  502,  503,  496,  499,  495,    0,  489,  493,
    0,  564,    0,  530,  540,  487,  576,  574,    0,    0,
    0, 1019,    0,    0,  746,  738,    0,    0,  521,    0,
  519,    0,    0,  878,  877,  874,  887,  645,    0,  650,
    0,    0,  655,  649,    0, 1031,    0,    0,    0, 1045,
    0, 1043, 1054,    0, 1083, 1102,    0,   81,    0,    0,
   75,   76,   79,   80,    0,  354,  343,  342,    0,  761,
  236,  110,    0,  876,  895,  189,    0,  201,    0,    0,
    0,  933, 1021,    0,    0,    0,    0,  939,    0,  960,
  911,    0,  545,  542,  920,    0,  926,    0,    0,  918,
    0,  922,    0,  996, 1018, 1014,    0,  464,  736,  523,
    0,    0,  653,  652,  661,  659, 1033, 1058,    0, 1044,
    0,    0, 1072,    0,   82,   73,    0,    0,    0,  338,
    0,    0,    0,    0,    0,  190,    0,  180,  178, 1011,
  949,  943,  941,    0,  500,    0,  914,  919,    0,  923,
 1003,    0,    0,  739,    0,  889,    0, 1062, 1079, 1080,
 1073,   60,    0,   77,   78,    0,    0,    0,    0,    0,
    0,    0,  755,    0,  787,    0,  752,  896,  187,    0,
  200,    0,    0,  961,  925,  924, 1000,    0,  997, 1015,
  898,    0,    0,    0,   83,    0,    0,  355,    0,    0,
  353,  339,    0,  347,    0,  409,    0,  407,    0,    0,
  762,    0,  792,  237,    0,  191, 1012,  945,  942,    0,
    0,  954,  810,  812,  999, 1059,    0, 1074,    0,    0,
    0,  335,    0,    0,  753,  789,    0,  758,    0,    0,
  793,    0,  111,    0,    0,    0, 1063,   29,   28,   25,
  356,  352,    0,    0,  348,  408,    0,  795,    0,    0,
    0,    0,  944,    0,    0,    0,    0,    0,   34,  340,
    0,  800,    0,  801,  798,    0,  796,  106,  107,    0,
  103,    0,    0,   91,   93,   94,   95,   96,   97,   98,
   99,  100,  101,  102,  104,  105,  155,    0,    0,  253,
  245,  246,  247,  248,  249,  250,  251,  252,    0,    0,
  243,  112,  811,    0, 1060,    0,  357,  351,  759,    0,
    0,    0,    0,  763,   92,    0,  295,  290,  294,    0,
  238,  244,    0, 1066, 1064,  799,  797,    0,    0,    0,
    0,    0,    0,    0,    0,  304,    0,    0,  254,    0,
    0,  260,    0,  170,  169,  156,  166,  167,  168,    0,
    0,    0,  108,    0,    0,  289,    0,    0,  288,    0,
  160,    0,    0,  378,  336,    0,  376,    0,    0,    0,
    0,    0,    0,    0,    0,  764,    0,  239,  113,  118,
  116,  311,    0,  375,    0,    0,    0,    0,  131,    0,
    0,    0,    0,    0,    0,  165,  157,    0,    0,    0,
  218,    0,  379,    0,  255,    0,    0,    0,    0,  308,
    0,  286,  133,    0,  284,    0,    0,    0,  135,    0,
  380,    0,    0,  207,  212,    0,    0,    0,  377,  258,
  171,  114,  126,  124,    0,    0,  313,    0,    0,    0,
    0,    0,  161,    0,  292,    0,    0,    0,    0,  139,
    0,    0,    0,    0,  381,  382,    0,    0,    0,    0,
    0,  121,  328,    0,  309,    0,    0,  322,    0,    0,
    0,  317,    0,  151,    0,    0,    0,    0,  146,    0,
    0,  305,    0,  136,    0,  130,  140,  158,  164,  227,
    0,  208,    0,    0,  219,    0,  125,    0,  117,  122,
    0,    0,    0,  324,    0,  325,  314,    0,    0,  307,
  318,  287,    0,    0,  132,  147,  285,    0,  303,    0,
  293,  297,  142,    0,    0,    0,  224,  226,    0,  259,
  123,  329,  331,  310,    0,    0,  323,  320,  150,  148,
  162,  302,    0,    0,    0,  159,  228,  230,  209,    0,
  222,  220,    0,    0,  322,    0,  298,  300,  143,    0,
    0,    0,    0,  333,  334,  330,  332,  321,  163,    0,
    0,  234,  233,  232,  229,  231,  214,  210,  221,    0,
    0,    0,  299,  301,  216,  217,    0,  215,
  };
  protected static readonly short [] yyDgoto  = {             7,
    8,   50,    9,   51,   10,   11,   52,  238,  785,  786,
   12,   13,   53,   22,   23,  199,  332,  241,  770,  961,
 1185, 1317, 1370, 1694,  958,  242,  243,  244,  245,  246,
  247,  248,  249,  763,  479,  764,  765, 1080,  766,  767,
 1084,  959, 1180, 1181, 1182,  274,  652, 1283,  113,  970,
 1095,  827, 1402, 1403, 1404, 1405, 1406, 1407, 1408, 1409,
 1410, 1411, 1412, 1413, 1414, 1415, 1416,  604, 1442,  880,
  498,  774, 1497, 1094, 1296, 1253, 1294, 1331, 1382, 1453,
 1538, 1326, 1565, 1539, 1590, 1591, 1592, 1097, 1588, 1098,
  836,  962, 1550, 1524, 1578,  553, 1571, 1544, 1607, 1045,
 1576, 1579, 1580, 1675, 1608, 1609, 1605, 1417, 1476, 1446,
 1498,  787, 1552, 1654, 1521, 1611, 1686,  499, 1477, 1478,
  275, 1507,  788,  789,  790,  791,  792,  745,  622, 1300,
  746,  747,  976, 1500, 1529, 1622, 1583, 1656, 1708, 1692,
 1530, 1717, 1712, 1501, 1556, 1682, 1659, 1623, 1624, 1705,
 1690, 1691, 1092, 1252, 1362, 1429, 1481, 1430, 1431, 1469,
 1504, 1470,  335,  228, 1587, 1472, 1572, 1569, 1418, 1448,
 1493, 1651, 1613, 1345, 1652,  653, 1700, 1701, 1492, 1568,
 1541, 1600, 1595, 1566, 1632, 1637, 1598, 1601, 1602, 1685,
 1638, 1596, 1597, 1696, 1683, 1684, 1089, 1189, 1322, 1288,
 1353, 1323, 1324, 1373, 1249, 1350, 1387,  395,  336,  115,
  384,  385,  116,  615,  475,  231, 1516,  754,  755,  950,
  963,  117,  340,  442,  328,  341,  312, 1327, 1328,   46,
  120,  313,  122,  123,  124,  125,  126,  127,  128,  129,
  130,  131,  132,  133,  134,  135,  136,  137,  138,  139,
  140,  141,  142,  143,  359,  360,  875, 1147,  259,  915,
  832, 1135, 1124,  820, 1001,  821,  822, 1125,  144,  202,
  828,  655,  656,  657,  906,  907,  145,  508,  509,  305,
 1133,  830,  443,  307,  537,  538,  539,  540,  543,  838,
  571,  271,  514,  866,  272,  513,  146,  147,  148,  149,
 1056,  927, 1057,  690,  691, 1058, 1053, 1054, 1059, 1060,
 1061,  150,  151,  152,  153,  154,  155,  156,  157,  158,
  159,  160,  625,  626,  627,  871,  872,  161,  612,  596,
  868,  386, 1148,  592, 1227,  162,  528, 1291, 1292, 1295,
 1377, 1090, 1251, 1360, 1473,  500, 1332, 1333, 1396, 1397,
  951,  361, 1365,    0,    0,  605,  606,  276,  277,  278,
  165,  166,  167,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  179,  291,  632,  180,  329,
  920,  658, 1048, 1156,  973,  781, 1101, 1046, 1049, 1205,
 1050, 1102, 1103,  292,  181,  182,  183, 1218, 1139, 1219,
 1220, 1221, 1222,  184,  185,  186,  187,  798,  521,  799,
 1208, 1119, 1209, 1339, 1303, 1340,  800, 1118,  801, 1342,
 1264,  188,  189,  190,  191,  192,  193,  314,  565,  566,
  845, 1309, 1272, 1012,  325, 1117,  983, 1302, 1144, 1018,
 1273,  194,  455,  195,  456, 1065, 1167,  457,  458,  740,
  731,  732, 1172, 1069,  459,  460,  461,  462,  463, 1070,
  726, 1067, 1277, 1366, 1435, 1169, 1313, 1386,  939,  734,
  940, 1242, 1174, 1243, 1314, 1074,   17,   19,   47,   48,
  230,  748,  954,  473,  749,  750,
  };
  protected static readonly short [] yySindex = {          226,
    0, -164,  156,  -25,  193,19811,    0,  172,    0,    0,
  193,  -25,    0,    0,  174,    0, 8919,  193,    0, -158,
   69,    0,    0,    0,    0,    0,    0,    0,  380,    0,
  390,    0,    0,    0,12330,    0,    0,    0,    0,    0,
    0,  331,    0,    0,  634,    0,    0,  665,    0,    0,
  172,  433,  193,    0,  339,    0,  378,  441, -171,19227,
 -151,  336,  565, 9080,    0,  336,  336,  336,   67,  336,
  336,  855,    0,11110,  336,  336,    0,11271,    0,  598,
  336, -161,    0,  336,  597,  336,    0, 9580, 9580,  629,
  336,  336,   70,11434,18112,    0,    0,18112,    0,12646,
12781,12916,13051,13186,13321,13456,13591,    0,  276,    0,
10346,    0,   52,    0,  -38,    0,    0,    0,  486,  868,
   31,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  -38,    0, 1172,  890,  116,  392,
  643,  723,  636,  675,  692,  688,  114,  712,    0,    0,
    0,    0,    0,    0, 4190,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  762,
 -272,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  396,  465,  433,    0,    0,  724,    0,
    0,    0,10346,10346,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  331,    0,    0,
  736,  743,    0, -232,    0,    0,    0,  433,13222,  847,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  914,  -38,18252,    0,    0,    0,    0,    0,18112, -144,
 -142,  901,  809, -274,  868,  -38,    0,    0,10346,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  133,  330,19227,    0,10346,18112,  811,    0,    0,  887,
18112,18112, 7036,  653,  299,  877,10346,    0,11434,  276,
 1031,  917,    0,  925,10346,18112,    0, 1062,  945,  603,
 1181,    0,    0,18112,  598,17552,    0,    0,  597,18112,
  452,  575, 1038,  -38,    0,    0,  920,    0,    0,  762,
    0,   31, 1051,  -38,18112,18112,18112,  565,    0, 1015,
    0,10346,10346,    0,12511,  -38,    0,  878,  896,    0,
 9241,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1587,    0,    0,    0,    0,19691,  452,  976,  993,18112,
    0,   -9,    0,  202,    0,    0,  150,  255,    0,    0,
  946,11569, 9563,    0,    0,    0,18112,18112,18112,18112,
18112,18112,18112,18112,18112,18112,18112,13726,13861,13996,
 1795,16291,14131,14266,14401,14536,14671,14806,14941,15076,
15211,15346,15481,15616,15751,15886,16021,18672,18112,    0,
    0,    0,  762,    0,    0,    0,    0, 9580, 9580,    0,
    0,  -38,    0,    0,    0,    0,  564, 1021,    0,    0,
    0,    0,    0,    0,    0,  433,  847,  548,  473,  331,
  331,    0,  682, -149,    0,  331, 1016,    0, -167,13222,
    0,    0,    0,    0, -152,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  348,13357,    0,
    0,    0,    0,  999,    0,    0, 1003,  706,    0, 1026,
    0, 1036,  241,  598,    0,  336,    0,    0,    0,  -38,
17552, -147,    0, 1040,    0,    0,    0, -168,   94,    0,
  809, -274,    0,    0, 1043,    0, 1047,    0, 1045,  992,
    0,    0,  734,    0, 9843,  739,11730,  877,17412,    0,
10007,    0,    0,    0,    0,    0,    0,   99,  107,    0,
    0,    0,  347,  598,  713,    0,    0,  597,    0,    0,
 1053, 1056,    0,  108,  -38,    0,  119, 1011,    0,    0,
18112, 1141,   -9,    0,18112, 1144, 1061,    0, 1064, 1066,
    0,19691,    0,    0,    0,   98,  999,18112,    0,18112,
    0,    0, -197,  138, 9241,    0,    0,    0,    0,    0,
    0,   98,    0,    0,  155,    0,    0,    0,  597,    0,
  452,  -38,10966,    0, 1067,    0, 1071,16156,    0, 1194,
 1073, 9241,    0,    0, 1027,    0,  999,  -38,18252, 1029,
    0,   -9,  999,    0,  127,    0,17692,17692, 1087, 1210,
    0,    0,  139,   76,    0,    0,    0, -172,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,18800,18800,
    0,10346,  646,    0,    0,    0,    0,  -38,    0,    0,
    0,    0,  890,    0,  890,    0,12376,  116,    0,  116,
    0,  392,    0,  392,    0,  392,    0,  392,    0,  643,
    0,  643,    0,  723,    0,  636,    0,  675,    0,  692,
    0,  688,    0, -200,    0,11730, 1173,  -38, 1174,  -38,
11730,11730, 1085,18112,    0,    0, 1021,    0,  -38,    0,
 1049,    0,    0,    0,10966,  682,    0, 1096, 1097,    0,
    0,  574,  433,  201,    0,    0,    0,    0,    0,    0,
 -117, 1100,    0, 1099, 1101,    0,    0,    0,    0, 1105,
11127, 1065,    0,  240,    0,    0,  614,    0,18252,    0,
 1098,    0,    0,    0,  726,   39, 1108,    0, 1110, 1111,
 1113,    0,    0,18112,    0,  -38,    0,    0,  751,    0,
 1114,    0,  560,    0,    0, 9080,    0, 9080,10490,    0,
16510,    0,    0,    0,10653,10788,  401,11730,    0,  154,
   81,    0, 1063, 1059,    0,    0,    0,  814,    0,    0,
 1122, 1124,    0,    0,    0,    0,    0, 1127,    0,    0,
    0, 1129,    0, 2102,  598,    0,  598,    0,    0,    0,
    0, 9080,    0,    0, 9080,   -9,    0,18112,    0,    0,
    0,18112,10346,    0,    0,  598, 1131,   98,    0,    0,
    0,18112,    0, 1130, 1092,    0,    0,    0,    0,    0,
    0,    0,10346,    0,    0,  -38,19691, 1165,    0,    0,
    0,    0,    0,    0,    0,  999,  820,    0,    0,    0,
    0,    0,    0,17692,    0,    0,    0,  -38,    0,    0,
17272,    0,    0,    0,    0,    0,10168,    0,10329, 1136,
    0,    0, 1140,  -38,18928,    0,    0,    0,10949,    0,
    0, 1223,    0, 1226,    0,    0,    0,  959,    0, 1143,
    0,    0,  856,    0,    0,    0,  682,    0,    0, 1104,
    0, -149,    0,  682,    0,    0, 1049, 1148, 1154, 1109,
 1162, 1065,    0, 1155,    0, 1279, 1281,    0,    0,11730,
    0,17832, 1160,  726,10966,10346,    0,    0,   91, 1284,
 1285,  131, 1157,    0,    0,    0,18112,    0,18112, 1263,
    0,    0,    0,17972,    0,  552,17972,  830,    0,    0,
    0,    0, 9703,    0, 1288,  762,11730, 1175,10490, 1176,
    0,  336,    0,  -38,    0,    0,    0, -170,    0,    0,
    0,    0,    0, 1169,    0, 1208,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1177, 1178,    0,  899,
    0,    0,    0,10346,    0,    0,  -38,  539, 1136,    0,
18800, 1260,  680,    0,  449,  -38,    0, 1184,    0, 1187,
    0,    0,    0,    0,11730,    0,11730,    0, -165,11730,
    0,    0,    0,  314,    0,    0,    0,    0, 1188, 1049,
    0,    0,11891,    0,    0,    0, 1191, 4772,    0, 1065,
    0, 1065,    0, 1065,    0,    0,    0,    0,    0,  -38,
 1192, 1160,    0,    0,    0, -129, -132, 1189, 1190,    0,
    0,    0,    0,    0, 1193,10490, 1136, -172,18112,    0,
 1199, 9080,    0,    0,    0,    0,    0, 1206,    0,    0,
 1218,    0,  877,    0,    0,    0,    0,    0, -185,18112,
 1217,    0, 1136, 1219,    0,    0, 1179,   98,    0,18112,
    0, 1167, 1213,    0,    0,    0,    0,    0,19037,    0,
  -38,19037,    0,    0,18928,    0,11730, 1252,11730,    0,
11730,    0,    0,18112,    0,    0, 1101,    0,  561,  910,
    0,    0,    0,    0,  -25,    0,    0,    0, 1231,    0,
    0,    0, 1221,    0,    0,    0,  623,    0, 1222, 1352,
 1353,    0,    0, 1136, 1234, 1136, 1235,    0, 1232,    0,
    0,17972,    0,    0,    0,18112,    0, 1243, -188,    0,
 8756,    0, 1240,    0,    0,    0,   98,    0,    0,    0,
18112,10329,    0,    0,    0,    0,    0,    0, 1271,    0,
 1025, 1241,    0, 1246,    0,    0,11891,  193,  241,    0,
  789, 1247, 1250,17832, 1248,    0,18112,    0,    0,    0,
    0,    0,    0, 9080,    0, -174,    0,    0, 9241,    0,
    0,  102, 9080,    0, 1254,    0,11730,    0,    0,    0,
    0,    0,18112,    0,    0,  433, 1253,  433,  241,10346,
 1247, 1291,    0, 1291,    0, 1247,    0,    0,    0,18112,
    0, 9080,12052,    0,    0,    0,    0,  919,    0,    0,
    0, 1283,11730,18112,    0,  433, 1262,    0, 1214, 1019,
    0,    0, 1257,    0, 1261,    0,   83,    0, 1264, 1216,
    0, 1291,    0,    0, 1291,    0,    0,    0,    0, 1266,
 1114,    0,    0,    0,    0,    0, 1292,    0, -133, 1291,
 1388,    0, 1273,  433,    0,    0,10346,    0,   58, 1275,
    0, 1276,    0, 9080, 9241,11730,    0,    0,    0,    0,
    0,    0, 1265, 1268,    0,    0,17412,    0,19879,  149,
  433, 1278,    0, 1280, 1295,11730, 1282,18112,    0,    0,
 1287,    0, 1286,    0,    0, 1289,    0,    0,    0,13357,
    0, 1293,  149,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -239,13357,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1296,  433,
    0,    0,    0,  -38,    0, 1295,    0,    0,    0, 1294,
19879, 9241,19470,    0,    0,  591,    0,    0,    0,19538,
    0,    0,  149,    0,    0,    0,    0,  138,10346,10346,
  268,10346,  482,  597, 1322,    0,  452,17193,    0, 1355,
    0,    0, 1268,    0,    0,    0,    0,    0,    0, 1943,
 1268, 1297,    0, -130, -128,    0,10346, -111,    0,10346,
    0, 1242, 1300,    0,    0, -276,    0, -181, 4941,    0,
 1298, 1255,    3,  591,12330,    0,18112,    0,    0,    0,
    0,    0, -276,    0, 1301, 1256, 1304, 1302,    0, 1310,
 1267, 1311,  241, 1303, 1299,    0,    0, 1312, 1319, 1349,
    0,  999,    0,  975,    0, 1318, 1314, 1268, -145,    0,
 1313,    0,    0, 1323,    0, 1324, 1321, 1326,    0, 1325,
    0,  241,  241,    0,    0,  241, 1327, 1328,    0,    0,
    0,    0,    0,    0, 1336,   89,    0, 1339,  241, 1462,
 1343,  241,    0,  345,    0,10490, 1305, 1344, 1325,    0,
 1347, 1354,  112, 1357,    0,    0,  241,17832, 1306, 1356,
 1336,    0,    0,13357,    0,  433,  433,    0, 1307, 1358,
 1339,    0, 1363,    0,18112, 1329, 1360, 1343,    0, 1365,
  241,    0,   64,    0, 1348,    0,    0,    0,    0,    0,
13357,    0,  112,  112,    0, 1367,    0, -145,    0,    0,
 -153, 1362,13357,    0,13357,    0,    0,10490, 1359,    0,
    0,    0, 1371, 1323,    0,    0,    0, 1376,    0,  282,
    0,    0,    0, 1291, 1028, 1375,    0,    0,  360,    0,
    0,    0,    0,    0, 1417, 1490,    0,    0,    0,    0,
    0,    0, 1381, 1382,10490,    0,    0,    0,    0,  112,
    0,    0,  359,  359,    0, 1291,    0,    0,    0,   97,
   97, 1373, 1391,    0,    0,    0,    0,    0,    0,17412,
17412,    0,    0,    0,    0,    0,    0,    0,    0, 1384,
 1389,17832,    0,    0,    0,    0, 1390,    0,
  };
  protected static readonly short [] yyRindex = {         1465,
    0,    0, 9402, 1465,    0,    0,    0, 1764,    0,    0,
 3907, 2165,    0,    0,    0,    0,    0, 3907,    0, 1346,
   46,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1769,    0,    0, 1769,    0,    0, 1769,    0,    0,
 1764, 1666, 2625,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1400,    0,    0,    0,    0,    0,    0,    0,
    0,11747,    0, 1393,    0,    0,    0, 1393,    0,    0,
    0,    0,    0,    0, 3589,    0,    0,    0,    0,    0,
    0,    0,    0,   93,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 5812,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 6345, 5749,
 4348,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 6453, 6633, 7038, 7317,
 7813, 8029, 8173, 8317, 8461, 5037, 5363, 3547,    0,    0,
    0,    0,    0,    0,   46,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 6525,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 2233,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1769,    0,    0,
  182,    0,    0,    0,    0,    0,    0, 3954,  355, 4001,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 4608,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1406,    0,    0,    0,    0,    0,    0, 4771,
 1399,    0,    0,    0,    0,    0,    0, 1399,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 3031,    0,
  601, 3181,    0,    0,    0,    0,    0,    0,    0, 3331,
    0, 3181,    0,    0,    0,    0,    0, 1400,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1032,    0,    0,
  301,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1405, 3439,    0,    0, 1393,
    0, 4608,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  167,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 2296,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 4570,    0,    0,
    0,    0,    0,    0,    0, 4048, 4111,  875,    0, 1769,
 1769,    0,10024, -204,    0, 1769, 1783,    0,    0,  317,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  516,19151,    0,
    0,    0,    0, 4608,    0,    0,    0,    0,    0,    0,
    0,    0,19578,    0,    0,    0,    0,    0,    0,    0,
  831,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  335,  951,    0,    0,  272, 1077,    0,    0, 1412,  716,
    0,    0,    0,    0,  303,    0,    0, 5260, 1413,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1419,    0, 2470,    0,    0, -263,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 2881,    0,    0,    0,    0,    0,    0,    0,
    0, 1405,    0,    0,    0,18392, 4608,    0,    0,    0,
    0,    0, 8592,    0,  304,    0,    0,    0,    0,    0,
    0,18392,    0,    0,    0,    0,    0,    0,  225,    0,
  799,    0,    0,    0, 1415,    0,    0,    0,    0, 1399,
    0,    0,    0,    0, 4445,    0, 4608,    0,    0, 4281,
    0, 4608, 5423,    0,    0,    0,    0,    0, -189,    0,
    0,    0,    0,  190,    0,    0,    0,  684,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 5909, 6018, 6127, 6236,    0, 6705,    0,    0,
    0,    0, 6813,    0, 6885,    0,    0, 7144,    0, 7216,
    0, 7389,    0, 7490,    0, 7562,    0, 7663,    0, 7885,
    0, 7957,    0, 8101,    0, 8245,    0, 8389,    0, 8533,
    0, 5200,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 4570,    0,    0,    0,
    0,    0,    0,    0,    0,11908,    0,    0,  924,    0,
    0, 1370,16676,    0,    0,    0,    0,    0,    0,    0,
  770, -238,    0,    0, 1421,    0,    0,    0,    0, 1876,
    0,    0,    0,    0,    0,    0,12213,    0,    0,    0,
  921,    0,    0,    0,12069,19731,    0,    0,  932,  935,
  936,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  851,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1424,    0,    0,    0,    0,    0, 7722,    0,    0,    0,
  324,    0,   -7, 4934,    0,    0,    0,    0,    0,    0,
    0, 1423,    0,    0,    0,    0,    0, 1430,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 2881,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,18392,    0,    0,
    0,    0,    0, 1034,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 4608,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  677,
    0,    0,    0,    0, 1428,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -169,    0,  592,
    0,    0,    0,    0,    0,    0,12069,    0,    0,    0,
    0, -204,    0,10185,    0,    0, 1434,    0,  864,    0,
    0,    0,    0, 1422,    0, 1387, 1392,    0,    0,    0,
    0,    0, 1073,19855,    0,    0,    0,    0,19771,    0,
    0,    0,  941,    0,    0,    0,    0,    0,    0, 2751,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 5097,    0, 5586, 1438,    0,
    0,    0,    0, 1436,    0,    0,    0,  941,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -179,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  698,    0,
    0,    0,    0,    0, 2949,  642,    0,    0,    0, 1437,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  961,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1439,    0,    0,    0,    0,    0,  964,  967,    0,
    0,    0,    0,    0,    0,    0, 1440,  793, 1441,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 5260,    0,    0,    0,    0,    0, 1446,    0,
    0,    0, 1440,    0,    0,    0,    0,18392,    0,    0,
    0,  683,  715,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1421,    0,16511,    0,
    0,    0,    0,    0,19927,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  807,    0,  873,    0,
    0,    0,    0, 1444,    0,  870, 1442,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1452,    0,
    0,    0,    0,    0,    0,    0,18392,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -127,  733,    0,    0,    0,    0,    0,19974,19578,    0,
  361,  521, -219,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -194,    0,
    0, 1033,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,20021,    0,  169,19578,    0,
  530, 1454,    0, 1454,    0,  521,    0,    0,    0,    0,
    0,    0, 1450,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,20068,    0,    0,    0,16949,
    0,    0, 1456,    0,    0,    0,  610,    0,  579,    0,
    0,  596,    0,    0, 1454,    0,    0,    0,    0,    0,
 1458,    0,    0,    0,    0,    0,    0,    0, 3860, 1455,
 -247,    0,    0,  319,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1460,    0,    0,    0,    0,    0,
    0,    0,    0, 3758,    0,    0, 1413,    0,    0,16785,
17031,    0,    0,    0,  790,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  583,    0,    0,    0,19334,
    0,    0,16867,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,19402,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,17113,
    0,    0,    0,    0,    0,  790,    0,    0,    0,    0,
    0,  301,  516,    0,    0,    0,    0,    0,    0,  516,
    0,    0,16785,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 5584,  526,    0,17155,    0,    0,    0,
 5746,    0, 3758,    0,    0,    0,    0,    0,    0,    0,
 3758,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  381,    0,  454,    0,  651,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  825,    0,  725,    0,    0,    0,    0,    0,
    0,    0,19578,  966,    0,    0,    0,    0,    0,    0,
    0, 1453,    0,  508,    0,    0,    0, 3758,    0,    0,
  979,    0,    0,    0,    0,    0,    0,    0,    0, 1459,
    0,19578,19578,    0,    0,19618,    0,    0,    0,    0,
    0,    0,    0,    0, 1461,13087,    0, 1464,19578,18532,
 1469,19578,    0,    0,    0,    0,    0,    0, 1470,    0,
    0,    0,20144,    0,    0,    0,19578,    0,    0,    0,
 1471,    0,    0,  113,    0,12817,12952,    0,    0,    0,
 1475,    0,    0,    0,    0,    0,    0, 1476,    0,    0,
19578,    0, -237,    0,  985,    0,    0,    0,    0,    0,
 1039,    0,19073,20106,    0,    0,    0,    0,    0,    0,
    0,    0, 1525,    0, 1579,    0,    0,    0,  994,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  604,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,20144,
    0,    0,12547,12682,    0,  604,    0,    0,    0,    0,
    0,16421,    0,    0,    0,    0,    0,    0,    0, 1413,
 1413,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
  };
  protected static readonly short [] yyGindex = {            0,
    0, 1794,    0,    0,    0,   -3,  -14, -182,  -47,  -27,
    0, 1846, 1854,  590,    0,    0, -183,    0,    0,    0,
    0,    0,    0,-1278, -800, -227, -557,    0,    0,    0,
    0,    0, -230,    0,    0,    0,  780,    0,  906,    0,
    0,    0,    0,  618,  624,  -17, -231,    0,  -46,    0,
    0, -559,  417,    0,  470, -628, -599, -598, -596, -592,
 -588, -573, -515,    0,    0, -837,    0, -942,    0,  416,
-1297,    0,   38,    0,    0,    0,  581,-1234,    0,    0,
    0,  346,  250,    0,    0,    0,  288,-1214,    0, -287,
 -303, -445,    0,    0,    0, -999,  236,    0,    0, -538,
    0,    0,  302,    0,    0,  275,    0,    0,  382,    0,
 -564, -907,    0,    0,    0,    0,    0, -435,  310,-1457,
  -10,    0,    0,    0,  909,  911,  915, 1115, -560,    0,
    0, -336,  927,  400,    0,-1254,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  198,
    0,    0,    0,    0,    0,    0,    0,    0,  463,    0,
    0,    0, -292,  393,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  477,    0, -541,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  214,    0,    0,  305,    0,
    0,  307,  311,  224,    0,    0,    0,    0,    0,    0,
    0,    0,  556,    0,    0,    0,    0,  -86,    0,  872,
 -316, -340, 1516,    0,  377,    0, -433,    0,  960,    0,
 1593,   65, -301, -278,  -55,  259, 1009,    0,  562,    0,
  -41,  942, -390,    0,    0, -386,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -381,    0,    0,    0,    0,
    0,    0, -269,    0,    0, 1320,    0,    0,  374,    0,
 -366,    0, -279,    0,    0,    0,  922, -939, -315, -134,
  569,    0, 1005,    0, 1308, -600,  -43, -348, 1147,    0,
    0,  795, 1857,    0,    0,    0,    0, 1119,    0,    0,
    0, 1583,    0,    0,    0,    0,    0, 1606,  987,  988,
 1510, -388, 1511,    0,    0,    0,    0,  774,  117,    0,
  771,  844,  984, 1506, 1507, 1505, 1508, 1509,    0, 1504,
    0,    0,    0, 1058, 1361, -579,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -306,  695,    0, -890,
    0,    0,    0,    0,    0, -487,    0,  617,    0,  513,
    0,    0,    0,    0,    0,  737, -577,  -15, -346,    1,
    0, 1790,    0,   62,    0,  100,  101,  140,  147,  151,
  157,  175,  176,  179,  184,    0, -755,    0,    0,    0,
  839,    0,  753,    0,    0,    0,    0,  738, -987,  823,
 -943,    0,  867, -500,    0,    0,    0,    0,    0,    0,
  752,    0,  758,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  669,    0,
    0,    0,    0,    0,    0,    0,    0,  -39,    0, 1409,
  708,    0,    0,    0,    0,  963,    0,    0,    0,    0,
    0,    0, -175,    0,    0,    0,    0,    0, 1529, 1245,
    0,    0,    0,    0, 1531,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  554,    0,    0,    0,    0,    0,
    0,    0,    0,  678,    0,    0,    0,    0,    0,    0,
   20, 1037,    0,    0,    0, 1046,
  };
  protected static readonly short [] yyTable = {           112,
   18,  163,  552,  196,  239,  555,  114,  831,  524,  502,
  481,  775,  837,  466,  608,  469,  266,  164,  265,  465,
  797,  506,  300,  577,  240,  550,  548,  881,  569,  587,
  440,  684,  882,  536,  404,  685,  654, 1010,  319, 1298,
  686,  333,  343,   44, 1152, 1091,  350,  910,  258,  623,
  990,  634,  991,  645,  893,  928,  311, 1127,  877, 1334,
  318,  584,  886,  396,  233,  405,  745,  235,  392,  320,
 1215,  323, 1555,  921, 1526,  633,  522,  358,  168, 1216,
  362, 1305, 1216,  918,  255, 1142, 1075,  805,  758,   53,
 1170,   14,  477,  624,  322, 1390, 1017,  197,  406, 1019,
 1363,   53, 1443,  768,  267, 1157,  751,  444,  802, 1662,
 1563,  255,  390,  322,  759, 1371,  169,  170,  380,  751,
  380, 1450, 1368, 1198,  349, 1510, 1196, 1512, 1078, 1204,
  349, 1343, 1344,  296,  296,   71,   71,  350,  955,   71,
 1447,  381,  296,  381, 1518,  379,  760,  112,  239,  163,
  382,  751,  339,  339,  114, 1204,  171,  383,  390,  751,
  445, 1663,  198,  172,  725,  164,  930,  173,  467, 1075,
  506,  935,  936,  174, 1075,  339, 1075,  921,  929, 1075,
 1075,  383, 1075, 1075,  944, 1171,  745,  776,  745,   43,
  480,  175,  176, 1527, 1506,  177,  522,  380,  522,   97,
  178, 1681, 1508,  256, 1306,  504,  507,  806, 1075,   97,
  467, 1078,  919,  256, 1116,  298, 1078,   53, 1078,  511,
  381, 1078, 1078,  237, 1078, 1078,  168,  382,  268,  823,
  256,  921,  256,  298,  383,  505,  502, 1217,  481, 1564,
 1217,  510,  860,  745,  829,  579, 1369,  472, 1091,  520,
 1078,  265,  257,  522,  761,  623,  535,   15,  608, 1562,
 1157,  265,  257, 1075,  169,  170,  859,  339,  339,  769,
  992,  478, 1265,  576,  299,  118,  580,  380,  523,  257,
  873,  257,  575,  527,  529,  608,  396,  582, 1027, 1199,
  897, 1511,  299, 1513,  977,  762, 1631,  586,  559,  624,
  381,  900, 1091, 1037,  171, 1078,  572,  382,  574,  597,
 1519,  172,  527, 1378,  573,  173,    6,  389,  118, 1649,
  895,  174,  118, 1655,  298,  899,  901, 1533,  589,  590,
  624,  916,    2,  339,  296, 1665, 1002, 1666, 1356,  175,
  176, 1287,  297,  177, 1593,  607,  348,  637,  178,  807,
  631,  642, 1702,  869,  839,  507,  507, 1307,  872,  339,
 1293,  609,  841,  851, 1091,  390, 1211, 1620, 1657, 1658,
 1091,  554,  630, 1627,  854,  767, 1244,  421,  687,  339,
  265, 1325,  902,  299,  505,  651, 1114,  393,  515,  659,
  660,  661,  662,  663,  664,  665,  666,  667,  668,  669,
 1329,  727,  729,   20, 1398,  733,  872,  506,  381,  945,
 1096,  237,   16,  422, 1106,  382,  339,  339,  239, 1676,
  327,  724, 1384,  118, 1534, 1693,  752,  767,   49,  298,
  391, 1108,  298,  334,  344,  269, 1379,  383,  467,  293,
  294,  295, 1650,  301,  302,  339,  753, 1134,  315,  316,
 1321, 1699,  624,  917,  321,  324,  388,  326, 1003,  330,
 1357,  237, 1488,  237,  346,  347,  843,   97,   97,  808,
 1137,  872,  516,  795,  840,  803, 1703,  796,  569,  610,
  397,    1,  842,  852,  237,  339, 1120,  982,  299,  743,
  744,  299,  349,  403,  855,  756,  783,  423,  424, 1458,
  903,  200,  507,  793,  779, 1166, 1115, 1168, 1304,  878,
 1173,  965,  339,  339,  913, 1021, 1321, 1310,  437, 1399,
  383,  237,  502, 1486,  383,  999,  638,   20,  853,  826,
  438,  651,  883,  835,  684,  966,  611, 1672,  685, 1020,
  344,  536,  504,  686, 1040, 1673, 1337,  506,  470,  471,
  623,  118,  383,  846,  544,  502,  383,  943,  383,  383,
  383,  383,  967,  857,  298,  505,  383,  861, 1229,  446,
  879,  914, 1487,    6,  884,  885,  639, 1203,  952, 1035,
  874,  784,  358,    2,  118,  870, 1000,  397,  767,  607,
   53,  896,  507,  767,  624,   55,  404,  767,  397,  504,
  397,  870,  397,  908,  908,  609, 1674, 1237, 1383, 1239,
  201, 1240,  767,  237,  512, 1548,  607,  298,  379,  118,
  953,  505,  505,  635,  771, 1141,  767,  405,  772,  905,
  905,  767,  609,  636,  324,  767,  373, 1104,  403,  767,
  522,  926,  201,  560, 1581, 1582,  397, 1274, 1584,  560,
  767,  446,  447,    3,    4,    5,    6,  448,  767,  449,
  558, 1603,  450,  451, 1610,  452,  453, 1163, 1099,  545,
  380,  546,  815,  256,  490,  816,  640,  767,  549, 1626,
  118,  932,  624,  934,  203, 1042,  641,  823, 1004,  773,
  346,  881,  942,  381,  204,  491,  767,  594,  595,  754,
  382,  517, 1474, 1648,  560,  229,  872,  383,  826,  518,
  256,  843,  872,  826,  826,   97,  938, 1312,  250,  872,
  446,  256,  257,  373, 1475,  547,  614, 1132, 1136,   97,
 1680,  754,  507,  815,  447,  490,  816, 1489, 1389,  448,
   53,  449,  555,  379,  450,  451,  339,  452,  453,  984,
  251,  373, 1421, 1347,  252,  373,  491,  368,  129,  257,
  129,  505,  519,  383,  535,  129,  677,  872,  684,  265,
  257,  684,  685,  762,  684,  685,  527,  686,  685,  118,
  686, 1422, 1423,  686, 1424,  997, 1490,  765, 1425,  425,
  426,  835, 1426,  728,  730,  380,  375,  766,  826,  373,
  826, 1421,  797,  447,  253,  237, 1385, 1427,  448,  964,
  449,  765, 1207,  450,  451,  988,  452,  453,  381,  735,
  254,  766, 1401, 1420,  375,  382, 1436, 1162,  454,  829,
 1422, 1423,  383, 1424, 1015, 1391, 1016, 1425,  765, 1032,
 1022, 1426,  393,  380, 1023, 1401,  380, 1069,  766,  578,
  383, 1184,  742,  989, 1028, 1025, 1427,  870,  562,  786,
  908, 1038,  394,  118,  507, 1428,  381,  948,  756,  381,
  507,  563, 1420,  382,  608,  327,  382, 1052,  383,  949,
  383,  687,  383,  265,  368,  383,  362,  383,  564,  794,
  118,  786,  383,  651,  871, 1401,  762,  464, 1175,  651,
  756,  835,  447,  379,  752,  118,  118,  448,  339,  449,
 1154, 1064,  450,  451, 1428,  452,  453,  757, 1155,  968,
 1514,  794,  608, 1126,  753,  794,  969,  339, 1266, 1007,
 1069,  393,  741, 1474, 1528, 1069,  844, 1069,  791,  270,
 1069, 1069,  380, 1069, 1069, 1245,  790,  339,  788,  757,
 1099,  578,  826,  794,  523,  380, 1546,  368,  121,  337,
  337,   97,  794,  368,  327,  381,  791,  926,   97, 1301,
 1475, 1121,  382,  368,  790,  791, 1123,  368,  381, 1123,
  788,  563,  337,  790,  788,  382,  327,  616, 1071,  826,
  368,  835,  383,  211,  617, 1255,  736, 1468,  847, 1087,
 1153,  121,  393,  345, 1480,  121,  618, 1256,  229,  926,
  232,  775, 1336,  993,   45, 1184,  924,  993,  608,  993,
  925,  206,  368,  433, 1069,  119,  541,  923,  427,  428,
  542,  616, 1499,  974, 1503,  327,  507, 1614,  617,  229,
  339,  234,  429,  430, 1499, 1065, 1503,  826,  882,  826,
  618, 1160,  826, 1193,  899,  879,  882, 1161,  899, 1197,
  899,  879,  899,  879,  118, 1183,  118,  434,  119,  883,
  337, 1071,  119,  883,  337,  337, 1071,  883, 1071,  778,
  435, 1071, 1071,  779, 1071, 1071,  888,  555,  481,  502,
  888,  436,  888,  555,  888,  608,  342,  342,  835, 1667,
 1438,  527,  306, 1316,  306,  439,  121,  813,  554,  306,
  118,  814,  824,  118, 1052,  687,  542,  265,  687,  342,
  265,  687, 1223,  265,  431,  432,  985, 1190, 1065, 1191,
  986, 1192, 1230, 1065,  304, 1065, 1689,  870, 1065, 1065,
  337, 1065, 1065,  368,  368,  468,  368,  368,   64,  826,
 1471,  826,  339,  826,  474,  368, 1241, 1471, 1710, 1711,
  555,  368,  118, 1289,  476, 1071,  337, 1290,  879,  503,
  879,  368,  879,  119,  718,  368,  718,  348,  337, 1525,
  186, 1248,  186,  118,  186,  356,  337, 1006,  368, 1014,
  525, 1007,  337, 1036, 1123,  373, 1525,  779,  523,  373,
  507,  368,  373, 1128,  373,  607,  946, 1007, 1024,  373,
  946,  342,  342, 1275,  835, 1557,  870, 1558,  501,  237,
  368,  609, 1065,  337,  337,  303,  950,  304, 1031, 1183,
  950,  397,  578, 1286,  121, 1075,  523,   72,  239,  523,
 1319,   72,  256,  373,  398,  882,  199,  551,  199,  882,
  199,  368,  337,  607,  368,  598,  599,  337,  467,  826,
 1320,  600,  601,  399,  400, 1315,  526,  121,  239,  609,
  702,  704,  706,  708, 1151, 1233,  917,  342, 1235,  418,
  419,  420,  523,  401, 1099, 1246,  556, 1247,  467, 1343,
 1344,  257,  337,  394,  402,  826, 1241, 1112,  890, 1112,
  890,  119,  121,  342,  557,  174, 1319,  174,  181,  182,
  181,  182, 1071, 1072,  368,  342, 1020,  560, 1020,  337,
  337, 1107,  871,  342,  561,  368, 1320,  368,  871,  342,
  507,  581, 1400, 1419,  119,  871,   74,  205,   74,  205,
  175,  583,  175,  134,  585,  134,  368,  368,  826,  607,
  337,  628, 1320,  753,  339, 1400,  312,  593,  312,  651,
  342,  342,  141,  683,  141,  609,  368,  643,  826,  119,
  523,  319,  629,  319,  368, 1320,  739,  368, 1279, 1280,
  118,  777, 1419,  871,  996, 1140,  998, 1454,  757,  342,
 1352,  237,  381,  474,  342, 1677, 1678,  459,  459,  460,
  460,  780,  753, 1001, 1001, 1400,  767,  767, 1716,  693,
  695,  782,  698,  700,  710,  712,  381,  118,  810,  804,
  118,  339,  811,  118,  812, 1320,  607,  809,  849,  342,
  119,  850,  856, 1188,  858, 1479,  567,  862,  863,  864,
  449,  865,  609,  339,  887,   24,  888,   25,  561,  891,
   26,  449,  892,  449,  561,   27,  342,  342,  894,   28,
  898,  911,  121,  337,   39,  912,  931,  933,   30,  937,
  387,  946,  449,  449,  947,   32,  578,  956,  957,  118,
   33,  960,  972,  978,   34, 1005,   43,  979,  980, 1537,
  981,  987,  449, 1479,  337,  200,   36, 1008,   37, 1011,
  449,  917,   38,  449, 1009,  339, 1026, 1034, 1029,  561,
   39,   40, 1030, 1047,   41, 1051, 1066,  568, 1594, 1068,
 1073, 1082,  118,  339,  339, 1077,  554,  118, 1083,  119,
 1085,  118, 1086, 1088, 1091, 1621, 1093, 1100,  753, 1112,
 1113, 1116, 1122, 1131, 1145,  545,  121, 1138, 1633, 1635,
 1146,  339, 1149,  337,  339,  753,  407, 1159,  835, 1164,
  118, 1176, 1150, 1479, 1165, 1186, 1200, 1201,  753,  753,
  523, 1194, 1202,  121, 1210, 1621, 1621,  408,  409,  410,
  411,  412,  413,  414,  415,  416,  417, 1643,  121,  121,
 1212, 1213, 1224, 1231, 1226,  753,  753, 1232, 1238, 1228,
  342, 1250,  387,  338,  338, 1254, 1257, 1258, 1259, 1260,
 1262, 1263,  337,  119, 1267, 1271,  337, 1278, 1281, 1282,
  835, 1299,  118,  118, 1289, 1290,  338, 1311, 1318, 1330,
 1346,  342, 1621, 1349, 1354, 1351, 1355, 1359, 1358, 1367,
  119, 1364,  337, 1372, 1374, 1380, 1381, 1389, 1432, 1388,
 1434, 1433,  753,  507,  507,  119,  119,  835, 1491, 1505,
 1440, 1437, 1439, 1522, 1444,    5, 1441, 1451, 1509, 1456,
 1531, 1540, 1695, 1695, 1523, 1551, 1532, 1534, 1542, 1704,
 1704, 1543,  651,  651, 1545, 1547, 1553, 1549, 1513, 1554,
  342, 1474, 1560, 1561, 1715, 1570, 1574, 1567, 1573,  357,
  118, 1575, 1577, 1585, 1586,  364,  366,  368,  370,  372,
  374,  376,  378, 1589,  338,  337, 1599, 1604,  338,  338,
 1606,   39, 1618, 1616, 1395,   39, 1615, 1628, 1639, 1619,
 1625, 1663, 1653, 1664,  337, 1629,   39, 1640, 1642, 1645,
 1647,   39, 1660, 1668, 1669,   39, 1679,  121,   39,  121,
 1644, 1671, 1662,  342,  337, 1687, 1688, 1707,  337, 1713,
   39,   39, 1709,    9, 1714,   39,   39,   21, 1108, 1718,
  593,   39,  985,   39,   39,   39,   39,  553,  986,  342,
  720,   39, 1100,  554,  338,   39, 1395,   39,  504, 1001,
  721,  802,  341,  121,   35,  552,  121,   39,  505,   39,
   39,   35,   39,  656, 1484, 1485,   39,   36,  235,   36,
  338,  993,  657,  109,  119,  884,  119,  916,  893,  885,
  951,  952,  338,  917,  790,  953,   39,  345,  337,  368,
  338,  815, 1517,  955,  790, 1520,  338,   39,  137,  767,
  119,  767,  613,  315,  236,  121,  337,  337,  144,  138,
  120,   24,  342,   25,  316,  145,   26,   54,   21, 1177,
  119,   27, 1081,  119, 1284,   28,  683,  338,  338, 1482,
 1285,  342, 1445, 1483,   30,   26, 1335, 1661, 1630, 1670,
 1617,   32, 1646, 1612, 1515, 1535,   33, 1109, 1706, 1110,
   34,  342, 1452, 1111, 1449,  342,  338, 1536, 1698,  975,
 1105,  338,   36, 1636,   37, 1641, 1634, 1697,   38, 1375,
 1559, 1078,  119,  570,  357,  337,   39,   40, 1376,  876,
   41, 1043,    5,   85, 1130,  971,   53, 1214,  306,  993,
  591,  688,  689,  119, 1234, 1236,  338,   53,  714,  718,
  716,  723,   53,  720, 1033,  722,   53, 1297, 1361,   53,
  588,  337,  867, 1457,  441,  909, 1206, 1269, 1261,  337,
  357,   53,   53,  338,  338, 1225,   53,   53, 1195, 1276,
 1268, 1341,   53,  848,   53,   53,   53,   53, 1270, 1308,
 1143,  941,   53,  342,  342,  737,   53,  738,   53, 1455,
 1079, 1348, 1076,    0,  338,    0,    0,    0,   53,    0,
    0,   53,    0,   53,    0,    0,    0,   53,  387,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  671,  673,  675,    0,   53,  588,  588,
  588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
  588,  588,  588,  588,    0,    0,    0,    0,    0,    0,
  676,    0,  342,    0,    0,    0,    0,    0,    0,   24,
    0,   25,    0,  121,   26,    0,    0,    0,    0,   27,
    0,    0,    0,   28,    0,    0,    0,    0,    0,    0,
    0,    0,   30,    0,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,  342,    0,   34,    0,
  683,    0,    0,  683,    0,    0,  683,  338,    0,    0,
   36,    0,   37,    0,    0,    0,   38,    0,    0,    0,
    0,    0,    0,    0,   39,   40,    0,    0,   41,    0,
  119,   85,   26,    0,    0,    0,   26,    0,  338,    0,
    0,    0,    0,    0,    0,    0,    0,   26,    0,    0,
  588,    0,   26,    0,    0,    0,   26,    0,    0,   26,
    0,  337,  121,    0,   40,    0,    0,  119,    0,    0,
  119,   26,   26,  119,    0,    0,   26,   26,    0,    0,
    0,    0,   26,    0,   26,   26,   26,   26,    0,    0,
    0,    0,   26,    0,    0,    0,   26,  338,   26,    0,
    0,    0,    0,  482,    0,  121,    0,    0,   26,    0,
  121,   26,    0,   26,  121,    0,  387,   26,    0,    0,
    0,    0,    0,    0,    0,    0,  483,    0,  337,  119,
    0,    0, 1089,  890,    0,    0,    0,   26,    0,  484,
    0,    0,    0,  121,  486,    0,   23,   26,   26,  487,
  337,  488,  489,  490,  491,    0,  338,    0,    0,  492,
  338,    0,    0,  493,    0,    0,    0, 1494,    0,    0,
    0,    0,  119,    0,    0,  494,    0,  119,  495,    0,
  496,  119,    0,    0,  921,  922,  338,    0,    0,    0,
    0,    0,    0,    0,    0,  565,    0,    0,  342,    0,
    0,    0,  357,    0,  497,  121,  121,    0,    0,    0,
  119,    0,  337,    0,  337,    0,    0,    0,    0,    0,
    0,  337,    0,    0,    0,    0,    0,    0,    0,    0,
  337,  337,    0,  337,    0,    0,    0,    0,    0, 1502,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1502,    0,    0,    0,    0, 1502, 1013,  337,  338,
    0,  337,    0,    0, 1496,  342,   24,    0,   25,    0,
 1502,   26,  119,  119,    0,    0,   27,    0,  338,    0,
   28,    0,    0,  121,    0,    0,    0,  342,    0,   30,
    0,    0, 1502,    0,    0,    0,   32,    0,  338,    0,
    0,   33,  338,    0,    0,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
  357,   40,    0,   38,    0,   40,    0,    0,    0,    0,
    0,   39,   40,    0,    0,   41,   40,    0,   85,    0,
    0,   40,    0,    0,    0,   40,    0,    0,   40,  342,
  119,  342,    0,    0,    0,    0,    0,    0,  342,    0,
   40,   40,    0,    0,    0,   40,   40,  342,  342,  987,
  342,   40,  338,   40,   40,   40,   40,    0,    0,    0,
    0,   40,    0,    0,    0,   40,    0,   40,    0, 1089,
  338,  338,    0,   53,    0,  342,    0,   40,  342,   40,
   40,    0,   40,    0,   53,    0,   40,    0,    0,   53,
    0,    0,    0,   53,    0,    0,   53,    0,    0,    0,
    0,    0,    0,  387,    0,    0,   40,    0,   53,   53,
    0,    0,    0,   53,   53,    0,   40,   40,    0,   53,
    0,   53,   53,   53,   53,    0,    0,    0,    0,   53,
    0,  565,    0,   53,    0,   53,  565,  565,    0,  338,
    0,    0,    0,    0,    0,   53,    0,    0,   53,    0,
   53,    0,    0,    0,   53,    0,    0,    0,    0,  565,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  565,  565,   53,  338,    0,  565,    0,    0,
  565,    0,  565,  338,  565,  565,  565,  565,  588,    0,
    0,    0,  565,    0,    0,    0,  565,    0,    0,    0,
  565,    0,    0,    0,   38,    0,    0,    0,  565,    0,
    0,  565,    0,  565,  565,    0,    0,    0,  565,  565,
    0,  565,  565,  565,  565,  565,  565,  565,  565,  565,
  565,  565,    0,    0,    0,    0, 1158,  565,  565,  565,
    0,  565,  565,    0,    0,    0,  565,  565,    0,  565,
  565,  565,  565,  565,  565,  565,    0,  565,  565,    0,
  565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
    0,  565,  565,  565,  565,  565,  565,  565,  565,  565,
  565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
  565,  565,  565,    0,    0,  565,    0,  565,    0,  565,
    0,    0,  565,    0,    0,  987,  987,    0,  565,    0,
    0,    0,    0,  987,  987,  987,  987,  987,    0,  987,
  987,    0,  987,  987,  987,  987,  987,  987,  987,  987,
  910,    0,    0,    0,  987,    0,  987,  987,  987,  987,
  987,  987,    0,    0,  987,    0,    0,    0,  987,  987,
    0,  987,  987,  987,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  987,    0,  987,    0,  987,  987,    0,
    0,  987,    0,  987,  987,  987,  987,  987,  987,  987,
  987,  987,  987,  987,  987,  338,  987,    0,    0,  987,
  987,    0,    0,  987,  987,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  987,  987,
  987,  987,  987,    0,    0,  987,  987,    0,    0,    0,
  987,  987,    0,    0,  987,    0,    0,    0,    0,  987,
  987,  987,  987,  987,    0,    0,    0,  987,    0,  987,
    0,    0,    0,    0,    0,  987,  987,    0,    0,    0,
    0,    0,  338,    0,    0,    0,    0,    0,    0,    0,
  368,   38,    0,    0,    0,   38,    0,    0,    0,    0,
  987,  987,  987,  987,  338,  987,   38,    0,    0,    0,
    0,   38,  987,    0,    0,   38,    0,    0,   38,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   38,   38,    0,    0,    0,   38,   38,    0,    0,    0,
    0,   38,    0,   38,   38,   38,   38,    0,    0,    0,
    0,   38,    0,    0,    0,   38,    0,   38,    0,    0,
    0,    0,    0,    0,    0,    0,  338,   38,  338,    0,
   38,    0,   38,    0,    0,  338,   38,    0,    0,    0,
    0,    0,    0,    0,  338,  338,    0,  338,    0,    0,
    0,    0,    0,    0,    0,    0,   38,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   38,   38,    0,    0,
    0,    0,  338,    0,    0,  338,  910,  910,    0,    0,
    0,    0,    0,    0,  910,  910,  910,  910,  910,    0,
  910,  910,    0,  910,  910,  910,  910,  910,  910,  910,
  868,    0,    0,    0,    0,  910,    0,  910,  910,  910,
  910,  910,  910,    0,    0,  910,    0,    0,    0,  910,
  910,    0,  910,  910,  910,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  910,    0,  910,    0,  910,  910,
    0,    0,  910,    0,  910,  910,  910,  910,  910,  910,
  910,  910,  910,  910,  910,  910,    0,  910,    0,    0,
  910,  910,    0,    0,  910,  910,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  910,
  910,  910,  910,  910,    0,    0,  910,  910,    0,    0,
    0,  910,  910,    0,    0,  910,    0,    0,    0,    0,
  910,  910,  910,  910,  910,    0,  368,    0,  910,    0,
  910,  368,  368,    0,    0,    0,  910,  910,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  368,    0,    0,    0,    0,    0,
    0,  910,  910,  910,  910,    0,  910,  368,  368,    0,
  358,    0,  368,  910,    0,  368,    0,  368,    0,  368,
  368,  368,  368,    0,    0,    0,    0,  368,    0,    0,
    0,  368,    0,    0,    0,  368,    0,    0,    0,    0,
    0,    0,    0,  368,    0,    0,  368,    0,  368,  368,
    0,    0,    0,  368,  368,    0,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,    0,    0,
    0,    0,  368,  368,    0,    0,  368,  368,    0,    0,
    0,  368,  368,  368,  368,  368,  368,  368,  368,  368,
  368,    0,  368,  368,    0,    0,  368,  368,  368,  368,
  368,    0,    0,  368,  368,    0,    0,    0,  368,  368,
  368,  368,  368,  368,  368,  368,  868,    0,    0,    0,
    0,  868,  868,    0,    0,    0,    0,  368,    0,    0,
  368,    0,  368,    0,  368,  368,    0,  368,    0,    0,
    0,  368,  368,  368,  868,    0,    0,    0,    0,  368,
    0,  368,    0,  368,  368,  368,  368,  868,  868,    0,
  398,    0,  868,    0,    0,  868,    0,  868,  368,  868,
  868,  868,  868,    0,  368,  368,    0,  868,    0,    0,
    0,  868,    0,    0,    0,  868,    0,    0,    0,    0,
    0,    0,    0,  868,  368,    0,  868,    0,  868,  868,
  368,    0,  368,  868,  868,  368,  868,  868,  868,  868,
  868,  868,  868,  868,  868,  868,  868,    0,    0,    0,
    0,    0,  868,  868,    0,    0,  868,  868,    0,    0,
    0,  868,  868,  868,  868,  868,  868,    0,  868,  868,
  868,    0,  868,  868,    0,    0,  868,  868,  868,  868,
    0,    0,    0,  868,  868,    0,    0,    0,  868,  868,
  868,  868,  868,  868,  868,  868,  358,    0,  368,    0,
    0,  358,  358,    0,    0,    0,    0,  868,    0,    0,
  868,    0,  868,    0,  868,    0,    0,  868,    0,    0,
    0,    0,    0,  868,  358,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  358,  358,    0,
    0,    0,  358,    0,    0,  358,    0,  358,    0,  358,
  358,  358,  358,    0,    0,    0,    0,  358,    0,    0,
    0,  358,    0,    0,    0,  358,    0,    0,    0,    0,
    0,    0,    0,  358,    0,    0,  358,    0,  358,  358,
    0,    0,    0,  358,  358,    0,  358,  358,  358,  358,
  358,  358,  358,  358,  358,  358,  358,    0,    0,    0,
    0,    0,  358,  358,    0,    0,  358,  358,    0,    0,
    0,  358,  358,  358,  358,  358,  358,    0,  358,  358,
  358,    0,  358,  358,    0,    0,  358,  358,  358,  358,
    0,    0,    0,  358,  358,    0,    0,    0,  358,  358,
  358,  358,  358,  358,  358,  358,  398,    0,  403,    0,
    0,  398,  398,    0,    0,    0,    0,  358,    0,    0,
  358,    0,  358,    0,  358,    0,    0,  358,    0,    0,
    0,    0,    0,  358,  398,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  398,  398,    0,
    0,    0,  398,    0,    0,  398,    0,  398,    0,  398,
  398,  398,  398,    0,    0,    0,    0,  398,    0,    0,
    0,  398,    0,    0,    0,  398,    0,    0,    0,    0,
    0,    0,    0,  398,    0,    0,  398,    0,  398,  398,
    0,    0,    0,  398,  398,    0,  398,  398,  398,  398,
  398,  398,  398,  398,  398,  398,  398,    0,    0,    0,
    0,    0,  398,  398,  368,    0,  398,  398,    0,    0,
  368,  398,  398,    0,  398,  398,  398,    0,  398,  398,
  398,    0,  398,  398,    0,    0,  398,  398,  398,  398,
    0,    0,    0,  398,  398,    0,    0,    0,  398,  398,
  398,  398,  398,  398,  398,  398,  368,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  398,    0,    0,
  398,    0,  398,    0,    0,    0,    0,   33,    0,    0,
    0,    0,    0,  398,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  368,    0,    0,
    0,  368,  368,    0,  368,  368,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,    0,    0,    0,    0,
    0,  368,  698,    0,  368,  368,    0,    0,    0,  368,
  368,  368,  368,  368,  368,  368,  368,  368,  368,    0,
  368,  368,    0,    0,  368,  368,  368,  368,  368,    0,
    0,  368,  368,    0,    0,    0,  368,  368,  368,  368,
  368,  368,  368,  368,  403,    0,    0,    0,    0,    0,
  403,    0,    0,    0,    0,  368,    0,    0,  368,   27,
  368,    0,  368,    0,    0,  368,    0,    0,    0,    0,
    0,  368,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  698,  403,    0,    0,    0,
  698,    0,  698,  698,  698,  698,  698,  698,  698,  698,
  698,  698,  698,    0,    0,    0,   37,    0,    0,    0,
    0,    0,  698,  698,    0,    0,    0,    0,  698,    0,
  698,    0,  698,    0,  698,  698,  698,  403,    0,    0,
    0,  403,  403,    0,  403,  403,  403,  403,  403,  403,
  403,  403,  403,  403,  403,    0,    0,    0,    0,    0,
    0,  403,    0,   53,  403,  403,    0,    0,    0,  403,
  403,  403,  403,  403,  403,    0,  403,  403,  403,    0,
  403,  403,    0,    0,  403,  403,  403,  403,    0,  698,
    0,  403,  403,    0,    0,    0,  403,  403,  403,  403,
  403,  403,  403,  403,    0,    0,    0,    0,    0,    0,
    7,    0,    0,    0,    0,  403,    0,    0,  403,    0,
  403,    0,  403,   33,   33,  403,    0,    0,   33,    0,
    0,  403,   33,    0,   33,    0,    0,   33,    0,   33,
   33,    0,   33,    0,   33,    0,   33,    0,   33,   33,
   33,   33,    0,    0,   33,   33,    0, 1090,    0,    0,
   33,    0,   33,   33,   33,    0,    0,   33,   33,   33,
    0,   33,    0,    0,   33,    0,   33,   33,   33,   33,
    0,    0,    0,   33,   33,   33,    0,    0,   33,   33,
   33,    0,    0,    0,    0,    0,    0,   33,   33,    0,
   33,   33,    0,   33,   33,   33,    0,    0,    0,   33,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   54,    0,    0,    0,    0,    0,   27,    0,    0,   33,
   27,    0,    0,    0,    0,    0,    0,    0,   33,   33,
   33,   27,    0,    0,    0,    0,   27,    0,   33,    0,
   27,    0,    0,   27,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   27,   27,    0,    0,    0,
   27,   27,    0,   37,    0,    0,   27,   37,   27,   27,
   27,   27,    0,    0,    0,    0,   27,    0,   37,   33,
   27,    0,   27,   37,    0,    0,    0,   37,    0,    0,
   37,    0,   27,    0,    0,   27,    0,   27,    0,    0,
    0,   27,   37,   37,    0,    0,    0,   37,   37,    0,
   53,    0,    0,   37,   53,   37,   37,   37,   37,    0,
    0,   27,    0,   37,    0,   53,    0,   37,    0,   37,
   53,   27,   27,    0,   53,    0,    0,   53,    0,   37,
    0,    0,   37,    0,   37,    0,    0,    0,   37,   53,
   53,    0,    0,    0,   53,   53,    0,    7,    0,    0,
   53,   54,   53,   53,   53,   53,    0,    0,   37,    0,
   53,    0,   54,    0,   53,    0,   53,   54,    0,   37,
    0,   54,    0,    0,   54,    0,   53,    0,    0,   53,
    0,   53,    0,    0,    0,   53,   54,   54,    0,    0,
    0,   54,   54,    0, 1090,    0,    0,   54,   53,   54,
   54,   54,   54,    0,    0,   53,    0,   54,    0,   53,
    0,   54,    0,   54,   53,    0,    0,    0,   53,    0,
    0,   53,    0,   54,    0,    0,   54,    0,   54,    0,
    0,    0,   54,   53,   53,    0,    0,    0,   53,   53,
    0,    0,    0,    0,   53,    0,   53,   53,   53,   53,
    0,    0,   54,    0,   53,    0,    0,   54,   53,    0,
   53,   54,    0,    0,    0,    0,    0,    0,    0,    0,
   53,    0,   54,   53,    0,   53,    0,   54,    0,   53,
    0,   54,    0,    0,   54,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   54,   54,    0,   53,
    0,   54,   54,    0,    0,    0,    0,   54,    0,   54,
   54,   54,   54,    0,    0,    0,    0,   54,    0,    0,
    0,   54,    0,   54,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   54,    0,   56,   54,    0,   54,    0,
    0,    0,   54,   57,   24,   58,   25,    0,    0,   26,
   59,    0,   60,   61,   27,   62,   63,   64,   28,    0,
    0,    0,   54,    0,   65,    0,   66,   30,   67,   68,
   69,   70,    0,    0,   32,    0,    0,    0,   71,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   74,    0,   36,    0,   37,   75,    0,
    0,   38,    0,   76,   77,   78,   79,   80,   81,   39,
   40,   82,   83,   41,   84,    0,   85,    0,    0,   86,
   87,    0,    0,   88,   89,    0,  871,    0,    0,    0,
    0,    0,  871,    0,    0,    0,    0,    0,   90,   91,
   92,   93,   94,    0,    0,   95,   96,    0,    0,    0,
   97,    0,    0,    0,   98,    0,    0,    0,    0,   99,
  100,  101,  102,  103,    0,    0,    0,  104,  871,  105,
    0,    0,    0,    0,    0,  106,  107,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  426,    0,    0,    0,    0,    0,  426,
  108,  109,  110,  111,    0,    0,    0,    0,    0,  871,
    0,    0,  200,    0,  871,    0,  871,  871,  871,  871,
  871,  871,  871,  871,  871,  871,  871,  871,    0,    0,
    0,    0,    0,  871,  871,  426,  871,  871,    0,    0,
    0,  871,  871,  871,  871,  871,  871,  871,  871,  871,
  871,    0,  871,  871,    0,  871,  871,  871,  871,  871,
  871,  871,  871,  871,  871,    0,  871,  871,  871,  871,
  871,  871,  871,  871,  871,  871,  871,  871,  871,  871,
  871,  871,  871,  871,  871,  871,  871,  871,  871,    0,
  871,    0,  871,    0,  871,  871,  871,  871,    0,    0,
  358,  426,    0,  871,    0,    0,    0,    0,    0,  426,
  358,    0,  426,  426,  426,  426,    0,  426,    0,  426,
  426,    0,  426,  426,  426,  426,  426,    0,  426,  426,
  426,  426,  871,  426,  426,  426,  426,  426,  426,  426,
  426,  426,  426,  426,  426,  426,  426,  426,  426,  426,
  426,  426,  426,  426,  426,    0,    0,    0,    0,  358,
    0,  426,    0,    0,  426,    0,    0,    0,    0,    0,
  426,    0,    0,  871,    0,    0,    0,    0,  871,    0,
  871,  871,  871,  871,  871,  871,  871,  871,  871,  871,
  871,  871,    0,    0,    0,    0,    0,  871,  871,    0,
  871,  871,    0,    0,    0,  871,  871,  871,  871,  871,
  871,  871,  871,  871,  871, 1081,  871,  871,    0,  871,
  871,  871,  871,  871,  871,  871,  871,  871,  871,    0,
  871,  871,  871,  871,  871,  871,  871,  871,  871,  871,
  871,  871,  871,  871,  871,  871,  871,  871,  871,  871,
  871,  871,  871,  368,    0,    0,  871,    0,  871,  368,
    0,  871,    0,    0,    0,    0,    0,  871,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  368,    0,    0, 1081,    0,
    0,    0,    0, 1081,    0, 1081, 1081, 1081, 1081, 1081,
 1081, 1081, 1081, 1081, 1081,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1081, 1081,    0,    0,    0,
    0, 1081,    0, 1081,    0, 1081,  368, 1081, 1081, 1081,
    0,  368,    0,  368,  368,  368,  368,  368,  368,  368,
  368,  368,  368,  368,  368,    0,    0,    0,    0,    0,
  368,  368,    0,  368,  368,    0,    0,    0,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,    0,  368,
  368,    0,  368,  368,  368,  368,  368,  368,  368,  368,
  368,  368, 1081,  368,  368,  368,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
  368,  368,  368,  368,  368,    0,  368, 1187,    0,  368,
    0,  368,  368,    0,  368,    0,   24,    0,   25,    0,
  368,   26,    0,    0,    0,    0,   27,    0,    0,    0,
   28,    0,    0,    0,    0,    0,    0,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,  368,    0,
    0,   33,    0,    0,    0,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
    0,    0,    0,   38,    0,    0,    0,    0,    0,    0,
    0,   39,   40,    0,    0,   41,    0,    0,   85,  368,
    0,    0,    0,    0,  368,    0,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,    0,    0,
    0,    0,    0,  368,  368,    0,  368,  368,    0,    0,
    0,    0,  368,  368,  368,  368,  368,  368,  368,  368,
  368,    0,  368,  368,    0,  368,  368,  368,  368,  368,
  368,  368,  368,  368,  368,    0,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,    0,  567,
    0,    0,  368,  387,  368,  567,    0,  368,    0,    0,
    0,  482,    0,  368,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  483,    0,    0,    0,    0,    0,
    0,  567,    0,    0,    0,    0,    0,  484,    0,    0,
    0,    0,  486,    0,    0,    0,    0,  487,    0,  488,
  489,  490,  491,    0,    0,    0,    0,  492,    0,    0,
    0,  493,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  567,  494,    0,    0,  495,  567,  496,  567,
  567,  567,  567,  567,  567,  567,  567,  567,  567,  567,
    0,    0,  693,    0,    0,    0,    0,  567,    0,  567,
  567,    0,  497,    0,  567,  567,  567,  567,  567,  567,
  567,  567,  567,  567,    0,  567,  567,    0,  567,  567,
  567,  567,  567,  567,  567,  567,  567,  567,    0,  567,
  567,  567,  567,  567,  567,  567,  567,  567,  567,  567,
  567,  567,  567,  567,  567,  567,  567,  567,  567,  567,
  567,    0,  563,    0,    0,    0,    0,  567,  563,    0,
    0,    0, 1513,    0,    0,    0,  567,    0,    0,    0,
    0,    0,    0,    0,    0,  693,    0,    0,    0,    0,
  693,    0,  693,  693,  693,  693,  693,  693,  693,  693,
  693,  693,  693,    0,  563,    0,    0,    0,    0,    0,
    0,    0,  693,  693,    0,    0,    0,    0,  693,    0,
  693,    0,  693,    0,  693,  693,  693,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  693,    0,    0,    0,    0,  563,    0,    0,    0,    0,
  563,  693,  563,  563,  563,  563,  563,  563,  563,  563,
  563,  563,  563,  693,    0,  694,    0,    0,    0,    0,
  563,    0,  563,  563,    0,    0,    0,  563,  563,  693,
  563,  563,  563,  563,  563,  563,  563,    0,  563,  563,
    0,  563,  563,  563,  563,  563,  563,  563,  563,  563,
  563,    0,  563,  563,  563,  563,  563,  563,  563,  563,
  563,  563,  563,  563,  563,  563,  563,  563,  563,  563,
  563,  563,  563,  563,    0,  571,    0,    0,    0,    0,
  563,  571,    0,  563,    0,    0,    0,    0,    0,  563,
    0,    0,    0,    0,    0,    0,    0,    0,  694,    0,
    0,    0,    0,  694,    0,  694,  694,  694,  694,  694,
  694,  694,  694,  694,  694,  694,    0,  571,    0,    0,
    0,    0,    0,    0,    0,  694,  694,    0,    0,    0,
    0,  694,    0,  694,    0,  694,    0,  694,  694,  694,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  694,    0,    0,    0,    0,  571,    0,
    0,    0,    0,  571,  694,  571,  571,  571,  571,  571,
  571,  571,  571,  571,  571,  571,  694,    0,  696,    0,
    0,    0,    0,  571,    0,  571,  571,    0,    0,    0,
    0,  571,  694,  571,  571,  571,  571,  571,  571,  571,
    0,  571,  571,    0,  571,  571,  571,  571,  571,  571,
  571,  571,  571,  571,    0,  571,  571,  571,  571,  571,
  571,  571,  571,  571,  571,  571,  571,  571,  571,  571,
  571,  571,  571,  571,  571,  571,  571,    0,  368,    0,
    0,    0,    0,  571,  368,    0,  571,    0,    0,    0,
    0,    0,  571,    0,    0,    0,    0,    0,    0,    0,
    0,  696,    0,    0,    0,    0,  696,    0,  696,  696,
  696,  696,  696,  696,  696,  696,  696,  696,  696,    0,
  368,    0,    0,    0,    0,    0,    0,    0,  696,  696,
    0,    0,    0,    0,  696,    0,  696,    0,  696,    0,
  696,  696,  696,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  696,    0,    0,    0,
    0,  368,    0,    0,    0,    0,  368,    0,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,  368,    0,
    0,    0,    0,    0,    0,    0,  368,    0,  368,  368,
    0,    0,    0,    0,  368,  696,  368,  368,  368,  368,
  368,  368,  368,    0,  368,  368,    0,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,    0,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
    0,  486,    0,    0,  390,    0,  368,  486,    0,  368,
    0,    0,    0,    0,    0,  368,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  390,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  390,    0,    0,  486,    0,  390,    0,    0,  257,    0,
  390,    0,  390,  390,  390,  390,    0,    0,    0,    0,
  390,    0,    0,    0,  390,    0,    0,    0,  390,    0,
    0,    0,    0,    0,    0,    0,  390,    0,    0,  390,
    0,  390,    0,    0,  486,    0,    0,    0,    0,  486,
    0,  486,  486,  486,  486,  486,  486,  486,  486,  486,
  486,  486,    0,    0,    0,  390,    0,    0,    0,  486,
    0,  486,  486,    0,    0,  390,    0,  486,    0,  486,
  486,  486,  486,  486,  486,  486,    0,  486,  486,    0,
  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,
    0,  486,  486,  486,  486,  486,  486,  486,  486,  486,
  486,  486,  486,  486,  486,  486,  486,  486,  486,  486,
  486,  486,  486,    0,  598,  390,  389,    0,    0,  486,
  598,    0,  486,    0,    0,    0,    0,    0,  486,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  389,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  389,    0,    0,    0,  598,  389,    0,    0,
  256,    0,  389,    0,  389,  389,  389,  389,    0,    0,
    0,    0,  389,    0,    0,    0,  389,  368,    0,    0,
  389,    0,    0,  368,    0,    0,    0,  871,  389,    0,
    0,  389,    0,  389,    0,    0,    0,  598,    0,    0,
    0,    0,  598,    0,  598,  598,  598,  598,  598,  598,
  598,  598,  598,  598,  598,    0,    0,  389,    0,  368,
    0,    0,    0,    0,  598,  598,    0,  389,    0,    0,
  598,    0,  598,    0,  598,  871,  598,  598,  598,    0,
  598,  598,    0,  598,  598,  598,  598,  598,  598,  598,
  598,  598,  598,    0,    0,    0,  598,  598,  598,  598,
  598,  598,  598,  598,  598,  598,  598,  598,  598,  598,
  598,  598,  598,  598,  358,  598,    0,  389,  368,    0,
  358,    0,    0,    0,  368,  368,    0,    0,    0,    0,
    0,  598,    0,  368,  368,  368,  368,  368,  368,  368,
  871,  368,    0,  368,  368,    0,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  358,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,  368,    0,
    0,    0,    0,  368,    0,  368,    0,    0,  368,    0,
    0,    0,    0,    0,  368,    0,    0,  358,    0,    0,
    0,    0,  358,    0,  358,  358,  358,  358,  358,  358,
  358,  358,  358,  358,  358,    0,    0,    0,    0,    0,
    0,  358,  426,  640,  358,  358,    0,    0,    0,  640,
  358,  358,  358,    0,  358,  426,  358,  358,  358,    0,
  358,  358,    0,    0,  358,  358,  358,  358,    0,    0,
    0,  358,  358,    0,  426,  426,  358,  358,  358,  358,
  358,  358,  358,  358,    0,  640,    0,    0,    0,    0,
    0,    0,    0,    0,  426,  358,    0,    0,    0,    0,
  358,    0,  426,    0,    0,  426,    0,    0,    0,    0,
    0,  358,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  640,    0,    0,    0,
    0,  640,    0,  640,  640,  640,  640,  640,  640,  640,
  640,  640,  640,  640,    0,    0,    0,    0,    0,    0,
    0,  427,  644,  640,  640,    0,    0,    0,  644,  640,
    0,  640,  427,  640,  427,  640,  640,  640,    0,  640,
  640,    0,    0,  640,  640,  640,  640,    0,    0,    0,
  640,  640,    0,  427,  427,  640,  640,  640,  640,  640,
  640,  640,  640,    0,  644,    0,    0,    0,    0,    0,
    0,    0,    0,  427,  640,    0,    0,    0,    0,    0,
    0,  427,    0,    0,  427,    0,    0,    0,    0,    0,
  640,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  644,    0,    0,    0,    0,
  644,    0,  644,  644,  644,  644,  644,  644,  644,  644,
  644,  644,  644,    0,    0,    0,    0,    0,    0,    0,
  430,  643,  644,  644,    0,    0,    0,  643,  644,    0,
  644,  430,  644,  430,  644,  644,  644,    0,  644,  644,
    0,    0,  644,  644,  644,  644,    0,    0,    0,  644,
  644,    0,  430,  430,  644,  644,  644,  644,  644,  644,
  644,  644,    0,  643,    0,    0,    0,    0,    0,    0,
    0,    0,  430,  644,    0,    0,    0,    0,    0,    0,
  430,    0,    0,  430,    0,    0,    0,    0,    0,  644,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  643,    0,    0,    0,    0,  643,
    0,  643,  643,  643,  643,  643,  643,  643,  643,  643,
  643,  643,    0,    0,    0,    0,    0,    0,    0,  440,
  358,  643,  643,    0,    0,    0,  358,  643,    0,  643,
  440,  643,  440,  643,  643,  643,    0,  643,  643,    0,
    0,  643,  643,  643,  643,    0,    0,    0,  643,  643,
    0,  440,  440,  643,  643,  643,  643,  643,  643,  643,
  643,    0,  358,    0,    0,    0,    0,    0,    0,    0,
    0,  440,  643,    0,    0,    0,    0,    0,    0,  440,
    0,    0,  440,    0,    0,    0,    0,    0,  643,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  358,    0,    0,    0,    0,  358,    0,
  358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
  358,    0,    0,    0,    0,    0,    0,  358,  620,    0,
  358,  358,    0,    0,  620,    0,  358,  358,  358,    0,
  358,    0,  358,  358,  358,    0,  358,  358,    0,    0,
  358,  358,  358,  358,    0,    0,    0,  358,  358,    0,
    0,    0,  358,  358,  358,  358,  358,  358,  358,  358,
  620,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  358,    0,    0,    0,    0,  358,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  358,    0,    0,
  862,    0,    0,    0,    0,    0,  862,    0,    0,    0,
    0,  620,    0,    0,    0,    0,  620,    0,  620,  620,
  620,  620,  620,  620,  620,  620,  620,  620,  620,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  620,  620,
    0,    0,  862,    0,  620,    0,  620,    0,  620,    0,
  620,  620,  620,    0,  620,  620,    0,    0,  620,  620,
  620,  620,  620,  620,  620,  620,  620,    0,    0,    0,
  620,  620,  620,  620,  620,  620,  620,  620,    0,    0,
    0,    0,    0,  862,    0,    0,    0,    0,  862,  620,
  862,  862,  862,  862,  862,  862,  862,  862,  862,  862,
  862,    0,    0,    0,    0,  620,    0,  862,  627,    0,
  862,  862,    0,    0,  627,    0,  862,    0,  862,    0,
  862,    0,  862,  862,  862,    0,  862,  862,    0,    0,
  862,  862,  862,  862,    0,    0,    0,  862,  862,    0,
    0,    0,  862,  862,  862,  862,  862,  862,  862,  862,
  627,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  862,    0,    0,    0,    0,  862,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  862,    0,    0,
  993,    0,    0,    0,    0,    0,  993,    0,    0,    0,
    0,  627,    0,    0,    0,    0,  627,    0,  627,  627,
  627,  627,  627,  627,  627,  627,  627,  627,  627,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  627,  627,
    0,    0,  993,    0,  627,    0,  627,    0,  627,    0,
  627,  627,  627,    0,  627,  627,    0,    0,  627,  627,
  627,  627,    0,    0,    0,  627,  627,    0,    0,    0,
  627,  627,  627,  627,  627,  627,  627,  627,    0,    0,
    0,    0,    0,  993,    0,    0,    0,    0,  993,  627,
  993,  993,  993,  993,  993,  993,  993,  993,  993,  993,
  993,    0,    0,    0,    0,  627,    0,    0,  628,    0,
  993,  993,    0,    0,  628,    0,  993,    0,  993,    0,
  993,    0,  993,  993,  993,    0,  993,  993,    0,    0,
  993,  993,  993,  993,    0,    0,    0,  993,  993,    0,
    0,    0,  993,  993,  993,  993,  993,  993,  993,  993,
  628,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  993,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  993,    0,    0,
  629,    0,    0,    0,    0,    0,  629,    0,    0,    0,
    0,  628,    0,    0,    0,    0,  628,    0,  628,  628,
  628,  628,  628,  628,  628,  628,  628,  628,  628,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  628,  628,
    0,    0,  629,    0,  628,    0,  628,    0,  628,    0,
  628,  628,  628,    0,  628,  628,    0,    0,  628,  628,
  628,  628,    0,    0,    0,  628,  628,    0,    0,    0,
  628,  628,  628,  628,  628,  628,  628,  628,    0,    0,
    0,    0,    0,  629,    0,    0,    0,    0,  629,  628,
  629,  629,  629,  629,  629,  629,  629,  629,  629,  629,
  629,    0,    0,    0,    0,  628,    0,    0,    0,    0,
  629,  629,    0,    0,    0,    0,  629,    0,  629,    0,
  629,    0,  629,  629,  629,    0,  629,  629,    0,    0,
  629,  629,  629,  629,    0,    0,    0,  629,  629,    0,
    0,    0,  629,  629,  629,  629,  629,  629,  629,  629,
    0,  530,    0,  662,    0,    0,    0,    0,    0,   57,
   24,  629,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,  629,    0,    0,
   65,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
    0,    0,    0,    0,    0,    0,  662,    0,    0,    0,
    0,  662,    0,  662,  662,  662,  662,  662,  662,  662,
  662,  662,  662,  662,   90,   91,   92,  262,  531,  663,
    0,   95,   96,  662,  662,    0,    0,    0,    0,  662,
   98,  662,    0,  662,    0,  662,  662,  662,    0,    0,
    0,    0,    0,  662,  662,  662,  662,    0,    0,    0,
  662,  662,    0,    0,    0,  662,  662,  662,  662,  662,
  662,  662,  662,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  662,    0,  108,  532,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  533,  534,    0,
  662,  664,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  663,    0,    0,    0,    0,  663,    0,  663,
  663,  663,  663,  663,  663,  663,  663,  663,  663,  663,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  663,
  663,    0,    0,    0,    0,  663,    0,  663,    0,  663,
    0,  663,  663,  663,    0,    0,    0,    0,    0,  663,
  663,  663,  663,    0,    0,    0,  663,  663,    0,    0,
    0,  663,  663,  663,  663,  663,  663,  663,  663,    0,
    0,    0,    0,    0,  664,    0,    0,    0,    0,  664,
  663,  664,  664,  664,  664,  664,  664,  664,  664,  664,
  664,  664,  667,    0,    0,    0,  663,    0,    0,    0,
    0,  664,  664,    0,    0,    0,    0,  664,    0,  664,
    0,  664,    0,  664,  664,  664,    0,    0,    0,    0,
    0,  664,  664,  664,  664,    0,    0,    0,  664,  664,
    0,    0,    0,  664,  664,  664,  664,  664,  664,  664,
  664,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  664,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  668,    0,    0,    0,  664,    0,
    0,    0,    0,    0,    0,  667,    0,    0,    0,    0,
  667,    0,  667,  667,  667,  667,  667,  667,  667,  667,
  667,  667,  667,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  667,  667,    0,    0,    0,    0,  667,    0,
  667,    0,  667,    0,  667,  667,  667,    0,    0,    0,
    0,    0,  667,  667,  667,  667,    0,    0,    0,  667,
  667,    0,    0,    0,    0,    0,  667,  667,  667,  667,
  667,  667,    0,    0,    0,    0,    0,  668,    0,    0,
    0,    0,  668,  667,  668,  668,  668,  668,  668,  668,
  668,  668,  668,  668,  668,  669,    0,    0,    0,  667,
    0,    0,    0,    0,  668,  668,    0,    0,    0,    0,
  668,    0,  668,    0,  668,    0,  668,  668,  668,    0,
    0,    0,    0,    0,  668,  668,  668,  668,    0,    0,
    0,  668,  668,    0,    0,    0,    0,    0,  668,  668,
  668,  668,  668,  668,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  668,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  670,    0,    0,
    0,  668,    0,    0,    0,    0,    0,    0,  669,    0,
    0,    0,    0,  669,    0,  669,  669,  669,  669,  669,
  669,  669,  669,  669,  669,  669,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  669,  669,    0,    0,    0,
    0,  669,    0,  669,    0,  669,    0,  669,  669,  669,
    0,    0,    0,    0,    0,  669,  669,  669,  669,    0,
    0,    0,  669,  669,    0,    0,    0,    0,    0,  669,
  669,  669,  669,  669,  669,    0,    0,    0,    0,    0,
  670,    0,    0,    0,    0,  670,  669,  670,  670,  670,
  670,  670,  670,  670,  670,  670,  670,  670,  671,    0,
    0,    0,  669,    0,    0,    0,    0,  670,  670,    0,
    0,    0,    0,  670,    0,  670,    0,  670,    0,  670,
  670,  670,    0,    0,    0,    0,    0,  670,  670,  670,
  670,    0,    0,    0,  670,  670,    0,    0,    0,    0,
    0,  670,  670,  670,  670,  670,  670,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  368,  670,    0,
    0,    0,    0,  368,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  670,    0,    0,    0,    0,    0,
    0,  671,    0,    0,    0,    0,  671,    0,  671,  671,
  671,  671,  671,  671,  671,  671,  671,  671,  671,  368,
    0,    0,    0,    0,    0,    0,    0,    0,  671,  671,
    0,    0,    0,    0,  671,    0,  671,    0,  671,    0,
  671,  671,  671,    0,    0,    0,    0,    0,  671,  671,
  671,  671,    0,    0,    0,  671,  671,    0,    0,    0,
    0,    0,  671,  671,  671,  671,  671,  671,  676,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  671,
    0,    0,    0,    0,    0,  368,    0,    0,    0,    0,
    0,    0,    0,  368,    0,  671,  368,    0,  368,  368,
    0,    0,    0,  368,  368,    0,    0,  368,  368,  368,
  368,  368,  368,  368,  368,  368,    0,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  368,  368,    0,
  677,    0,    0,    0,    0,  368,    0,    0,  368,    0,
    0,  676,    0,    0,  368,    0,  676,    0,  676,  676,
  676,  676,  676,  676,  676,  676,  676,  676,  676,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  676,  676,
    0,    0,    0,    0,  676,    0,  676,    0,  676,    0,
  676,  676,  676,    0,    0,    0,    0,    0,    0,    0,
  676,  676,    0,    0,    0,  676,  676,    0,    0,    0,
    0,    0,  678,    0,  676,  676,  676,  676,    0,    0,
    0,    0,    0,  677,    0,    0,    0,    0,  677,  676,
  677,  677,  677,  677,  677,  677,  677,  677,  677,  677,
  677,    0,    0,    0,    0,  676,    0,    0,    0,    0,
  677,  677,    0,    0,    0,    0,  677,    0,  677,    0,
  677,    0,  677,  677,  677,    0,    0,    0,    0,    0,
    0,    0,  677,  677,    0,    0,    0,  677,  677,    0,
    0,    0,    0,    0,  681,    0,  677,  677,  677,  677,
    0,    0,    0,    0,    0,  678,    0,    0,    0,    0,
  678,  677,  678,  678,  678,  678,  678,  678,  678,  678,
  678,  678,  678,    0,    0,    0,    0,  677,    0,    0,
    0,    0,  678,  678,    0,    0,    0,    0,  678,    0,
  678,    0,  678,    0,  678,  678,  678,    0,    0,    0,
    0,    0,    0,    0,  678,  678,    0,    0,    0,  678,
  678,    0,    0,    0,    0,    0,  682,    0,  678,  678,
  678,  678,    0,    0,    0,    0,    0,  681,    0,    0,
    0,    0,  681,  678,  681,  681,  681,  681,  681,  681,
  681,  681,  681,  681,  681,    0,    0,    0,    0,  678,
    0,    0,    0,    0,  681,  681,    0,    0,    0,    0,
  681,    0,  681,    0,  681,    0,  681,  681,  681,    0,
    0,    0,    0,    0,    0,    0,  681,  681,    0,    0,
    0,  681,  681,    0,    0,    0,    0,    0,  684,    0,
    0,    0,  681,  681,    0,    0,    0,    0,    0,  682,
    0,    0,    0,    0,  682,  681,  682,  682,  682,  682,
  682,  682,  682,  682,  682,  682,  682,    0,    0,    0,
    0,  681,    0,    0,    0,    0,  682,  682,    0,    0,
    0,    0,  682,    0,  682,    0,  682,    0,  682,  682,
  682,    0,    0,    0,    0,    0,    0,    0,  682,  682,
    0,    0,    0,  682,  682,    0,    0,    0,    0,    0,
  685,    0,    0,    0,  682,  682,    0,    0,    0,    0,
    0,  684,    0,    0,    0,    0,  684,  682,  684,  684,
  684,  684,  684,  684,  684,  684,  684,  684,  684,    0,
    0,    0,    0,  682,    0,    0,    0,    0,  684,  684,
    0,    0,    0,    0,  684,    0,  684,    0,  684,    0,
  684,  684,  684,    0,    0,    0,    0,    0,    0,    0,
    0,  684,    0,    0,    0,  684,  684,    0,    0,    0,
    0,    0,  687,    0,    0,    0,  684,  684,    0,    0,
    0,    0,    0,  685,    0,    0,    0,    0,  685,  684,
  685,  685,  685,  685,  685,  685,  685,  685,  685,  685,
  685,    0,    0,    0,    0,  684,    0,    0,    0,    0,
  685,  685,    0,    0,    0,    0,  685,    0,  685,    0,
  685,    0,  685,  685,  685,    0,    0,    0,    0,    0,
    0,    0,    0,  685,    0,    0,    0,  685,  685,    0,
    0,    0,    0,    0,  688,    0,    0,    0,  685,  685,
    0,    0,    0,    0,    0,  687,    0,    0,    0,    0,
  687,  685,  687,  687,  687,  687,  687,  687,  687,  687,
  687,  687,  687,    0,    0,    0,    0,  685,    0,    0,
    0,    0,  687,  687,    0,    0,    0,    0,  687,    0,
  687,    0,  687,    0,  687,  687,  687,    0,    0,    0,
    0,    0,    0,    0,    0,  687,    0,    0,    0,    0,
  687,    0,    0,    0,    0,    0,  690,    0,    0,    0,
  687,  687,    0,    0,    0,    0,    0,  688,    0,    0,
    0,    0,  688,  687,  688,  688,  688,  688,  688,  688,
  688,  688,  688,  688,  688,    0,    0,    0,    0,  687,
    0,    0,    0,    0,  688,  688,    0,    0,    0,    0,
  688,    0,  688,    0,  688,    0,  688,  688,  688,    0,
    0,    0,    0,    0,    0,    0,    0,  688,    0,    0,
    0,    0,  688,    0,    0,    0,    0,    0,  691,    0,
    0,    0,  688,  688,    0,    0,    0,    0,    0,  690,
    0,    0,    0,    0,  690,  688,  690,  690,  690,  690,
  690,  690,  690,  690,  690,  690,  690,    0,    0,    0,
    0,  688,    0,    0,    0,    0,  690,  690,    0,    0,
    0,    0,  690,    0,  690,    0,  690,    0,  690,  690,
  690,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  368,  690,    0,    0,  871,    0,    0,
    0,    0,    0,    0,  690,  690,    0,    0,    0,    0,
    0,  691,    0,    0,    0,    0,  691,  690,  691,  691,
  691,  691,  691,  691,  691,  691,  691,  691,  691,  368,
    0,    0,    0,  690,    0,    0,    0,    0,  691,  691,
    0,    0,    0,    0,  691,  871,  691,    0,  691,    0,
  691,  691,  691,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  691,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  691,  691,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  368,  691,
    0,    0,    0,    0,  368,  368,    0,    0,    0,    0,
    0,    0,    0,  368,  368,  691,  368,    0,  368,    0,
  871,  368,    0,  368,  368,    0,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,    0,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,  368,    0,
    0,  602,    0,  368,    0,  368,    0,    0,  368,   57,
   24,   58,   25, 1216,  368,   26,   59,    0,   60,   61,
   27,   62,   63,   64,   28,    0,    0,    0,    0,    0,
   65,    0,   66,   30,   67,   68,   69,   70,    0,    0,
   32,    0,    0,    0,   71,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   74,
    0,   36,    0,   37,   75,    0,    0,   38,    0,   76,
   77,   78,   79,   80,   81,   39,   40,   82,   83,   41,
   84,    0,   85,    0,    0,   86,   87,    0,    0,   88,
   89,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,   93,   94,    0,
    0,   95,   96,    0,    0,    0,   97,    0,    0,    0,
   98,    0,    0,    0,    0,   99,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,    0,    0,    0,    0,
    0,  106,  107,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   56,    0,  108,  603,  110,  111,
    0, 1217,   57,   24,   58,   25,    0,    0,   26,   59,
    0,   60,   61,   27,   62,   63,   64,   28,    0,    0,
    0,    0,    0,   65,    0,   66,   30,   67,   68,   69,
   70,    0,    0,   32,    0,    0,    0,   71,   33,    0,
   72,   73,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   74,    0,   36,    0,   37,   75,    0,    0,
   38,    0,   76,   77,   78,   79,   80,   81,   39,   40,
   82,   83,   41,   84,    0,   85,    0,    0,   86,   87,
    0,    0,   88,   89,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   90,   91,   92,
   93,   94,    0,    0,   95,   96,    0,    0,    0,   97,
    0,    0,    0,   98,    0,    0,    0,    0,   99,  100,
  101,  102,  103,    0,    0,    0,  104,    0,  105,    0,
    0,    0,    0,    0,  106,  107,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  273,    0,    0,    0,  108,
  109,  110,  111,   57,   24,   58,   25,    0,    0,   26,
   59,    0,   60,   61,   27,   62,   63,   64,   28,    0,
    0,    0,    0,    0,   65,    0,   66,   30,   67,   68,
   69,   70,    0,    0,   32,    0,    0,    0,   71,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   74,    0,   36,    0,   37,   75,    0,
    0,   38,    0,   76,   77,   78,   79,   80,   81,   39,
   40,   82,   83,   41,   84,    0,   85,    0,    0,   86,
   87,    0,    0,   88,   89,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,   93,   94,    0,    0,   95,   96,    0,    0,    0,
   97,    0,    0,    0,   98,    0,    0,    0,    0,   99,
  100,  101,  102,  103,    0,    0,    0,  104,    0,  105,
    0,    0,    0,    0,    0,  106,  107,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  602,    0,    0,    0,
  108,  109,  110,  111,   57,   24,   58,   25,    0,    0,
   26,   59,    0,   60,   61,   27,   62,   63,   64,   28,
    0,    0,    0,    0,    0,   65,    0,   66,   30,   67,
   68,   69,   70,    0,    0,   32,    0,    0,    0,   71,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   74,    0,   36,    0,   37,   75,
    0,    0,   38,    0,   76,   77,   78,   79,   80,   81,
   39,   40,   82,   83,   41,   84,    0,   85,    0,    0,
   86,   87,    0,    0,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,   93,   94,    0,    0,   95,   96,    0,    0,
    0,   97,    0,    0,    0,   98,    0,    0,    0,    0,
   99,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,    0,    0,    0,    0,    0,  106,  107,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1086,    0,    0,
    0,  108,  603,  110,  111, 1086, 1086, 1086, 1086,    0,
    0, 1086, 1086,    0, 1086, 1086, 1086, 1086, 1086, 1086,
 1086,    0,    0,    0,    0,    0, 1086,    0, 1086, 1086,
 1086, 1086, 1086, 1086,    0,    0, 1086,    0,    0,    0,
 1086, 1086,    0, 1086, 1086, 1086,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1086,    0, 1086,    0, 1086,
 1086,    0,    0, 1086,    0, 1086, 1086, 1086, 1086, 1086,
 1086, 1086, 1086, 1086, 1086, 1086, 1086,    0, 1086,    0,
    0, 1086, 1086,    0,    0, 1086, 1086,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1086, 1086, 1086, 1086, 1086,    0,    0, 1086, 1086,    0,
    0,    0, 1086,    0,    0,    0, 1086,    0,    0,    0,
    0, 1086, 1086, 1086, 1086, 1086,    0,    0,    0, 1086,
    0, 1086,    0,    0,    0,    0,    0, 1086, 1086,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  646,    0,
    0,    0, 1086, 1086, 1086, 1086,   57,   24,    0,   25,
    0,    0,   26,  260,    0,    0,    0,   27,   62,   63,
    0,   28,    0,    0,   24,    0,   25,   65,    0,   26,
   30,    0,    0,    0,   27,    0,    0,   32,   28,    0,
    0,    0,   33,    0,   72,   73,   34,   30,  647,    0,
    0,    0,    0,    0,   32,  648,    0,    0,   36,   33,
   37,   75,    0,   34,   38,    0,    0,   77,    0,   79,
    0,   81,   39,   40,  261,   36,   41,   37,    0,    0,
    0,   38,    0,  649,    0,    0,   88,   89,    0,   39,
   40,    0,    0,   41,    0,    0,   85,    0,    0,    0,
    0,   90,   91,   92,   93,   94,    0,    0,   95,   96,
    0,    0,    0,    0,    0,    0,    0,   98,    0,    0,
  650,    0,  298,  100,  101,  102,  103,    0,    0,    0,
  104,    0,  105,    0,    0,    0,    0,    0,  106,  107,
    0,    0,    0,    0,    0,    0,   57,   24,    0,   25,
    0,    0,   26,  260,    0,    0,    0,   27,   62,   63,
    0,   28,    0,  108,  109,  110,  111,   65,    0,    0,
   30,    0,    0,    0,    0,    0,    0,   32,    0,    0,
    0,  331,   33,    0,   72,   73,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   75,    0,    0,   38,    0,    0,   77,    0,   79,
    0,   81,   39,   40,  261,    0,   41,    0,    0,    0,
    0,    0,    0,   87,    0,    0,   88,   89,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   90,   91,   92,   93,  815,    0,    0,   95,   96,
    0,    0,    0,  816, 1129,    0,    0,   98,    0,    0,
    0,    0,    0,  100,  101,  102,  103,    0,    0,    0,
  104,    0,  105,    0,    0,    0,    0,    0,  106,  107,
    0,    0,    0,    0,    0,    0,   57,   24,    0,   25,
    0,    0,   26,  260,    0,    0,    0,   27,   62,   63,
    0,   28,    0,  108,  817,  110,  111,   65,    0,  818,
   30,    0,    0,    0,  819,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   72,   73,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   75,    0,    0,   38,    0,    0,   77,    0,   79,
    0,   81,   39,   40,  261,    0,   41,    0,    0,    0,
    0,    0,    0,   87,    0,    0,   88,   89,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   90,   91,   92,   93,  815,    0,    0,   95,   96,
    0,    0,    0,  816,    0,    0,    0,   98,    0,    0,
    0,    0,    0,  100,  101,  102,  103,    0,    0,    0,
  104,    0,  105,    0,    0,    0,    0,    0,  106,  107,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  833,  108,  817,  110,  111,    0,    0,  818,
   57,   24,    0,   25,  819,    0,   26,  260,    0,    0,
    0,   27,   62,   63,    0,   28,    0,    0,  192,    0,
  192,   65,    0,  192,   30,    0,    0,    0,  192,    0,
    0,   32,  192,    0,    0,    0,   33,    0,   72,   73,
   34,  192,    0,    0,    0,    0,    0,    0,  192,    0,
    0,    0,   36,  192,   37,   75,    0,  192,   38,    0,
    0,   77,    0,   79,    0,   81,   39,   40,  261,  192,
   41,  192,    0,    0,    0,  192,    0,   87,    0,    0,
   88,   89,    0,  192,  192,    0,    0,  192,    0,    0,
  192,    0,    0,    0,    0,   90,   91,   92,   93,  309,
    0,    0,   95,   96,    0,    0,    0,  551,  834,    0,
    0,   98,    0,    0,    0,    0,    0,  100,  101,  102,
  103,    0,    0,    0,  104,    0,  105,    0,    0, 1111,
    0,    0,  106,  107,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1041,    0,    0,    0,  108,  310,  110,
  111,   57,   24,    0,   25,    0,    0,   26,  260,    0,
    0,    0,   27,   62,   63,  192,   28,    0,    0,  192,
    0,  192,   65,    0,  192,   30,    0,    0,    0,  192,
    0,    0,   32,  192,    0,    0,    0,   33,    0,   72,
   73,   34,  192,  647,    0,    0,    0,    0,    0,  192,
  648,    0,    0,   36,  192,   37,   75,    0,  192,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  261,
  192,   41,  192,    0,    0,    0,  192,    0,  649,    0,
    0,   88,   89,    0,  192,  192,    0,    0,  192,    0,
    0,  192,    0,    0,    0,    0,   90,   91,   92,   93,
   94,    0,    0,   95,   96,    0,    0,    0,    0,    0,
    0,    0,   98,    0,    0,    0,    0,    0,  100,  101,
  102,  103,    0,    0,    0,  104,    0,  105, 1111,    0,
    0,    0,    0,  106,  107,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  833,    0,    0,    0,  108,  109,
  110,  111,   57,   24,    0,   25,    0,    0,   26,  260,
    0,    0,    0,   27,   62,   63,  192,   28,    0,    0,
   24,    0,   25,   65,    0,   26,   30,    0,    0,    0,
   27,    0,    0,   32,   28,    0,    0,    0,   33,    0,
   72,   73,   34,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,   36,   33,   37,   75, 1044,   34,
   38,    0,    0,   77,    0,   79,    0,   81,   39,   40,
  261,   36,   41,   37,    0,    0,    0,   38,    0,   87,
    0,    0,   88,   89,    0,   39,   40,    0,    0,   41,
    0,    0,   85,    0,    0,    0,    0,   90,   91,   92,
   93,  309,    0,    0,   95,   96,    0,    0,    0,  551,
    0,    0,    0,   98,    0,    0,    0,    0,    0,  100,
  101,  102,  103,    0,    0,    0,  104,    0,  105,    0,
    0,    0,    0,    0,  106,  107,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  833,    0,    0,    0,  108,
  310,  110,  111,   57,   24,    0,   25,    0,    0,   26,
  260,    0,    0,    0,   27,   62,   63,  387,   28,    0,
    0,    0,    0,    0,   65,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   75,    0,
    0,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  261,    0,   41,    0,    0,    0,    0,    0,    0,
   87,    0,    0,   88,   89,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,   93,  309,    0,    0,   95,   96,    0,    0,    0,
  551,    0,    0,    0,   98,    0,    0,    0,    0,    0,
  100,  101,  102,  103,    0,    0,    0,  104,    0,  105,
    0,    0,    0,    0,    0,  106,  107,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  351,    0,
  108,  310,  110,  111,  352,    0,   57,   24,    0,   25,
    0,    0,   26,  260,    0,    0,    0,   27,   62,   63,
    0,   28,    0,    0,    0,    0,    0,   65,    0,    0,
   30,    0,    0,    0,    0,    0,    0,   32,    0,    0,
  353,    0,   33,    0,   72,   73,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   75,    0,    0,   38,    0,    0,   77,    0,   79,
    0,   81,   39,   40,  261,    0,   41,    0,    0,    0,
    0,    0,    0,    0,    0,  354,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   90,   91,   92,  262,  355,    0,    0,   95,   96,
    0,    0,    0,    0,    0,    0,    0,   98,    0,  356,
    0,    0,    0,  100,  101,  102,  103,  994,    0,    0,
  104,    0,  105,  825,    0,    0,    0,    0,  106,  107,
    0,   57,   24,    0,   25,    0,    0,   26,  260,    0,
    0,    0,   27,   62,   63,    0,   28,    0,    0,    0,
    0,    0,   65,  108,  264,   30,  111,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   72,
   73,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   75,    0,    0,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  261,
    0,   41,    0,    0,    0,    0,    0,    0,   87,    0,
    0,   88,   89,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,   93,
  309,    0,    0,   95,   96,    0,    0,    0,    0,  995,
    0,    0,   98,    0,    0,    0,    0,    0,  100,  101,
  102,  103,    0,    0,    0,  104,    0,  105,    0,    0,
    0,    0,    0,  106,  107,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1062,    0,    0,    0,  108,  310,
  110,  111,   57,   24,    0,   25,    0,    0,   26,  260,
    0,    0,    0,   27,   62,   63,    0,   28,    0,    0,
   24,    0,   25,   65,    0,   26,   30,    0,    0,    0,
   27,    0,    0,   32,   28,    0,    0,    0,   33,    0,
   72,   73,   34,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,   36,   33,   37,   75,    0,   34,
   38,    0,    0,   77,    0,   79,    0,   81,   39,   40,
  261,   36,   41,   37,    0,    0,    0,   38,    0,   87,
    0,    0,   88,   89,    0,   39,   40,    0,    0,   41,
    0,    0,  619,    0,    0,    0,    0,   90,   91,   92,
   93,  309,    0,    0,   95,   96,    0,    0,    0,    0,
 1063,    0,    0,   98,    0,    0,    0,    0,    0,  100,
  101,  102,  103,    0,    0,    0,  104,    0,  105,    0,
    0,    0,    0,    0,  106,  107,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  308,    0,    0,    0,  108,
  310,  110,  111,   57,   24,    0,   25,    0,    0,   26,
  260,    0,    0,    0,   27,   62,   63,  387,   28,    0,
    0,   24,    0,   25,   65,    0,   26,   30,    0,    0,
    0,   27,    0,    0,   32,   28,    0,    0,    0,   33,
    0,   72,   73,   34,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,    0,   36,   33,   37,   75,    0,
   34,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  261,   36,   41,   37,    0,    0,    0,   38,    0,
   87,    0,    0,   88,   89,    0,   39,   40,    0,    0,
   41,    0,    0,  568,    0,    0,    0,    0,   90,   91,
   92,   93,  309,    0,    0,   95,   96,    0,    0,    0,
    0,    0,    0,    0,   98,    0,    0,    0,    0,    0,
  100,  101,  102,  103,    0,    0,    0,  104,    0,  105,
    0,    0,    0,    0,    0,  106,  107,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  317,    0,    0,    0,
  108,  310,  110,  111,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,  387,   28,
    0,    0,    0,    0,    0,   65,    0,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,    0,   41,    0,    0,    0,    0,    0,
    0,   87,    0,    0,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,   93,  309,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,    0,    0,    0,    0,    0,  106,  107,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  351,
    0,  108,  310,  110,  111,  352,    0,   57,   24,    0,
   25,    0,    0,   26,  260,    0,    0,    0,   27,   62,
   63,    0,   28,    0,    0,    0,    0,    0,   65,    0,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,  353,    0,   33,    0,   72,   73,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   75,    0,    0,   38,    0,    0,   77,    0,
   79,    0,   81,   39,   40,  261,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,  354,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,  262,  355,    0,    0,   95,
   96,    0,    0,    0,    0,    0,    0,    0,   98,    0,
  356,    0,    0,    0,  100,  101,  102,  103,    0,    0,
    0,  104,    0,  105,  644,    0,    0,    0,    0,  106,
  107,    0,   57,   24,    0,   25,    0,    0,   26,  260,
    0,    0,    0,   27,   62,   63,    0,   28,    0,    0,
    0,    0,    0,   65,  108,  264,   30,  111,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   72,   73,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   75,    0,    0,
   38,    0,    0,   77,    0,   79,    0,   81,   39,   40,
  261,    0,   41,    0,    0,    0,    0,    0,    0,   87,
    0,    0,   88,   89,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   90,   91,   92,
   93,   94,    0,    0,   95,   96,    0,    0,    0,    0,
    0,    0,    0,   98,    0,    0,    0,    0,    0,  100,
  101,  102,  103,    0,    0,    0,  104,    0,  105,    0,
    0,    0,    0,    0,  106,  107,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  825,    0,    0,    0,  108,
  109,  110,  111,   57,   24,    0,   25,    0,    0,   26,
  260,    0,    0,    0,   27,   62,   63,    0,   28,    0,
    0,  547,    0,  547,   65,    0,  547,   30,    0,    0,
    0,  547,    0,    0,   32,  547,    0,    0,    0,   33,
    0,   72,   73,   34,  547,    0,    0,    0,    0,    0,
    0,  547,    0,    0,    0,   36,  547,   37,   75,    0,
  547,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  261,  547,   41,  547,    0,    0,    0,  547,    0,
   87,    0,    0,   88,   89,    0,  547,  547,    0,    0,
  547,    0,    0,  547,    0,    0,    0,    0,   90,   91,
   92,   93,  309,    0,    0,   95,   96,    0,    0,    0,
    0,    0,    0,    0,   98,    0,    0,    0,    0,    0,
  100,  101,  102,  103,    0,    0,    0,  104,    0,  105,
    0,    0,    0,    0,    0,  106,  107,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1178,    0,    0,    0,
  108,  310,  110,  111,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,  547,   28,
    0,    0,  193,    0,  193,   65,    0,  193,   30,    0,
    0,    0,  193,    0,    0,   32,  193,    0,    0,    0,
   33,    0,   72,   73,   34,  193,    0,    0,    0,    0,
    0,    0,  193,    0,    0,    0,   36,  193,   37,   75,
    0,  193,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,  193,   41,  193,    0,    0,    0,  193,
    0,   87,    0,    0,   88,   89,    0,  193,  193,    0,
    0,  193,    0,    0,  193,    0,    0,    0,    0,   90,
   91,   92,   93,   94,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,    0,    0,    0,    0,    0,  106,  107,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1338,    0,    0,
    0,  108, 1179,  110,  111,   57,   24,    0,   25,    0,
    0,   26,  260,    0,    0,    0,   27,   62,   63,  193,
   28,    0,    0,  192,    0,  192,   65,    0,  192,   30,
    0,    0,    0,  192,    0,    0,   32,  192,    0,    0,
    0,   33,    0,   72,   73,   34,  192,    0,    0,    0,
    0,    0,    0,  192,    0,    0,    0,   36,  192,   37,
   75,    0,  192,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  261,  192,   41,  192,    0,    0,    0,
  192,    0,   87,    0,    0,   88,   89,    0,  192,  192,
    0,    0,  192,    0,    0,  192,    0,    0,    0,    0,
   90,   91,   92,   93,  309,    0,    0,   95,   96,    0,
    0,    0,    0,    0,    0,    0,   98,    0,    0,    0,
    0,    0,  100,  101,  102,  103,    0,    0,    0,  104,
    0,  105,    0,    0,    0,    0,    0,  106,  107,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   86,    0,
    0,    0,  108,  310,  110,  111,   86,   86,    0,   86,
    0,    0,   86,   86,    0,    0,    0,   86,   86,   86,
  192,   86,    0,    0,    0,    0,    0,   86,    0,    0,
   86,    0,    0,    0,    0,    0,    0,   86,    0,    0,
    0,    0,   86,    0,   86,   86,   86,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   86,    0,
   86,   86,    0,    0,   86,    0,    0,   86,    0,   86,
    0,   86,   86,   86,   86,    0,   86,    0,    0,    0,
    0,    0,    0,   86,    0,    0,   86,   86,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   86,   86,   86,   86,   86,    0,    0,   86,   86,
    0,    0,    0,    0,    0,    0,    0,   86,    0,    0,
    0,    0,    0,   86,   86,   86,   86,    0,    0,    0,
   86,    0,   86,    0,    0,    0,    0,    0,   86,   86,
    0,    0,    0,    0,  205,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  206,    0,    0,
    0,  351,    0,   86,   86,   86,   86,  352,    0,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,  207,    0,    0,    0,
   65,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,  353,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
  208,  209,  210,  211,    0,  212,  213,  214,  215,  216,
  217,  218,  219,    0,    0,  220,  221,  222,  223,  224,
  225,  226,  227,    0,   90,   91,   92,  262,  355,    0,
    0,   95,   96,    0,    0,    0,    0,    0,    0,    0,
   98,    0,  356,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  351,    0,    0,    0,
    0,  106,  107,    0,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,   33,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
   33,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,   33,   41,    0,    0,    0,   33,    0,
    0,    0,    0,   33,    0,   33,   33,   33,   33,    0,
    0,   33,    0,   33,    0,    0,    0,   33,    0,   90,
   91,   92,  262,  355,    0,    0,   95,   96,    0,   33,
    0,    0,   33,    0,   33,   98,    0,  356,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  363,    0,    0,    0,    0,  106,  107,   33,   57,
   24,    0,   25,    0,    0,   26,  260,    0,   33,   33,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,   33,    0,   33,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,   33,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,   33,   41,
    0,    0,    0,   33,    0,    0,    0,    0,   33,    0,
   33,   33,   33,   33,    0,    0,    0,    0,   33,    0,
    0,    0,   33,    0,   90,   91,   92,  262,  355,    0,
    0,   95,   96,    0,   33,    0,    0,   33,    0,   33,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  365,    0,    0,    0,
    0,  106,  107,   33,   57,   24,    0,   25,    0,    0,
   26,  260,    0,   33,   33,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,   53,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
   53,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,   53,   41,    0,    0,    0,   53,    0,
    0,    0,    0,   53,    0,   53,   53,   53,   53,    0,
    0,   53,    0,   53,    0,    0,    0,   53,    0,   90,
   91,   92,  262,  355,    0,    0,   95,   96,    0,   53,
    0,    0,   53,    0,   53,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  367,    0,    0,    0,    0,  106,  107,   53,   57,
   24,    0,   25,    0,    0,   26,  260,    0,  326,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,   53,    0,   53,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,   53,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,   53,   41,
    0,    0,    0,   53,    0,    0,    0,    0,   53,    0,
   53,   53,   53,   53,    0,    0,    0,    0,   53,    0,
    0,    0,   53,    0,   90,   91,   92,  262,  355,    0,
    0,   95,   96,    0,   53,    0,    0,   53,    0,   53,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  369,    0,    0,    0,
    0,  106,  107,   53,   57,   24,    0,   25,    0,    0,
   26,  260,    0,  327,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,   53,    0,   53,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
   53,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,   53,   41,    0,    0,    0,   53,    0,
    0,    0,    0,   53,    0,   53,   53,   53,   53,    0,
    0,   53,    0,   53,    0,    0,    0,   53,    0,   90,
   91,   92,  262,  355,    0,    0,   95,   96,    0,   53,
    0,    0,   53,    0,   53,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  371,    0,    0,    0,    0,  106,  107,   53,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,  482,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,  483,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,  484,   41,
    0,    0,  485,  486,    0,    0,    0,    0,  487,    0,
  488,  489,  490,  491,    0,    0,    0,    0,  492,    0,
    0,    0,  493,    0,   90,   91,   92,  262,  355,    0,
    0,   95,   96,    0,  494,    0,    0,  495,    0,  496,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  373,    0,    0,    0,
    0,  106,  107,  497,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,  482,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
  483,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,  484,   41,    0,    0,    0,  486,    0,
    0,    0,    0,  487,    0,  488,  489,  490,  491,    0,
    0,    0,    0,  492,    0,    0,    0,  493,    0,   90,
   91,   92,  262,  355,    0,    0,   95,   96,    0,  494,
    0,    0,  495,    0,  496,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  375,    0,    0,    0,    0,  106,  107,  497,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  262,  355,    0,
    0,   95,   96,    0,    0,    0,    0,    0,    0,    0,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  377,    0,    0,    0,
    0,  106,  107,    0,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,  262,  355,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  670,    0,    0,    0,    0,  106,  107,    0,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  262,  355,    0,
    0,   95,   96,    0,    0,    0,    0,    0,    0,    0,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  672,    0,    0,    0,
    0,  106,  107,    0,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,  262,  355,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  674,    0,    0,    0,    0,  106,  107,    0,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  262,  355,    0,
    0,   95,   96,    0,    0,    0,    0,    0,    0,    0,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  692,    0,    0,    0,
    0,  106,  107,    0,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,  262,  355,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  694,    0,    0,    0,    0,  106,  107,    0,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  262,  355,    0,
    0,   95,   96,    0,    0,    0,    0,    0,    0,    0,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  696,    0,    0,    0,
    0,  106,  107,    0,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,  262,  697,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  699,    0,    0,    0,    0,  106,  107,    0,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  262,  697,    0,
    0,   95,   96,    0,    0,    0,    0,    0,    0,    0,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  701,    0,    0,    0,
    0,  106,  107,    0,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,  262,  697,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  703,    0,    0,    0,    0,  106,  107,    0,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  262,  697,    0,
    0,   95,   96,    0,    0,    0,    0,    0,    0,    0,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  705,    0,    0,    0,
    0,  106,  107,    0,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,  262,  697,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  707,    0,    0,    0,    0,  106,  107,    0,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  262,  697,    0,
    0,   95,   96,    0,    0,    0,    0,    0,    0,    0,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  709,    0,    0,    0,
    0,  106,  107,    0,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,  262,  697,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  711,    0,    0,    0,    0,  106,  107,    0,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  262,  697,    0,
    0,   95,   96,    0,    0,    0,    0,    0,    0,    0,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  713,    0,    0,    0,
    0,  106,  107,    0,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,  262,  697,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  715,    0,    0,    0,    0,  106,  107,    0,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  262,  697,    0,
    0,   95,   96,    0,    0,    0,    0,    0,    0,    0,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  717,    0,    0,    0,
    0,  106,  107,    0,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,  262,  697,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  719,    0,    0,    0,    0,  106,  107,    0,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  262,  697,    0,
    0,   95,   96,    0,    0,    0,    0,    0,    0,    0,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  721,    0,    0,    0,
    0,  106,  107,    0,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,  262,  697,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,  100,  101,  102,  103,    0,    0,    0,  104,    0,
  105,  889,    0,    0,    0,    0,  106,  107,    0,   57,
   24,    0,   25,    0,    0,   26,  260,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  108,  264,   30,  111,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  261,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  262,  355,    0,
    0,   95,   96,    0,    0,    0,    0,    0,    0,    0,
   98,    0,    0,    0,    0,    0,  100,  101,  102,  103,
    0,    0,    0,  104,    0,  105,  678,    0,    0,    0,
    0,  106,  107,    0,   57,   24,    0,   25,    0,    0,
   26,  260,    0,    0,    0,   27,   62,   63,    0,   28,
    0,    0,    0,    0,    0,   65,  108,  264,   30,  111,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  261,    0,   41,    0,    0,   85,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,  262,  263,    0,    0,   95,   96,    0,    0,
    0,    0,    0,    0,    0,   98,    0,    0,    0,    0,
    0,    0,  679,  680,    0,    0,  213,    0,    0,    0,
  681,  213,    0,    0,    0,  213,    0,  213,    0,    0,
  213,    0,  213,  213,    0,  213,    0,  213,    0,  213,
    0,  213,  213,  213,  213,    0,    0,  213,  213,    0,
    0,  108,  264,  213,  682,  213,  213,  213,    0,    0,
  213,    0,  213,    0,  213,    0,    0,  213,    0,  213,
  213,  213,  213,    0,    0,    0,  213,  213,  213,    0,
    0,  213,  213,  213,    0,    0,    0,    0,    0,    0,
  213,  213,    0,  213,  213,    0,  213,  213,  213,    0,
    0,    0,  213,    0,    0,  530,    0,    0,    0,    0,
    0,    0,  368,   57,   24,    0,   25,    0,    0,   26,
  260,    0,  213,    0,   27,   62,   63,    0,   28,    0,
    0,  213,  213,  213,   65,    0,    0,   30,    0,    0,
    0,  213,    0,    0,   32,    0,    0,    0,  368,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   75,    0,
    0,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  261,  213,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,  262,  531,    0,  368,   95,   96,    0,    0,    0,
    0,    0,    0,    0,   98,  368,  368,  368,  368,  871,
    0,    0,  368,  368,    0,    0,  368,  368,  368,  368,
  368,  368,  368,  368,  368,    0,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
  368,  368,  368,  368,  368,  368,  368,  368,    0,    0,
  108,  532,    0,    0,  368,    0,   54,  368,   54,    0,
   54,    0,   54,    0,    0,   54,    0,   54,   54,    0,
   54,    0,   54,    0,   54,    0,   54,   54,   54,   54,
    0,    0,   54,   54,    0,    0,    0,    0,   54,   54,
   54,   54,   54,    0,    0,   54,    0,   54,    0,   54,
    0,   54,   54,    0,   54,   54,   54,   54,    0,    0,
   54,   54,   54,   54,    0,    0,   54,   54,   54,    0,
    0,    0,    0,    0,    0,   54,   54,    0,   54,   54,
    0,   54,   54,   54,    0,    0,    0,   54,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   54,    0,    0,
    0,    0,    0,   54,   54,   53,    0,    0,    0,   53,
    0,   53,    0,    0,   53,    0,   53,   53,    0,   53,
    0,   53,    0,   53,    0,   53,   53,   53,   53,    0,
    0,   53,   53,    0,    0,    0,    0,   53,    0,   53,
   53,   53,    0,    0,   53,    0,   53,    0,   53,    0,
    0,   53,    0,   53,   53,   53,   53,   54,    0,    0,
   53,   53,   53,    0,    0,   53,   53,   53,    0,    0,
    0,    0,    0,    0,   53,   53,    0,   53,   53,    0,
   53,   53,   53,    0,    0,    0,   53,   53,    0,    0,
    0,   53,    0,   53,    0,    0,   53,    0,   53,   53,
    0,   53,    0,   53,    0,   53,   53,   53,   53,   53,
   53,    0,    0,   53,   53,    0,   89,    0,    0,   53,
    0,   53,   53,   53,    0,   53,   53,    0,   53,    0,
   53,    0,    0,   53,    0,   53,   53,   53,   53,    0,
    0,    0,   53,   53,   53,    0,    0,   53,   53,   53,
    0,    0,    0,    0,    0,    0,   53,   53,    0,   53,
   53,    0,   53,   53,   53,    0,   53,    0,   53,   54,
    0,    0,    0,   54,    0,   54,    0,    0,   54,    0,
   54,   54,    0,   54,    0,   54,    0,   54,   53,   54,
   54,   54,   54,    0,    0,   54,   54,    0,   90,    0,
    0,   54,    0,   54,   54,   54,    0,   53,   54,    0,
   54,    0,   54,    0,    0,   54,    0,   54,   54,   54,
   54,    0,    0,    0,   54,   54,   54,    0,    0,   54,
   54,   54,    0,    0,    0,    0,    0,    0,   54,   54,
    0,   54,   54,    0,   54,   54,   54,    0,   53,    0,
   54,   53,    0,    0,    0,   53,    0,   53,    0,    0,
   53,    0,   53,   53,    0,   53,    0,   53,    0,   53,
   54,   53,   53,   53,   53,    0,    0,   53,   53,    0,
    0,    0,    0,   53,    0,   53,   53,   53,    0,   54,
   53,    0,   53,    0,   53,    0,    0,   53,    0,   53,
   53,   53,   53,    0,    0,    0,   53,   53,   53,    0,
    0,   53,   53,   53,    0,    0,    0,    0,    0,    0,
   53,   53,    0,   53,   53,    0,   53,   53,   53,    0,
   54,    0,   53,   53,    0,    0,    0,   53,    0,   53,
    0,    0,   53,    0,   53,   53,    0,   53,    0,   53,
    0,   53,   53,   53,   53,   53,   53,    0,    0,   53,
   53,    0,  241,    0,    0,   53,    0,   53,   53,   53,
    0,    0,   53,    0,   53,  368,   53,    0,    0,   53,
    0,   53,   53,   53,   53,    0,    0,    0,   53,   53,
   53,    0,    0,   53,   53,   53,    0,    0,  368,    0,
    0,    0,   53,   53,    0,   53,   53,    0,   53,   53,
   53,  368,   53,  482,   53,    0,  368,    0,    0,  368,
    0,  368,    0,  368,  368,  368,  368,    0,    0,    0,
    0,  368,    0,    0,   53,  368,  483,    0,    0,  368,
    0,    0,    0,    0,  242,    0,    0,  368,    0,  484,
  368,    0,  368,    0,  486,    0,    0,    0,    0,  487,
    0,  488,  489,  490,  491,    0,    0,    0,    0,  492,
    0,  368,    0,  493,    0,    0,  368, 1494,    0,    0,
    0,    0,    0,    0,    0,  494,  368,  368,  495,  291,
  496,  368,    0,    0,   53,   57,   24,    0,   25,    0,
    0,   26,  260,    0,  368,    0,   27,   62,   63,    0,
   28,    0,    0,    0,  497,    0,   65,    0,    0,   30,
    0,    0,    0,    0, 1495,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,  368,  647,    0,    0,
    0,    0,    0,    0,  648,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  261,    0,   41,    0,    0,    0,    0,
    0,    0,  649,    0, 1496,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,   93,   94,    0,    0,   95,   96,    0,
    0,    0,    0,    0,    0,    0,   98, 1039,    0,  650,
    0,    0,  100,  101,  102,  103,    0,    0,    0,  104,
    0,  105,    0,    0,    0,    0,    0,  106,  107,    0,
    0,    0,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  260,    0,    0,    0,   27,   62,   63,    0,
   28,    0,  108,  109,  110,  111,   65,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,  647,    0,    0,
    0,    0,    0,    0,  648,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  261,    0,   41,    0,    0,    0,    0,
    0,    0,  649,    0,    0,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,   93,   94,    0,    0,   95,   96,    0,
    0,    0,    0,    0,    0,    0,   98,    0,    0,  650,
    0,    0,  100,  101,  102,  103,    0,    0,    0,  104,
    0,  105,    0,    0,    0,    0,    0,  106,  107,    0,
    0,    0,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  260,    0,    0,    0,   27,   62,   63,    0,
   28,    0,  108,  109,  110,  111,   65,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  261,    0,   41,    0,    0,   85,    0,
    0,    0,   87,    0,    0,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,   93,  309,    0,    0,   95,   96,    0,
    0,    0,    0,    0,    0,    0,   98,    0,    0,    0,
    0,    0,  100,  101,  102,  103,    0,    0,    0,  104,
    0,  105,    0,    0,    0,    0,    0,  106,  107,    0,
    0,    0,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  260,    0,    0,    0,   27,   62,   63,    0,
   28,    0,  108,  310,  110,  111,   65,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  261,    0,   41,    0,    0,   85,    0,
    0,    0,   87,    0,    0,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,   93,  309,    0,    0,   95,   96,    0,
    0,    0,    0,    0,    0,    0,  904,    0,    0,    0,
    0,    0,  100,  101,  102,  103,    0,    0,    0,  104,
    0,  105,    0,    0,    0,    0,    0,  106,  107,    0,
    0,    0,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  260,    0,    0,    0,   27,   62,   63,    0,
   28,    0,  108,  310,  110,  111,   65,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  261,    0,   41,    0,    0,    0,    0,
    0,    0,   87,    0,    0,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,   93,  309,    0,    0,   95,   96,    0,
    0,    0,  551,    0,    0,    0,   98,    0,    0,    0,
    0,    0,  100,  101,  102,  103,    0,    0,    0,  104,
    0,  105,    0,    0,    0,    0,    0,  106,  107,    0,
    0,    0,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  260,    0,    0,    0,   27,   62,   63,    0,
   28,    0,  108,  310,  110,  111,   65,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  261,    0,   41,    0,    0,    0,    0,
    0,    0,   87,    0,    0,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,   93,  309,    0,    0,   95,   96,    0,
    0,    0,  545,    0,    0,    0,   98,    0,    0,    0,
    0,    0,  100,  101,  102,  103,    0,    0,    0,  104,
    0,  105,    0,    0,    0,    0,    0,  106,  107,    0,
    0,    0,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  260,    0,    0,    0,   27,   62,   63,    0,
   28,    0,  108,  310,  110,  111,   65,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  261,    0,   41,    0,    0,    0,    0,
    0,    0,   87,    0,    0,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,   93,  309,    0,    0,   95,   96,    0,
    0,    0,    0,    0,    0,    0,   98,    0,    0,    0,
    0,    0,  100,  101,  102,  103,    0,    0,    0,  104,
    0,  105,    0,    0,    0,    0,    0,  106,  107,    0,
    0,    0,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  260,    0,    0,    0,   27,   62,   63,    0,
   28,    0,  108,  310,  110,  111,   65,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  261,    0,   41,    0,    0,    0,    0,
    0,    0,   87,    0,    0,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,   93,   94,    0,    0,   95,   96,    0,
    0,    0,    0,    0,    0,    0,   98,    0,    0,    0,
    0,    0,  100,  101,  102,  103,    0,    0,    0,  104,
    0,  105,    0,    0,    0,    0,    0,  106,  107,    0,
    0,    0,    0,    0,    0,  722,  722,    0,  722,    0,
    0,  722,  722,    0,    0,    0,  722,  722,  722,    0,
  722,    0,  108,  109,  110,  111,  722,    0,    0,  722,
    0,    0,    0,    0,    0,    0,  722,    0,    0,    0,
    0,  722,    0,  722,  722,  722,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  722,    0,  722,
  722,    0,    0,  722,    0,    0,  722,    0,  722,    0,
  722,  722,  722,  722,    0,  722,    0,    0,    0,    0,
    0,    0,  722,    0,    0,  722,  722,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  722,  722,  722,  722,  722,    0,    0,  722,  722,    0,
    0,    0,    0,    0,    0,    0,  722,    0,    0,    0,
    0,    0,  722,  722,  722,  722,    0,    0,    0,  722,
    0,  722,    0,    0,    0,    0,    0,  722,  722,    0,
    0,    0,    0,    0,    0,  149,  149,    0,  149,    0,
    0,  149,  149,    0,    0,    0,  149,  149,  149,    0,
  149,    0,  722,  722,  722,  722,  149,    0,    0,  149,
    0,    0,    0,    0,    0,    0,  149,    0,    0,    0,
    0,  149,    0,  149,  149,  149,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  149,    0,  149,
  149,    0,    0,  149,    0,    0,  149,    0,  149,    0,
  149,  149,  149,  149,    0,  149,    0,    0,    0,    0,
    0,    0,  149,    0,    0,  149,  149,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  149,  149,  149,  149,  149,    0,    0,  149,  149,    0,
    0,    0,    0,    0,    0,    0,  149,    0,    0,    0,
    0,    0,  149,  149,  149,  149,    0,    0,    0,  149,
    0,  149,    0,    0,    0,    0,    0,  149,  149,    0,
    0,    0,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  260,    0,    0,    0,   27,   62,   63,    0,
   28,    0,  149,  149,  149,  149,   65,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  261,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,  262,  697,    0,    0,   95,   96,    0,
    0,    0,    0,    0,    0,    0,   98,    0,    0,    0,
    0,    0,  100,  101,  102,  103,    0,    0,    0,  104,
    0,  105,    0,   57,   24,    0,   25,  106,  107,   26,
  260,    0,    0,    0,   27,   62,   63,    0,   28,    0,
    0,    0,    0,    0,   65,    0,    0,   30,    0,    0,
    0,    0,  108,  264,   32,  111,    0,    0,    0,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   75,    0,
    0,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  261,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,  262,  355,    0,    0,   95,   96,    0,    0,    0,
    0,    0,    0,    0,   98,    0,    0,    0,    0,    0,
  100,  101,  102,  103,    0,    0,    0,  104,    0,  105,
    0,   57,   24,    0,   25,  106,  107,   26,  260,    0,
    0,    0,   27,   62,   63,    0,   28,    0,    0,    0,
    0,    0,   65,    0,    0,   30,    0,    0,    0,    0,
  108,  264,   32,  111,    0,    0,    0,   33,    0,   72,
   73,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   75,    0,    0,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  261,
    0,   41,    0,    0,   85,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,  262,
  263,    0,    0,   95,   96,    0,    0,    0,    0,    0,
   57,   24,   98,   25,    0,    0,   26,  260,    0,  679,
  680,   27,   62,   63,    0,   28,    0,  681,    0,    0,
    0,   65,    0,    0,   30,    0,    0,    0,    0,    0,
    0,   32,    0,   53,    0,    0,   33,    0,   72,   73,
   34,    0,    0,    0,    0,    0,    0,    0,  108, 1055,
    0,  682,   36,    0,   37,   75,   53,    0,   38,    0,
    0,   77,    0,   79,    0,   81,   39,   40,  261,   53,
   41,    0,    0,   85,   53,    0,    0,    0,    0,   53,
    0,   53,   53,   53,   53,    0,    0,    0,    0,   53,
    0,    0,    0,   53,    0,   90,   91,   92,  262,  263,
    0,    0,   95,   96,    0,   53,    0,    0,   53,    0,
   53,   98,    0,  768,    0,  768,    0,  768,  679,  680,
  768,    0,  768,  768,    0,  768,  681,  768,    0,  768,
    0,  768,  768,  768,   53,    0,    0,  768,  768,    0,
   53,   53,    0,  768,  223,  768,  768,    0,    0,    0,
  768,    0,    0,    0,  768,    0,    0,  108,  264,    0,
  682,    0,    0,    0,    0,  768,  768,    0,  768,    0,
    0,    0,  768,  768,    0,    0,    0,    0,    0,    0,
  768,  768,    0,    0,  768,    0,    0,  768,    0,    0,
   57,   24,  768,   25,    0,    0,   26,  260,    0,    0,
    0,   27,   62,   63,    0,   28,    0,    0,    0,    0,
    0,   65,    0,    0,   30,    0,    0,    0,  768,  768,
    0,   32,    0,    0,    0,    0,   33,    0,   72,   73,
   34,  768,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   75,    0,    0,   38,    0,
    0,   77,    0,   79,    0,   81,   39,   40,  261,    0,
   41,    0,    0,   85,    0,    0,    0,    0,    0,    0,
    0,    0,  768,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   90,   91,   92,  262,  263,
    0,    0,   95,   96,    0,    0,    0,    0,  767,    0,
  767,   98,    0,  767,    0,  767,  767,    0,  767,    0,
  767,    0,  767,    0,  767,  767,  767,    0,    0,    0,
  767,  767,    0,    0,    0,    0,  767,    0,  767,  767,
    0,    0,    0,  767,    0,    0,    0,  767,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  108,  264,  767,
    0,  767,    0,    0,    0,  767,  767,    0,    0,    0,
    0,    0,    0,  767,  767,    0,  767,  767,  767,    0,
  767,  767,    0,  767,  767,  767,  767,    0,  767,    0,
  767,    0,  767,  767,  767,    0,    0,    0,  767,  767,
    0,    0,    0,    0,  767,    0,  767,  767,    0,    0,
    0,  767,    0,    0,    0,  767,    0,    0,    0,    0,
    0,    0,    0,    0,  767,    0,    0,  767,    0,  767,
    0,    0,    0,  767,  767,    0,    0,    0,    0,    0,
    0,  767,  767,    0,   24,  767,   25,    0,  767,   26,
    0,    0, 1459,  767,   27,    0,  771,    0,   28,    0,
  772, 1460, 1461,    0,    0,  767, 1462,   30,    0,    0,
    0,    0, 1463,    0,   32,    0,    0,    0,    0,   33,
    0,    0,    0,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,    0,    0,
    0,   38,    0,    0,    0,    0,    0,    0,    0,   39,
   40,    0,   24,   41,   25,    0, 1464,   26,    0,    0,
 1459, 1465,   27,    0,  771,    0,   28,    0,  772, 1460,
 1461,    0,    0,  767, 1462,   30,    0,    0,    0,    0,
 1463,    0,   32,    0,    0,    0,    0,   33,    0,    0,
    0,   34,   53,    0,   53,    0,    0,   53,    0,    0,
 1466,    0,   53,   36,    0,   37,   53,    0,    0,   38,
    0,    0,    0,    0,    0,   53,    0,   39,   40,    0,
    0,   41,   53,    0, 1464,    0,    0,   53,    0, 1465,
    0,   53,   53,   53,   53,   53,    0,   53,    0,    0,
   53, 1467,   53,   53,    0,   53,   53,    0,    0,   53,
    0,    0,   53,    0,    0,   53,    0,   53,   53,    0,
    0,   53,   53,    0,   53,    0,    0,   53,    0,    0,
    0,   53,    0,   53,    0,   53,    0,    0,    0,    0,
   53,    0,    0,   53,    0,   53,    0,    0,    0,   53,
    0,    0,   53,    0,    0,    0,    0,   53,   53,    0,
    0,   53,    0,  172,   53,   24,    0,   25,    0, 1467,
   26,    0,    0,    0,    0,   27,    0,    0,    0,   28,
    0,    0,    0,    0,    0,    0,    0,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,  172,    0,    0,   34,   54,  616,   54,    0,   53,
   54,    0,    0,  617,    0,   54,   36,    0,   37,   54,
    0,    0,   38,    0,    0,  618,    0,    0,   54,    0,
   39,   40,    0,    0,   41,   54,    0,  619,    0,    0,
   54,    0,    0,    0,   54,   53,   54,   53,   54,   53,
   53,    0,    0,   54,    0,   53,   54,    0,   54,   53,
    0,    0,   54,  620,    0,   54,    0,    0,   53,    0,
   54,   54,    0,    0,   54,   53,    0,   54,    0,    0,
   53,    0,    0,    0,   53,   24,   53,   25,   53,    0,
   26,    0,    0,   53,    0,   27,   53,    0,   53,   28,
    0,    0,   53,   29,    0,   53,    0,    0,   30,    0,
   53,   53,    0,   31,   53,   32,    0,   53,    0,    0,
   33,    0,  621,    0,   34,   35,    0,    0,    0,  202,
    0,  202,    0,    0,  202,    0,   36,    0,   37,  202,
    0,    0,   38,  202,    0,    0,    0,    0,    0,    0,
   39,   40,  202,   24,   41,   25,    0,   42,   26,  202,
 1392,    0,   54,   27,  202,    0,    0,   28,  202,    0,
    0,    0,    0,    0,    0,    0,   30,    0,    0,    0,
  202,    0,  202,   32,    0,    0,  202,    0,   33,    0,
 1393,    0,   34,    0,  202,  202,    0,   39,  202,    0,
    0,  202,   53,    0,   36,    0,   37,    0,   39,    0,
   38, 1394,    0,   39,    0,    0,    0,   39,   39,   40,
   39,    0,   41,    0,    0,   85,    0,    0,    0,    0,
    0,    0,   39,   39,    0,    0,    0,   39,   39,    0,
    0,    0,   43,   39,   37,   39,   39,   39,   39,    0,
    0,    0,    0,   39,    0,   37,    0,   39,    0,   39,
   37,    0,    0,    0,   37,    0,    0,   37,    0,   39,
    0,   39,   39,    0,   39,    0,    0,    0,   39,   37,
   37,    0,    0,    0,   37,   37,  202,    0,    0,    0,
   37,   53,   37,   37,   37,   37,    0,    0,   39,    0,
   37,    0,   53,    0,   37,    0,   37,   53,   39,   39,
  387,   53,    0,    0,   53,    0,   37,    0,    0,   37,
    0,   37,    0,    0,    0,   37,   53,   53,    0,    0,
    0,   53,   53,    0,    0,    0,    0,   53,   53,   53,
   53,   53,   53,    0,    0,   37,    0,   53,    0,   53,
    0,   53,    0,   53,   53,   37,   37,    0,   53,    0,
    0,   53,    0,   53,    0,    0,   53,    0,   53,    0,
    0,    0,   53,   53,   53,    0,   53,    0,   53,   53,
    0,    0,    0,    0,   53,    0,   53,   53,   53,   53,
    0,    0,   53,    0,   53,    0,    0,    0,   53,   53,
   53,    0,   41,    0,    0,    0,    0,    0,    0,    0,
   53,    0,   53,   53,   53,   53,    0,   53,    0,   53,
    0,    0,   53,    0,   53,   53,   53,   53,    0,    0,
    0,    0,   53,    0,    0,    0,   53,   53,    0,   53,
    0,    0,    0,    0,    0,    0,    0,    0,   53,   42,
   53,   53,    0,   53,    0,   53,    0,    0,    0,    0,
   53,    0,   53,   53,   53,   53,    0,    0,    0,    0,
   53,    0,    0,    0,   53,    0,    0,   53,    0,    0,
    0,    0,    0,   53,   53,    0,   53,  225,    0,   53,
    0,   53,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   53,    0,    0,    0,    0,
    0,   53,   53,
  };
  protected static readonly short [] yyCheck = {            17,
    4,   17,  306,   18,   52,  307,   17,  549,  296,  240,
  238,  499,  551,  196,  361,  199,   60,   17,   60,  195,
  521,  253,   69,  330,   52,  305,  305,  605,  321,  345,
  165,  422,  612,  303,  121,  422,  403,  838,   78, 1254,
  422,   88,   89,    6, 1044,    0,   93,  648,   59,  386,
  806,  392,  808,  402,  632,  256,   74,  997,  256, 1294,
   78,  340,  623,  119,   45,  121,  256,   48,  115,   80,
  256,   82, 1530,  268,  256,  392,  256,   95,   17,  268,
   98,  256,  268,  256,  256,  256,  256,  256,  256,  294,
  256,  256,  325,  386,  256, 1374,  852,  256,  145,  855,
 1335,  306, 1400,  256,  256, 1049,  256,  380,  256,  263,
  256,  256,  376,  256,  282, 1350,   17,   17,  395,  339,
  395, 1419,  256,  256,  372,  256,  256,  256,  256, 1117,
  378,  371,  372,  371,  372,  374,  375,  385,  256,  378,
  380,  418,  380,  418,  256,  343,  314,  165,  196,  165,
  425,  371,   88,   89,  165, 1143,   17,  432,  422,  379,
  433,  315,  321,   17,  443,  165,  726,   17,  196,  339,
  402,  731,  732,   17,  344,  111,  346,  372,  379,  349,
  350,    0,  352,  353,  745,  351,  376,  504,  378,  422,
  238,   17,   17,  375, 1473,   17,  376,  395,  378,  371,
   17, 1659, 1481,  375,  379,  252,  253,  376,  378,  371,
  238,  339,  385,  375,  385,  363,  344,  422,  346,  266,
  418,  349,  350,  373,  352,  353,  165,  425,  380,  545,
  375,  426,  375,  363,  432,  253,  467,  426,  466,  385,
  426,  259,  583,  433,  548,  332,  380,  228,  256,  293,
  378,  293,  424,  433,  422,  592,  303,  422,  605, 1538,
 1204,  303,  424,  433,  165,  165,  583,  203,  204,  422,
  809,  234, 1212,  329,  422,   17,  332,  395,  296,  424,
  597,  424,  326,  301,  302,  632,  342,  334,  868,  422,
  639,  422,  422,  422,  256,  479, 1594,  344,  316,  592,
  418,  642,  257,  904,  165,  433,  324,  425,  326,  356,
  422,  165,  330,  256,  325,  165,    0,  266,   60,  256,
  637,  165,   64, 1621,  363,  642,  643,  325,  346,  347,
  623,  256,  358,  269,  268, 1633,  256, 1635,  256,  165,
  165, 1249,  276,  165,  256,  361,  277,  394,  165,  256,
  390,  398,  256,  256,  256,  402,  403,  256,  266,  295,
 1251,  361,  256,  256,  372,  314, 1122,  256, 1623, 1624,
  378,  307,  390, 1588,  256,  263, 1177,  262,  422,  315,
  422, 1289,  256,  422,  402,  403,  256,  357,  256,  407,
  408,  409,  410,  411,  412,  413,  414,  415,  416,  417,
 1291,  448,  449,  335,  256,  452,  314,  639,  418,  746,
  970,  373,  257,  298,  975,  425,  352,  353,  466, 1654,
  390,  439, 1365,  165,  422, 1680,  474,  315,  257,  363,
  379,  341,  363,   88,   89,   62,  379,  256,  466,   66,
   67,   68,  379,   70,   71,  381,  474, 1007,   75,   76,
 1288, 1686,  745,  378,   81,   82,  111,   84,  378,   86,
  378,  373, 1462,  373,   91,   92,  365,  371,  371,  376,
 1009,  379,  340,  520,  376,  522,  380,  521,  771,  376,
  256,  256,  376,  376,  373,  421,  987,  794,  422,  470,
  471,  422,  423,  120,  376,  476,  256,  382,  383, 1442,
  374,  433,  549,  514,  378, 1065,  376, 1067, 1264,  372,
 1070,  272,  448,  449,  376,  856, 1354, 1273,  405,  371,
  339,  373,  753,  256,  343,  372,  377,  335,  575,  547,
  417,  549,  378,  551,  925,  296,  433,  256,  925,  856,
  372,  811,  376,  925,  911,  264, 1302,  779,  203,  204,
  887,  293,  371,  564,  256,  786,  375,  741,  377,  378,
  379,  380,  323,  581,  363,  376,  385,  585, 1148,  256,
  433,  433,  305,  257,  420,  622,  427, 1116,  378,  896,
  598,  341,  600,  358,  326,  596,  433,  363,  272,  605,
  422,  638,  639,  277,  887,  422,  683,  281,  374,  433,
  376,  612,  378,  647,  648,  605,  325, 1167, 1364, 1169,
   21, 1171,  296,  373,  269, 1523,  632,  363,  343,  361,
  420,  639,  433,  422,  277, 1014,  272,  683,  281,  647,
  648,  277,  632,  432,  261,  281,  256,  974,  265,  323,
  295,  688,   53,  372, 1552, 1553,  422, 1227, 1556,  378,
  296,  256,  339,  428,  429,  430,  431,  344,  342,  346,
  315, 1569,  349,  350, 1572,  352,  353, 1056,  972,  371,
  395,  373,  372,  375,  372,  372,  422,  323,  305, 1587,
  422,  728,  975,  730,  305,  917,  432, 1003,  823,  342,
  372, 1269,  739,  418,  305,  372,  342,  352,  353,  339,
  425,  372,  343, 1611,  433,  375,  372,  432,  726,  380,
  375,  365,  378,  731,  732,  371,  734, 1277,  380,  385,
  256,  375,  424,  343,  380,  427,  381, 1006, 1008,  371,
  371,  371,  779,  433,  339,  433,  433,  256,  380,  344,
  422,  346, 1044,  343,  349,  350,  682,  352,  353,  796,
  373,  371, 1381, 1313,  377,  375,  433,  377,  378,  424,
  380,  779,  433,  256,  811,  385,  421,  433, 1159,  811,
  424, 1162, 1159,  957, 1165, 1162,  794, 1159, 1165,  521,
 1162, 1381, 1381, 1165, 1381,  385,  305,  272, 1381,  398,
  399,  809, 1381,  448,  449,  395,  343,  272,  816,  419,
  818, 1430, 1303,  339,  427,  373, 1366, 1381,  344,  772,
  346,  296, 1119,  349,  350,  256,  352,  353,  418,  256,
  380,  296, 1380, 1381,  371,  425, 1386,  379,  433, 1133,
 1430, 1430,  432, 1430,  845, 1377,  847, 1430,  323,  886,
  858, 1430,  357,  395,  862, 1403,  395,  256,  323,  377,
  343, 1083,  380,  294,  872,  866, 1430,  868,  256,  339,
  904,  908,  377,  605,  911, 1381,  418,  294,  339,  418,
  917,  269, 1430,  425, 1221,  390,  425,  924,  371,  306,
  432,  925,  375,  925,  377,  378,  904,  380,  286,  516,
  632,  371,  385,  911,  294, 1453, 1080,  433, 1074,  917,
  371,  919,  339,  343,  952,  647,  648,  344,  844,  346,
  372,  929,  349,  350, 1430,  352,  353,  339,  380,  306,
 1485,  339, 1269,  372,  952,  343,  313,  863, 1216,  378,
  339,  357,  385,  343, 1499,  344,  563,  346,  343,  375,
  349,  350,  395,  352,  353,  385,  343,  883,  339,  371,
 1254,  377,  970,  371,  972,  395, 1521,  357,   17,   88,
   89,  371,  380,  363,  390,  418,  371, 1014,  371, 1257,
  380,  989,  425,  373,  371,  380,  994,  377,  418,  997,
  371,  269,  111,  380,  375,  425,  390,  306,  256, 1007,
  390, 1009,  432,  343,  313,  373,  433, 1443,  286,  962,
 1047,   60,  357,  375, 1450,   64,  325,  385,  375, 1056,
  377, 1499, 1300,  372,    6, 1247,  371,  376, 1365,  378,
  375,  371,  422,  388,  433,   17,  374,  682,  386,  387,
  378,  306, 1468,  308, 1468,  390, 1083, 1576,  313,  375,
  976,  377,  400,  401, 1480,  256, 1480, 1065,  372, 1067,
  325,  372, 1070, 1100,  372,  372,  380,  378,  376, 1106,
  378,  378,  380,  380,  806, 1083,  808,  393,   60,  372,
  199,  339,   64,  376,  203,  204,  344,  380,  346,  374,
  389,  349,  350,  378,  352,  353,  372,  372, 1316, 1320,
  376,  404,  378,  378,  380, 1442,   88,   89, 1116, 1638,
 1388, 1119,  378, 1286,  380,  394,  165,  374, 1044,  385,
  852,  378,  374,  855, 1161, 1159,  378, 1159, 1162,  111,
 1162, 1165, 1140, 1165,  402,  403,  376, 1090,  339, 1092,
  380, 1094, 1150,  344,  373,  346, 1675, 1148,  349,  350,
  269,  352,  353,  374,  375,  422,  377,  378,  379, 1167,
 1443, 1169, 1088, 1171,  419,  357, 1174, 1450, 1700, 1701,
 1462,  363,  904,  375,  422,  433,  295,  379,  376,  256,
  378,  373,  380,  165,  376,  377,  378,  277,  307, 1496,
  374, 1185,  376,  925,  378,  377,  315,  374,  390,  844,
  380,  378,  321,  374, 1212,  371, 1513,  378, 1216,  375,
 1247,  377,  378,  374,  380, 1221,  376,  378,  863,  385,
  380,  203,  204, 1231, 1232, 1532, 1227, 1534,  372,  373,
  422, 1221,  433,  352,  353,  371,  376,  373,  883, 1247,
  380,  364,  377, 1248,  293,  380, 1254,  374, 1286, 1257,
 1288,  378,  375,  419,  377,  376,  374,  371,  376,  380,
  378,  377,  381, 1269,  380,  378,  379,  386, 1286, 1277,
 1288,  366,  367,  396,  397, 1283,  380,  326, 1316, 1269,
  427,  428,  429,  430,  376, 1159,  378,  269, 1162,  390,
  391,  392, 1300,  416, 1588,  376,  256,  378, 1316,  371,
  372,  424,  421,  377,  427, 1313, 1314,  374,  378,  376,
  380,  293,  361,  295,  380,  374, 1354,  376,  374,  374,
  376,  376,  354,  355,  364,  307,  376,  256,  378,  448,
  449,  976,  372,  315,  380,  375, 1354,  377,  378,  321,
 1377,  294, 1380, 1381,  326,  385,  376,  374,  378,  376,
  374,  422,  376,  378,  294,  380,  396,  397, 1366, 1365,
  479,  376, 1380, 1381, 1290, 1403,  378,  343,  380, 1377,
  352,  353,  378,  422,  380, 1365,  416,  422, 1386,  361,
 1388,  378,  380,  380,  424, 1403,  356,  427,  354,  355,
 1122,  379, 1430,  433,  816, 1012,  818, 1434,  373,  381,
  372,  373,  418,  419,  386,  368,  369,  366,  367,  366,
  367,  376, 1430,  371,  372, 1453,  368,  369, 1712,  423,
  424,  376,  425,  426,  431,  432,  418, 1159,  372,  380,
 1162, 1357,  378, 1165,  433, 1453, 1442,  385,  376,  421,
  422,  376,  422, 1088,  294, 1446,  256,  294,  378,  376,
  364,  376, 1442, 1379,  378,  265,  376,  267,  372,  256,
  270,  375,  380,  377,  378,  275,  448,  449,  432,  279,
  432,  375,  521,  592,    0,  256,  294,  294,  288,  385,
  422,  376,  396,  397,  378,  295,  377,  379,  378, 1221,
  300,  377,  385,  376,  304,  427,  422,  378,  378, 1507,
  378,  378,  416, 1504,  623,  433,  316,  376,  318,  371,
  424,  378,  322,  427,  378, 1441,  376,  343,  379,  433,
  330,  331,  421,  378,  334,  376,  294,  337, 1566,  294,
  378,  374, 1264, 1459, 1460,  422, 1462, 1269,  375,  521,
  422, 1273,  371,  379,  256, 1583,  256,  378, 1566,  256,
  256,  385,  280,  256,  376,  371,  605,  372, 1596, 1597,
  343, 1487,  376,  682, 1490, 1583,  385,  298, 1576,  376,
 1302,  374,  385, 1574,  378,  375,  378,  378, 1596, 1597,
 1588,  380,  380,  632,  376, 1623, 1624,  406,  407,  408,
  409,  410,  411,  412,  413,  414,  415, 1605,  647,  648,
  385,  374,  376,  427,  376, 1623, 1624,  385,  347,  421,
  592,  371,  422,   88,   89,  385,  385,  256,  256,  376,
  376,  380,  741,  605,  372,  376,  745,  347,  378,  374,
 1638,  374, 1364, 1365,  375,  379,  111,  374,  376,  339,
  348,  623, 1680,  372,  378,  422,  376,  422,  375,  348,
  632,  376,  771,  256,  372,  371,  371,  380,  371,  385,
  356,  372, 1680, 1700, 1701,  647,  648, 1675,  337,  305,
  375,  380,  376,  422,  372,    0,  378,  372,  372,  376,
  373,  371, 1683, 1684,  375,  377,  422,  422,  375, 1690,
 1691,  380, 1700, 1701,  375,  375,  375,  385,  422,  371,
  682,  343,  375,  380, 1712,  373,  376,  385,  375,   94,
 1442,  376,  378,  377,  377,  100,  101,  102,  103,  104,
  105,  106,  107,  378,  199,  844,  378,  256,  203,  204,
  378,  257,  376,  380, 1379,  261,  422,  422,  422,  376,
  374,  315,  385,  372,  863,  380,  272,  380,  376,  380,
  376,  277,  376,  385,  374,  281,  372,  806,  284,  808,
  422,  376,  263,  745,  883,  375,  375,  385,  887,  376,
  296,  297,  372,    0,  376,  301,  302,  422,    0,  380,
  371,  307,  380,  309,  310,  311,  312,  372,  380,  771,
  376,  317,    0,  372,  269,  321, 1441,  323,  376,  371,
  376,  422,  371,  852,  374,  372,  855,  333,  376,  335,
  336,  372,  338,  376, 1459, 1460,  342,  374,  422,  372,
  295,  376,  376,  422,  806,  376,  808,  372,  380,  376,
  380,  380,  307,  372,  371,  376,  362,  372,  957,  377,
  315,  372, 1487,  376,  380, 1490,  321,  373,  380,  315,
  380,  263,  256,  380,   51,  904,  975,  976,  380,  380,
  380,  265,  844,  267,  380,  380,  270,   12,    5, 1080,
  852,  275,  957,  855, 1247,  279,  925,  352,  353, 1453,
 1247,  863, 1403, 1458,  288,    0, 1296, 1628, 1591, 1644,
 1579,  295, 1608, 1574, 1485, 1504,  300,  979, 1691,  979,
  304,  883, 1430,  979, 1418,  887,  381, 1505, 1685,  785,
  974,  386,  316, 1597,  318, 1601, 1596, 1684,  322, 1354,
 1534,  952,  904,  321,  309, 1044,  330,  331, 1357,  600,
  334,  917,  257,  337, 1003,  779,  261, 1133,   72,  811,
  348,  422,  422,  925, 1161, 1165,  421,  272,  433,  435,
  434,  438,  277,  436,  887,  437,  281, 1253, 1332,  284,
  345, 1080,  592, 1441,  165,  648, 1118, 1221, 1206, 1088,
  355,  296,  297,  448,  449, 1143,  301,  302, 1102, 1232,
 1219, 1303,  307,  565,  309,  310,  311,  312, 1221, 1272,
 1018,  737,  317,  975,  976,  457,  321,  457,  323, 1436,
  954, 1314,  947,   -1,  479,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,   -1,   -1,   -1,  342,  422,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  418,  419,  420,   -1,  362,  423,  424,
  425,  426,  427,  428,  429,  430,  431,  432,  433,  434,
  435,  436,  437,  438,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1, 1044,   -1,   -1,   -1,   -1,   -1,   -1,  265,
   -1,  267,   -1, 1122,  270,   -1,   -1,   -1,   -1,  275,
   -1,   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1, 1088,   -1,  304,   -1,
 1159,   -1,   -1, 1162,   -1,   -1, 1165,  592,   -1,   -1,
  316,   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  330,  331,   -1,   -1,  334,   -1,
 1122,  337,  257,   -1,   -1,   -1,  261,   -1,  623,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  272,   -1,   -1,
  545,   -1,  277,   -1,   -1,   -1,  281,   -1,   -1,  284,
   -1, 1290, 1221,   -1,    0,   -1,   -1, 1159,   -1,   -1,
 1162,  296,  297, 1165,   -1,   -1,  301,  302,   -1,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,  682,  323,   -1,
   -1,   -1,   -1,  261,   -1, 1264,   -1,   -1,  333,   -1,
 1269,  336,   -1,  338, 1273,   -1,  422,  342,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1, 1357, 1221,
   -1,   -1,    0,  628,   -1,   -1,   -1,  362,   -1,  297,
   -1,   -1,   -1, 1302,  302,   -1,  371,  372,  373,  307,
 1379,  309,  310,  311,  312,   -1,  741,   -1,   -1,  317,
  745,   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,
   -1,   -1, 1264,   -1,   -1,  333,   -1, 1269,  336,   -1,
  338, 1273,   -1,   -1,  679,  680,  771,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 1290,   -1,
   -1,   -1,  697,   -1,  362, 1364, 1365,   -1,   -1,   -1,
 1302,   -1, 1441,   -1, 1443,   -1,   -1,   -1,   -1,   -1,
   -1, 1450,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
 1459, 1460,   -1, 1462,   -1,   -1,   -1,   -1,   -1, 1468,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1, 1480,   -1,   -1,   -1,   -1, 1485,  256, 1487,  844,
   -1, 1490,   -1,   -1,  422, 1357,  265,   -1,  267,   -1,
 1499,  270, 1364, 1365,   -1,   -1,  275,   -1,  863,   -1,
  279,   -1,   -1, 1442,   -1,   -1,   -1, 1379,   -1,  288,
   -1,   -1, 1521,   -1,   -1,   -1,  295,   -1,  883,   -1,
   -1,  300,  887,   -1,   -1,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  815,  257,   -1,  322,   -1,  261,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,   -1,  334,  272,   -1,  337,   -1,
   -1,  277,   -1,   -1,   -1,  281,   -1,   -1,  284, 1441,
 1442, 1443,   -1,   -1,   -1,   -1,   -1,   -1, 1450,   -1,
  296,  297,   -1,   -1,   -1,  301,  302, 1459, 1460,    0,
 1462,  307,  957,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,  323,   -1,  257,
  975,  976,   -1,  261,   -1, 1487,   -1,  333, 1490,  335,
  336,   -1,  338,   -1,  272,   -1,  342,   -1,   -1,  277,
   -1,   -1,   -1,  281,   -1,   -1,  284,   -1,   -1,   -1,
   -1,   -1,   -1,  422,   -1,   -1,  362,   -1,  296,  297,
   -1,   -1,   -1,  301,  302,   -1,  372,  373,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,
   -1,  256,   -1,  321,   -1,  323,  261,  262,   -1, 1044,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,
  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  297,  298,  362, 1080,   -1,  302,   -1,   -1,
  305,   -1,  307, 1088,  309,  310,  311,  312, 1003,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,
  325,   -1,   -1,   -1,    0,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,  339,   -1,   -1,   -1,  343,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1, 1051,  362,  363,  364,
   -1,  366,  367,   -1,   -1,   -1,  371,  372,   -1,  374,
  375,  376,  377,  378,  379,  380,   -1,  382,  383,   -1,
  385,  386,  387,  388,  389,  390,  391,  392,  393,  394,
   -1,  396,  397,  398,  399,  400,  401,  402,  403,  404,
  405,  406,  407,  408,  409,  410,  411,  412,  413,  414,
  415,  416,  417,   -1,   -1,  420,   -1,  422,   -1,  424,
   -1,   -1,  427,   -1,   -1,  256,  257,   -1,  433,   -1,
   -1,   -1,   -1,  264,  265,  266,  267,  268,   -1,  270,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,  280,
    0,   -1,   -1,   -1,  285,   -1,  287,  288,  289,  290,
  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,  324,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335, 1290,  337,   -1,   -1,  340,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,   -1,
  371,  372,   -1,   -1,  375,   -1,   -1,   -1,   -1,  380,
  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,  390,
   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,   -1,
   -1,   -1, 1357,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
    0,  257,   -1,   -1,   -1,  261,   -1,   -1,   -1,   -1,
  421,  422,  423,  424, 1379,  426,  272,   -1,   -1,   -1,
   -1,  277,  433,   -1,   -1,  281,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  296,  297,   -1,   -1,   -1,  301,  302,   -1,   -1,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,  323,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1, 1441,  333, 1443,   -1,
  336,   -1,  338,   -1,   -1, 1450,  342,   -1,   -1,   -1,
   -1,   -1,   -1,   -1, 1459, 1460,   -1, 1462,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  372,  373,   -1,   -1,
   -1,   -1, 1487,   -1,   -1, 1490,  256,  257,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,  266,  267,  268,   -1,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
    0,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,
  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,
  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,  371,  372,   -1,   -1,  375,   -1,   -1,   -1,   -1,
  380,  381,  382,  383,  384,   -1,  256,   -1,  388,   -1,
  390,  261,  262,   -1,   -1,   -1,  396,  397,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,  421,  422,  423,  424,   -1,  426,  297,  298,   -1,
    0,   -1,  302,  433,   -1,  305,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  339,
   -1,   -1,   -1,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,   -1,   -1,
   -1,   -1,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,  371,  372,  373,  374,  375,  376,  377,  378,  379,
  380,   -1,  382,  383,   -1,   -1,  386,  387,  388,  389,
  390,   -1,   -1,  393,  394,   -1,   -1,   -1,  398,  399,
  400,  401,  402,  403,  404,  405,  256,   -1,   -1,   -1,
   -1,  261,  262,   -1,   -1,   -1,   -1,  417,   -1,   -1,
  420,   -1,  422,   -1,  424,  357,   -1,  427,   -1,   -1,
   -1,  363,  364,  433,  284,   -1,   -1,   -1,   -1,  371,
   -1,  373,   -1,  375,  376,  377,  378,  297,  298,   -1,
    0,   -1,  302,   -1,   -1,  305,   -1,  307,  390,  309,
  310,  311,  312,   -1,  396,  397,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,  416,   -1,  336,   -1,  338,  339,
  422,   -1,  424,  343,  344,  427,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,  371,  372,  373,  374,  375,  376,   -1,  378,  379,
  380,   -1,  382,  383,   -1,   -1,  386,  387,  388,  389,
   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,  398,  399,
  400,  401,  402,  403,  404,  405,  256,   -1,    0,   -1,
   -1,  261,  262,   -1,   -1,   -1,   -1,  417,   -1,   -1,
  420,   -1,  422,   -1,  424,   -1,   -1,  427,   -1,   -1,
   -1,   -1,   -1,  433,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  297,  298,   -1,
   -1,   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  339,
   -1,   -1,   -1,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,  371,  372,  373,  374,  375,  376,   -1,  378,  379,
  380,   -1,  382,  383,   -1,   -1,  386,  387,  388,  389,
   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,  398,  399,
  400,  401,  402,  403,  404,  405,  256,   -1,    0,   -1,
   -1,  261,  262,   -1,   -1,   -1,   -1,  417,   -1,   -1,
  420,   -1,  422,   -1,  424,   -1,   -1,  427,   -1,   -1,
   -1,   -1,   -1,  433,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  297,  298,   -1,
   -1,   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  339,
   -1,   -1,   -1,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,  362,  363,  256,   -1,  366,  367,   -1,   -1,
  262,  371,  372,   -1,  374,  375,  376,   -1,  378,  379,
  380,   -1,  382,  383,   -1,   -1,  386,  387,  388,  389,
   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,  398,  399,
  400,  401,  402,  403,  404,  405,  298,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  417,   -1,   -1,
  420,   -1,  422,   -1,   -1,   -1,   -1,    0,   -1,   -1,
   -1,   -1,   -1,  433,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,  343,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  357,   -1,   -1,   -1,   -1,
   -1,  363,  256,   -1,  366,  367,   -1,   -1,   -1,  371,
  372,  373,  374,  375,  376,  377,  378,  379,  380,   -1,
  382,  383,   -1,   -1,  386,  387,  388,  389,  390,   -1,
   -1,  393,  394,   -1,   -1,   -1,  398,  399,  400,  401,
  402,  403,  404,  405,  256,   -1,   -1,   -1,   -1,   -1,
  262,   -1,   -1,   -1,   -1,  417,   -1,   -1,  420,    0,
  422,   -1,  424,   -1,   -1,  427,   -1,   -1,   -1,   -1,
   -1,  433,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  339,  298,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,    0,   -1,   -1,   -1,
   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,  372,   -1,
  374,   -1,  376,   -1,  378,  379,  380,  339,   -1,   -1,
   -1,  343,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,  363,   -1,    0,  366,  367,   -1,   -1,   -1,  371,
  372,  373,  374,  375,  376,   -1,  378,  379,  380,   -1,
  382,  383,   -1,   -1,  386,  387,  388,  389,   -1,  433,
   -1,  393,  394,   -1,   -1,   -1,  398,  399,  400,  401,
  402,  403,  404,  405,   -1,   -1,   -1,   -1,   -1,   -1,
    0,   -1,   -1,   -1,   -1,  417,   -1,   -1,  420,   -1,
  422,   -1,  424,  256,  257,  427,   -1,   -1,  261,   -1,
   -1,  433,  265,   -1,  267,   -1,   -1,  270,   -1,  272,
  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,  282,
  283,  284,   -1,   -1,  287,  288,   -1,    0,   -1,   -1,
  293,   -1,  295,  296,  297,   -1,   -1,  300,  301,  302,
   -1,  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,
  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,
  333,  334,   -1,  336,  337,  338,   -1,   -1,   -1,  342,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
    0,   -1,   -1,   -1,   -1,   -1,  257,   -1,   -1,  362,
  261,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,  372,
  373,  272,   -1,   -1,   -1,   -1,  277,   -1,  381,   -1,
  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  296,  297,   -1,   -1,   -1,
  301,  302,   -1,  257,   -1,   -1,  307,  261,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,  272,  422,
  321,   -1,  323,  277,   -1,   -1,   -1,  281,   -1,   -1,
  284,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,   -1,
   -1,  342,  296,  297,   -1,   -1,   -1,  301,  302,   -1,
  257,   -1,   -1,  307,  261,  309,  310,  311,  312,   -1,
   -1,  362,   -1,  317,   -1,  272,   -1,  321,   -1,  323,
  277,  372,  373,   -1,  281,   -1,   -1,  284,   -1,  333,
   -1,   -1,  336,   -1,  338,   -1,   -1,   -1,  342,  296,
  297,   -1,   -1,   -1,  301,  302,   -1,  257,   -1,   -1,
  307,  261,  309,  310,  311,  312,   -1,   -1,  362,   -1,
  317,   -1,  272,   -1,  321,   -1,  323,  277,   -1,  373,
   -1,  281,   -1,   -1,  284,   -1,  333,   -1,   -1,  336,
   -1,  338,   -1,   -1,   -1,  342,  296,  297,   -1,   -1,
   -1,  301,  302,   -1,  257,   -1,   -1,  307,  261,  309,
  310,  311,  312,   -1,   -1,  362,   -1,  317,   -1,  272,
   -1,  321,   -1,  323,  277,   -1,   -1,   -1,  281,   -1,
   -1,  284,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,
   -1,   -1,  342,  296,  297,   -1,   -1,   -1,  301,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,  362,   -1,  317,   -1,   -1,  257,  321,   -1,
  323,  261,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,  272,  336,   -1,  338,   -1,  277,   -1,  342,
   -1,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  296,  297,   -1,  362,
   -1,  301,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,  256,  336,   -1,  338,   -1,
   -1,   -1,  342,  264,  265,  266,  267,   -1,   -1,  270,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,   -1,
   -1,   -1,  362,   -1,  285,   -1,  287,  288,  289,  290,
  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,  324,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,
  341,   -1,   -1,  344,  345,   -1,  256,   -1,   -1,   -1,
   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,   -1,
  371,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,  380,
  381,  382,  383,  384,   -1,   -1,   -1,  388,  298,  390,
   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,   -1,   -1,  262,
  421,  422,  423,  424,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,  433,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,   -1,   -1,
   -1,   -1,   -1,  363,  364,  298,  366,  367,   -1,   -1,
   -1,  371,  372,  373,  374,  375,  376,  377,  378,  379,
  380,   -1,  382,  383,   -1,  385,  386,  387,  388,  389,
  390,  391,  392,  393,  394,   -1,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,  414,  415,  416,  417,  418,   -1,
  256,   -1,  422,   -1,  424,  425,  262,  427,   -1,   -1,
  363,  364,   -1,  433,   -1,   -1,   -1,   -1,   -1,  372,
  373,   -1,  375,  376,  377,  378,   -1,  380,   -1,  382,
  383,   -1,  385,  386,  387,  388,  389,   -1,  391,  392,
  393,  394,  298,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
  413,  414,  415,  416,  417,   -1,   -1,   -1,   -1,  422,
   -1,  424,   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,
  433,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,   -1,   -1,   -1,   -1,   -1,  363,  364,   -1,
  366,  367,   -1,   -1,   -1,  371,  372,  373,  374,  375,
  376,  377,  378,  379,  380,  256,  382,  383,   -1,  385,
  386,  387,  388,  389,  390,  391,  392,  393,  394,   -1,
  396,  397,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  412,  413,  414,  415,
  416,  417,  418,  256,   -1,   -1,  422,   -1,  424,  262,
   -1,  427,   -1,   -1,   -1,   -1,   -1,  433,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  298,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  366,  367,   -1,   -1,   -1,
   -1,  372,   -1,  374,   -1,  376,  339,  378,  379,  380,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  357,   -1,   -1,   -1,   -1,   -1,
  363,  364,   -1,  366,  367,   -1,   -1,   -1,  371,  372,
  373,  374,  375,  376,  377,  378,  379,  380,   -1,  382,
  383,   -1,  385,  386,  387,  388,  389,  390,  391,  392,
  393,  394,  433,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
  413,  414,  415,  416,  417,   -1,  256,  256,   -1,  422,
   -1,  424,  262,   -1,  427,   -1,  265,   -1,  267,   -1,
  433,  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,
  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,
   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
   -1,   -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,   -1,   -1,
   -1,   -1,   -1,  363,  364,   -1,  366,  367,   -1,   -1,
   -1,   -1,  372,  373,  374,  375,  376,  377,  378,  379,
  380,   -1,  382,  383,   -1,  385,  386,  387,  388,  389,
  390,  391,  392,  393,  394,   -1,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,  414,  415,  416,  417,   -1,  256,
   -1,   -1,  422,  422,  424,  262,   -1,  427,   -1,   -1,
   -1,  261,   -1,  433,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,  298,   -1,   -1,   -1,   -1,   -1,  297,   -1,   -1,
   -1,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  339,  333,   -1,   -1,  336,  344,  338,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,  256,   -1,   -1,   -1,   -1,  364,   -1,  366,
  367,   -1,  362,   -1,  371,  372,  373,  374,  375,  376,
  377,  378,  379,  380,   -1,  382,  383,   -1,  385,  386,
  387,  388,  389,  390,  391,  392,  393,  394,   -1,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,  414,  415,  416,
  417,   -1,  256,   -1,   -1,   -1,   -1,  424,  262,   -1,
   -1,   -1,  422,   -1,   -1,   -1,  433,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,  298,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,  372,   -1,
  374,   -1,  376,   -1,  378,  379,  380,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  394,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  405,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  417,   -1,  256,   -1,   -1,   -1,   -1,
  364,   -1,  366,  367,   -1,   -1,   -1,  371,  372,  433,
  374,  375,  376,  377,  378,  379,  380,   -1,  382,  383,
   -1,  385,  386,  387,  388,  389,  390,  391,  392,  393,
  394,   -1,  396,  397,  398,  399,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
  414,  415,  416,  417,   -1,  256,   -1,   -1,   -1,   -1,
  424,  262,   -1,  427,   -1,   -1,   -1,   -1,   -1,  433,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,  298,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  366,  367,   -1,   -1,   -1,
   -1,  372,   -1,  374,   -1,  376,   -1,  378,  379,  380,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  394,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  405,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  417,   -1,  256,   -1,
   -1,   -1,   -1,  364,   -1,  366,  367,   -1,   -1,   -1,
   -1,  372,  433,  374,  375,  376,  377,  378,  379,  380,
   -1,  382,  383,   -1,  385,  386,  387,  388,  389,  390,
  391,  392,  393,  394,   -1,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,  414,  415,  416,  417,   -1,  256,   -1,
   -1,   -1,   -1,  424,  262,   -1,  427,   -1,   -1,   -1,
   -1,   -1,  433,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  366,  367,
   -1,   -1,   -1,   -1,  372,   -1,  374,   -1,  376,   -1,
  378,  379,  380,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  394,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  364,   -1,  366,  367,
   -1,   -1,   -1,   -1,  372,  433,  374,  375,  376,  377,
  378,  379,  380,   -1,  382,  383,   -1,  385,  386,  387,
  388,  389,  390,  391,  392,  393,  394,   -1,  396,  397,
  398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  412,  413,  414,  415,  416,  417,
   -1,  256,   -1,   -1,  261,   -1,  424,  262,   -1,  427,
   -1,   -1,   -1,   -1,   -1,  433,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  297,   -1,   -1,  298,   -1,  302,   -1,   -1,  305,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,  362,   -1,   -1,   -1,  364,
   -1,  366,  367,   -1,   -1,  372,   -1,  372,   -1,  374,
  375,  376,  377,  378,  379,  380,   -1,  382,  383,   -1,
  385,  386,  387,  388,  389,  390,  391,  392,  393,  394,
   -1,  396,  397,  398,  399,  400,  401,  402,  403,  404,
  405,  406,  407,  408,  409,  410,  411,  412,  413,  414,
  415,  416,  417,   -1,  256,  422,  261,   -1,   -1,  424,
  262,   -1,  427,   -1,   -1,   -1,   -1,   -1,  433,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  297,   -1,   -1,   -1,  298,  302,   -1,   -1,
  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,  256,   -1,   -1,
  325,   -1,   -1,  262,   -1,   -1,   -1,  266,  333,   -1,
   -1,  336,   -1,  338,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,  362,   -1,  298,
   -1,   -1,   -1,   -1,  366,  367,   -1,  372,   -1,   -1,
  372,   -1,  374,   -1,  376,  314,  378,  379,  380,   -1,
  382,  383,   -1,  385,  386,  387,  388,  389,  390,  391,
  392,  393,  394,   -1,   -1,   -1,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,  413,  414,  415,  256,  417,   -1,  422,  357,   -1,
  262,   -1,   -1,   -1,  363,  364,   -1,   -1,   -1,   -1,
   -1,  433,   -1,  372,  373,  374,  375,  376,  377,  378,
  379,  380,   -1,  382,  383,   -1,  385,  386,  387,  388,
  389,  390,  391,  392,  393,  394,  298,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,  414,  415,  416,  417,   -1,
   -1,   -1,   -1,  422,   -1,  424,   -1,   -1,  427,   -1,
   -1,   -1,   -1,   -1,  433,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,  363,  364,  256,  366,  367,   -1,   -1,   -1,  262,
  372,  373,  374,   -1,  376,  377,  378,  379,  380,   -1,
  382,  383,   -1,   -1,  386,  387,  388,  389,   -1,   -1,
   -1,  393,  394,   -1,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,   -1,  298,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  416,  417,   -1,   -1,   -1,   -1,
  422,   -1,  424,   -1,   -1,  427,   -1,   -1,   -1,   -1,
   -1,  433,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  364,  256,  366,  367,   -1,   -1,   -1,  262,  372,
   -1,  374,  375,  376,  377,  378,  379,  380,   -1,  382,
  383,   -1,   -1,  386,  387,  388,  389,   -1,   -1,   -1,
  393,  394,   -1,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,   -1,  298,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  416,  417,   -1,   -1,   -1,   -1,   -1,
   -1,  424,   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,
  433,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  364,  256,  366,  367,   -1,   -1,   -1,  262,  372,   -1,
  374,  375,  376,  377,  378,  379,  380,   -1,  382,  383,
   -1,   -1,  386,  387,  388,  389,   -1,   -1,   -1,  393,
  394,   -1,  396,  397,  398,  399,  400,  401,  402,  403,
  404,  405,   -1,  298,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  416,  417,   -1,   -1,   -1,   -1,   -1,   -1,
  424,   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,  433,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,
  256,  366,  367,   -1,   -1,   -1,  262,  372,   -1,  374,
  375,  376,  377,  378,  379,  380,   -1,  382,  383,   -1,
   -1,  386,  387,  388,  389,   -1,   -1,   -1,  393,  394,
   -1,  396,  397,  398,  399,  400,  401,  402,  403,  404,
  405,   -1,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  416,  417,   -1,   -1,   -1,   -1,   -1,   -1,  424,
   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,  433,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,   -1,   -1,  363,  256,   -1,
  366,  367,   -1,   -1,  262,   -1,  372,  373,  374,   -1,
  376,   -1,  378,  379,  380,   -1,  382,  383,   -1,   -1,
  386,  387,  388,  389,   -1,   -1,   -1,  393,  394,   -1,
   -1,   -1,  398,  399,  400,  401,  402,  403,  404,  405,
  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  417,   -1,   -1,   -1,   -1,  422,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,   -1,   -1,
  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  366,  367,
   -1,   -1,  298,   -1,  372,   -1,  374,   -1,  376,   -1,
  378,  379,  380,   -1,  382,  383,   -1,   -1,  386,  387,
  388,  389,  390,  391,  392,  393,  394,   -1,   -1,   -1,
  398,  399,  400,  401,  402,  403,  404,  405,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  417,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  433,   -1,  363,  256,   -1,
  366,  367,   -1,   -1,  262,   -1,  372,   -1,  374,   -1,
  376,   -1,  378,  379,  380,   -1,  382,  383,   -1,   -1,
  386,  387,  388,  389,   -1,   -1,   -1,  393,  394,   -1,
   -1,   -1,  398,  399,  400,  401,  402,  403,  404,  405,
  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  417,   -1,   -1,   -1,   -1,  422,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,   -1,   -1,
  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  366,  367,
   -1,   -1,  298,   -1,  372,   -1,  374,   -1,  376,   -1,
  378,  379,  380,   -1,  382,  383,   -1,   -1,  386,  387,
  388,  389,   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,
  398,  399,  400,  401,  402,  403,  404,  405,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  417,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  433,   -1,   -1,  256,   -1,
  366,  367,   -1,   -1,  262,   -1,  372,   -1,  374,   -1,
  376,   -1,  378,  379,  380,   -1,  382,  383,   -1,   -1,
  386,  387,  388,  389,   -1,   -1,   -1,  393,  394,   -1,
   -1,   -1,  398,  399,  400,  401,  402,  403,  404,  405,
  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  417,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  433,   -1,   -1,
  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  366,  367,
   -1,   -1,  298,   -1,  372,   -1,  374,   -1,  376,   -1,
  378,  379,  380,   -1,  382,  383,   -1,   -1,  386,  387,
  388,  389,   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,
  398,  399,  400,  401,  402,  403,  404,  405,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  417,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  433,   -1,   -1,   -1,   -1,
  366,  367,   -1,   -1,   -1,   -1,  372,   -1,  374,   -1,
  376,   -1,  378,  379,  380,   -1,  382,  383,   -1,   -1,
  386,  387,  388,  389,   -1,   -1,   -1,  393,  394,   -1,
   -1,   -1,  398,  399,  400,  401,  402,  403,  404,  405,
   -1,  256,   -1,  256,   -1,   -1,   -1,   -1,   -1,  264,
  265,  417,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,  433,   -1,   -1,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  359,  360,  361,  362,  363,  256,
   -1,  366,  367,  366,  367,   -1,   -1,   -1,   -1,  372,
  375,  374,   -1,  376,   -1,  378,  379,  380,   -1,   -1,
   -1,   -1,   -1,  386,  387,  388,  389,   -1,   -1,   -1,
  393,  394,   -1,   -1,   -1,  398,  399,  400,  401,  402,
  403,  404,  405,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  417,   -1,  421,  422,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  432,  433,   -1,
  433,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  366,
  367,   -1,   -1,   -1,   -1,  372,   -1,  374,   -1,  376,
   -1,  378,  379,  380,   -1,   -1,   -1,   -1,   -1,  386,
  387,  388,  389,   -1,   -1,   -1,  393,  394,   -1,   -1,
   -1,  398,  399,  400,  401,  402,  403,  404,  405,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  417,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  256,   -1,   -1,   -1,  433,   -1,   -1,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,  372,   -1,  374,
   -1,  376,   -1,  378,  379,  380,   -1,   -1,   -1,   -1,
   -1,  386,  387,  388,  389,   -1,   -1,   -1,  393,  394,
   -1,   -1,   -1,  398,  399,  400,  401,  402,  403,  404,
  405,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  417,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  433,   -1,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,  372,   -1,
  374,   -1,  376,   -1,  378,  379,  380,   -1,   -1,   -1,
   -1,   -1,  386,  387,  388,  389,   -1,   -1,   -1,  393,
  394,   -1,   -1,   -1,   -1,   -1,  400,  401,  402,  403,
  404,  405,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  417,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  256,   -1,   -1,   -1,  433,
   -1,   -1,   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,
  372,   -1,  374,   -1,  376,   -1,  378,  379,  380,   -1,
   -1,   -1,   -1,   -1,  386,  387,  388,  389,   -1,   -1,
   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,  400,  401,
  402,  403,  404,  405,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  417,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  433,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  366,  367,   -1,   -1,   -1,
   -1,  372,   -1,  374,   -1,  376,   -1,  378,  379,  380,
   -1,   -1,   -1,   -1,   -1,  386,  387,  388,  389,   -1,
   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,  400,
  401,  402,  403,  404,  405,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  417,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  256,   -1,
   -1,   -1,  433,   -1,   -1,   -1,   -1,  366,  367,   -1,
   -1,   -1,   -1,  372,   -1,  374,   -1,  376,   -1,  378,
  379,  380,   -1,   -1,   -1,   -1,   -1,  386,  387,  388,
  389,   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,
   -1,  400,  401,  402,  403,  404,  405,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  417,   -1,
   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  433,   -1,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  298,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  366,  367,
   -1,   -1,   -1,   -1,  372,   -1,  374,   -1,  376,   -1,
  378,  379,  380,   -1,   -1,   -1,   -1,   -1,  386,  387,
  388,  389,   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,
   -1,   -1,  400,  401,  402,  403,  404,  405,  256,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  417,
   -1,   -1,   -1,   -1,   -1,  364,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  372,   -1,  433,  375,   -1,  377,  378,
   -1,   -1,   -1,  382,  383,   -1,   -1,  386,  387,  388,
  389,  390,  391,  392,  393,  394,   -1,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  416,  417,   -1,
  256,   -1,   -1,   -1,   -1,  424,   -1,   -1,  427,   -1,
   -1,  339,   -1,   -1,  433,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  366,  367,
   -1,   -1,   -1,   -1,  372,   -1,  374,   -1,  376,   -1,
  378,  379,  380,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  388,  389,   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,
   -1,   -1,  256,   -1,  402,  403,  404,  405,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  417,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  433,   -1,   -1,   -1,   -1,
  366,  367,   -1,   -1,   -1,   -1,  372,   -1,  374,   -1,
  376,   -1,  378,  379,  380,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  388,  389,   -1,   -1,   -1,  393,  394,   -1,
   -1,   -1,   -1,   -1,  256,   -1,  402,  403,  404,  405,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  417,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  433,   -1,   -1,
   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,  372,   -1,
  374,   -1,  376,   -1,  378,  379,  380,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  388,  389,   -1,   -1,   -1,  393,
  394,   -1,   -1,   -1,   -1,   -1,  256,   -1,  402,  403,
  404,  405,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  417,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  433,
   -1,   -1,   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,
  372,   -1,  374,   -1,  376,   -1,  378,  379,  380,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  388,  389,   -1,   -1,
   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  404,  405,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  417,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  433,   -1,   -1,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,  372,   -1,  374,   -1,  376,   -1,  378,  379,
  380,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388,  389,
   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  404,  405,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  417,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  433,   -1,   -1,   -1,   -1,  366,  367,
   -1,   -1,   -1,   -1,  372,   -1,  374,   -1,  376,   -1,
  378,  379,  380,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  389,   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,  404,  405,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  417,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  433,   -1,   -1,   -1,   -1,
  366,  367,   -1,   -1,   -1,   -1,  372,   -1,  374,   -1,
  376,   -1,  378,  379,  380,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  389,   -1,   -1,   -1,  393,  394,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  404,  405,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  417,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  433,   -1,   -1,
   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,  372,   -1,
  374,   -1,  376,   -1,  378,  379,  380,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  389,   -1,   -1,   -1,   -1,
  394,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  404,  405,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  417,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  433,
   -1,   -1,   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,
  372,   -1,  374,   -1,  376,   -1,  378,  379,  380,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  389,   -1,   -1,
   -1,   -1,  394,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  404,  405,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  417,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  433,   -1,   -1,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,  372,   -1,  374,   -1,  376,   -1,  378,  379,
  380,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  262,  394,   -1,   -1,  266,   -1,   -1,
   -1,   -1,   -1,   -1,  404,  405,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  417,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  298,
   -1,   -1,   -1,  433,   -1,   -1,   -1,   -1,  366,  367,
   -1,   -1,   -1,   -1,  372,  314,  374,   -1,  376,   -1,
  378,  379,  380,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  394,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  404,  405,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  357,  417,
   -1,   -1,   -1,   -1,  363,  364,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  372,  373,  433,  375,   -1,  377,   -1,
  379,  380,   -1,  382,  383,   -1,  385,  386,  387,  388,
  389,  390,  391,  392,  393,  394,   -1,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,  414,  415,  416,  417,   -1,
   -1,  256,   -1,  422,   -1,  424,   -1,   -1,  427,  264,
  265,  266,  267,  268,  433,  270,  271,   -1,  273,  274,
  275,  276,  277,  278,  279,   -1,   -1,   -1,   -1,   -1,
  285,   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,
  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,   -1,  337,   -1,   -1,  340,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,
  375,   -1,   -1,   -1,   -1,  380,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,   -1,   -1,   -1,   -1,
   -1,  396,  397,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,  421,  422,  423,  424,
   -1,  426,  264,  265,  266,  267,   -1,   -1,  270,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,   -1,   -1,
   -1,   -1,   -1,  285,   -1,  287,  288,  289,  290,  291,
  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,  324,  325,  326,  327,  328,  329,  330,  331,
  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,  366,  367,   -1,   -1,   -1,  371,
   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,  380,  381,
  382,  383,  384,   -1,   -1,   -1,  388,   -1,  390,   -1,
   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  421,
  422,  423,  424,  264,  265,  266,  267,   -1,   -1,  270,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,   -1,
   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,  290,
  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,  324,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,   -1,
  371,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,  380,
  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,  390,
   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  421,  422,  423,  424,  264,  265,  266,  267,   -1,   -1,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,
  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,
  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,  371,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
  380,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  421,  422,  423,  424,  264,  265,  266,  267,   -1,
   -1,  270,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,
  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,
  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,   -1,  337,   -1,
   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,  371,   -1,   -1,   -1,  375,   -1,   -1,   -1,
   -1,  380,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  421,  422,  423,  424,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,
  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,  288,  306,   -1,
   -1,   -1,   -1,   -1,  295,  313,   -1,   -1,  316,  300,
  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,  316,  334,  318,   -1,   -1,
   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,  366,  367,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,
  378,   -1,  363,  381,  382,  383,  384,   -1,   -1,   -1,
  388,   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,
   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,  421,  422,  423,  424,  285,   -1,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,  422,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,  366,  367,
   -1,   -1,   -1,  371,  372,   -1,   -1,  375,   -1,   -1,
   -1,   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,
  388,   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,
   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,  421,  422,  423,  424,  285,   -1,  427,
  288,   -1,   -1,   -1,  432,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,  366,  367,
   -1,   -1,   -1,  371,   -1,   -1,   -1,  375,   -1,   -1,
   -1,   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,
  388,   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,  421,  422,  423,  424,   -1,   -1,  427,
  264,  265,   -1,  267,  432,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,   -1,  265,   -1,
  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,
   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,  316,
  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,
  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,
  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,  366,  367,   -1,   -1,   -1,  371,  372,   -1,
   -1,  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,
  384,   -1,   -1,   -1,  388,   -1,  390,   -1,   -1,  376,
   -1,   -1,  396,  397,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  421,  422,  423,
  424,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  422,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,  306,   -1,   -1,   -1,   -1,   -1,  295,
  313,   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,  381,  382,
  383,  384,   -1,   -1,   -1,  388,   -1,  390,  374,   -1,
   -1,   -1,   -1,  396,  397,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  421,  422,
  423,  424,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,  422,  279,   -1,   -1,
  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,
  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,  316,  300,  318,  319,  320,  304,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,
   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,
   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,  366,  367,   -1,   -1,   -1,  371,
   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,  381,
  382,  383,  384,   -1,   -1,   -1,  388,   -1,  390,   -1,
   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  421,
  422,  423,  424,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,  422,  279,   -1,
   -1,   -1,   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,   -1,
  371,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,
  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,  390,
   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
  421,  422,  423,  424,  262,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
  298,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  343,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,  366,  367,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,  377,
   -1,   -1,   -1,  381,  382,  383,  384,  385,   -1,   -1,
  388,   -1,  390,  256,   -1,   -1,   -1,   -1,  396,  397,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  421,  422,  288,  424,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,  372,
   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,  381,  382,
  383,  384,   -1,   -1,   -1,  388,   -1,  390,   -1,   -1,
   -1,   -1,   -1,  396,  397,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  421,  422,
  423,  424,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,
  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,
   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,
   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,
  372,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,  381,
  382,  383,  384,   -1,   -1,   -1,  388,   -1,  390,   -1,
   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  421,
  422,  423,  424,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,  422,  279,   -1,
   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,
   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,
  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,
  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,
  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,  390,
   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  421,  422,  423,  424,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  422,  279,
   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,  421,  422,  423,  424,  262,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,  298,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  343,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,  366,
  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,
  377,   -1,   -1,   -1,  381,  382,  383,  384,   -1,   -1,
   -1,  388,   -1,  390,  256,   -1,   -1,   -1,   -1,  396,
  397,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
   -1,   -1,   -1,  285,  421,  422,  288,  424,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,  381,
  382,  383,  384,   -1,   -1,   -1,  388,   -1,  390,   -1,
   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  421,
  422,  423,  424,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,
   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,
  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,
  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,
  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,  390,
   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  421,  422,  423,  424,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  422,  279,
   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,
   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,
   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,
   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,
   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  421,  422,  423,  424,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,  422,
  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,
   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,
  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,
  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,
   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  421,  422,  423,  424,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
  422,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,  366,  367,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,
   -1,   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,
  388,   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,
   -1,   -1,   -1,   -1,  285,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,   -1,
   -1,  256,   -1,  421,  422,  423,  424,  262,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  327,   -1,   -1,   -1,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,  298,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
  381,  382,  383,  384,   -1,  386,  387,  388,  389,  390,
  391,  392,  393,   -1,   -1,  396,  397,  398,  399,  400,
  401,  402,  403,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  375,   -1,  377,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,  261,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
  284,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  297,  334,   -1,   -1,   -1,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,  315,   -1,  317,   -1,   -1,   -1,  321,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,  333,
   -1,   -1,  336,   -1,  338,  375,   -1,  377,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,  362,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,  372,  373,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,  261,   -1,  263,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,  284,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,  297,  334,
   -1,   -1,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,  333,   -1,   -1,  336,   -1,  338,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,  362,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,  372,  373,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,  261,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
  284,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  297,  334,   -1,   -1,   -1,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,  315,   -1,  317,   -1,   -1,   -1,  321,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,  333,
   -1,   -1,  336,   -1,  338,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,  362,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,  372,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,  261,   -1,  263,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,  284,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,  297,  334,
   -1,   -1,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,  333,   -1,   -1,  336,   -1,  338,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,  362,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,  372,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,  261,   -1,  263,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
  284,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  297,  334,   -1,   -1,   -1,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,  315,   -1,  317,   -1,   -1,   -1,  321,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,  333,
   -1,   -1,  336,   -1,  338,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,  362,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,  261,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,  284,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,  297,  334,
   -1,   -1,  301,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,  333,   -1,   -1,  336,   -1,  338,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,  362,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,  261,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
  284,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  297,  334,   -1,   -1,   -1,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,  333,
   -1,   -1,  336,   -1,  338,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,  362,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,
  390,  256,   -1,   -1,   -1,   -1,  396,  397,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  421,  422,  288,  424,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,   -1,  390,  256,   -1,   -1,   -1,
   -1,  396,  397,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  421,  422,  288,  424,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,
   -1,   -1,  382,  383,   -1,   -1,  256,   -1,   -1,   -1,
  390,  261,   -1,   -1,   -1,  265,   -1,  267,   -1,   -1,
  270,   -1,  272,  273,   -1,  275,   -1,  277,   -1,  279,
   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,   -1,
   -1,  421,  422,  293,  424,  295,  296,  297,   -1,   -1,
  300,   -1,  302,   -1,  304,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,   -1,
   -1,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,  333,  334,   -1,  336,  337,  338,   -1,
   -1,   -1,  342,   -1,   -1,  256,   -1,   -1,   -1,   -1,
   -1,   -1,  262,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,  362,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,  371,  372,  373,  285,   -1,   -1,  288,   -1,   -1,
   -1,  381,   -1,   -1,  295,   -1,   -1,   -1,  298,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  422,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,  364,  366,  367,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  375,  375,  376,  377,  378,  379,
   -1,   -1,  382,  383,   -1,   -1,  386,  387,  388,  389,
  390,  391,  392,  393,  394,   -1,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,  414,  415,  416,  417,   -1,   -1,
  421,  422,   -1,   -1,  424,   -1,  261,  427,  263,   -1,
  265,   -1,  267,   -1,   -1,  270,   -1,  272,  273,   -1,
  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,  284,
   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,  294,
  295,  296,  297,   -1,   -1,  300,   -1,  302,   -1,  304,
   -1,  306,  307,   -1,  309,  310,  311,  312,   -1,   -1,
  315,  316,  317,  318,   -1,   -1,  321,  322,  323,   -1,
   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,  333,  334,
   -1,  336,  337,  338,   -1,   -1,   -1,  342,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,
   -1,   -1,   -1,  368,  369,  261,   -1,   -1,   -1,  265,
   -1,  267,   -1,   -1,  270,   -1,  272,  273,   -1,  275,
   -1,  277,   -1,  279,   -1,  281,  282,  283,  284,   -1,
   -1,  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,
  296,  297,   -1,   -1,  300,   -1,  302,   -1,  304,   -1,
   -1,  307,   -1,  309,  310,  311,  312,  422,   -1,   -1,
  316,  317,  318,   -1,   -1,  321,  322,  323,   -1,   -1,
   -1,   -1,   -1,   -1,  330,  331,   -1,  333,  334,   -1,
  336,  337,  338,   -1,   -1,   -1,  342,  261,   -1,   -1,
   -1,  265,   -1,  267,   -1,   -1,  270,   -1,  272,  273,
   -1,  275,   -1,  277,   -1,  279,  362,  281,  282,  283,
  284,   -1,   -1,  287,  288,   -1,  372,   -1,   -1,  293,
   -1,  295,  296,  297,   -1,  381,  300,   -1,  302,   -1,
  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,  323,
   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,  333,
  334,   -1,  336,  337,  338,   -1,  422,   -1,  342,  261,
   -1,   -1,   -1,  265,   -1,  267,   -1,   -1,  270,   -1,
  272,  273,   -1,  275,   -1,  277,   -1,  279,  362,  281,
  282,  283,  284,   -1,   -1,  287,  288,   -1,  372,   -1,
   -1,  293,   -1,  295,  296,  297,   -1,  381,  300,   -1,
  302,   -1,  304,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,  316,  317,  318,   -1,   -1,  321,
  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
   -1,  333,  334,   -1,  336,  337,  338,   -1,  422,   -1,
  342,  261,   -1,   -1,   -1,  265,   -1,  267,   -1,   -1,
  270,   -1,  272,  273,   -1,  275,   -1,  277,   -1,  279,
  362,  281,  282,  283,  284,   -1,   -1,  287,  288,   -1,
   -1,   -1,   -1,  293,   -1,  295,  296,  297,   -1,  381,
  300,   -1,  302,   -1,  304,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,   -1,
   -1,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,  333,  334,   -1,  336,  337,  338,   -1,
  422,   -1,  342,  261,   -1,   -1,   -1,  265,   -1,  267,
   -1,   -1,  270,   -1,  272,  273,   -1,  275,   -1,  277,
   -1,  279,  362,  281,  282,  283,  284,   -1,   -1,  287,
  288,   -1,  372,   -1,   -1,  293,   -1,  295,  296,  297,
   -1,   -1,  300,   -1,  302,  261,  304,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,
  318,   -1,   -1,  321,  322,  323,   -1,   -1,  284,   -1,
   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,
  338,  297,  422,  261,  342,   -1,  302,   -1,   -1,  305,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,  362,  321,  284,   -1,   -1,  325,
   -1,   -1,   -1,   -1,  372,   -1,   -1,  333,   -1,  297,
  336,   -1,  338,   -1,  302,   -1,   -1,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,
   -1,  357,   -1,  321,   -1,   -1,  362,  325,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  333,  372,  373,  336,  375,
  338,  377,   -1,   -1,  422,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,  390,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,  362,   -1,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,  372,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,  422,  306,   -1,   -1,
   -1,   -1,   -1,   -1,  313,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,  422,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  421,  422,  423,  424,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,  306,   -1,   -1,
   -1,   -1,   -1,   -1,  313,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,  378,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  421,  422,  423,  424,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,  337,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  421,  422,  423,  424,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,  337,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  421,  422,  423,  424,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,  371,   -1,   -1,   -1,  375,   -1,   -1,   -1,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  421,  422,  423,  424,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,  371,   -1,   -1,   -1,  375,   -1,   -1,   -1,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  421,  422,  423,  424,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  421,  422,  423,  424,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  421,  422,  423,  424,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  421,  422,  423,  424,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,   -1,   -1,   -1,   -1,  396,  397,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  421,  422,  423,  424,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,  366,  367,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
   -1,  390,   -1,  264,  265,   -1,  267,  396,  397,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,  421,  422,  295,  424,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,  366,  367,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,
  381,  382,  383,  384,   -1,   -1,   -1,  388,   -1,  390,
   -1,  264,  265,   -1,  267,  396,  397,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
  421,  422,  295,  424,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,   -1,
  264,  265,  375,  267,   -1,   -1,  270,  271,   -1,  382,
  383,  275,  276,  277,   -1,  279,   -1,  390,   -1,   -1,
   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,  261,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  421,  422,
   -1,  424,  316,   -1,  318,  319,  284,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,  297,
  334,   -1,   -1,  337,  302,   -1,   -1,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,
   -1,   -1,   -1,  321,   -1,  359,  360,  361,  362,  363,
   -1,   -1,  366,  367,   -1,  333,   -1,   -1,  336,   -1,
  338,  375,   -1,  263,   -1,  265,   -1,  267,  382,  383,
  270,   -1,  272,  273,   -1,  275,  390,  277,   -1,  279,
   -1,  281,  282,  283,  362,   -1,   -1,  287,  288,   -1,
  368,  369,   -1,  293,  372,  295,  296,   -1,   -1,   -1,
  300,   -1,   -1,   -1,  304,   -1,   -1,  421,  422,   -1,
  424,   -1,   -1,   -1,   -1,  315,  316,   -1,  318,   -1,
   -1,   -1,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,
  264,  265,  342,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,
   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,  368,  369,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,  381,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  422,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,  366,  367,   -1,   -1,   -1,   -1,  265,   -1,
  267,  375,   -1,  270,   -1,  272,  273,   -1,  275,   -1,
  277,   -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1,
  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,
   -1,   -1,   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  421,  422,  316,
   -1,  318,   -1,   -1,   -1,  322,  323,   -1,   -1,   -1,
   -1,   -1,   -1,  330,  331,   -1,  265,  334,  267,   -1,
  337,  270,   -1,  272,  273,  342,  275,   -1,  277,   -1,
  279,   -1,  281,  282,  283,   -1,   -1,   -1,  287,  288,
   -1,   -1,   -1,   -1,  293,   -1,  295,  296,   -1,   -1,
   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  381,   -1,   -1,  316,   -1,  318,
   -1,   -1,   -1,  322,  323,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,  265,  334,  267,   -1,  337,  270,
   -1,   -1,  273,  342,  275,   -1,  277,   -1,  279,   -1,
  281,  282,  283,   -1,   -1,  422,  287,  288,   -1,   -1,
   -1,   -1,  293,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,   -1,
   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,
  331,   -1,  265,  334,  267,   -1,  337,  270,   -1,   -1,
  273,  342,  275,   -1,  277,   -1,  279,   -1,  281,  282,
  283,   -1,   -1,  422,  287,  288,   -1,   -1,   -1,   -1,
  293,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,   -1,
   -1,  304,  265,   -1,  267,   -1,   -1,  270,   -1,   -1,
  381,   -1,  275,  316,   -1,  318,  279,   -1,   -1,  322,
   -1,   -1,   -1,   -1,   -1,  288,   -1,  330,  331,   -1,
   -1,  334,  295,   -1,  337,   -1,   -1,  300,   -1,  342,
   -1,  304,  265,  306,  267,  308,   -1,  270,   -1,   -1,
  313,  422,  275,  316,   -1,  318,  279,   -1,   -1,  322,
   -1,   -1,  325,   -1,   -1,  288,   -1,  330,  331,   -1,
   -1,  334,  295,   -1,  337,   -1,   -1,  300,   -1,   -1,
   -1,  304,   -1,  306,   -1,  308,   -1,   -1,   -1,   -1,
  313,   -1,   -1,  316,   -1,  318,   -1,   -1,   -1,  322,
   -1,   -1,  325,   -1,   -1,   -1,   -1,  330,  331,   -1,
   -1,  334,   -1,  376,  337,  265,   -1,  267,   -1,  422,
  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,  374,   -1,   -1,  304,  265,  306,  267,   -1,  422,
  270,   -1,   -1,  313,   -1,  275,  316,   -1,  318,  279,
   -1,   -1,  322,   -1,   -1,  325,   -1,   -1,  288,   -1,
  330,  331,   -1,   -1,  334,  295,   -1,  337,   -1,   -1,
  300,   -1,   -1,   -1,  304,  265,  306,  267,  308,  422,
  270,   -1,   -1,  313,   -1,  275,  316,   -1,  318,  279,
   -1,   -1,  322,  363,   -1,  325,   -1,   -1,  288,   -1,
  330,  331,   -1,   -1,  334,  295,   -1,  337,   -1,   -1,
  300,   -1,   -1,   -1,  304,  265,  306,  267,  308,   -1,
  270,   -1,   -1,  313,   -1,  275,  316,   -1,  318,  279,
   -1,   -1,  322,  283,   -1,  325,   -1,   -1,  288,   -1,
  330,  331,   -1,  293,  334,  295,   -1,  337,   -1,   -1,
  300,   -1,  422,   -1,  304,  305,   -1,   -1,   -1,  265,
   -1,  267,   -1,   -1,  270,   -1,  316,   -1,  318,  275,
   -1,   -1,  322,  279,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,  288,  265,  334,  267,   -1,  337,  270,  295,
  272,   -1,  422,  275,  300,   -1,   -1,  279,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,
  316,   -1,  318,  295,   -1,   -1,  322,   -1,  300,   -1,
  302,   -1,  304,   -1,  330,  331,   -1,  261,  334,   -1,
   -1,  337,  422,   -1,  316,   -1,  318,   -1,  272,   -1,
  322,  323,   -1,  277,   -1,   -1,   -1,  281,  330,  331,
  284,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,
   -1,   -1,  296,  297,   -1,   -1,   -1,  301,  302,   -1,
   -1,   -1,  422,  307,  261,  309,  310,  311,  312,   -1,
   -1,   -1,   -1,  317,   -1,  272,   -1,  321,   -1,  323,
  277,   -1,   -1,   -1,  281,   -1,   -1,  284,   -1,  333,
   -1,  335,  336,   -1,  338,   -1,   -1,   -1,  342,  296,
  297,   -1,   -1,   -1,  301,  302,  422,   -1,   -1,   -1,
  307,  261,  309,  310,  311,  312,   -1,   -1,  362,   -1,
  317,   -1,  272,   -1,  321,   -1,  323,  277,  372,  373,
  422,  281,   -1,   -1,  284,   -1,  333,   -1,   -1,  336,
   -1,  338,   -1,   -1,   -1,  342,  296,  297,   -1,   -1,
   -1,  301,  302,   -1,   -1,   -1,   -1,  307,  261,  309,
  310,  311,  312,   -1,   -1,  362,   -1,  317,   -1,  272,
   -1,  321,   -1,  323,  277,  372,  373,   -1,  281,   -1,
   -1,  284,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,
   -1,   -1,  342,  296,  297,   -1,  261,   -1,  301,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,  362,   -1,  317,   -1,   -1,   -1,  321,  284,
  323,   -1,  372,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,  297,  336,  261,  338,   -1,  302,   -1,  342,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,  284,   -1,  362,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,  372,
  297,  336,   -1,  338,   -1,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,  362,   -1,   -1,
   -1,   -1,   -1,  368,  369,   -1,  333,  372,   -1,  336,
   -1,  338,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,
   -1,  368,  369,
  };

#line 7571 "cs-parser.jay"

// <summary>
//  A class used to hold info about an operator declarator
// </summary>
class OperatorDeclaration {
	public readonly Operator.OpType optype;
	public readonly FullNamedExpression ret_type;
	public readonly Location location;

	public OperatorDeclaration (Operator.OpType op, FullNamedExpression ret_type, Location location)
	{
		optype = op;
		this.ret_type = ret_type;
		this.location = location;
	}
}

void Error_ExpectingTypeName (Expression expr)
{
	if (expr is Invocation){
		report.Error (1002, expr.Location, "Expecting `;'");
	} else {
		expr.Error_InvalidExpressionStatement (report);
	}
}

void Error_ParameterModifierNotValid (string modifier, Location loc)
{
	report.Error (631, loc, "The parameter modifier `{0}' is not valid in this context",
			              modifier);
}

void Error_DuplicateParameterModifier (Location loc, Parameter.Modifier mod)
{
	report.Error (1107, loc, "Duplicate parameter modifier `{0}'",
  		Parameter.GetModifierSignature (mod));
}

void Error_TypeExpected (Location loc)
{
	report.Error (1031, loc, "Type expected");
}

void Error_UnsafeCodeNotAllowed (Location loc)
{
	report.Error (227, loc, "Unsafe code requires the `unsafe' command line option to be specified");
}

void Warning_EmptyStatement (Location loc)
{
	report.Warning (642, 3, loc, "Possible mistaken empty statement");
}

void Error_NamedArgumentExpected (NamedArgument a)
{
	report.Error (1738, a.Location, "Named arguments must appear after the positional arguments");
}

void Error_MissingInitializer (Location loc)
{
	report.Error (210, loc, "You must provide an initializer in a fixed or using statement declaration");
}

object Error_AwaitAsIdentifier (object token)
{
	if (async_block) {
		report.Error (4003, GetLocation (token), "`await' cannot be used as an identifier within an async method or lambda expression");
		return new LocatedToken ("await", GetLocation (token));
	}

	return token;
}

void push_current_container (TypeDefinition tc, object partial_token)
{
	if (module.Evaluator != null){
		tc.Definition.Modifiers = tc.ModFlags = (tc.ModFlags & ~Modifiers.AccessibilityMask) | Modifiers.PUBLIC;
		if (undo == null)
			undo = new Undo ();

		undo.AddTypeContainer (current_container, tc);
	}
	
	if (partial_token != null)
		current_container.AddPartial (tc);
	else
		current_container.AddTypeContainer (tc);
		
	++lexer.parsing_declaration;
	current_container = tc;
	current_type = tc;
}

TypeContainer pop_current_class ()
{
	var retval = current_container;

	current_container = current_container.Parent;
	current_type = current_type.Parent as TypeDefinition;

	return retval;
}

[System.Diagnostics.Conditional ("FULL_AST")]
void StoreModifierLocation (object token, Location loc)
{
	if (lbag == null)
		return;

	if (mod_locations == null)
  		mod_locations = new List<Tuple<Modifiers, Location>> ();

	mod_locations.Add (Tuple.Create ((Modifiers) token, loc));
}

List<Tuple<Modifiers, Location>> GetModifierLocations ()
{
	var result = mod_locations;
	mod_locations = null;
	return result;
}

[System.Diagnostics.Conditional ("FULL_AST")]
void PushLocation (Location loc)
{
	if (location_stack == null)
		location_stack = new Stack<Location> ();

	location_stack.Push (loc);
}

Location PopLocation ()
{
	if (location_stack == null)
		return Location.Null;

	return location_stack.Pop ();
}

string CheckAttributeTarget (int token, string a, Location l)
{
	switch (a) {
	case "assembly" : case "module" : case "field" : case "method" : case "param" : case "property" : case "type" :
			return a;
	}

	if (!Tokenizer.IsValidIdentifier (a)) {
		Error_SyntaxError (token);
	} else {
		report.Warning (658, 1, l,
			 "`{0}' is invalid attribute target. All attributes in this attribute section will be ignored", a);
	}

	return string.Empty;
}

static bool IsUnaryOperator (Operator.OpType op)
{
	switch (op) {
		
	case Operator.OpType.LogicalNot: 
	case Operator.OpType.OnesComplement: 
	case Operator.OpType.Increment:
	case Operator.OpType.Decrement:
	case Operator.OpType.True: 
	case Operator.OpType.False: 
	case Operator.OpType.UnaryPlus: 
	case Operator.OpType.UnaryNegation:
		return true;
	}
	return false;
}

void syntax_error (Location l, string msg)
{
	report.Error (1003, l, "Syntax error, " + msg);
}

Tokenizer lexer;

public Tokenizer Lexer {
	get {
		return lexer;
	}
}		   

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, ParserSession session)
	: this (reader, file, file.Compiler.Report, session)
{
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, Report report, ParserSession session)
{
	this.file = file;
	current_container = current_namespace = file;
	
	this.module = file.Module;
	this.compiler = file.Compiler;
	this.settings = compiler.Settings;
	this.report = report;
	
	lang_version = settings.Version;
	yacc_verbose_flag = settings.VerboseParserFlag;
	doc_support = settings.DocumentationFile != null;
	lexer = new Tokenizer (reader, file, session, report);
	oob_stack = new Stack<object> ();
	lbag = session.LocationsBag;
	use_global_stacks = session.UseJayGlobalArrays;
	parameters_bucket = session.ParametersStack;
}

public void parse ()
{
	eof_token = Token.EOF;
	
	try {
		if (yacc_verbose_flag > 1)
			yyparse (lexer, new yydebug.yyDebugSimple ());
		else
			yyparse (lexer);
			
		Tokenizer tokenizer = lexer as Tokenizer;
		tokenizer.cleanup ();		
	} catch (Exception e){
	  	if (e is yyParser.yyUnexpectedEof) {
			Error_SyntaxError (yyToken);
			UnexpectedEOF = true;
			return;
		}
			
		if (e is yyParser.yyException) {
			if (report.Errors == 0)
				report.Error (-25, lexer.Location, "Parsing error");
		} else {
			// Used by compiler-tester to test internal errors
			if (yacc_verbose_flag > 0 || e is FatalException)
				throw;
		
			report.Error (589, lexer.Location, "Internal compiler error during parsing" + e);
		}
	}
}

void CheckToken (int error, int yyToken, string msg, Location loc)
{
	if (yyToken >= Token.FIRST_KEYWORD && yyToken <= Token.LAST_KEYWORD)
		report.Error (error, loc, "{0}: `{1}' is a keyword", msg, GetTokenName (yyToken));
	else
		report.Error (error, loc, msg);
}

string ConsumeStoredComment ()
{
	string s = tmpComment;
	tmpComment = null;
	Lexer.doc_state = XmlCommentState.Allowed;
	return s;
}

void FeatureIsNotAvailable (Location loc, string feature)
{
	report.FeatureIsNotAvailable (compiler, loc, feature);
}

Location GetLocation (object obj)
{
	var lt = obj as LocatedToken;
	if (lt != null)
		return lt.Location;
		
	var mn = obj as MemberName;
	if (mn != null)
		return mn.Location;
		
	var expr = obj as Expression;
	if (expr != null)
		return expr.Location;

	return lexer.Location;
}

void start_block (Location loc)
{
	if (current_block == null) {
		current_block = new ToplevelBlock (compiler, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else if (parsing_anonymous_method) {
		current_block = new ParametersBlock (current_block, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else {
		current_block = new ExplicitBlock (current_block, loc, Location.Null);
	}
}

Block
end_block (Location loc)
{
	Block retval = current_block.Explicit;
	retval.SetEndLocation (loc);
	current_block = retval.Parent;
	return retval;
}

void start_anonymous (bool isLambda, ParametersCompiled parameters, bool isAsync, Location loc)
{
	oob_stack.Push (current_anonymous_method);
	oob_stack.Push (current_local_parameters);
	oob_stack.Push (current_variable);
	oob_stack.Push (async_block);

	current_local_parameters = parameters;
	if (isLambda) {
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (loc, "lambda expressions");

		current_anonymous_method = new LambdaExpression (loc);
	} else {
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (loc, "anonymous methods");
			
		current_anonymous_method = new AnonymousMethodExpression (loc);
	}
	current_anonymous_method.IsAsync = isAsync;
	
	async_block = isAsync;
	// Force the next block to be created as a ToplevelBlock
	parsing_anonymous_method = true;
}

/*
 * Completes the anonymous method processing, if lambda_expr is null, this
 * means that we have a Statement instead of an Expression embedded 
 */
AnonymousMethodExpression end_anonymous (ParametersBlock anon_block)
{
	AnonymousMethodExpression retval;

	if (async_block)
		anon_block.IsAsync = true;

	current_anonymous_method.Block = anon_block;
	retval = current_anonymous_method;

	async_block = (bool) oob_stack.Pop ();
	current_variable = (BlockVariable) oob_stack.Pop ();
	current_local_parameters = (ParametersCompiled) oob_stack.Pop ();
	current_anonymous_method = (AnonymousMethodExpression) oob_stack.Pop ();

	return retval;
}

void Error_SyntaxError (int token)
{
	Error_SyntaxError (0, token);
}

void Error_SyntaxError (int error_code, int token)
{
	Error_SyntaxError (error_code, token, "Unexpected symbol");
}

void Error_SyntaxError (int error_code, int token, string msg)
{
	Lexer.CompleteOnEOF = false;

	// An error message has been reported by tokenizer
	if (token == Token.ERROR)
		return;
	
	// Avoid duplicit error message after unterminated string literals
	if (token == Token.LITERAL && lexer.Location.Column == 0)
		return;

	string symbol = GetSymbolName (token);
	string expecting = GetExpecting ();
	var loc = lexer.Location - symbol.Length;
	
	if (error_code == 0) {
		if (expecting == "`identifier'") {
			if (token > Token.FIRST_KEYWORD && token < Token.LAST_KEYWORD) {
				report.Error (1041, loc, "Identifier expected, `{0}' is a keyword", symbol);
				return;
			}
			
			error_code = 1001;
			expecting = "identifier";
		} else if (expecting == "`)'") {
			error_code = 1026;
		} else {
			error_code = 1525;
		}
	}
	
	if (string.IsNullOrEmpty (expecting))
		report.Error (error_code, loc, "{1} `{0}'", symbol, msg);
	else
		report.Error (error_code, loc, "{2} `{0}', expecting {1}", symbol, expecting, msg);	  
}

string GetExpecting ()
{
	int [] tokens = yyExpectingTokens (yyExpectingState);
	var names = new List<string> (tokens.Length);
	bool has_type = false;
	bool has_identifier = false;
	for (int i = 0; i < tokens.Length; i++){
		int token = tokens [i];
		has_identifier |= token == Token.IDENTIFIER;
		
		string name = GetTokenName (token);
		if (name == "<internal>")
			continue;
			
		has_type |= name == "type";
		if (names.Contains (name))
			continue;
		
		names.Add (name);
	}

	//
	// Too many tokens to enumerate
	//
	if (names.Count > 8)
		return null;

	if (has_type && has_identifier)
		names.Remove ("identifier");

	if (names.Count == 1)
		return "`" + GetTokenName (tokens [0]) + "'";
	
	StringBuilder sb = new StringBuilder ();
	names.Sort ();
	int count = names.Count;
	for (int i = 0; i < count; i++){
		bool last = i + 1 == count;
		if (last)
			sb.Append ("or ");
		sb.Append ('`');
		sb.Append (names [i]);
		sb.Append (last ? "'" : count < 3 ? "' " : "', ");
	}
	return sb.ToString ();
}


string GetSymbolName (int token)
{
	switch (token){
	case Token.LITERAL:
		return ((Constant)lexer.Value).GetValue ().ToString ();
	case Token.IDENTIFIER:
		return ((LocatedToken)lexer.Value).Value;

	case Token.BOOL:
		return "bool";
	case Token.BYTE:
		return "byte";
	case Token.CHAR:
		return "char";
	case Token.VOID:
		return "void";
	case Token.DECIMAL:
		return "decimal";
	case Token.DOUBLE:
		return "double";
	case Token.FLOAT:
		return "float";
	case Token.INT:
		return "int";
	case Token.LONG:
		return "long";
	case Token.SBYTE:
		return "sbyte";
	case Token.SHORT:
		return "short";
	case Token.STRING:
		return "string";
	case Token.UINT:
		return "uint";
	case Token.ULONG:
		return "ulong";
	case Token.USHORT:
		return "ushort";
	case Token.OBJECT:
		return "object";
		
	case Token.PLUS:
		return "+";
	case Token.UMINUS:
	case Token.MINUS:
		return "-";
	case Token.BANG:
		return "!";
	case Token.BITWISE_AND:
		return "&";
	case Token.BITWISE_OR:
		return "|";
	case Token.STAR:
		return "*";
	case Token.PERCENT:
		return "%";
	case Token.DIV:
		return "/";
	case Token.CARRET:
		return "^";
	case Token.OP_INC:
		return "++";
	case Token.OP_DEC:
		return "--";
	case Token.OP_SHIFT_LEFT:
		return "<<";
	case Token.OP_SHIFT_RIGHT:
		return ">>";
	case Token.OP_LT:
		return "<";
	case Token.OP_GT:
		return ">";
	case Token.OP_LE:
		return "<=";
	case Token.OP_GE:
		return ">=";
	case Token.OP_EQ:
		return "==";
	case Token.OP_NE:
		return "!=";
	case Token.OP_AND:
		return "&&";
	case Token.OP_OR:
		return "||";
	case Token.OP_PTR:
		return "->";
	case Token.OP_COALESCING:	
		return "??";
	case Token.OP_MULT_ASSIGN:
		return "*=";
	case Token.OP_DIV_ASSIGN:
		return "/=";
	case Token.OP_MOD_ASSIGN:
		return "%=";
	case Token.OP_ADD_ASSIGN:
		return "+=";
	case Token.OP_SUB_ASSIGN:
		return "-=";
	case Token.OP_SHIFT_LEFT_ASSIGN:
		return "<<=";
	case Token.OP_SHIFT_RIGHT_ASSIGN:
		return ">>=";
	case Token.OP_AND_ASSIGN:
		return "&=";
	case Token.OP_XOR_ASSIGN:
		return "^=";
	case Token.OP_OR_ASSIGN:
		return "|=";
	}

	return GetTokenName (token);
}

static string GetTokenName (int token)
{
	switch (token){
	case Token.ABSTRACT:
		return "abstract";
	case Token.AS:
		return "as";
	case Token.ADD:
		return "add";
	case Token.ASYNC:
		return "async";
	case Token.BASE:
		return "base";
	case Token.BREAK:
		return "break";
	case Token.CASE:
		return "case";
	case Token.CATCH:
		return "catch";
	case Token.CHECKED:
		return "checked";
	case Token.CLASS:
		return "class";
	case Token.CONST:
		return "const";
	case Token.CONTINUE:
		return "continue";
	case Token.DEFAULT:
		return "default";
	case Token.DELEGATE:
		return "delegate";
	case Token.DO:
		return "do";
	case Token.ELSE:
		return "else";
	case Token.ENUM:
		return "enum";
	case Token.EVENT:
		return "event";
	case Token.EXPLICIT:
		return "explicit";
	case Token.EXTERN:
	case Token.EXTERN_ALIAS:
		return "extern";
	case Token.FALSE:
		return "false";
	case Token.FINALLY:
		return "finally";
	case Token.FIXED:
		return "fixed";
	case Token.FOR:
		return "for";
	case Token.FOREACH:
		return "foreach";
	case Token.GOTO:
		return "goto";
	case Token.IF:
		return "if";
	case Token.IMPLICIT:
		return "implicit";
	case Token.IN:
		return "in";
	case Token.INTERFACE:
		return "interface";
	case Token.INTERNAL:
		return "internal";
	case Token.IS:
		return "is";
	case Token.LOCK:
		return "lock";
	case Token.NAMESPACE:
		return "namespace";
	case Token.NEW:
		return "new";
	case Token.NULL:
		return "null";
	case Token.OPERATOR:
		return "operator";
	case Token.OUT:
		return "out";
	case Token.OVERRIDE:
		return "override";
	case Token.PARAMS:
		return "params";
	case Token.PRIVATE:
		return "private";
	case Token.PROTECTED:
		return "protected";
	case Token.PUBLIC:
		return "public";
	case Token.READONLY:
		return "readonly";
	case Token.REF:
		return "ref";
	case Token.RETURN:
		return "return";
	case Token.REMOVE:
		return "remove";
	case Token.SEALED:
		return "sealed";
	case Token.SIZEOF:
		return "sizeof";
	case Token.STACKALLOC:
		return "stackalloc";
	case Token.STATIC:
		return "static";
	case Token.STRUCT:
		return "struct";
	case Token.SWITCH:
		return "switch";
	case Token.THIS:
		return "this";
	case Token.THROW:
		return "throw";
	case Token.TRUE:
		return "true";
	case Token.TRY:
		return "try";
	case Token.TYPEOF:
		return "typeof";
	case Token.UNCHECKED:
		return "unchecked";
	case Token.UNSAFE:
		return "unsafe";
	case Token.USING:
		return "using";
	case Token.VIRTUAL:
		return "virtual";
	case Token.VOLATILE:
		return "volatile";
	case Token.WHERE:
		return "where";
	case Token.WHILE:
		return "while";
	case Token.ARGLIST:
		return "__arglist";
	case Token.REFVALUE:
		return "__refvalue";
	case Token.REFTYPE:
		return "__reftype";
	case Token.MAKEREF:
		return "__makeref";
	case Token.PARTIAL:
		return "partial";
	case Token.ARROW:
		return "=>";
	case Token.FROM:
	case Token.FROM_FIRST:
		return "from";
	case Token.JOIN:
		return "join";
	case Token.ON:
		return "on";
	case Token.EQUALS:
		return "equals";
	case Token.SELECT:
		return "select";
	case Token.GROUP:
		return "group";
	case Token.BY:
		return "by";
	case Token.LET:
		return "let";
	case Token.ORDERBY:
		return "orderby";
	case Token.ASCENDING:
		return "ascending";
	case Token.DESCENDING:
		return "descending";
	case Token.INTO:
		return "into";
	case Token.GET:
		return "get";
	case Token.SET:
		return "set";
	case Token.OPEN_BRACE:
		return "{";
	case Token.CLOSE_BRACE:
		return "}";
	case Token.OPEN_BRACKET:
	case Token.OPEN_BRACKET_EXPR:
		return "[";
	case Token.CLOSE_BRACKET:
		return "]";
	case Token.OPEN_PARENS_CAST:
	case Token.OPEN_PARENS_LAMBDA:
	case Token.OPEN_PARENS:
		return "(";
	case Token.CLOSE_PARENS:
		return ")";
	case Token.DOT:
		return ".";
	case Token.COMMA:
		return ",";
	case Token.DEFAULT_COLON:
		return "default:";
	case Token.COLON:
		return ":";
	case Token.SEMICOLON:
		return ";";
	case Token.TILDE:
		return "~";
	case Token.WHEN:
		return "when";
	case Token.INTERPOLATED_STRING_END:
		return "}";
	case Token.INTERPOLATED_STRING:
		return "${";

	case Token.PLUS:
	case Token.UMINUS:
	case Token.MINUS:
	case Token.BANG:
	case Token.OP_LT:
	case Token.OP_GT:
	case Token.BITWISE_AND:
	case Token.BITWISE_OR:
	case Token.STAR:
	case Token.PERCENT:
	case Token.DIV:
	case Token.CARRET:
	case Token.OP_INC:
	case Token.OP_DEC:
	case Token.OP_SHIFT_LEFT:
	case Token.OP_SHIFT_RIGHT:
	case Token.OP_LE:
	case Token.OP_GE:
	case Token.OP_EQ:
	case Token.OP_NE:
	case Token.OP_AND:
	case Token.OP_OR:
	case Token.OP_PTR:
	case Token.OP_COALESCING:	
	case Token.OP_MULT_ASSIGN:
	case Token.OP_DIV_ASSIGN:
	case Token.OP_MOD_ASSIGN:
	case Token.OP_ADD_ASSIGN:
	case Token.OP_SUB_ASSIGN:
	case Token.OP_SHIFT_LEFT_ASSIGN:
	case Token.OP_SHIFT_RIGHT_ASSIGN:
	case Token.OP_AND_ASSIGN:
	case Token.OP_XOR_ASSIGN:
	case Token.OP_OR_ASSIGN:
	case Token.INTERR_OPERATOR:
		return "<operator>";

	case Token.BOOL:
	case Token.BYTE:
	case Token.CHAR:
	case Token.VOID:
	case Token.DECIMAL:
	case Token.DOUBLE:
	case Token.FLOAT:
	case Token.INT:
	case Token.LONG:
	case Token.SBYTE:
	case Token.SHORT:
	case Token.STRING:
	case Token.UINT:
	case Token.ULONG:
	case Token.USHORT:
	case Token.OBJECT:
		return "type";
	
	case Token.ASSIGN:
		return "=";
	case Token.OP_GENERICS_LT:
	case Token.GENERIC_DIMENSION:
		return "<";
	case Token.OP_GENERICS_GT:
		return ">";
	case Token.INTERR:
	case Token.INTERR_NULLABLE:
		return "?";
	case Token.DOUBLE_COLON:
		return "::";
	case Token.LITERAL:
		return "value";
	case Token.IDENTIFIER:
	case Token.AWAIT:
		return "identifier";

	case Token.EOF:
		return "end-of-file";

		// All of these are internal.
	case Token.NONE:
	case Token.ERROR:
	case Token.FIRST_KEYWORD:
	case Token.EVAL_COMPILATION_UNIT_PARSER:
	case Token.EVAL_USING_DECLARATIONS_UNIT_PARSER:
	case Token.EVAL_STATEMENT_PARSER:
	case Token.LAST_KEYWORD:
	case Token.GENERATE_COMPLETION:
	case Token.COMPLETE_COMPLETION:
		return "<internal>";

		// A bit more robust.
	default:
		return yyNames [token];
        }
}

/* end end end */
}
#line default
namespace yydebug {
        using System;
	 internal interface yyDebug {
		 void push (int state, Object value);
		 void lex (int state, int token, string name, Object value);
		 void shift (int from, int to, int errorFlag);
		 void pop (int state);
		 void discard (int state, int token, string name, Object value);
		 void reduce (int from, int to, int rule, string text, int len);
		 void shift (int from, int to);
		 void accept (Object value);
		 void error (string message);
		 void reject ();
	 }
	 
	 class yyDebugSimple : yyDebug {
		 void println (string s){
			 Console.Error.WriteLine (s);
		 }
		 
		 public void push (int state, Object value) {
			 println ("push\tstate "+state+"\tvalue "+value);
		 }
		 
		 public void lex (int state, int token, string name, Object value) {
			 println("lex\tstate "+state+"\treading "+name+"\tvalue "+value);
		 }
		 
		 public void shift (int from, int to, int errorFlag) {
			 switch (errorFlag) {
			 default:				// normally
				 println("shift\tfrom state "+from+" to "+to);
				 break;
			 case 0: case 1: case 2:		// in error recovery
				 println("shift\tfrom state "+from+" to "+to
					     +"\t"+errorFlag+" left to recover");
				 break;
			 case 3:				// normally
				 println("shift\tfrom state "+from+" to "+to+"\ton error");
				 break;
			 }
		 }
		 
		 public void pop (int state) {
			 println("pop\tstate "+state+"\ton error");
		 }
		 
		 public void discard (int state, int token, string name, Object value) {
			 println("discard\tstate "+state+"\ttoken "+name+"\tvalue "+value);
		 }
		 
		 public void reduce (int from, int to, int rule, string text, int len) {
			 println("reduce\tstate "+from+"\tuncover "+to
				     +"\trule ("+rule+") "+text);
		 }
		 
		 public void shift (int from, int to) {
			 println("goto\tfrom state "+from+" to "+to);
		 }
		 
		 public void accept (Object value) {
			 println("accept\tvalue "+value);
		 }
		 
		 public void error (string message) {
			 println("error\t"+message);
		 }
		 
		 public void reject () {
			 println("reject");
		 }
		 
	 }
}
// %token constants
 class Token {
  public const int EOF = 257;
  public const int NONE = 258;
  public const int ERROR = 259;
  public const int FIRST_KEYWORD = 260;
  public const int ABSTRACT = 261;
  public const int AS = 262;
  public const int ADD = 263;
  public const int BASE = 264;
  public const int BOOL = 265;
  public const int BREAK = 266;
  public const int BYTE = 267;
  public const int CASE = 268;
  public const int CATCH = 269;
  public const int CHAR = 270;
  public const int CHECKED = 271;
  public const int CLASS = 272;
  public const int CONST = 273;
  public const int CONTINUE = 274;
  public const int DECIMAL = 275;
  public const int DEFAULT = 276;
  public const int DELEGATE = 277;
  public const int DO = 278;
  public const int DOUBLE = 279;
  public const int ELSE = 280;
  public const int ENUM = 281;
  public const int EVENT = 282;
  public const int EXPLICIT = 283;
  public const int EXTERN = 284;
  public const int FALSE = 285;
  public const int FINALLY = 286;
  public const int FIXED = 287;
  public const int FLOAT = 288;
  public const int FOR = 289;
  public const int FOREACH = 290;
  public const int GOTO = 291;
  public const int IF = 292;
  public const int IMPLICIT = 293;
  public const int IN = 294;
  public const int INT = 295;
  public const int INTERFACE = 296;
  public const int INTERNAL = 297;
  public const int IS = 298;
  public const int LOCK = 299;
  public const int LONG = 300;
  public const int NAMESPACE = 301;
  public const int NEW = 302;
  public const int NULL = 303;
  public const int OBJECT = 304;
  public const int OPERATOR = 305;
  public const int OUT = 306;
  public const int OVERRIDE = 307;
  public const int PARAMS = 308;
  public const int PRIVATE = 309;
  public const int PROTECTED = 310;
  public const int PUBLIC = 311;
  public const int READONLY = 312;
  public const int REF = 313;
  public const int RETURN = 314;
  public const int REMOVE = 315;
  public const int SBYTE = 316;
  public const int SEALED = 317;
  public const int SHORT = 318;
  public const int SIZEOF = 319;
  public const int STACKALLOC = 320;
  public const int STATIC = 321;
  public const int STRING = 322;
  public const int STRUCT = 323;
  public const int SWITCH = 324;
  public const int THIS = 325;
  public const int THROW = 326;
  public const int TRUE = 327;
  public const int TRY = 328;
  public const int TYPEOF = 329;
  public const int UINT = 330;
  public const int ULONG = 331;
  public const int UNCHECKED = 332;
  public const int UNSAFE = 333;
  public const int USHORT = 334;
  public const int USING = 335;
  public const int VIRTUAL = 336;
  public const int VOID = 337;
  public const int VOLATILE = 338;
  public const int WHERE = 339;
  public const int WHILE = 340;
  public const int ARGLIST = 341;
  public const int PARTIAL = 342;
  public const int ARROW = 343;
  public const int FROM = 344;
  public const int FROM_FIRST = 345;
  public const int JOIN = 346;
  public const int ON = 347;
  public const int EQUALS = 348;
  public const int SELECT = 349;
  public const int GROUP = 350;
  public const int BY = 351;
  public const int LET = 352;
  public const int ORDERBY = 353;
  public const int ASCENDING = 354;
  public const int DESCENDING = 355;
  public const int INTO = 356;
  public const int INTERR_NULLABLE = 357;
  public const int EXTERN_ALIAS = 358;
  public const int REFVALUE = 359;
  public const int REFTYPE = 360;
  public const int MAKEREF = 361;
  public const int ASYNC = 362;
  public const int AWAIT = 363;
  public const int INTERR_OPERATOR = 364;
  public const int WHEN = 365;
  public const int INTERPOLATED_STRING = 366;
  public const int INTERPOLATED_STRING_END = 367;
  public const int GET = 368;
  public const int SET = 369;
  public const int LAST_KEYWORD = 370;
  public const int OPEN_BRACE = 371;
  public const int CLOSE_BRACE = 372;
  public const int OPEN_BRACKET = 373;
  public const int CLOSE_BRACKET = 374;
  public const int OPEN_PARENS = 375;
  public const int CLOSE_PARENS = 376;
  public const int DOT = 377;
  public const int COMMA = 378;
  public const int COLON = 379;
  public const int SEMICOLON = 380;
  public const int TILDE = 381;
  public const int PLUS = 382;
  public const int MINUS = 383;
  public const int BANG = 384;
  public const int ASSIGN = 385;
  public const int OP_LT = 386;
  public const int OP_GT = 387;
  public const int BITWISE_AND = 388;
  public const int BITWISE_OR = 389;
  public const int STAR = 390;
  public const int PERCENT = 391;
  public const int DIV = 392;
  public const int CARRET = 393;
  public const int INTERR = 394;
  public const int DOUBLE_COLON = 395;
  public const int OP_INC = 396;
  public const int OP_DEC = 397;
  public const int OP_SHIFT_LEFT = 398;
  public const int OP_SHIFT_RIGHT = 399;
  public const int OP_LE = 400;
  public const int OP_GE = 401;
  public const int OP_EQ = 402;
  public const int OP_NE = 403;
  public const int OP_AND = 404;
  public const int OP_OR = 405;
  public const int OP_MULT_ASSIGN = 406;
  public const int OP_DIV_ASSIGN = 407;
  public const int OP_MOD_ASSIGN = 408;
  public const int OP_ADD_ASSIGN = 409;
  public const int OP_SUB_ASSIGN = 410;
  public const int OP_SHIFT_LEFT_ASSIGN = 411;
  public const int OP_SHIFT_RIGHT_ASSIGN = 412;
  public const int OP_AND_ASSIGN = 413;
  public const int OP_XOR_ASSIGN = 414;
  public const int OP_OR_ASSIGN = 415;
  public const int OP_PTR = 416;
  public const int OP_COALESCING = 417;
  public const int OP_GENERICS_LT = 418;
  public const int OP_GENERICS_LT_DECL = 419;
  public const int OP_GENERICS_GT = 420;
  public const int LITERAL = 421;
  public const int IDENTIFIER = 422;
  public const int OPEN_PARENS_LAMBDA = 423;
  public const int OPEN_PARENS_CAST = 424;
  public const int GENERIC_DIMENSION = 425;
  public const int DEFAULT_COLON = 426;
  public const int OPEN_BRACKET_EXPR = 427;
  public const int EVAL_STATEMENT_PARSER = 428;
  public const int EVAL_COMPILATION_UNIT_PARSER = 429;
  public const int EVAL_USING_DECLARATIONS_UNIT_PARSER = 430;
  public const int DOC_SEE = 431;
  public const int GENERATE_COMPLETION = 432;
  public const int COMPLETE_COMPLETION = 433;
  public const int UMINUS = 434;
  public const int yyErrorCode = 256;
 }
 namespace yyParser {
  using System;
  /** thrown for irrecoverable syntax errors and stack overflow.
    */
  internal class yyException : System.Exception {
    public yyException (string message) : base (message) {
    }
  }
  internal class yyUnexpectedEof : yyException {
    public yyUnexpectedEof (string message) : base (message) {
    }
    public yyUnexpectedEof () : base ("") {
    }
  }

  /** must be implemented by a scanner object to supply input to the parser.
    */
  internal interface yyInput {
    /** move on to next token.
        @return false if positioned beyond tokens.
        @throws IOException on input error.
      */
    bool advance (); // throws java.io.IOException;
    /** classifies current token.
        Should not be called if advance() returned false.
        @return current %token or single character.
      */
    int token ();
    /** associated with current token.
        Should not be called if advance() returned false.
        @return value for token().
      */
    Object value ();
  }
 }
} // close outermost namespace, that MUST HAVE BEEN opened in the prolog
