/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;

public class ReferenceQueue {
    static ReferenceQueue NULL = new Null();
    static ReferenceQueue ENQUEUED = new Null();
    private Lock lock = new Lock();
    private Reference head = null;
    private long queueLength = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueue(Reference reference) {
        Reference reference2 = reference;
        synchronized (reference2) {
            if (reference.queue == ENQUEUED) {
                return false;
            }
            Lock lock = this.lock;
            synchronized (lock) {
                reference.queue = ENQUEUED;
                reference.next = this.head == null ? reference : this.head;
                this.head = reference;
                ++this.queueLength;
                this.lock.notifyAll();
                return true;
            }
        }
    }

    private Reference reallyPoll() {
        if (this.head != null) {
            Reference reference = this.head;
            this.head = reference.next == reference ? null : reference.next;
            reference.queue = NULL;
            reference.next = reference;
            --this.queueLength;
            return reference;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference poll() {
        Lock lock = this.lock;
        synchronized (lock) {
            return this.reallyPoll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference remove(long l) throws IllegalArgumentException, InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout value");
        }
        Lock lock = this.lock;
        synchronized (lock) {
            Reference reference = this.reallyPoll();
            if (reference != null) {
                return reference;
            }
            do {
                this.lock.wait(l);
                reference = this.reallyPoll();
                if (reference == null) continue;
                return reference;
            } while (l == 0L);
            return null;
        }
    }

    public Reference remove() throws InterruptedException {
        return this.remove(0L);
    }

    private static class Lock {
        private Lock() {
        }
    }

    private static class Null
    extends ReferenceQueue {
        private Null() {
        }

        boolean enqueue(Reference reference) {
            return false;
        }
    }
}

