/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me.socket;

import com.sun.cdc.io.ConnectionBase;
import com.sun.cdc.io.j2me.UniversalFilterInputStream;
import com.sun.cdc.io.j2me.UniversalFilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.microedition.io.Connection;
import javax.microedition.io.SocketConnection;
import javax.microedition.io.StreamConnection;

public class Protocol
extends ConnectionBase
implements StreamConnection,
SocketConnection {
    Socket socket;
    int opens = 0;
    boolean ipv6 = false;

    public void open(String string, int n, boolean bl) throws IOException {
        throw new RuntimeException("Should not be called");
    }

    protected void checkPermission(String string, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (string != null) {
                securityManager.checkConnect(string, n);
            } else {
                securityManager.checkConnect("localhost", n);
            }
        }
    }

    protected void outputStreamPermissionCheck() {
    }

    protected void inputStreamPermissionCheck() {
    }

    public Connection openPrim(String string, int n, boolean bl) throws IOException {
        if (string.charAt(0) != '/' || string.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\" " + string);
        }
        string = string.substring(2);
        try {
            int n2;
            String string2 = "";
            int n3 = string.indexOf(58);
            if (n3 != -1 && ((string2 = this.parseHostName(string, n3)).indexOf(47) != -1 || string2.indexOf(64) != -1 || string2.indexOf(63) != -1 || string2.indexOf(59) != -1)) {
                throw new IllegalArgumentException("hostname " + string2 + " cannot contain \"?\" , \"@\" , \";\", \":\", or \"/\" character.");
            }
            if (string2.length() == 0) {
                com.sun.cdc.io.j2me.serversocket.Protocol protocol = new com.sun.cdc.io.j2me.serversocket.Protocol();
                protocol.open("//" + string, n, bl);
                return protocol;
            }
            if (this.ipv6) {
                int n4 = string.lastIndexOf(":");
                n2 = Integer.parseInt(string.substring(n4 + 1));
            } else {
                n2 = Integer.parseInt(string.substring(n3 + 1));
            }
            this.checkPermission(string2, n2);
            final String string3 = string2;
            this.socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PrivilegedActionException, IOException {
                    return new Socket(string3, n2);
                }
            });
            ++this.opens;
            return this;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid port number in " + string);
        }
        catch (PrivilegedActionException privilegedActionException) {
            IOException iOException = (IOException)privilegedActionException.getException();
            throw iOException;
        }
    }

    public void open(Socket socket) throws IOException {
        this.socket = socket;
    }

    private String parseHostName(String string, int n) {
        int n2;
        int n3 = string.indexOf("[");
        if (n3 > (n2 = string.indexOf("]"))) {
            throw new IllegalArgumentException("invalid host name " + string);
        }
        if (n3 == 0 && n2 > 0) {
            return this.parseIPv6Address(string, n2);
        }
        return this.parseIPv4Address(string, n);
    }

    private String parseIPv4Address(String string, int n) {
        return string.substring(0, n);
    }

    private String parseIPv6Address(String string, int n) {
        this.ipv6 = true;
        return string.substring(0, n + 1);
    }

    public InputStream openInputStream() throws IOException {
        this.inputStreamPermissionCheck();
        UniversalFilterInputStream universalFilterInputStream = new UniversalFilterInputStream(this, this.socket.getInputStream());
        ++this.opens;
        return universalFilterInputStream;
    }

    public OutputStream openOutputStream() throws IOException {
        this.outputStreamPermissionCheck();
        UniversalFilterOutputStream universalFilterOutputStream = new UniversalFilterOutputStream(this, this.socket.getOutputStream());
        ++this.opens;
        return universalFilterOutputStream;
    }

    public void close() throws IOException {
        if (--this.opens == 0) {
            this.socket.close();
        }
    }

    public void setSocketOption(byte by, int n) throws IllegalArgumentException, IOException {
        if (this.socket.isClosed()) {
            throw new IOException("Socket is closed");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Value cannot be negative");
        }
        switch (by) {
            case 0: {
                this.socket.setTcpNoDelay(n != 0);
                break;
            }
            case 2: {
                this.socket.setKeepAlive(n != 0);
                break;
            }
            case 1: {
                this.socket.setSoLinger(n != 0, n);
                break;
            }
            case 3: {
                this.socket.setReceiveBufferSize(n);
                break;
            }
            case 4: {
                this.socket.setSendBufferSize(n);
                break;
            }
            default: {
                throw new IllegalArgumentException("Option identifier is out of range");
            }
        }
    }

    public int getSocketOption(byte by) throws IllegalArgumentException, IOException {
        if (this.socket.isClosed()) {
            throw new IOException("Socket is closed");
        }
        switch (by) {
            case 0: {
                return this.socket.getTcpNoDelay() ? 1 : 0;
            }
            case 2: {
                return this.socket.getKeepAlive() ? 1 : 0;
            }
            case 1: {
                return this.socket.getSoLinger();
            }
            case 3: {
                return this.socket.getReceiveBufferSize();
            }
            case 4: {
                return this.socket.getSendBufferSize();
            }
        }
        throw new IllegalArgumentException("Option identifier is out of range");
    }

    public String getLocalAddress() throws IOException {
        if (this.socket.isClosed()) {
            throw new IOException("Socket is closed");
        }
        return this.socket.getLocalAddress().getHostName();
    }

    public int getLocalPort() throws IOException {
        if (this.socket.isClosed()) {
            throw new IOException("Socket is closed");
        }
        return this.socket.getLocalPort();
    }

    public String getAddress() throws IOException {
        if (this.socket.isClosed()) {
            throw new IOException("Socket is closed");
        }
        return this.socket.getInetAddress().getHostName();
    }

    public int getPort() throws IOException {
        if (this.socket.isClosed()) {
            throw new IOException("Socket is closed");
        }
        return this.socket.getPort();
    }
}

