/*
 *  @(#)DefaultTestRecord.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.itf.impl;

import net.sourceforge.groboutils.pmti.v1.itf.ITestRecord;



/**
 * Simple changeable implementation of ITestRecord.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:00 $
 * @since      July 7, 2002
 */
public class DefaultTestRecord extends ImmutableTestRecord
{
    
    private String name;
    private String suite;
    private int tCount;
    private long tRuntime;
    private String[] failures;
    private String[] errors;
    private String log;
    
    
    public DefaultTestRecord()
    {
        super();
    }
    
    
    public DefaultTestRecord( ITestRecord tr )
    {
        super( tr );
    }
    
    
    public void setTestName( String name )
    {
        super.setTestName( name );
    }
    
    
    public void setTestSuite( String suite )
    {
        super.setTestSuite( suite );
    }
    
    
    public void setTestCount( int count )
    {
        super.setTestCount( count );
    }
    
    
    public void setRuntime( long time )
    {
        super.setRuntime( time );
    }
    
    
    public void setFailures( String[] f )
    {
        super.setFailures( f );
    }
    
    
    public void setErrors( String[] e )
    {
        super.setErrors( e );
    }
    
    
    public void setLog( String log )
    {
        super.setLog( log );
    }
    
    
    public ImmutableTestRecord createImmutable()
    {
        return new ImmutableTestRecord( this );
    }
}

