/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__EQUIPMENT_HPP)
#include <Equipment.hpp>
#endif

using namespace corelinux;

//
// Default constructor throws
// exception
//

Equipment::Equipment( void ) throw( CompositeException )
   :
   theName("")
{
   throw CompositeException( LOCATION );
}

//
// Valid default constructor
//

Equipment::Equipment( NameCref aName )
   :
   theName( aName )
{
   ;  // do nothing
}

//
// Copy constructor
//

Equipment::Equipment( EquipmentCref aRef )
   :
   theName( aRef.getName() )
{
   ;  // do nothing
}

//
// Destructor
//

Equipment::~Equipment( void )
{
   ;  // do nothing
}

//
// Assignment operator throws exception
//

EquipmentRef   Equipment::operator=( EquipmentCref )
   throw(CORELINUX(CompositeException))
{
   throw CompositeException( LOCATION );
   return (*this);
}

//
// Equality operator overload
//

bool  Equipment::operator==( EquipmentCref aRef ) const
{
   return (theName == aRef.getName() );
}

//
// Retrieve theName
//

NameCref Equipment::getName( void ) const
{
   return theName;
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/01/21 03:44:01 $
   $Locker:  $
*/

