typedef enum {
	GIT_OK         =  0,		/**< No error */

	GIT_ERROR      = -1,		/**< Generic error */
	GIT_ENOTFOUND  = -3,		/**< Requested object could not be found */
	GIT_EEXISTS    = -4,		/**< Object exists preventing operation */
	GIT_EAMBIGUOUS = -5,		/**< More than one object matches */
	GIT_EBUFS      = -6,		/**< Output buffer too short to hold data */

	/**
	 * GIT_EUSER is a special error that is never generated by libgit2
	 * code.  You can return it from a callback (e.g to stop an iteration)
	 * to know that it was generated by the callback and not by libgit2.
	 */
	GIT_EUSER      = -7,

	GIT_EBAREREPO       =  -8,	/**< Operation not allowed on bare repository */
	GIT_EUNBORNBRANCH   =  -9,	/**< HEAD refers to branch with no commits */
	GIT_EUNMERGED       = -10,	/**< Merge in progress prevented operation */
	GIT_ENONFASTFORWARD = -11,	/**< Reference was not fast-forwardable */
	GIT_EINVALIDSPEC    = -12,	/**< Name/ref spec was not in a valid format */
	GIT_ECONFLICT       = -13,	/**< Checkout conflicts prevented operation */
	GIT_ELOCKED         = -14,	/**< Lock file prevented operation */
	GIT_EMODIFIED       = -15,	/**< Reference value does not match expected */
	GIT_EAUTH           = -16,	/**< Authentication error */
	GIT_ECERTIFICATE    = -17,	/**< Server certificate is invalid */
	GIT_EAPPLIED        = -18,	/**< Patch/merge has already been applied */
	GIT_EPEEL           = -19,	/**< The requested peel operation is not possible */
	GIT_EEOF            = -20,	/**< Unexpected EOF */
	GIT_EINVALID        = -21,	/**< Invalid operation or input */
	GIT_EUNCOMMITTED    = -22,	/**< Uncommitted changes in index prevented operation */
	GIT_EDIRECTORY      = -23,	/**< The operation is not valid for a directory */
	GIT_EMERGECONFLICT  = -24,	/**< A merge conflict exists and cannot continue */

	GIT_PASSTHROUGH     = -30,	/**< A user-configured callback refused to act */
	GIT_ITEROVER        = -31,	/**< Signals end of iteration with iterator */
	GIT_RETRY           = -32,	/**< Internal only */
	GIT_EMISMATCH       = -33,	/**< Hashsum mismatch in object */
	GIT_EINDEXDIRTY     = -34,	/**< Unsaved changes in the index would be overwritten */
	GIT_EAPPLYFAIL      = -35,	/**< Patch application failed */
	GIT_EOWNER          = -36,	/**< The object is not owned by the current user */
	GIT_TIMEOUT         = -37	/**< The operation timed out */
} git_error_code;

typedef struct {
	char *message;
	int klass;
} git_error;


const git_error * git_error_last(void);
