# User Guide

This user guide provides detailed information about how to use Param, assuming you have worked through the Getting Started guide.

- [Simplifying Codebases](./Simplifying_Codebases): How Param allows you to eliminate boilerplate and unsafe code 
- [Parameters](./Parameters): Using parameters (Class vs. instance parameters, setting defaults, etc.)
- [Parameter Types](./Parameter_Types): Predefined Parameter classes available for your use
- [Dependencies and Watchers](./Dependencies_and_Watchers): Expressing relationships between parameters and parameters or code, and triggering events
- [Serialization and Persistence](./Serialization_and_Persistence): Saving the state of a Parameterized object to a text, script, or pickle file
- [Outputs](./Outputs): Output types and connecting output to Parameter inputs
- [Logging and Warnings](./Logging_and_Warnings): Logging, messaging, warning, and raising errors on Parameterized objects
- [ParameterizedFunctions](./ParameterizedFunctions): Parameterized function objects, for configurable callables
- [Dynamic Parameters](./Dynamic_Parameters): Using dynamic parameter values with and without Numbergen
- [How Param Works](./How_Param_Works): Internal details, for Param developers and power users
- [Using Param in GUIs](https://panel.holoviz.org/user_guide/Param.html): (external site) Using Param with Panel to make GUIs

```{toctree}
---
hidden: true
maxdepth: 2
---
Overview <self>
Simplifying Codebases <Simplifying_Codebases>
Parameters <Parameters>
Parameter Types <Parameter_Types>
Dependencies and Watchers <Dependencies_and_Watchers>
Serialization and Persistence <Serialization_and_Persistence>
Outputs <Outputs>
Logging and Warnings <Logging_and_Warnings>
ParameterizedFunctions <ParameterizedFunctions>
Dynamic Parameters <Dynamic_Parameters>
How Param Works <How_Param_Works>
```
