# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AvailabilityStateValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Impacted resource status of the resource."""

    AVAILABLE = "Available"
    UNAVAILABLE = "Unavailable"
    DEGRADED = "Degraded"
    UNKNOWN = "Unknown"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class EventLevelValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Level of event."""

    CRITICAL = "Critical"
    ERROR = "Error"
    WARNING = "Warning"
    INFORMATIONAL = "Informational"


class EventSourceValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Source of event."""

    RESOURCE_HEALTH = "ResourceHealth"
    SERVICE_HEALTH = "ServiceHealth"


class EventStatusValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current status of event."""

    ACTIVE = "Active"
    RESOLVED = "Resolved"


class EventTypeValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of event."""

    SERVICE_ISSUE = "ServiceIssue"
    PLANNED_MAINTENANCE = "PlannedMaintenance"
    HEALTH_ADVISORY = "HealthAdvisory"
    RCA = "RCA"
    EMERGING_ISSUES = "EmergingIssues"
    SECURITY_ADVISORY = "SecurityAdvisory"


class IssueNameParameter(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IssueNameParameter."""

    DEFAULT = "default"


class LevelValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Level of insight."""

    CRITICAL = "Critical"
    WARNING = "Warning"


class LinkTypeValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of link."""

    BUTTON = "Button"
    HYPERLINK = "Hyperlink"


class ReasonChronicityTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Chronicity of the availability transition."""

    TRANSIENT = "Transient"
    PERSISTENT = "Persistent"


class ReasonTypeValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """When the resource's availabilityState is Unavailable, it describes where the health impacting
    event was originated.
    """

    UNPLANNED = "Unplanned"
    PLANNED = "Planned"
    USER_INITIATED = "UserInitiated"


class Scenario(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scenario."""

    ALERTS = "Alerts"


class SeverityValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The severity level of this active event."""

    INFORMATION = "Information"
    WARNING = "Warning"
    ERROR = "Error"


class StageValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The stage of this active event."""

    ACTIVE = "Active"
    RESOLVE = "Resolve"
    ARCHIVED = "Archived"
