# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class ApiVersionSetContract(Resource):
    """Api Version Set Contract details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param description: Description of API Version Set.
    :type description: str
    :param version_query_name: Name of query parameter that indicates the API
     Version if versioningScheme is set to `query`.
    :type version_query_name: str
    :param version_header_name: Name of HTTP header parameter that indicates
     the API Version if versioningScheme is set to `header`.
    :type version_header_name: str
    :param display_name: Required. Name of API Version Set
    :type display_name: str
    :param versioning_scheme: Required. An value that determines where the API
     Version identifer will be located in a HTTP request. Possible values
     include: 'Segment', 'Query', 'Header'
    :type versioning_scheme: str or
     ~azure.mgmt.apimanagement.models.VersioningScheme
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'version_query_name': {'max_length': 100, 'min_length': 1},
        'version_header_name': {'max_length': 100, 'min_length': 1},
        'display_name': {'required': True, 'max_length': 100, 'min_length': 1},
        'versioning_scheme': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'version_query_name': {'key': 'properties.versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'properties.versionHeaderName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'versioning_scheme': {'key': 'properties.versioningScheme', 'type': 'str'},
    }

    def __init__(self, *, display_name: str, versioning_scheme, description: str=None, version_query_name: str=None, version_header_name: str=None, **kwargs) -> None:
        super(ApiVersionSetContract, self).__init__(**kwargs)
        self.description = description
        self.version_query_name = version_query_name
        self.version_header_name = version_header_name
        self.display_name = display_name
        self.versioning_scheme = versioning_scheme
