# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationInfo(Model):
    """Information about a Service Fabric application.

    :param id:
    :type id: str
    :param name: The Uniform Resource Identifier(URI) of the application.
    :type name: str
    :param type_name: The Name of the application type as specified in the
     Application Manifest.
    :type type_name: str
    :param type_version: The version of the application type as specified in
     the Application Manifest.
    :type type_version: str
    :param status: Possible values include: 'Invalid', 'Ready', 'Upgrading',
     'Creating', 'Deleting', 'Failed'
    :type status: str
    :param parameters:
    :type parameters: list of :class:`ApplicationParameter
     <azure.servicefabric.models.ApplicationParameter>`
    :param health_state: Possible values include: 'Invalid', 'Ok', 'Warning',
     'Error', 'Unknown'
    :type health_state: str
    """ 

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'type_name': {'key': 'TypeName', 'type': 'str'},
        'type_version': {'key': 'TypeVersion', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'parameters': {'key': 'Parameters', 'type': '[ApplicationParameter]'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
    }

    def __init__(self, id=None, name=None, type_name=None, type_version=None, status=None, parameters=None, health_state=None):
        self.id = id
        self.name = name
        self.type_name = type_name
        self.type_version = type_version
        self.status = status
        self.parameters = parameters
        self.health_state = health_state
