/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public final class IOHelper {
    private static final int IO_BUF_SIZE = 32768;
    private static final String BACKSLASH = "\\";
    private static final String SLASH = "/";

    public static String createDirectoryTreeForFolder(String folder) throws IOException {
        File f;
        if (folder == null) {
            throw new IOException("The requested folder is null!");
        }
        if (!folder.endsWith(BACKSLASH) && !folder.endsWith(SLASH)) {
            folder = folder + SLASH;
        }
        if (!(f = new File(folder)).exists()) {
            boolean result = f.mkdirs();
            if (!result) {
                throw new IOException("Cannot create folder structure for: " + folder);
            }
        } else if (!f.isDirectory()) {
            throw new IOException("Invalid directory/Cannot create directory: " + folder);
        }
        return folder;
    }

    public static void createDirectoryTreeForFile(String file) throws IOException {
        if (file == null) {
            throw new IOException("null file requested!");
        }
        String path = null;
        int sep1 = file.lastIndexOf(BACKSLASH);
        int sep2 = file.lastIndexOf(SLASH);
        if (sep1 == -1 && sep2 == -1) {
            path = file;
        } else if (sep1 != -1) {
            path = file.substring(0, sep1);
        } else if (sep2 != -1) {
            path = file.substring(0, sep2);
        } else {
            throw new IOException("Cannot create folder structure for: " + file);
        }
        IOHelper.createDirectoryTreeForFolder(path);
    }

    public static boolean isTheSameFile(String pathname1, String pathname2) throws IOException {
        File file1 = new File(pathname1);
        File file2 = new File(pathname2);
        file1 = file1.getCanonicalFile();
        file2 = file2.getCanonicalFile();
        return file1.equals(file2);
    }

    public static boolean fileOrDirectoryExists(String pathname) {
        File f = new File(pathname);
        return f.exists();
    }

    public static boolean isFile(String pathname) {
        File f = new File(pathname);
        return f.isFile();
    }

    public static boolean isDirectory(String pathname) {
        File f = new File(pathname);
        return f.isDirectory();
    }

    public static void saveTxtFile(String pathname, String data, boolean append) throws IOException {
        IOHelper.saveTxtFile(new File(pathname), data, append);
    }

    public static void saveTxtFile(File f, String data, boolean append) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(f, append));
            out.write(data);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static String readTxtFile(String pathname) throws IOException {
        return IOHelper.readTxtFile(new File(pathname));
    }

    public static String readTxtFile(File f) throws IOException {
        BufferedReader in = null;
        StringBuilder strBuf = new StringBuilder();
        try {
            in = new BufferedReader(new FileReader(f));
            String str = null;
            while ((str = in.readLine()) != null) {
                strBuf.append(str);
                strBuf.append("\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return strBuf.toString();
    }

    public static boolean deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = IOHelper.deleteDirectory(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteDirectory(String pathname) {
        return IOHelper.deleteDirectory(new File(pathname));
    }

    public static boolean deleteFile(String pathname) {
        File f = new File(pathname);
        return f.delete();
    }

    public static boolean copyFile(String fromName, String toName, boolean overwrite) throws IOException {
        if (fromName == null) {
            throw new IOException("source filename is null!");
        }
        if (toName == null) {
            throw new IOException("destination filename is null!");
        }
        File fromFile = new File(fromName);
        File toFile = new File(toName);
        return IOHelper.copyFile(fromFile, toFile, overwrite);
    }

    public static boolean copyFile(File fromFile, File toFile, boolean overwrite) throws IOException {
        if (fromFile == null) {
            throw new IOException("source file is null!");
        }
        if (toFile == null) {
            throw new IOException("destination file is null!");
        }
        if (!fromFile.exists()) {
            throw new IOException("no such source file: " + fromFile.getAbsoluteFile());
        }
        if (!fromFile.isFile()) {
            throw new IOException("can't copy directory: " + fromFile.getAbsoluteFile());
        }
        if (!fromFile.canRead()) {
            throw new IOException("source file is unreadable: " + fromFile.getAbsoluteFile());
        }
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        if (toFile.exists()) {
            if (!toFile.canWrite()) {
                throw new IOException("destination file is unwriteable: " + toFile.getAbsoluteFile());
            }
            if (!overwrite) {
                return false;
            }
        } else {
            File dir;
            String parent = toFile.getParent();
            if (parent == null) {
                parent = System.getProperty("user.dir");
            }
            if (!(dir = new File(parent)).exists()) {
                throw new IOException("destination directory doesn't exist: " + parent);
            }
            if (dir.isFile()) {
                throw new IOException("destination is not a directory: " + parent);
            }
            if (!dir.canWrite()) {
                throw new IOException("destination directory is unwritable: " + parent);
            }
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[32768];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return true;
    }
}

