/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationEventListenerElement;
import org.odftoolkit.odfdom.dom.element.script.ScriptEventListenerElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element office:event-listeners}.
 *
 */
public class OfficeEventListenersElement extends OdfElement {

	public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.OFFICE, "event-listeners");

	/**
	 * Create the instance of <code>OfficeEventListenersElement</code>
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public OfficeEventListenersElement(OdfFileDom ownerDoc) {
		super(ownerDoc, ELEMENT_NAME);
	}

	/**
	 * Get the element name
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element office:event-listeners}.
	 */
	public OdfName getOdfName() {
		return ELEMENT_NAME;
	}

	/**
	 * Create child element {@odf.element presentation:event-listener}.
	 *
	 * @param presentationActionValue  the <code>String</code> value of <code>PresentationActionAttribute</code>, see {@odf.attribute  presentation:action} at specification
	 * @param scriptEventNameValue  the <code>String</code> value of <code>ScriptEventNameAttribute</code>, see {@odf.attribute  script:event-name} at specification
	 * @return the element {@odf.element presentation:event-listener}
	 */
	 public PresentationEventListenerElement newPresentationEventListenerElement(String presentationActionValue, String scriptEventNameValue) {
		PresentationEventListenerElement presentationEventListener = ((OdfFileDom) this.ownerDocument).newOdfElement(PresentationEventListenerElement.class);
		presentationEventListener.setPresentationActionAttribute(presentationActionValue);
		presentationEventListener.setScriptEventNameAttribute(scriptEventNameValue);
		this.appendChild(presentationEventListener);
		return presentationEventListener;
	}

	/**
	 * Create child element {@odf.element script:event-listener}.
	 *
	 * @param scriptEventNameValue  the <code>String</code> value of <code>ScriptEventNameAttribute</code>, see {@odf.attribute  script:event-name} at specification
	 * @param scriptLanguageValue  the <code>String</code> value of <code>ScriptLanguageAttribute</code>, see {@odf.attribute  script:language} at specification
	 * @return the element {@odf.element script:event-listener}
	 */
	 public ScriptEventListenerElement newScriptEventListenerElement(String scriptEventNameValue, String scriptLanguageValue) {
		ScriptEventListenerElement scriptEventListener = ((OdfFileDom) this.ownerDocument).newOdfElement(ScriptEventListenerElement.class);
		scriptEventListener.setScriptEventNameAttribute(scriptEventNameValue);
		scriptEventListener.setScriptLanguageAttribute(scriptLanguageValue);
		this.appendChild(scriptEventListener);
		return scriptEventListener;
	}

	@Override
	public void accept(ElementVisitor visitor) {
		if (visitor instanceof DefaultElementVisitor) {
			DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
			defaultVisitor.visit(this);
		} else {
			visitor.visit(this);
		}
	}
}
