/*
 * @(#)IAnalysisModule.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2;


/**
 * Processes a method for coverage analysis.  The analysis should mark
 * certain bytecode instructions with <tt>IAnalysisMetaData</tt> for
 * report generation.  Each module generates data that is used for one
 * specific measure type, such as source line coverage, or branch coverage.
 * The coverage amount is based on the number of marks added verses the
 * number of marks (and which ones) encountered during a run.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:51:25 $
 * @since     December 15, 2002
 * @see       IAnalysisMetaData
 */
public interface IAnalysisModule
{
    /**
     * Returns the human-readable name of the measure.
     */
    public String getMeasureName();
    
    /**
     * Returns the unit name for this particular coverage measure.
     */
    public String getMeasureUnit();
    
    
    /**
     * Returns the text format used in meta-data formatted text.  This should
     * be the mime encoding type, such as "text/plain" or "text/html".
     */
    public String getMimeEncoding();
    
    
    /**
     * Perform the analysis on the method.  <tt>method</tt> should never
     * be <tt>null</tt>, so null checking isn't necessary;
     * <tt>NullPointerException</tt>s are an acceptable exception to be
     * thrown from this method.
     */
    public void analyze( IMethodCode method );
}

