<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_ldap - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_ldap</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_ldap.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_ldap.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Conservation des connexions LDAP et services de mise en
cache du rsultat  destination des autres modules LDAP</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>ldap_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>util_ldap.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module a t conu dans le but d'amliorer les performances
    des sites web s'appuyant sur des connexions en arrire-plan vers des
    serveurs LDAP. Il ajoute aux fonctions fournies par les
    bibliothques standards LDAP la conservation des connexions LDAP
    ainsi qu'un cache LDAP partag en mmoire.</p>

    <p>Pour activer ce module, le support LDAP doit tre compil dans
    apr-util. Pour ce faire, on ajoute l'option <code>--with-ldap</code>
    au script <code class="program"><a href="../programs/configure.html">configure</a></code> lorsqu'on construit
    Apache.</p>

    <p>Le support SSL/TLS est conditionn par le kit de dveloppement
    LDAP qui a t li  <a class="glossarylink" href="../glossary.html#apr" title="voir glossaire">APR</a>. Au moment o ces
    lignes sont crites, APR-util supporte <a href="http://www.openldap.org/">OpenLDAP SDK</a> (version 2.x ou
    suprieure), <a href="http://developer.novell.com/ndk/cldap.htm">Novell LDAP
    SDK</a>, <a href="https://wiki.mozilla.org/LDAP_C_SDK">
    Mozilla LDAP SDK</a>, le SDK LDAP Solaris natif (bas sur Mozilla)
    ou le SDK LDAP Microsoft natif. Voir le site web <a href="http://apr.apache.org">APR</a> pour plus de dtails.</p>

</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#exampleconfig">Exemple de configuration</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#pool">Conservation des connexions LDAP</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cache">Cache LDAP</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#usingssltls">Utiliser SSL/TLS</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#settingcerts">Certificats SSL/TLS</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#ldapcacheentries">LDAPCacheEntries</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldapcachettl">LDAPCacheTTL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldapconnectionpoolttl">LDAPConnectionPoolTTL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldapconnectiontimeout">LDAPConnectionTimeout</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldaplibrarydebug">LDAPLibraryDebug</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldapopcacheentries">LDAPOpCacheEntries</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldapopcachettl">LDAPOpCacheTTL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldapreferralhoplimit">LDAPReferralHopLimit</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldapreferrals">LDAPReferrals</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldapretries">LDAPRetries</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldapretrydelay">LDAPRetryDelay</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldapsharedcachefile">LDAPSharedCacheFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldapsharedcachesize">LDAPSharedCacheSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldaptimeout">LDAPTimeout</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldaptrustedclientcert">LDAPTrustedClientCert</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldaptrustedglobalcert">LDAPTrustedGlobalCert</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldaptrustedmode">LDAPTrustedMode</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ldapverifyservercert">LDAPVerifyServerCert</a></li>
</ul>
<ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="exampleconfig" id="exampleconfig">Exemple de configuration</a></h2>
    <p>Ce qui suit est un exemple de configuration qui utilise
    <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> pour amliorer les performances de
    l'authentification HTTP de base fournie par
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code>.</p>

    <pre class="prettyprint lang-config"># Active la conservation des connexions LDAP et le cache partag en
# mmoire. Active le gestionnaire de statut du cache LDAP.
# Ncessite le chargement de mod_ldap et de mod_authnz_ldap.
# Remplacez "votre-domaine.example.com" par le nom de votre
# domaine.

LDAPSharedCacheSize 500000
LDAPCacheEntries 1024
LDAPCacheTTL 600
LDAPOpCacheEntries 1024
LDAPOpCacheTTL 600

&lt;Location "/ldap-status"&gt;
    SetHandler ldap-status
    
    Require host yourdomain.example.com
    
    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    AuthLDAPURL "ldap://127.0.0.1/dc=example,dc=com?uid?one"
    Require valid-user
&lt;/Location&gt;</pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="pool" id="pool">Conservation des connexions LDAP</a></h2>

    <p>Les connexions LDAP sont conserves de requte en requte. Ceci
    permet de rester connect et identifi au serveur LDAP, ce dernier
    tant ainsi prt pour la prochaine requte, sans avoir  se
    dconnecter, reconnecter et ridentifier. Le gain en performances
    est similaire  celui des connexions persistantes (keepalives)
    HTTP.</p>

    <p>Sur un serveur trs sollicit, il est possible que de nombreuses
    requtes tentent d'accder simultanment  la mme connexion au
    serveur LDAP. Lorsqu'une connexion LDAP est utilise, Apache en cre
    une deuxime en parallle  la premire, ce qui permet d'viter que
    le systme de conservation des connexions ne devienne un goulot
    d'tranglement.</p>

    <p>Il n'est pas ncessaire d'activer explicitement la conservation
    des connexions dans la configuration d'Apache. Tout module utilisant
    le module ldap pour accder aux services LDAP partagera le jeu de
    connexions.</p>

    <p>Les connexions LDAP peuvent garder la trace des donnes
    d'identification du client ldap utilises pour l'identification
    auprs du serveur LDAP. Ces donnes peuvent tre fournies aux
    serveurs LDAP qui ne permettent pas les connexions anonymes au cours
    lors des tentatives de sauts vers des serveurs alternatifs. Pour
    contrler cette fonctionnalit, voir les directives <code class="directive"><a href="#ldapreferrals">LDAPReferrals</a></code> et <code class="directive"><a href="#ldapreferralhoplimit">LDAPReferralHopLimit</a></code>. Cette
    fonctionnalit est active par dfaut.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="cache" id="cache">Cache LDAP</a></h2>

    <p>Pour amliorer les performances, <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> met en
    oeuvre une stratgie de mise en cache agressive visant  minimiser
    le nombre de fois que le serveur LDAP doit tre contact. La mise en
    cache peut facilement doubler et mme tripler le dbit d'Apache
    lorsqu'il sert des pages protges par mod_authnz_ldap. De plus, le
    serveur LDAP verra lui-mme sa charge sensiblement diminue.</p>

    <p><code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> supporte deux types de mise en cache
    LDAP : un <em>cache recherche/identification</em> durant la phase
    de recherche/identification et deux <em>caches d'oprations</em>
    durant la phase de comparaison. Chaque URL LDAP utilise par le
    serveur a son propre jeu d'instances dans ces trois caches.</p>

    <h3><a name="search-bind" id="search-bind">Le cache
    recherche/identification</a></h3>
      <p>Les processus de recherche et d'identification sont les
      oprations LDAP les plus consommatrices en temps, en particulier
      si l'annuaire est de grande taille. Le cache de
      recherche/identification met en cache toutes les recherches qui
      ont abouti  une identification positive. Les rsultats ngatifs
      (c'est  dire les recherches sans succs, ou les recherches qui
      n'ont pas abouti  une identification positive) ne sont pas mis en
      cache. La raison de cette dcision rside dans le fait que les
      connexions avec des donnes d'identification invalides ne
      reprsentent qu'un faible pourcentage du nombre total de
      connexions, et ainsi, le fait de ne pas mettre en cache les
      donnes d'identification invalides rduira d'autant la taille du
      cache.</p>

      <p><code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> met en cache le nom d'utilisateur, le
      DN extrait, le mot de passe utilis pour l'identification, ainsi
      que l'heure de l'identification. Chaque fois qu'une nouvelle
      connexion est initialise avec le mme nom d'utilisateur,
      <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> compare le mot de passe de la nouvelle
      connexion avec le mot de passe enregistr dans le cache. Si les
      mots de passe correspondent, et si l'entre du cache n'est pas
      trop ancienne, <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> court-circuite la phase
      de recherche/identification.</p>

      <p>Le cache de recherche/identification est contrl par les
      directives <code class="directive"><a href="#ldapcacheentries">LDAPCacheEntries</a></code> et <code class="directive"><a href="#ldapcachettl">LDAPCacheTTL</a></code>.</p>
    

    <h3><a name="opcaches" id="opcaches">Les caches d'oprations</a></h3>
      <p>Au cours des oprations de comparaison d'attributs et de noms
      distinctifs (DN), <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> utilise deux caches
      d'oprations pour mettre en cache les oprations de comparaison.
      Le premier cache de comparaison sert  mettre en cache les
      rsultats de comparaisons effectues pour vrifier l'appartenance
       un groupe LDAP. Le second cache de comparaison sert  mettre en
      cache les rsultats de comparaisons entre DNs.</p>

      <p>Notez que, lorsque l'appartenance  un groupe est vrifie,
      toute comparaison de sous-groupes est mise en cache afin
      d'acclrer les comparaisons de sous-groupes ultrieures.</p>

      <p>Le comportement de ces deux caches est contrl par les
      directives <code class="directive"><a href="#ldapopcacheentries">LDAPOpCacheEntries</a></code> et <code class="directive"><a href="#ldapopcachettl">LDAPOpCacheTTL</a></code>.</p>
    

    <h3><a name="monitoring" id="monitoring">Superviser le cache</a></h3>
      <p><code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> possde un gestionnaire de contenu
      qui permet aux administrateurs de superviser les performances du
      cache. Le nom du gestionnaire de contenu est
      <code>ldap-status</code>, et on peut utiliser les directives
      suivantes pour accder aux informations du cache de
      <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> :</p>

      <pre class="prettyprint lang-config">&lt;Location "/server/cache-info"&gt;
    SetHandler ldap-status
&lt;/Location&gt;</pre>


      <p>En se connectant  l'URL
      <code>http://nom-serveur/infos-cache</code>, l'administrateur peut
      obtenir un rapport sur le statut de chaque cache qu'utilise
      <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code>. Notez que si Apache ne supporte pas la
      mmoire partage, chaque instance de <code class="program"><a href="../programs/httpd.html">httpd</a></code>
      possdera son propre cache, et chaque fois que l'URL sera
      recharge, un rsultat diffrent pourra tre affich, en fonction
      de l'instance de <code class="program"><a href="../programs/httpd.html">httpd</a></code> qui traitera la
      requte.</p>
    
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="usingssltls" id="usingssltls">Utiliser SSL/TLS</a></h2>

    <p>La possibilit de crer des connexions SSL et TLS avec un serveur
    LDAP est dfinie par les directives <code class="directive"><a href="#ldaptrustedglobalcert">
    LDAPTrustedGlobalCert</a></code>, <code class="directive"><a href="#ldaptrustedclientcert">
    LDAPTrustedClientCert</a></code> et <code class="directive"><a href="#ldaptrustedmode">
    LDAPTrustedMode</a></code>. Ces directives permettent de spcifier
    l'autorit de certification (CA), les certificats clients ventuels,
    ainsi que le type de chiffrement  utiliser pour la connexion (none,
    SSL ou TLS/STARTTLS).</p>

    <pre class="prettyprint lang-config"># Etablissement d'une connexion SSL LDAP sur le port 636.
# Ncessite le chargement de mod_ldap et mod_authnz_ldap.
# Remplacez "votre-domaine.example.com" par le nom de votre
# domaine.

LDAPTrustedGlobalCert CA_DER "/certs/certfile.der"

&lt;Location "/ldap-status"&gt;
    SetHandler ldap-status
    
    Require host yourdomain.example.com
    
    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    AuthLDAPURL "ldaps://127.0.0.1/dc=example,dc=com?uid?one"
    Require valid-user
&lt;/Location&gt;</pre>


    <pre class="prettyprint lang-config"># Etablissement d'une connexion TLS LDAP sur le port 389.
# Ncessite le chargement de mod_ldap et mod_authnz_ldap.
# Remplacez "votre-domaine.example.com" par le nom de votre
# domaine.

LDAPTrustedGlobalCert CA_DER "/certs/certfile.der"

&lt;Location "/ldap-status"&gt;
    SetHandler ldap-status
    
    Require host yourdomain.example.com
    
    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    AuthLDAPURL "ldap://127.0.0.1/dc=example,dc=com?uid?one" TLS
    Require valid-user
&lt;/Location&gt;</pre>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="settingcerts" id="settingcerts">Certificats SSL/TLS</a></h2>

    <p>Les diffrents SDKs LDAP disposent de nombreuses mthodes pour
    dfinir et grer les certificats des clients et des autorits de
    certification (CA).</p>

    <p>Si vous avez l'intention d'utiliser SSL ou TLS, lisez cette
    section ATTENTIVEMENT de faon  bien comprendre les diffrences de
    configurations entre les diffrents SDKs LDAP supports.</p>

    <h3><a name="settingcerts-netscape" id="settingcerts-netscape">SDK Netscape/Mozilla/iPlanet</a></h3>
        <p>Les certificat de CA sont enregistrs dans un fichier nomm
	cert7.db. Le SDK ne dialoguera avec aucun serveur LDAP dont le
	certificat n'a pas t sign par une CA spcifie dans ce
	fichier. Si des certificats clients sont requis, un fichier
	key3.db ainsi qu'un mot de passe optionnels peuvent tre
	spcifis. On peut aussi spcifier le fichier secmod si
	ncessaire. Ces fichiers sont du mme format que celui utilis
	par les navigateurs web Netscape Communicator ou Mozilla. Le
	moyen le plus simple pour obtenir ces fichiers consiste  les
	extraire de l'installation de votre navigateur.</p>

        <p>Les certificats clients sont spcifis pour chaque connexion
	en utilisant la directive LDAPTrustedClientCert et en se
	rfrant au certificat "nickname". On peut ventuellement
	spcifier un mot de passe pour dverrouiller la cl prive du
	certificat.</p>

        <p>Le SDK supporte seulement SSL. Toute tentative d'utilisation
	de STARTTLS engendrera une erreur lors des tentatives de
	contacter le serveur LDAP pendant l'excution.</p>

        <pre class="prettyprint lang-config"># Spcifie un fichier de certificats de CA Netscape
LDAPTrustedGlobalCert CA_CERT7_DB "/certs/cert7.db"
# Spcifie un fichier key3db optionnel pour le support des
# certificats clients
LDAPTrustedGlobalCert CERT_KEY3_DB "/certs/key3.db"
# Spcifie le fichier secmod si ncessaire
LDAPTrustedGlobalCert CA_SECMOD "/certs/secmod"
&lt;Location "/ldap-status"&gt;
    SetHandler ldap-status

    Require host yourdomain.example.com

    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    LDAPTrustedClientCert CERT_NICKNAME &lt;nickname&gt; [password]
    AuthLDAPURL "ldaps://127.0.0.1/dc=example,dc=com?uid?one"
    Require valid-user
&lt;/Location&gt;</pre>


    

    <h3><a name="settingcerts-novell" id="settingcerts-novell">SDK Novell</a></h3>

        <p>Un ou plusieurs certificats de CA doivent tre spcifis pour
	que le SDK Novell fonctionne correctement. Ces certificats
	peuvent tre spcifis sous forme de fichiers au format binaire
	DER ou cods en Base64 (PEM).</p>

        <p>Note: Les certificats clients sont spcifis globalement
	plutt qu' chaque connexion, et doivent tre spcifis  l'aide
	de la directive LDAPTrustedGlobalCert comme ci-dessous. Dfinir
	des certificats clients via la directive LDAPTrustedClientCert
	engendrera une erreur qui sera journalise, au moment de la
	tentative de connexion avec le serveur LDAP.</p>

        <p>Le SDK supporte SSL et STARTTLS, le choix tant dfini par le
	paramtre de la directive LDAPTrustedMode. Si une URL de type
	ldaps:// est spcifie, le mode SSL est forc, et l'emporte sur
	cette directive.</p>

        <pre class="prettyprint lang-config"># Spcifie deux fichiers contenant des certificats de CA
LDAPTrustedGlobalCert CA_DER "/certs/cacert1.der"
LDAPTrustedGlobalCert CA_BASE64 "/certs/cacert2.pem"
# Spcifie un fichier contenant des certificats clients
# ainsi qu'une cl
LDAPTrustedGlobalCert CERT_BASE64 "/certs/cert1.pem"
LDAPTrustedGlobalCert KEY_BASE64 "/certs/key1.pem" [password]
# N'utilisez pas cette directive, sous peine de provoquer
# une erreur
#LDAPTrustedClientCert CERT_BASE64 "/certs/cert1.pem"</pre>


    

    <h3><a name="settingcerts-openldap" id="settingcerts-openldap">SDK OpenLDAP</a></h3>

        <p>Un ou plusieurs certificats de CA doivent tre spcifis pour
	que le SDK OpenLDAP fonctionne correctement. Ces certificats
	peuvent tre spcifis sous forme de fichiers au format binaire
	DER ou cods en Base64 (PEM).</p>

        <p>Les certificats clients sont spcifis pour chaque connexion
	 l'aide de la directive LDAPTrustedClientCert.</p>

        <p>La documentation du SDK prtend que SSL et STARTTLS sont
	supports ; cependant, STARTTLS semble ne pas fonctionner avec
	toutes les versions du SDK. Le mode SSL/TLS peut tre dfini en
	utilisant le paramtre de la directive LDAPTrustedMode. Si une
	URL de type
	ldaps:// est spcifie, le mode SSL est forc. La documentation
	OpenLDAP indique que le support SSL (ldaps://) tend  tre
	remplac par TLS, bien que le mode SSL fonctionne toujours.</p>

        <pre class="prettyprint lang-config"># Spcifie deux fichiers contenant des certificats de CA
LDAPTrustedGlobalCert CA_DER "/certs/cacert1.der"
LDAPTrustedGlobalCert CA_BASE64 "/certs/cacert2.pem"
&lt;Location /ldap-status&gt;
    SetHandler ldap-status
    
    Require host yourdomain.example.com
    
    LDAPTrustedClientCert CERT_BASE64 "/certs/cert1.pem"
    LDAPTrustedClientCert KEY_BASE64 "/certs/key1.pem"
    # CA certs respecified due to per-directory client certs
    LDAPTrustedClientCert CA_DER "/certs/cacert1.der"
    LDAPTrustedClientCert CA_BASE64 "/certs/cacert2.pem"
    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    AuthLDAPURL "ldaps://127.0.0.1/dc=example,dc=com?uid?one"
    Require valid-user
&lt;/Location&gt;</pre>


    

    <h3><a name="settingcerts-solaris" id="settingcerts-solaris">SDK Solaris</a></h3>

        <p>SSL/TLS pour les bibliothques LDAP propres  Solaris n'est
	pas encore support. Si ncessaire, installez et utilisez plutt
	les bibliothques OpenLDAP.</p>

    

    <h3><a name="settingcerts-microsoft" id="settingcerts-microsoft">SDK Microsoft</a></h3>

        <p>La configuration des certificats SSL/TLS pour les
	bibliothques LDAP propres  Microsoft s'effectue  l'intrieur
	du registre systme, et aucune directive de configuration n'est
	requise.</p>

        <p>SSL et TLS sont tous deux supports en utilisant des URLs de
	type ldaps://, ou en dfinissant la directive LDAPTrustedMode 
	cet effet.</p>

        <p>Note: L'tat du support des certificats clients n'est pas
	encore connu pour ce SDK.</p>

    

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapcacheentries" id="ldapcacheentries">Directive</a> <a name="LDAPCacheEntries" id="LDAPCacheEntries">LDAPCacheEntries</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre maximum d'entres dans le cache LDAP
primaire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPCacheEntries <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LDAPCacheEntries 1024</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Cette directive permet de spcifier la taille maximale du cache
    LDAP primaire. Ce cache contient les rsultats de
    recherche/identification positifs. Dfinissez-la  0 pour dsactiver
    la mise en cache des rsultats de recherche/identification positifs.
    La taille par dfaut est de 1024 recherches en cache.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapcachettl" id="ldapcachettl">Directive</a> <a name="LDAPCacheTTL" id="LDAPCacheTTL">LDAPCacheTTL</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dure pendant laquelle les entres du cache restent
valides.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPCacheTTL <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LDAPCacheTTL 600</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Cette directive permet de spcifier la dure (en secondes)
    pendant laquelle une entre du cache de recherche/identification
    reste valide. La valeur par dfaut est de 600 secondes (10
    minutes).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapconnectionpoolttl" id="ldapconnectionpoolttl">Directive</a> <a name="LDAPConnectionPoolTTL" id="LDAPConnectionPoolTTL">LDAPConnectionPoolTTL</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dsactive les connexions d'arrire-plan qui sont restes
inactives trop longtemps au sein du jeu de connexions.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPConnectionPoolTTL <var>n</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LDAPConnectionPoolTTL -1</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.3.12 du serveur HTTP
Apache</td></tr>
</table>
    <p>Cette directive permet de spcifier la dure maximale, en
    secondes, pendant laquelle une connexion LDAP du jeu de connexions
    peut demeurer inactive, mais rester quand-mme disponible pour une
    utilisation ventuelle. Le jeu de connexions est nettoy au fur et 
    mesure des besoins, de manire non asynchrone.</p>

    <p>Si cette directive est dfinie  0, les connexions ne sont jamais
    sauvegardes dans le jeu de connexions d'arrire-plan. Avec la
    valeur par dfaut -1, ou toute autre valeur ngative, les connexions
    peuvent tre rutilises sans limite de dure.</p>

    <p>Dans le but d'amliorer les performances, le temps de rfrence
    qu'utilise cette directive correspond au moment o la connexion LDAP
    est enregistre ou remise dans le jeu de connexions, et non au
    moment du dernier change russi avec le serveur LDAP.</p>

    <p>La version 2.4.10 a introduit de nouvelles mesures permettant
    d'viter une augmentation excessive du temps de rfrence due  des
    correspondances positives dans le cache ou des requtes lentes. A
    cet effet, le temps de rfrence n'est pas ractualis si aucune
    connexion LDAP d'arrire-plan n'est requise ; d'autre part, le temps
    de rfrence se base sur le moment o la requte HTTP est reue, et
    non sur le moment o la requte a t traite.</p>

    <div class="note"><p>Cette dure de vie s'exprime par dfaut en secondes, mais
    il est possible d'utiliser d'autres units en ajoutant un suffixe :
    millisecondes (ms), minutes (min), ou heures (h).
    </p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapconnectiontimeout" id="ldapconnectiontimeout">Directive</a> <a name="LDAPConnectionTimeout" id="LDAPConnectionTimeout">LDAPConnectionTimeout</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie le dlai d'attente en secondes de la socket de
connexion</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPConnectionTimeout <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Cette directive configure l'option LDAP_OPT_NETWORK_TIMEOUT (ou
    LDAP_OPT_CONNECT_TIMEOUT) dans la bibliothque client LDAP
    sous-jacente, si elle est disponible. Cette valeur reprsente la
    dure pendant laquelle la bibliothque client LDAP va attendre que
    le processus de connexion TCP au serveur LDAP soit achev.</p>

    <p>Si la connexion n'a pas russi avant ce dlai, une erreur sera
    renvoye, ou la bibliothque client LDAP tentera de se connecter 
    un second serveur LDAP, s'il en a t dfini un (via une liste de
    noms d'htes spars par des espaces dans la directive <code class="directive"><a href="../mod/mod_authnz_ldap.html#authldapurl">AuthLDAPURL</a></code>).</p>

    <p>La valeur par dfaut est 10 secondes, si la bibliothque client
    LDAP lie avec le serveur supporte l'option
    LDAP_OPT_NETWORK_TIMEOUT.</p>

    <div class="note">LDAPConnectionTimeout n'est disponible que si la bibliothque client
    LDAP lie avec le serveur supporte l'option
    LDAP_OPT_NETWORK_TIMEOUT (ou LDAP_OPT_CONNECT_TIMEOUT), et le
    comportement final est entirement dict par la bibliothque client
    LDAP.
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldaplibrarydebug" id="ldaplibrarydebug">Directive</a> <a name="LDAPLibraryDebug" id="LDAPLibraryDebug">LDAPLibraryDebug</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active le dbogage dans le SDK LDAP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPLibraryDebug <var>7</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>disabled</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Active les options de dbogage LDAP spcifiques au SDK, qui
    entranent en gnral une journalisation d'informations verbeuses du
    SDK LDAP dans le journal principal des erreurs d'Apache. Les
    messages de traces en provenance du SDK LDAP fournissent des
    informations trs dtailles qui peuvent s'avrer utiles lors du
    dbogage des problmes de connexion avec des serveurs LDAP
    d'arrire-plan.</p>

    <p>Cette option n'est configurable que lorsque le serveur HTTP
    Apache est li avec un SDK LDAP qui implmente
    <code>LDAP_OPT_DEBUG</code> ou <code>LDAP_OPT_DEBUG_LEVEL</code>,
    comme OpenLDAP (une valeur de 7 est verbeuse) ou Tivoli Directory
    Server (une valeur de 65535 est verbeuse).</p>

    <div class="warning">
    <p>Les informations journalises peuvent contenir des donnes
    d'authentification en clair utilises ou valides lors de
    l'authentification LDAP ; vous devez donc prendre soin de protger
    et de purger le journal des erreurs lorsque cette directive est
    utilise.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapopcacheentries" id="ldapopcacheentries">Directive</a> <a name="LDAPOpCacheEntries" id="LDAPOpCacheEntries">LDAPOpCacheEntries</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre d'entres utilises pour mettre en cache les
oprations de comparaison LDAP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPOpCacheEntries <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LDAPOpCacheEntries 1024</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Cette directive permet de spcifier le nombre d'entres que
    <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> va utiliser pour mettre en cache les
    oprations de comparaison LDAP. La valeur par dfaut est de 1024
    entres. Si elle est dfinie  0, la mise en cache des oprations de
    comparaison LDAP est dsactive.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapopcachettl" id="ldapopcachettl">Directive</a> <a name="LDAPOpCacheTTL" id="LDAPOpCacheTTL">LDAPOpCacheTTL</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dure pendant laquelle les entres du cache d'oprations
restent valides</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPOpCacheTTL <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LDAPOpCacheTTL 600</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Cette directive permet de spcifier la dure (en secondes)
    pendant laquelle les entres du cache d'oprations restent valides.
    La valeur par dfaut est de 600 secondes.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapreferralhoplimit" id="ldapreferralhoplimit">Directive</a> <a name="LDAPReferralHopLimit" id="LDAPReferralHopLimit">LDAPReferralHopLimit</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le nombre maximum de redirections vers des serveurs
alternatifs (referrals) avant l'abandon de la requte
LDAP.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPReferralHopLimit <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Dpend du SDK, en gnral entre 5 et 10</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Si elle est active par la directive <code class="directive">LDAPReferrals</code>,
    cette directive permet de dfinir le nombre maximum de sauts vers
    des serveurs alternatifs (referrals) avant l'abandon de la requte
    LDAP.</p>

<div class="warning">
<p>L'ajustement de ce paramtre n'est pas commun  tous les SDKs LDAP.</p>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapreferrals" id="ldapreferrals">Directive</a> <a name="LDAPReferrals" id="LDAPReferrals">LDAPReferrals</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la redirection vers des serveurs alternatifs au
cours des requtes vers le serveur LDAP.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPReferrals <var>On|Off|default</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LDAPReferrals On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Le paramtre <var>default</var> est disponible depuis la
version 2.4.7 du serveur HTTP Apache.</td></tr>
</table>
    <p>Certains serveurs LDAP partagent leur annuaire en plusieurs
    domaines et utilisent le systme des redirections (referrals) pour
    aiguiller un client lorsque les limites d'un domaine doivent tre
    franchies. Ce processus est similaire  une redirection HTTP. Les
    bibliothques client LDAP ne respectent pas forcment ces
    redirections par dfaut. Cette directive permet de configurer
    explicitement les redirections LDAP dans le SDK sous-jacent.</p>

    <p>La directive <code class="directive">LDAPReferrals</code> accepte les
    valeurs suivantes :</p>

    <dl>
     <dt>"on"</dt>
     <dd> <p>Avec la valeur "on", la prise en compte des redirections
     LDAP par le SDK sous-jacent est active, la directive
     <code class="directive">LDAPReferralHopLimit</code> permet de surcharger la
     "hop limit" du SDK, et un "LDAP rebind callback" est enregistr.</p></dd>
     <dt>"off"</dt>
     <dd> <p>Avec la valeur "off", la prise en compte des redirections
     LDAP par le SDK sous-jacent est compltement dsactive.</p></dd>
     <dt>"default"</dt>
     <dd> <p>Avec la valeur "default", la prise en compte des redirections
     LDAP par le SDK sous-jacent n'est pas modifie, la directive
     <code class="directive">LDAPReferralHopLimit</code> ne permet pas de surcharger la
     "hop limit" du SDK, et aucun "LDAP rebind callback" n'est enregistr.</p></dd>
    </dl>
    
    <p>La directive <code class="directive">LDAPReferralHopLimit</code> travaille en
    conjonction avec cette directive pour limiter le nombre de
    redirections  suivre pour achever le traitement de la requte LDAP.
    Lorsque le processus de redirection est activ par la valeur "On",
    les donnes d'authentification du client sont transmises via un
    "rebind callback"  tout serveur LDAP qui en fait la demande.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapretries" id="ldapretries">Directive</a> <a name="LDAPRetries" id="LDAPRetries">LDAPRetries</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le nombre maximum de tentatives de connexions au
serveur LDAP.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPRetries <var>nombre d'essais</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LDAPRetries 3</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Suite  des checs de connexion au serveur LDAP, le serveur
    tentera de se connecter autant de fois qu'indiqu par la directive
    <code class="directive">LDAPRetries</code>. Si cette directive est dfinie 
    0, le serveur ne tentera pas d'autre connexion aprs un chec.</p>
    <p>Il est possible d'effectuer une autre tentative de connexion en
    cas d'erreurs LDAP du type dlai dpass ou connexion refuse. </p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapretrydelay" id="ldapretrydelay">Directive</a> <a name="LDAPRetryDelay" id="LDAPRetryDelay">LDAPRetryDelay</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le temps d'attente avant un autre essai de connexion au
serveur LDAP.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPRetryDelay <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LDAPRetryDelay 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Si la directive <code class="directive">LDAPRetryDelay</code> est dfinie
     une valeur diffrente de 0, le serveur attendra pendant la dure
    spcifie pour envoyer  nouveau sa requte LDAP. Une valeur de 0
    implique une absence de dlai pour les essais successifs.</p>

    <p>Il est possible d'effectuer une autre tentative de connexion en
    cas d'erreurs LDAP du type dlai dpass ou connexion refuse. </p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapsharedcachefile" id="ldapsharedcachefile">Directive</a> <a name="LDAPSharedCacheFile" id="LDAPSharedCacheFile">LDAPSharedCacheFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le fichier du cache en mmoire
partage</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPSharedCacheFile <var>chemin/fichier</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Cette directive permet de spcifier le chemin du
    fichier du cache en mmoire partage. Si elle n'est pas dfinie, la
    mmoire partage anonyme sera utilise si la plate-forme la
    supporte.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapsharedcachesize" id="ldapsharedcachesize">Directive</a> <a name="LDAPSharedCacheSize" id="LDAPSharedCacheSize">LDAPSharedCacheSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Taille en octets du cache en mmoire partage</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPSharedCacheSize <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LDAPSharedCacheSize 500000</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Cette directive permet de spcifier le nombre d'octets  allouer
    pour le cache en mmoire partage. La valeur par
    dfaut est 500kb.
    Si elle est dfinie  0, le cache en mmoire partage ne sera pas
    utilis et chaque processus HTTPD va crer son propre cache.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldaptimeout" id="ldaptimeout">Directive</a> <a name="LDAPTimeout" id="LDAPTimeout">LDAPTimeout</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie le dlai d'attente pour les oprations de
recherche et d'identification LDAP en secondes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPTimeout <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LDAPTimeout 60</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.3.5 du serveur HTTP
Apache</td></tr>
</table>
    <p>Cette directive permet de spcifier le dlai d'attente pour les
    oprations de recherche et d'identification, ainsi que l'option
    LDAP_OPT_TIMEOUT dans la bibliothque LDAP client sous-jacente,
    lorsqu'elle est disponible.</p>

    <p>Lorsque le dlai est atteint, httpd va refaire un essai dans le
    cas o une connexion existante a t silencieusement ferme par un
    pare-feu. Les performances seront cependant bien meilleures si le
    pare-feu est configur pour envoyer des paquets TCP RST au lieu de
    rejeter silencieusement les paquets.</p>

    <div class="note">
    <p>Les dlais pour les oprations de comparaison LDAP ncessitent un
    SDK avec LDAP_OPT_TIMEOUT, comme OpenLDAP &gt;= 2.4.4.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldaptrustedclientcert" id="ldaptrustedclientcert">Directive</a> <a name="LDAPTrustedClientCert" id="LDAPTrustedClientCert">LDAPTrustedClientCert</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le nom de fichier contenant un certificat client ou
un alias renvoyant vers un certificat client spcifique  une connexion.
Tous les SDK LDAP ne supportent pas les certificats clients par
connexion.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPTrustedClientCert <var>type</var>
<var>chemin/nom-fichier/alias</var> <var>[mot de passe]</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Cette directive permet de spcifier le chemin et le nom de
    fichier ou l'alias d'un certificat client par connexion utilis lors
    de l'tablissement d'une connexion SSL ou TLS avec un serveur LDAP.
    Les sections directory ou location peuvent possder leurs propres
    configurations de certificats clients. Certains SDK LDAP (en
    particulier Novell) ne supportent pas les certificats clients par
    connexion, et renvoient une erreur lors de la connexion au serveur
    LDAP si vous tenter d'utiliser cette directive (Utilisez  la place
    la directive LDAPTrustedGlobalCert pour les certificats clients sous
    Novell - Voir plus haut le guide des certificats SSL/TLS pour plus
    de dtails). Le paramtre type spcifie le type du certificat en
    cours de dfinition, en fonction du SDK LDAP utilis. Les types
    supports sont :</p>
    <ul>
      <li>CA_DER - certificat de CA cod en binaire DER</li>
      <li>CA_BASE64 - certificat de CA cod en PEM</li>
      <li>CERT_DER - certificat client cod en binaire DER</li>
      <li>CERT_BASE64 - certificat client cod en PEM</li>
      <li>CERT_NICKNAME - certificat client "nickname" (SDK Netscape)</li>
      <li>KEY_DER - cl prive code en binaire DER</li>
      <li>KEY_BASE64 - cl prive code en PEM</li>
    </ul>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldaptrustedglobalcert" id="ldaptrustedglobalcert">Directive</a> <a name="LDAPTrustedGlobalCert" id="LDAPTrustedGlobalCert">LDAPTrustedGlobalCert</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le nom de fichier ou la base de donnes contenant
les Autorits de Certification de confiance globales ou les certificats
clients globaux</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPTrustedGlobalCert <var>type</var>
<var>chemin/nom-fichier</var> <var>[mot de passe]</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Cette directive permet de spcifier le chemin et le nom du
    fichier contenant les certificats des CA de confiance et/ou les
    certificats clients du systme global que <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code>
    utilisera pour tablir une connexion SSL ou TLS avec un serveur
    LDAP. Notez que toute information relative aux certificats spcifie
    en utilisant cette directive s'applique globalement  l'ensemble de
    l'installation du serveur. Certains SDK LDAP (en particulier Novell)
    ncessitent la dfinition globale de tous les certificats clients en
    utilisant cette directive. La plupart des autres SDK ncessitent la
    dfinition des certificats clients dans une section Directory ou
    Location en utilisant la directive LDAPTrustedClientCert. Si vous ne
    dfinissez pas ces directives correctement, une erreur sera gnre
    lors des tentatives de contact avec un serveur LDAP, ou la connexion
    chouera silencieusement (Voir plus haut le guide des certificats
    SSL/TLS pour plus de dtails). Le paramtre type spcifie le type de
    certificat en cours de dfinition, en fonction du SDK LDAP utilis.
    Les types supports sont :</p>
    <ul>
      <li>CA_DER - certificat de CA cod en binaire DER</li>
      <li>CA_BASE64 - certificat de CA cod en PEM</li>
      <li>CA_CERT7_DB - fichier de base de donnes des certificats de CA
      de Netscape cert7.db</li>
      <li>CA_SECMOD - fichier de base de donnes secmod de Netscape</li>
      <li>CERT_DER - certificat client cod en binaire DER</li>
      <li>CERT_BASE64 - certificat client cod en PEM</li>
      <li>CERT_KEY3_DB - fichier de base de donnes des certificats
      clients de Netscape key3.db</li>
      <li>CERT_NICKNAME - certificat client "nickname" (SDK Netscape)</li>
      <li>CERT_PFX - certificat client cod en PKCS#12 (SDK Novell)</li>
      <li>KEY_DER - cl prive code en binaire DER</li>
      <li>KEY_BASE64 - cl prive code en PEM</li>
      <li>KEY_PFX - cl prive code en PKCS#12 (SDK Novell)</li>
    </ul>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldaptrustedmode" id="ldaptrustedmode">Directive</a> <a name="LDAPTrustedMode" id="LDAPTrustedMode">LDAPTrustedMode</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie le mode (SSL ou TLS)  utiliser lors de la
connexion  un serveur LDAP.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPTrustedMode <var>type</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Les modes suivants sont supports :</p>
    <ul>
      <li>NONE - aucun chiffrement</li>
      <li>SSL - chiffrement ldaps:// sur le port par dfaut 636</li>
      <li>TLS - chiffrement STARTTLS sur le port par dfaut 389</li>
    </ul>

    <p>Les modes ci-dessus ne sont pas supports par tous les SDK LDAP.
    Un message d'erreur sera gnr  l'excution si un mode n'est pas
    support, et la connexion au serveur LDAP chouera.
    </p>

    <p>Si une URL de type ldaps:// est spcifie, le mode est forc 
    SSL et la dfinition de LDAPTrustedMode est ignore.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ldapverifyservercert" id="ldapverifyservercert">Directive</a> <a name="LDAPVerifyServerCert" id="LDAPVerifyServerCert">LDAPVerifyServerCert</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Force la vrification du certificat du
serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LDAPVerifyServerCert <var>On|Off</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LDAPVerifyServerCert On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ldap</td></tr>
</table>
    <p>Cette directive permet de spcifier s'il faut forcer la
    vrification d'un certificat de serveur lors de l'tablissement
    d'une connexion SSL avec un serveur LDAP.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_ldap.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_ldap.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_ldap.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2015 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>