/* pktopx in C by Tomas Rokicki */
#include <stdio.h>
#define namelength 80 
#define terminallinelength 132 
#define maxdiv32 100 
#define onefourth 1073741824 

#define incr(a) (a++)
#define decr(a) (a--)
#define true (1)
#define false (0)
#define round(a) ((int)(a+0.5))

  typedef int integer ;
  typedef unsigned char quarterword ;
  typedef char boolean ;
  typedef quarterword eightbits ; 
  typedef FILE *bytefile ; 
  bytefile pxlfile ; 
  bytefile pkfile ; 
  char pxlname[81], pkname[81] ; 
  integer pxlloc, pkloc ; 
  integer magnification ; 
  integer designsize ; 
  integer checksum ; 
  integer hppp, vppp ; 
  integer i, j ; 
  integer endofpacket ; 
  integer rasterpointer[128] ; 
  integer sizes[128] ; 
  integer offsets[128] ; 
  integer tfmwidth[128] ; 
  integer dynf ; 
  integer car ; 
  integer cheight, cwidth ; 
  integer coffsets ; 
  integer wordwidth ; 
  integer horesc ; 
  integer packetlength ; 
  eightbits inputbyte ; 
  eightbits bitweight ; 
  eightbits nybble ; 
  integer row[101] ; 
  integer word ; 
  integer wordweight ; 
  integer power[32] ; 
  integer gpower[33] ; 
  integer repeatcount ; 
  integer rowsleft ; 
  boolean turnon ; 
  integer hbit ; 
  integer count ; 
  integer rp ; 
  integer dirptr ; 
  integer flagbyte ; 
  integer haveext ; 
  integer lastext ; 
  int gargc ;
  char **gargv ;
  initialize () { integer i ; 
    printf ( "This is PKtoPX, C Version 2.3\n" ) ; 
    power [ 0 ] = 1 ; 
    for ( i = 1 ; i <= 30 ; i ++ ) power [ i ] = power [ i - 1 ] * 2 ; 
      power [ 31 ] = - onefourth - onefourth ; 
    gpower [ 0 ] = 0 ; 
    for ( i = 1 ; i <= 32 ; i ++ ) gpower [ i ] = gpower [ i - 1 ] + power [ 
      i - 1 ] ; 
    for ( i = 0 ; i <= 127 ; i ++ ) rasterpointer [ i ] = 0 ;
      } 
  jumpout () { exit ( 1 ) ; 
    } 
  openpxlfile () { pxlfile = fopen ( pxlname , "w" ) ; 
    pxlloc = 0 ; 
    } 
  openpkfile () { pkfile = fopen ( pkname , "r" ) ; 
    pkloc = 0 ; 
    } 
  pixelinteger ( i ) 
  integer i ; 
  { putc ( (char) ( (i >> 24) & 255 ) , pxlfile ) ; 
    putc ( (char) ( (i >> 16) & 255 ) , pxlfile ) ; 
    putc ( (char) ( (i >> 8) & 255) , pxlfile ) ; 
    putc ( (char) ( i & 255 ) , pxlfile ) ; 
    incr ( pxlloc ) ;
    } 
  eightbits pkbyte () { incr ( pkloc ) ; 
    return ( getc ( pkfile ) ) ; 
    } 
  integer get16 () { integer a ; 
    a = pkbyte () ; 
    return ( a * 256 + pkbyte () ) ; 
    } 
  integer get32 () { integer a ; 
    a = get16 () ; 
    if ( a > 32767 ) a = a - 65536 ; 
    return ( a * 65536 + get16 () ) ; 
    } 
  integer getnyb () { eightbits temp ; 
    if ( bitweight == 0 ) 
    { inputbyte = pkbyte () ; 
      bitweight = 16 ; 
      } 
    temp = inputbyte / bitweight ; 
    inputbyte = inputbyte - temp * bitweight ; 
    bitweight = bitweight / 16 ; 
    return ( temp ) ; 
    } 
  boolean getbit () { boolean temp ; 
    bitweight = bitweight / 2 ; 
    if ( bitweight == 0 ) 
    { inputbyte = pkbyte () ; 
      bitweight = 128 ; 
      } 
    temp = inputbyte >= bitweight ; 
    if ( temp ) inputbyte = inputbyte - bitweight ; 
    return ( temp ) ; 
    } 
  integer pkpackednum () { integer i, j, k ; 
    i = getnyb () ; 
    if ( i == 0 ) 
    { do { j = getnyb () ; 
        incr ( i ) ; 
        } while ( ! ( j != 0 ) ) ; 
      while ( i > 0 ) 
        { j = j * 16 + getnyb () ; 
          decr ( i ) ; 
          } 
        return ( j - 15 + ( 13 - dynf ) * 16 + dynf ) ; 
      } 
    else if ( i <= dynf ) return ( i ) ; 
    else if ( i < 14 ) return ( ( i - dynf - 1 ) * 16 + getnyb () + dynf + 1 
    ) ; 
    else 
    { if ( i == 14 ) repeatcount = pkpackednum () ; 
      else repeatcount = 1 ; 
      return ( pkpackednum () ) ; 
      } 
    } 
  skipspecials () { integer i, j, k ; 
    do { flagbyte = pkbyte () ; 
      if ( flagbyte >= 240 ) switch ( flagbyte ) 
      { case 240 : 
        case 241 : 
        case 242 : 
        case 243 : 
        
        { i = 0 ; 
          for ( j = 240 ; j <= flagbyte ; j ++ ) i = 256 * i + pkbyte () ; 
            for ( j = 1 ; j <= i ; j ++ ) k = pkbyte () ; 
            } 
        break ; 
        case 244 : 
        i = get32 () ; 
        break ; 
        case 245 : 
        
        { ; 
          } 
        break ; 
        case 246 : 
        
        { ; 
          } 
        break ; 
        case 247 : 
        case 248 : 
        case 249 : 
        case 250 : 
        case 251 : 
        case 252 : 
        case 253 : 
        case 254 : 
        case 255 : 
        
        { printf ( " Unexpected %d!\n" , flagbyte ) ; 
          jumpout () ; 
          } 
        break ; 
        } } while ( ! ( ( flagbyte < 240 ) || ( flagbyte == 245 ) ) ) ; 
    } 
  dialog () { integer i ; 
    if ( ( gargc < 2 ) || ( gargc > 3 ) ) 
    { printf ( " Usage: pktopx pkfile[.pk] [pxlfile[.nnnnpxl]]\n" ) 
      ; 
      jumpout () ; 
      } 
    strcpy ( pkname , gargv [ 1 ] ) ; 
    lastext = - 1 ; 
    i = 0 ; 
    while ( pkname [ i ] != 0 ) 
      { if ( pkname [ i ] == '.' ) lastext = i ; 
        else if ( pkname [ i ] == '/' ) lastext = - 1 ; 
        incr ( i ) ; 
        } 
      if ( lastext == - 1 ) 
    { strcpy ( pkname + i , ".pk" ) ; 
      lastext = i ; 
      } 
    if ( gargc == 3 ) 
    { strcpy ( pxlname , gargv [ 2 ] ) ; 
      haveext = true ; 
      } 
    else 
    { strcpy ( pxlname , pkname ) ; 
      haveext = false ; 
      } 
    } 
  main (argc, argv) 
int argc ;
char *argv[] ;
{ gargc = argc ;
  gargv = argv ;
  initialize () ; 
  dialog () ; 
  openpkfile () ; 
  if ( pkbyte () != 247 ) 
  { printf ( " Bad pk file!  pre command missing.\n" ) ; 
    jumpout () ; 
    } 
  if ( pkbyte () != 89 ) 
  { printf ( " Wrong version of packed file!.\n" ) ; 
    jumpout () ; 
    } 
  j = pkbyte () ; 
  for ( i = 1 ; i <= j ; i ++ ) hppp = pkbyte () ; 
    designsize = get32 () ; 
  checksum = get32 () ; 
  hppp = get32 () ; 
  vppp = get32 () ; 
  if ( hppp != vppp ) printf ( "Warning:  aspect ratio not 1:1!\n" ) ; 
  magnification = round ( hppp * 72.27 * 5 / 65536 ) ; 
  if ( ! haveext ) 
  { i = round ( hppp * 72.27 * 5 / 65536 ) ; 
    sprintf ( pxlname + lastext , ".%dpxl" , i ) ; 
    } 
  openpxlfile () ; 
  pixelinteger ( 1001 ) ; 
  skipspecials () ; 
  while ( flagbyte != 245 ) 
    { dynf = flagbyte / 16 ; 
      flagbyte = flagbyte % 16 ; 
      turnon = flagbyte >= 8 ; 
      if ( turnon ) flagbyte = flagbyte - 8 ; 
      if ( flagbyte == 7 ) 
      { packetlength = get32 () ; 
        car = get32 () ; 
        endofpacket = packetlength + pkloc ; 
        if ( ( car > 127 ) || ( car < 0 ) ) goto lab9997 ; 
        tfmwidth [ car ] = get32 () ; 
        horesc = get32 () ; 
        i = get32 () ; 
        cwidth = get32 () ; 
        cheight = get32 () ; 
        if ( ( cwidth < 0 ) || ( cheight < 0 ) || ( cwidth > 65535 ) || ( 
        cheight > 65535 ) ) goto lab9997 ; 
        wordwidth = ( cwidth + 31 ) / 32 ; 
        sizes [ car ] = cwidth * 65536 + cheight ; 
        i = get32 () ; 
        j = get32 () ; 
        if ( j < 0 ) j = j + 65536 ; 
        offsets [ car ] = i * 65536 + j ; 
        } 
      else if ( flagbyte > 3 ) 
      { packetlength = ( flagbyte - 4 ) * 65536 + get16 () ; 
        car = pkbyte () ; 
        endofpacket = packetlength + pkloc ; 
        if ( car > 127 ) goto lab9997 ; 
        i = pkbyte () ; 
        tfmwidth [ car ] = i * 65536 + get16 () ; 
        horesc = get16 () ; 
        cwidth = get16 () ; 
        cheight = get16 () ; 
        wordwidth = ( cwidth + 31 ) / 32 ; 
        sizes [ car ] = cwidth * 65536 + cheight ; 
        i = get16 () ; 
        j = get16 () ; 
        if ( i > 32767 ) i = i - 65536 ; 
        offsets [ car ] = i * 65536 + j ; 
        } 
      else 
      { packetlength = flagbyte * 256 + pkbyte () ; 
        car = pkbyte () ; 
        endofpacket = packetlength + pkloc ; 
        if ( car > 127 ) goto lab9997 ; 
        i = pkbyte () ; 
        tfmwidth [ car ] = i * 65536 + get16 () ; 
        horesc = pkbyte () ; 
        cwidth = pkbyte () ; 
        cheight = pkbyte () ; 
        wordwidth = ( cwidth + 31 ) / 32 ; 
        sizes [ car ] = cwidth * 65536 + cheight ; 
        i = pkbyte () ; 
        j = pkbyte () ; 
        if ( i > 127 ) i = i - 256 ; 
        if ( j > 127 ) j = j + 255 * 256 ; 
        offsets [ car ] = i * 65536 + j ; 
        } 
      if ( rasterpointer [ car ] != 0 ) 
      { printf ( " Second time this character used!\n" ) ; 
        jumpout () ; 
        } 
      rasterpointer [ car ] = pxlloc ; 
      bitweight = 0 ; 
      if ( dynf == 14 ) 
      { bitweight = 0 ; 
        for ( i = 1 ; i <= cheight ; i ++ ) 
          { word = 0 ; 
            wordweight = 31 ; 
            for ( j = 1 ; j <= cwidth ; j ++ ) 
              { if ( getbit () ) word = word + power [ wordweight ] ; 
                wordweight = wordweight - 1 ; 
                if ( wordweight == - 1 ) 
                { pixelinteger ( word ) ; 
                  word = 0 ;
                  wordweight = 31 ; 
                  } 
                } 
              if ( wordweight < 31 ) pixelinteger ( word ) ; 
            } 
          } 
      else 
      { rowsleft = cheight ; 
        hbit = cwidth ; 
        repeatcount = 0 ; 
        wordweight = 32 ; 
        word = 0 ; 
        rp = 1 ; 
        while ( rowsleft > 0 ) 
          { count = pkpackednum () ; 
            while ( count > 0 ) 
              { if ( ( count < wordweight ) && ( count < hbit ) ) 
                { if ( turnon ) word = word + gpower [ wordweight ] - gpower 
                  [ wordweight - count ] ; 
                  hbit = hbit - count ; 
                  wordweight = wordweight - count ; 
                  count = 0 ; 
                  } 
                else if ( ( count >= hbit ) && ( hbit <= wordweight ) ) 
                { if ( turnon ) word = word + gpower [ wordweight ] - gpower 
                  [ wordweight - hbit ] ; 
                  row [ rp ] = word ; 
                  for ( i = 0 ; i <= repeatcount ; i ++ ) for ( j = 1 ; j <= 
                      wordwidth ; j ++ ) pixelinteger ( row [ j ] ) ; 
                      rowsleft = rowsleft - repeatcount - 1 ; 
                  repeatcount = 0 ; 
                  rp = 1 ; 
                  word = 0 ; 
                  wordweight = 32 ; 
                  count = count - hbit ; 
                  hbit = cwidth ; 
                  } 
                else 
                { if ( turnon ) word = word + gpower [ wordweight ] ; 
                  row [ rp ] = word ; 
                  rp = rp + 1 ; 
                  word = 0 ; 
                  count = count - wordweight ; 
                  hbit = hbit - wordweight ; 
                  wordweight = 32 ; 
                  } 
                } 
              turnon = ! turnon ; 
            } 
          if ( ( rowsleft != 0 ) || ( hbit != cwidth ) ) 
        { printf ( " Bad pk file---more bits than required!\n" ) ; 
          jumpout () ; 
          } 
        } 
      if ( endofpacket != pkloc ) 
      { printf ( " Bad pk file!  Bad packet length.\n" ) ; 
        jumpout () ; 
        } 
      goto lab9998 ; 
      lab9997 : while ( pkloc != endofpacket ) i = pkbyte () ; 
        printf ( "Character %d out of range!\n" , car ) ; 
      lab9998 : skipspecials () ; 
      } 
    while ( ! feof ( pkfile ) ) i = pkbyte () ; 
    decr ( pkloc ) ;
    dirptr = pxlloc ; 
  for ( car = 0 ; car <= 127 ; car ++ ) 
    { pixelinteger ( sizes [ car ] ) ; 
      pixelinteger ( offsets [ car ] ) ; 
      pixelinteger ( rasterpointer [ car ] ) ; 
      pixelinteger ( tfmwidth [ car ] ) ; 
      } 
    pixelinteger ( checksum ) ; 
  pixelinteger ( magnification ) ; 
  pixelinteger ( designsize ) ; 
  pixelinteger ( dirptr ) ; 
  pixelinteger ( 1001 ) ; 
  printf ( "%d bytes read from packed file.\n" , pkloc ) ; 
  printf ( "%d bytes written to pixel file.\n" , pxlloc * 4 ) ; 
  lab9999 : ; 
  } 
