/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.stream;

import java.util.Arrays;
import korlibs.io.lang.Charset;
import korlibs.io.lang.CharsetKt;
import korlibs.io.lang.UTF8Kt;
import korlibs.io.util.ByteArrayExtKt;
import korlibs.memory.ArraysKt;
import korlibs.memory.ByteArrayReadWriteKt;
import korlibs.memory.NumbersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0017\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u0000J\u0016\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005J \u0010\u001f\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u0003J\u0006\u0010$\u001a\u00020\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J\"\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020\u0005J\u0006\u0010(\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0005J\u000e\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020-2\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010/\u001a\u0002002\u0006\u0010%\u001a\u00020\u0005J\u000e\u00101\u001a\u0002002\u0006\u0010%\u001a\u00020\u0005J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000203J\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u000206J\u000e\u00108\u001a\u0002092\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010:\u001a\u0002092\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010;\u001a\u00020<2\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010=\u001a\u00020<2\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010>\u001a\u00020?2\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010@\u001a\u00020?2\u0006\u0010%\u001a\u00020\u0005J\u0006\u0010A\u001a\u00020\u0005J\u0006\u0010B\u001a\u00020\u0005J\u0006\u0010C\u001a\u00020\u0005J\u0006\u0010D\u001a\u00020\u0005J\u0006\u0010E\u001a\u00020\u0005J\u0006\u0010F\u001a\u00020\u0005J\u0006\u0010G\u001a\u00020HJ\u0006\u0010I\u001a\u00020HJ\u0006\u0010J\u001a\u00020\u0005J\u0006\u0010K\u001a\u00020\u0005J\u000e\u0010L\u001a\u00020M2\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010N\u001a\u00020M2\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010O\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u0005J\u0018\u0010Q\u001a\u00020 2\u0006\u0010+\u001a\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\"J\u0010\u0010R\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"J\u0010\u0010S\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"J\u0018\u0010S\u001a\u00020 2\u0006\u0010+\u001a\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\"J\u0006\u0010T\u001a\u00020\u0005J\u0006\u0010U\u001a\u00020\u0005J\u0006\u0010V\u001a\u00020\u0005J\u0006\u0010W\u001a\u00020\u0005J\u0006\u0010X\u001a\u00020HJ\u0006\u0010Y\u001a\u00020HJ\u0006\u0010Z\u001a\u00020\u0005J\u0006\u0010[\u001a\u00020\u0005J\u000e\u0010\\\u001a\u00020]2\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010^\u001a\u00020]2\u0006\u0010%\u001a\u00020\u0005J\u0010\u0010_\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005J\u0016\u0010`\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005J\u000e\u0010a\u001a\u00020]2\u0006\u0010%\u001a\u00020\u0005J\n\u0010b\u001a\u00020\u0005*\u00020\u0005R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u000b\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000b\u00a8\u0006c"}, d2={"Lkorlibs/io/stream/FastByteArrayInputStream;", "", "ba", "", "offset", "", "start", "end", "([BIII)V", "available", "getAvailable", "()I", "getBa", "()[B", "getEnd", "eof", "", "getEof", "()Z", "hasMore", "getHasMore", "length", "getLength", "value", "position", "getPosition", "setPosition", "(I)V", "getStart", "clone", "extractBytes", "extractString", "", "charset", "Lkorlibs/io/lang/Charset;", "getAllBytes", "getBackingArrayUnsafe", "count", "read", "data", "readAll", "readBytes", "readBytesExact", "len", "readCharArrayBE", "", "readCharArrayLE", "readDoubleArrayBE", "", "readDoubleArrayLE", "readF32BE", "", "readF32LE", "readF64BE", "", "readF64LE", "readFloatArrayBE", "", "readFloatArrayLE", "readIntArrayBE", "", "readIntArrayLE", "readLongArrayBE", "", "readLongArrayLE", "readS16BE", "readS16LE", "readS24BE", "readS24LE", "readS32BE", "readS32LE", "readS64BE", "", "readS64LE", "readS8", "readS_VL", "readShortArrayBE", "", "readShortArrayLE", "readSlice", "size", "readString", "readStringVL", "readStringz", "readU16BE", "readU16LE", "readU24BE", "readU24LE", "readU32BE", "readU32LE", "readU8", "readU_VL", "skip", "", "skipToAlign", "sliceStart", "sliceWithSize", "unread", "coerceRange", "korio"})
public final class FastByteArrayInputStream {
    @NotNull
    private final byte[] ba;
    private final int start;
    private final int end;
    private int offset;

    public FastByteArrayInputStream(@NotNull byte[] ba, int offset, int start, int end2) {
        this.ba = ba;
        this.start = start;
        this.end = end2;
        this.offset = offset + this.start;
    }

    public /* synthetic */ FastByteArrayInputStream(byte[] byArray, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = byArray.length;
        }
        this(byArray, n, n2, n3);
    }

    @NotNull
    public final byte[] getBa() {
        return this.ba;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public final int getPosition() {
        return this.offset - this.start;
    }

    public final void setPosition(int value) {
        this.offset = this.start + value;
    }

    public final int getLength() {
        return this.end - this.start;
    }

    public final int getAvailable() {
        return this.end - this.offset;
    }

    public final boolean getHasMore() {
        return this.getAvailable() > 0;
    }

    public final boolean getEof() {
        return !this.getHasMore();
    }

    public final int coerceRange(int $this$coerceRange) {
        return RangesKt.coerceIn($this$coerceRange, this.start, this.end);
    }

    @NotNull
    public final byte[] extractBytes(int offset, int length) {
        int start = this.start + offset;
        int end2 = start + length;
        byte[] byArray = this.ba;
        return kotlin.collections.ArraysKt.copyOfRange(byArray, start, end2);
    }

    @NotNull
    public final String extractString(int offset, int length, @NotNull Charset charset) {
        int start = this.start + offset;
        int end2 = start + length;
        return CharsetKt.toString(this.ba, charset, start, end2);
    }

    public static /* synthetic */ String extractString$default(FastByteArrayInputStream fastByteArrayInputStream, int n, int n2, Charset charset, int n3, Object object) {
        if ((n3 & 4) != 0) {
            charset = UTF8Kt.getUTF8();
        }
        return fastByteArrayInputStream.extractString(n, n2, charset);
    }

    @NotNull
    public final FastByteArrayInputStream readSlice(int size2) {
        FastByteArrayInputStream out = this.sliceWithSize(this.getPosition(), size2);
        this.offset += size2;
        return out;
    }

    @NotNull
    public final FastByteArrayInputStream sliceStart(int offset) {
        return new FastByteArrayInputStream(this.ba, 0, this.coerceRange(this.start + offset), this.end);
    }

    public static /* synthetic */ FastByteArrayInputStream sliceStart$default(FastByteArrayInputStream fastByteArrayInputStream, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return fastByteArrayInputStream.sliceStart(n);
    }

    @NotNull
    public final FastByteArrayInputStream clone() {
        return new FastByteArrayInputStream(this.ba, this.getPosition(), this.start, this.end);
    }

    @NotNull
    public final FastByteArrayInputStream sliceWithSize(int offset, int len) {
        return new FastByteArrayInputStream(this.ba, 0, this.coerceRange(this.start + offset), this.coerceRange(this.start + offset + len));
    }

    private final int offset(int count2) {
        int out = this.offset;
        this.offset += count2;
        return out;
    }

    public final void skip(int count2) {
        this.offset = RangesKt.coerceIn(this.offset + count2, this.start, this.end);
    }

    public final void unread(int count2) {
        this.skip(-count2);
    }

    public final void skipToAlign(int count2) {
        int nextPosition = NumbersKt.nextAlignedTo(this.offset, count2);
        this.skip(nextPosition - this.offset);
    }

    @NotNull
    public final byte[] readBytesExact(int len) {
        byte[] byArray = this.ba;
        int n = this.offset;
        int n2 = this.offset + len;
        byte[] out = kotlin.collections.ArraysKt.copyOfRange(byArray, n, n2);
        this.offset += len;
        return out;
    }

    @NotNull
    public final byte[] readAll() {
        return this.readBytesExact(this.getAvailable());
    }

    public final int readS8() {
        return ByteArrayReadWriteKt.readS8(this.ba, this.offset(1));
    }

    public final int readU8() {
        return ByteArrayReadWriteKt.readU8(this.ba, this.offset(1));
    }

    public final int readS16LE() {
        return ByteArrayReadWriteKt.readS16LE(this.ba, this.offset(2));
    }

    public final int readS16BE() {
        return ByteArrayReadWriteKt.readS16BE(this.ba, this.offset(2));
    }

    public final int readU16LE() {
        return ByteArrayReadWriteKt.readU16LE(this.ba, this.offset(2));
    }

    public final int readU16BE() {
        return ByteArrayReadWriteKt.readU16BE(this.ba, this.offset(2));
    }

    public final int readS24LE() {
        return ByteArrayReadWriteKt.readS24LE(this.ba, this.offset(3));
    }

    public final int readS24BE() {
        return ByteArrayReadWriteKt.readS24BE(this.ba, this.offset(3));
    }

    public final int readU24LE() {
        return ByteArrayReadWriteKt.readU24LE(this.ba, this.offset(3));
    }

    public final int readU24BE() {
        return ByteArrayReadWriteKt.readU24BE(this.ba, this.offset(3));
    }

    public final int readS32LE() {
        return ByteArrayReadWriteKt.readS32LE(this.ba, this.offset(4));
    }

    public final int readS32BE() {
        return ByteArrayReadWriteKt.readS32BE(this.ba, this.offset(4));
    }

    public final long readU32LE() {
        return ByteArrayReadWriteKt.readU32LE(this.ba, this.offset(4));
    }

    public final long readU32BE() {
        return ByteArrayReadWriteKt.readU32BE(this.ba, this.offset(4));
    }

    public final float readF32LE() {
        return ByteArrayReadWriteKt.readF32LE(this.ba, this.offset(4));
    }

    public final float readF32BE() {
        return ByteArrayReadWriteKt.readF32BE(this.ba, this.offset(4));
    }

    public final double readF64LE() {
        return ByteArrayReadWriteKt.readF64LE(this.ba, this.offset(8));
    }

    public final double readF64BE() {
        return ByteArrayReadWriteKt.readF64BE(this.ba, this.offset(8));
    }

    public final long readS64LE() {
        return ByteArrayReadWriteKt.readS64LE(this.ba, this.offset(8));
    }

    public final long readS64BE() {
        return ByteArrayReadWriteKt.readS64BE(this.ba, this.offset(8));
    }

    public final int read(@NotNull byte[] data, int offset, int count2) {
        int readCount = RangesKt.coerceAtMost(count2, this.getAvailable());
        ArraysKt.arraycopy(this.ba, this.offset, data, offset, readCount);
        this.offset += count2;
        return readCount;
    }

    public static /* synthetic */ int read$default(FastByteArrayInputStream fastByteArrayInputStream, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return fastByteArrayInputStream.read(byArray, n, n2);
    }

    @NotNull
    public final byte[] readBytes(int count2) {
        return ByteArrayReadWriteKt.readByteArray(this.ba, this.offset(count2), count2);
    }

    @NotNull
    public final short[] readShortArrayLE(int count2) {
        return ByteArrayReadWriteKt.readShortArrayLE(this.ba, this.offset(count2 * 2), count2);
    }

    @NotNull
    public final short[] readShortArrayBE(int count2) {
        return ByteArrayReadWriteKt.readShortArrayBE(this.ba, this.offset(count2 * 2), count2);
    }

    @NotNull
    public final char[] readCharArrayLE(int count2) {
        return ByteArrayReadWriteKt.readCharArrayLE(this.ba, this.offset(count2 * 2), count2);
    }

    @NotNull
    public final char[] readCharArrayBE(int count2) {
        return ByteArrayReadWriteKt.readCharArrayBE(this.ba, this.offset(count2 * 2), count2);
    }

    @NotNull
    public final int[] readIntArrayLE(int count2) {
        return ByteArrayReadWriteKt.readIntArrayLE(this.ba, this.offset(count2 * 4), count2);
    }

    @NotNull
    public final int[] readIntArrayBE(int count2) {
        return ByteArrayReadWriteKt.readIntArrayBE(this.ba, this.offset(count2 * 4), count2);
    }

    @NotNull
    public final long[] readLongArrayLE(int count2) {
        return ByteArrayReadWriteKt.readLongArrayLE(this.ba, this.offset(count2 * 8), count2);
    }

    @NotNull
    public final long[] readLongArrayBE(int count2) {
        return ByteArrayReadWriteKt.readLongArrayBE(this.ba, this.offset(count2 * 8), count2);
    }

    @NotNull
    public final float[] readFloatArrayLE(int count2) {
        return ByteArrayReadWriteKt.readFloatArrayLE(this.ba, this.offset(count2 * 4), count2);
    }

    @NotNull
    public final float[] readFloatArrayBE(int count2) {
        return ByteArrayReadWriteKt.readFloatArrayBE(this.ba, this.offset(count2 * 4), count2);
    }

    @NotNull
    public final double[] readDoubleArrayLE(int count2) {
        return ByteArrayReadWriteKt.readDoubleArrayLE(this.ba, this.offset(count2 * 8), count2);
    }

    @NotNull
    public final double[] readDoubleArrayBE(int count2) {
        return ByteArrayReadWriteKt.readDoubleArrayBE(this.ba, this.offset(count2 * 8), count2);
    }

    public final int readU_VL() {
        int result2 = this.readU8();
        if ((result2 & 0x80) == 0) {
            return result2;
        }
        if (((result2 = result2 & 0x7F | this.readU8() << 7) & 0x4000) == 0) {
            return result2;
        }
        if (((result2 = result2 & 0x3FFF | this.readU8() << 14) & 0x200000) == 0) {
            return result2;
        }
        if (((result2 = result2 & 0x1FFFFF | this.readU8() << 21) & 0x10000000) == 0) {
            return result2;
        }
        result2 = result2 & 0xFFFFFFF | this.readU8() << 28;
        return result2;
    }

    public final int readS_VL() {
        int v = this.readU_VL();
        boolean sign = (v & 1) != 0;
        int uvalue = v >>> 1;
        return sign ? -uvalue - 1 : uvalue;
    }

    @NotNull
    public final String readString(int len, @NotNull Charset charset) {
        return CharsetKt.toString$default(this.readBytes(len), charset, 0, 0, 6, null);
    }

    public static /* synthetic */ String readString$default(FastByteArrayInputStream fastByteArrayInputStream, int n, Charset charset, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = UTF8Kt.getUTF8();
        }
        return fastByteArrayInputStream.readString(n, charset);
    }

    @NotNull
    public final String readStringz(int len, @NotNull Charset charset) {
        byte[] res;
        int index = ByteArrayExtKt.indexOf$default(res = this.readBytes(len), (byte)0, 0, 0, 0, 14, null);
        byte[] byArray = Arrays.copyOf(res, index < 0 ? len : index);
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(this, newSize)");
        return CharsetKt.toString$default(byArray, charset, 0, 0, 6, null);
    }

    public static /* synthetic */ String readStringz$default(FastByteArrayInputStream fastByteArrayInputStream, int n, Charset charset, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = UTF8Kt.getUTF8();
        }
        return fastByteArrayInputStream.readStringz(n, charset);
    }

    @NotNull
    public final String readStringz(@NotNull Charset charset) {
        int startOffset = this.offset;
        int index = ByteArrayExtKt.indexOf$default(this.ba, (byte)0, this.offset, 0, 0, 12, null);
        int end2 = index >= 0 ? index : this.ba.length;
        byte[] byArray = this.ba;
        String str = CharsetKt.toString$default(kotlin.collections.ArraysKt.copyOfRange(byArray, startOffset, end2), charset, 0, 0, 6, null);
        this.offset = index >= 0 ? end2 + 1 : end2;
        return str;
    }

    public static /* synthetic */ String readStringz$default(FastByteArrayInputStream fastByteArrayInputStream, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = UTF8Kt.getUTF8();
        }
        return fastByteArrayInputStream.readStringz(charset);
    }

    @NotNull
    public final String readStringVL(@NotNull Charset charset) {
        return this.readString(this.readU_VL(), charset);
    }

    public static /* synthetic */ String readStringVL$default(FastByteArrayInputStream fastByteArrayInputStream, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = UTF8Kt.getUTF8();
        }
        return fastByteArrayInputStream.readStringVL(charset);
    }

    @NotNull
    public final byte[] getAllBytes() {
        byte[] byArray = this.ba;
        int n = this.start;
        int n2 = this.end;
        return kotlin.collections.ArraysKt.copyOfRange(byArray, n, n2);
    }

    @NotNull
    public final byte[] getBackingArrayUnsafe() {
        return this.ba;
    }
}

